/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.BoardCache;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.LoadBoard;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.ArmySelector;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.LuxView;
import com.sillysoft.lux.gui.MenuView;
import com.sillysoft.lux.gui.WidthBar;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.lux.plugin.PluginRater;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.EventThread;
import com.sillysoft.tools.FolderLauncher;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.AquaButton;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.RegisterNag;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSChatArea;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSMenuItem;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SoundEffect;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.net.URLEncoder;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GameControllerGUI
extends GameControllerAbstract
implements Runnable,
WindowListener,
ActionListener,
ComponentListener,
WindowStateListener,
AdjustmentListener {
    public SSFrame boardWindow;
    public LuxView luxView;
    protected static SoundEffect yourTurnSound;
    public WidthBar widthBar;
    public ArmySelector armySelector;
    protected JPanel bottomRow;
    protected JPanel bottomRow2;
    protected Component spacerGlue = Box.createHorizontalGlue();
    protected JMenu themeMenu;
    protected JPanel gamePanel;
    protected JSplitPane splitPane;
    protected JCheckBoxMenuItem showContinentsMenuItem;
    protected JScrollPane scroller;
    protected JLabel spacerLabel;
    protected JLabel spacerLabelInitial;
    protected AbstractAction endGameAction;
    protected AbstractAction cardsAction;
    protected AbstractAction fortifyAction;
    protected AbstractAction endTurnAction;
    protected AbstractAction cashCardsAction;
    protected AbstractAction nextMapAction;
    protected AbstractAction bonusesAction;
    AquaButton buttonNextMap;
    AquaButton buttonCards;
    AquaButton buttonInfo;
    AquaButton buttonFortify;
    AquaButton buttonEndTurn;
    AquaButton buttonCashCards;
    AquaButton buttonReplay;
    AquaButton buttonGameOptions;
    AquaButton buttonBonuses;
    AquaButton buttonMenu;
    static Color buttonColor;
    protected boolean lostServer = false;
    public boolean fullscreen = false;
    protected static boolean tutorialStart;
    protected static boolean tutorialStart2;
    protected static boolean tutorialStart3;
    protected static boolean tutorialPlaceInitialArmies;
    protected static boolean tutorialAttackDraw;
    protected static boolean tutorialTookCountry;
    protected static boolean tutorialEliminatedPlayer;
    protected static boolean tutorialAttackPhase;
    protected static boolean tutorialStartTurn;
    protected static boolean tutorialStartTurnWithSet;
    protected static boolean tutorialFirstCard;
    protected static boolean tutorialFirstFortifyPhase;
    protected static boolean tutorialPlaceInitialArmiesAll;
    protected static boolean tutorialPlaceInitialArmiesThird;
    protected static boolean tutorialMoveInArmies;
    protected static boolean tutorialShowCards;
    protected static boolean tutorialCashCards;
    protected static boolean tutorialIncomes;
    protected static boolean tutorialDoneMovingIn;
    protected static boolean tutorialEndTurn;
    public String resizedMap = null;
    public double resizedPercent = 1.0;
    private boolean resizeInProgress = true;
    private static SoundEffect cashCardsSound;
    private int CHATPANEL_HEIGHT = 128;
    Runnable setBoardSizeRunnable = new Runnable(){

        public void run() {
            System.out.println("setBoardSizeRunnable.run()");
            Dimension oldSize = GameControllerGUI.this.luxView.getPreferredSize();
            if (oldSize.width == GameControllerGUI.this.ops.width && oldSize.height == GameControllerGUI.this.ops.height) {
                GameControllerGUI.this.debug("Board is the same size as it is now. Calling off the setBoardSize().");
                return;
            }
            if (GameControllerGUI.this.resizedMap != null && GameControllerGUI.this.resizedMap.equals(GameControllerGUI.this.ops.boardName())) {
                GameControllerGUI.this.luxView.prepareToResizeMap(GameControllerGUI.this.resizedPercent);
                GameControllerGUI.this.debug("Resized this map. Calling off the setBoardSize().");
                return;
            }
            GameControllerGUI.this.resizeInProgress = true;
            Rectangle usableRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension screenDimension = usableRect.getSize();
            int mapWidth = GameControllerGUI.this.ops.width;
            int mapHeight = GameControllerGUI.this.ops.height;
            boolean toFitTheScreen = false;
            double percent = GraphicsTool.getResizePercentToFitInsideDimension(mapWidth, mapHeight, screenDimension.getWidth() - (double)SwingTool.WINDOW_HORIZONTAL_PADDING, screenDimension.getHeight() - (double)SwingTool.WINDOW_VERTICAL_PADDING - (double)(GameControllerGUI.this.ops.width < 730 ? 80 : 40));
            float savedResize = Prefs.getFloat("rz_" + GameControllerGUI.this.ops.boardName(), 0.0f);
            if (GameControllerGUI.this.fullscreen) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension fulldim = toolkit.getScreenSize();
                percent = GraphicsTool.getResizePercentToFitInsideDimension(mapWidth, mapHeight, fulldim.getWidth(), fulldim.getHeight() - (double)(GameControllerGUI.this.ops.width < 730 ? 80 : 40) - (double)(GameControllerGUI.this.ops.allowNetworkPlayers ? 128 : 0));
                mapWidth = (int)((double)mapWidth * percent);
                mapHeight = (int)((double)mapHeight * percent);
                GameControllerGUI.this.luxView.prepareToResizeMap(percent);
                int extrawidth = (int)fulldim.getWidth() - mapWidth;
                int extraheight = (int)fulldim.getHeight() - mapHeight - (GameControllerGUI.this.ops.width < 730 ? 80 : 40) - (GameControllerGUI.this.ops.allowNetworkPlayers ? 128 : 0);
            } else if (savedResize != 0.0f && savedResize != 1.0f) {
                percent = savedResize;
                mapWidth = (int)((double)mapWidth * percent);
                mapHeight = (int)((double)mapHeight * percent);
                GameControllerGUI.this.luxView.prepareToResizeMap(percent);
            } else if (Prefs.getBoolean("autosizeMaps", true) && percent < 1.0) {
                System.out.println("Auto-shrink map to fit the screen");
                mapWidth = (int)((double)mapWidth * percent);
                mapHeight = (int)((double)mapHeight * percent);
                GameControllerGUI.this.luxView.prepareToResizeMap(percent);
            } else if (Prefs.getBoolean("autosizeMapsBigger", false) && percent > 1.0) {
                SS.debug("Auto-grow map to fit the screen");
                toFitTheScreen = true;
                if (GameControllerGUI.this.ops.allowNetworkPlayers && !Prefs.getBoolean("seperateChatWindow", false)) {
                    percent = GraphicsTool.getResizePercentToFitInsideDimension(mapWidth, mapHeight, screenDimension.getWidth() - (double)SwingTool.WINDOW_HORIZONTAL_PADDING, screenDimension.getHeight() - (double)SwingTool.WINDOW_VERTICAL_PADDING - (double)(GameControllerGUI.this.ops.width < 730 ? 80 : 40) - 128.0);
                }
                mapWidth = (int)((double)mapWidth * percent);
                mapHeight = (int)((double)mapHeight * percent);
                GameControllerGUI.this.luxView.prepareToResizeMap(percent);
            }
            GameControllerGUI.this.luxView.setMinimumSize(new Dimension(mapWidth, mapHeight));
            GameControllerGUI.this.luxView.setPreferredSize(new Dimension(mapWidth, mapHeight));
            GameControllerGUI.this.luxView.setSize(mapWidth, mapHeight);
            GameControllerGUI.this.luxView.setBoardSize(mapWidth, mapHeight);
            GameControllerGUI.this.scroller.setPreferredSize(new Dimension(mapWidth, mapHeight));
            if (GameControllerGUI.this.fullscreen) {
                GameControllerGUI.this.scroller.setMaximumSize(new Dimension(mapWidth, mapHeight));
                GameControllerGUI.this.bottomRow.setMaximumSize(new Dimension(mapWidth, 40));
            } else {
                GameControllerGUI.this.bottomRow.setMaximumSize(new Dimension(GameControllerGUI.this.getScreenWidth(), 40));
            }
            GameControllerGUI.this.bottomRow.setMinimumSize(new Dimension(mapWidth, 40));
            GameControllerGUI.this.bottomRow.setPreferredSize(new Dimension(mapWidth, 40));
            GameControllerGUI.this.bottomRow.setSize(mapWidth, 40);
            int WIDTHBAR_WIDTH = (int)((double)mapWidth * 0.35);
            GameControllerGUI.this.widthBar.setWidth(WIDTHBAR_WIDTH);
            GameControllerGUI.this.armySelector.setPreferredSize(new Dimension(mapWidth - WIDTHBAR_WIDTH, 40));
            GameControllerGUI.this.armySelector.setSize(mapWidth - WIDTHBAR_WIDTH, 40);
            GameControllerGUI.this.widthBar.setLocation(0, 0);
            GameControllerGUI.this.armySelector.setLocation(WIDTHBAR_WIDTH, 0);
            if (mapWidth < 730) {
                GameControllerGUI.this.gamePanel.add(GameControllerGUI.this.armySelector);
                GameControllerGUI.this.widthBar.setWidth(mapWidth - 3);
            } else {
                GameControllerGUI.this.bottomRow.add(GameControllerGUI.this.armySelector);
                GameControllerGUI.this.widthBar.setWidth(WIDTHBAR_WIDTH);
            }
            int dividerLocation = -1;
            if (GameControllerGUI.this.netBoss != null) {
                int width_offset = 20;
                if (SS.isMacintosh) {
                    width_offset = 0;
                }
                int height_offset = 20;
                if (GameControllerGUI.this.fullscreen) {
                    height_offset = 0;
                }
                SSChatArea chatPanel = GameControllerGUI.this.netBoss.getChatView();
                int oldHeight = chatPanel.getSize().height;
                GameControllerGUI.this.CHATPANEL_HEIGHT = Math.max(GameControllerGUI.this.CHATPANEL_HEIGHT, oldHeight);
                chatPanel.setPreferredSize(new Dimension(mapWidth, GameControllerGUI.this.CHATPANEL_HEIGHT));
                GameControllerGUI.this.splitPane.setPreferredSize(new Dimension(mapWidth + width_offset, mapHeight + 40 + GameControllerGUI.this.CHATPANEL_HEIGHT + height_offset));
                dividerLocation = mapHeight + 40;
                if (mapWidth < 730) {
                    dividerLocation += 40;
                }
            }
            if (!GameControllerGUI.this.fullscreen) {
                GameControllerGUI.this.boardWindow.pack();
            }
            GameControllerGUI.this.boardWindow.show();
            if (GameControllerGUI.this.netBoss == null) {
                GameControllerGUI.this.boardWindow.getRootPane().setDefaultButton(Prefs.getBoolean("nextMapButtonDefault", true) ? GameControllerGUI.this.buttonNextMap : GameControllerGUI.this.buttonReplay);
            }
            if (dividerLocation != -1) {
                GameControllerGUI.this.splitPane.setDividerLocation(dividerLocation);
            }
            if (GameControllerGUI.this.boardWindow.size().getHeight() + (double)SwingTool.WINDOW_VERTICAL_PADDING > screenDimension.getHeight() && !GameControllerGUI.this.fullscreen) {
                if (GameControllerGUI.this.netBoss != null) {
                    GameControllerGUI.this.splitPane.setDividerLocation(Math.min(mapHeight + 40, (int)screenDimension.getHeight() - 100));
                }
                if (GameControllerGUI.this.boardWindow.size().getWidth() > screenDimension.getWidth()) {
                    GameControllerGUI.this.debug("Maximize the window: " + ((int)screenDimension.getWidth() - (WIDTHBAR_WIDTH + 1)));
                    GameControllerGUI.this.armySelector.setPreferredSize(new Dimension((int)screenDimension.getWidth() - (WIDTHBAR_WIDTH + 1), 40));
                    GameControllerGUI.this.armySelector.setSize((int)screenDimension.getWidth() - (WIDTHBAR_WIDTH + 1), 40);
                    if (SS.isMacintosh) {
                        GameControllerGUI.this.boardWindow.setSize(new Dimension((int)screenDimension.getWidth(), (int)screenDimension.getHeight()));
                        GameControllerGUI.this.boardWindow.setLocation(usableRect.getLocation());
                        GameControllerGUI.this.debug("SetLocation 237645 ");
                    } else {
                        GameControllerGUI.this.debug("Maximize the Frame.MAXIMIZED_BOTH of the window ");
                        GameControllerGUI.this.boardWindow.setExtendedState(6);
                    }
                } else {
                    System.out.println("Maximize the height of the window");
                    int padding = toFitTheScreen && SS.isMacintosh ? 0 : SwingTool.SCROLLBAR_SIZE;
                    GameControllerGUI.this.boardWindow.setSize(new Dimension(mapWidth + padding, (int)screenDimension.getHeight()));
                    GameControllerGUI.this.boardWindow.setLocation(usableRect.getLocation());
                    if (GameControllerGUI.this.boardWindow.size().getWidth() + 100.0 > screenDimension.getWidth() || Prefs.getBoolean("autosizeMapsBigger", false)) {
                        System.out.println(" setExtended: Frame.MAXIMIZED_BOTH of the window ");
                        GameControllerGUI.this.boardWindow.setExtendedState(6);
                    }
                }
            } else if (GameControllerGUI.this.boardWindow.size().getWidth() > screenDimension.getWidth() && !GameControllerGUI.this.fullscreen) {
                GameControllerGUI.this.debug("Maximize the width of the window");
                GameControllerGUI.this.boardWindow.setSize(new Dimension((int)screenDimension.getWidth() - 5, mapHeight + 40 + 77 + (GameControllerGUI.this.netBoss == null ? 0 : GameControllerGUI.this.CHATPANEL_HEIGHT)));
                GameControllerGUI.this.boardWindow.setLocation(usableRect.getLocation());
                GameControllerGUI.this.debug("SetLocation usable 344 ");
                GameControllerGUI.this.armySelector.setPreferredSize(new Dimension((int)screenDimension.getWidth() - (WIDTHBAR_WIDTH + 1), 40));
                GameControllerGUI.this.armySelector.setSize((int)screenDimension.getWidth() - (WIDTHBAR_WIDTH + 1), 40);
            }
            if (GameControllerGUI.this.netBoss != null && !GameControllerGUI.this.netBoss.activeSoloWindow() && Prefs.getBoolean("seperateChatWindow", false) && !GameControllerGUI.this.fullscreen) {
                GameControllerGUI.this.toggleChatWindow();
            }
            GameControllerGUI.this.resizeInProgress = false;
        }
    };
    Runnable gameOverRunnable = new Runnable(){

        public void run() {
            MusicEngine.startTrackSequence(22);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonCards);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonFortify);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonEndTurn);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonBonuses);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonMenu);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonInfo);
            if (GameControllerGUI.this.netBoss != null) {
                if (GameControllerGUI.this.masterControl) {
                    GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonGameOptions);
                    GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonReplay);
                    GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonNextMap);
                    GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerGlue);
                    GameControllerGUI.this.boardWindow.getRootPane().setDefaultButton(Prefs.getBoolean("nextMapButtonDefault", true) ? GameControllerGUI.this.buttonNextMap : GameControllerGUI.this.buttonReplay);
                    GameControllerGUI.this.netBoss.promoteWinner();
                }
            } else {
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonGameOptions);
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonReplay);
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonNextMap);
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerGlue);
                GameControllerGUI.this.boardWindow.getRootPane().setDefaultButton(Prefs.getBoolean("nextMapButtonDefault", true) ? GameControllerGUI.this.buttonNextMap : GameControllerGUI.this.buttonReplay);
            }
            GameControllerGUI.this.nextMapButtonVisible = true;
            GameControllerGUI.this.gameIsOver = true;
            GameControllerGUI.this.armySelector.revalidate();
            GameControllerGUI.this.armySelector.repaint();
            GameControllerGUI.this.saveTutorialState();
            if (Prefs.getBoolean("autoplay", false) && GameControllerGUI.this.masterControl) {
                GameControllerGUI.this.debug("starting autoplay ");
                GameControllerGUI.this.autoplayHandler();
            }
        }
    };
    Runnable clickCardsRunnable = new Runnable(){

        public void run() {
            if (GameControllerGUI.this.nextMapButtonVisible) {
                SS.beep();
                return;
            }
            int cardsID = GameControllerGUI.this.whoseCardsToShow();
            if (cardsID == -1) {
                GameControllerGUI.this.updateCardButton(0, false);
            }
            GameControllerGUI.this.luxView.setHelperText(null);
            if (GameControllerGUI.this.luxView.cardsMode()) {
                if (GameControllerGUI.this.ops.guiControl[GameControllerGUI.this.world.currentPlayer] && !GameControllerGUI.this.forceTurnEnd && GameControllerGUI.this.stats.getCards(GameControllerGUI.this.world.currentPlayer) > 4 && (GameControllerGUI.this.ops.immediateCardCash || GameControllerGUI.this.world.turnPhase == 0)) {
                    GameControllerGUI.this.debug("Canceling hideCards because the user must cash first");
                    if (!GameControllerGUI.this.cashCardsAction.isEnabled()) {
                        GameControllerGUI.this.cashCardsAction.setEnabled(true);
                    } else {
                        SS.beep();
                    }
                    return;
                }
                GameControllerGUI.this.luxView.hideCards();
                if (!GameControllerGUI.this.luxView.cardsMode()) {
                    GameControllerGUI.this.updateCardButton(GameControllerGUI.this.stats.getCards(cardsID), false);
                }
                GameControllerGUI.this.cashCardsAction.setEnabled(false);
                GameControllerGUI.this.cardsAction.setEnabled(true);
                GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonCashCards);
                GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.spacerGlue);
                GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.spacerLabel);
                GameControllerGUI.this.buttonCards.setWidthForText();
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonBonuses);
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonInfo);
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonCards);
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerGlue);
                if (GameControllerGUI.this.armySelector.getFluxArmies() <= 0 && !GameControllerGUI.this.continentMode && GameControllerGUI.this.ops.guiControl[GameControllerGUI.this.world.currentPlayer]) {
                    GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerGlue);
                    if (GameControllerGUI.this.fortifyAction.isEnabled()) {
                        GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonFortify);
                    }
                    GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonEndTurn);
                }
                GameControllerGUI.this.armySelector.revalidate();
                return;
            }
            Card[] cards = GameControllerGUI.this.world.getPlayerCards(cardsID);
            boolean canCash = GameControllerGUI.this.world.cardPhase() || cards.length > 4 && GameControllerGUI.this.ops.immediateCardCash;
            GameControllerGUI.this.luxView.showCards(cards, canCash, Card.getBestSet(cards, cardsID, GameControllerGUI.this.world.countries));
            if (tutorialShowCards && cards.length > 0) {
                tutorialShowCards = false;
            }
            if (canCash) {
                if (Card.containsASet(cards)) {
                    if (tutorialCashCards) {
                        tutorialCashCards = false;
                    }
                    if (GameControllerGUI.this.ops.guiControl[GameControllerGUI.this.world.currentPlayer]) {
                        GameControllerGUI.this.cashCardsAction.setEnabled(true);
                        if (cards.length > 4) {
                            GameControllerGUI.this.cardsAction.setEnabled(false);
                        }
                    }
                }
            } else if (cards.length > 2) {
                GameControllerGUI.this.luxView.showNotice(Translator.getString("onlyCashStart"));
            }
            String top = cards.length == 0 ? Translator.getString("Youhave0card") : (cards.length == 1 ? Translator.getString("Youhave1card") : Translator.getString("Youhave") + " " + cards.length + " " + Translator.getString("cards") + ".");
            GameControllerGUI.this.luxView.showNoticeBottomRight(top + "\n" + Translator.getString("CardsGoUp") + " " + CardSequence.sequences[GameControllerGUI.this.ops.cardSequenceCode] + "\n" + Translator.getString("Thenextcardsetisworth") + " " + GameControllerGUI.this.world.getNextCardSetValue() + " " + Translator.getString("armies") + ".");
            GameControllerGUI.this.buttonCards.setText(Translator.getString("HideCards"));
            GameControllerGUI.this.buttonCards.setWidthForText();
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonBonuses);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonCards);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonFortify);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonEndTurn);
            GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.spacerGlue);
            GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerLabel);
            GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonInfo);
            GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonCards);
            GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerGlue);
            if (GameControllerGUI.this.cashCardsAction.isEnabled()) {
                GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonCashCards);
                if (canCash && Card.containsASet(cards)) {
                    GameControllerGUI.this.boardWindow.getRootPane().setDefaultButton(GameControllerGUI.this.buttonCashCards);
                }
            } else {
                GameControllerGUI.this.boardWindow.getRootPane().setDefaultButton(GameControllerGUI.this.buttonCards);
            }
            GameControllerGUI.this.armySelector.revalidate();
            GameControllerGUI.this.armySelector.repaint();
        }
    };
    Runnable ensureCanCashRunnable = new Runnable(){

        public void run() {
            if (GameControllerGUI.this.world.getCurrentPlayerCards().length > 4) {
                GameControllerGUI.this.armySelector.remove(GameControllerGUI.this.buttonCards);
            }
            GameControllerGUI.this.cashCardsAction.setEnabled(true);
            GameControllerGUI.this.armySelector.add(GameControllerGUI.this.spacerGlue);
            GameControllerGUI.this.armySelector.add(GameControllerGUI.this.buttonCashCards);
            GameControllerGUI.this.boardWindow.getRootPane().setDefaultButton(GameControllerGUI.this.buttonCashCards);
            GameControllerGUI.this.armySelector.revalidate();
            GameControllerGUI.this.armySelector.repaint();
        }
    };
    private boolean ignoreNextResizeEvent = false;
    private boolean continentMode;
    int earlyAttacks = 0;
    boolean shownEarlyAttackTip = false;

    public GameControllerGUI(LuxOptions ops, boolean masterControl, NetBoss netBoss) {
        super(ops, masterControl, netBoss);
        LuxController.getInstance().addGame(this);
        this.startGame();
    }

    public GameControllerGUI(LuxOptions ops, boolean masterControl, NetBoss netBoss, boolean forApplet) {
        super(ops, masterControl, netBoss);
        if (!forApplet) {
            LuxController.getInstance().addGame(this);
            this.startGame();
        }
    }

    public void toggleFullscreen() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getScreenDevices()[0];
        if (!device.isFullScreenSupported()) {
            SS.beep();
            return;
        }
        if (!this.fullscreen) {
            SS.debug("go fullscreen");
            this.fullscreen = true;
            this.boardWindow.removeWindowListener(this);
            this.boardWindow.removeWindowStateListener(this);
            SSFrame newWindow = new SSFrame(this.boardWindow.getTitle());
            newWindow.setResizable(false);
            newWindow.setUndecorated(true);
            newWindow.setBackground(Color.BLACK);
            newWindow.setContentPane(this.boardWindow.getContentPane());
            if (SS.isMacintosh) {
                newWindow.setJMenuBar(this.boardWindow.getJMenuBar());
            }
            newWindow.setDefaultCloseOperation(0);
            newWindow.addWindowListener(this);
            newWindow.addWindowStateListener(this);
            device.setFullScreenWindow(newWindow);
            SSFrame oldWindow = this.boardWindow;
            this.boardWindow = newWindow;
            this.resizeMapToFitTheScreen();
            oldWindow.hide();
        } else {
            SS.debug("exit fullscreen");
            this.ignoreNextResizeEvent = true;
            this.fullscreen = false;
            this.boardWindow.removeWindowListener(this);
            this.boardWindow.removeWindowStateListener(this);
            device.setFullScreenWindow(null);
            SSFrame newWindow = new SSFrame(this.boardWindow.getTitle());
            newWindow.setContentPane(this.boardWindow.getContentPane());
            newWindow.setJMenuBar(this.makeJMenuBar(null));
            newWindow.setLocationID("BoardWindow");
            newWindow.setDefaultCloseOperation(0);
            newWindow.addWindowListener(this);
            newWindow.addWindowStateListener(this);
            SSFrame oldWindow = this.boardWindow;
            this.boardWindow = newWindow;
            this.boardWindow.show();
            oldWindow.hide();
            this.doResize(false, this.ops.width, this.ops.height, false);
            if (this.ops.allowNetworkPlayers) {
                this.splitPane.setDividerLocation(Math.min(this.luxView.mapHeight + 40, (int)GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getHeight() - 128));
            }
        }
    }

    private void createBoardWindow() {
        this.boardWindow = new SSFrame("Lux Delux");
        if (Prefs.getBoolean("fullscreen", false) && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported()) {
            this.fullscreen = true;
            this.boardWindow.setResizable(false);
            this.boardWindow.setUndecorated(true);
            this.boardWindow.setBackground(Color.BLACK);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getScreenDevices()[0];
            device.setFullScreenWindow(this.boardWindow);
        } else {
            this.boardWindow.setLocationID("BoardWindow");
            if (Prefs.getInt("BoardWindowWindowX", -100) == -100) {
                Prefs.putInt("BoardWindowWindowX", 0);
                Prefs.putInt("BoardWindowWindowY", 0);
            }
            this.boardWindow.setResizable(true);
        }
        this.boardWindow.addWindowListener(this);
        this.boardWindow.addWindowStateListener(this);
        this.boardWindow.setDefaultCloseOperation(0);
        this.luxView = new LuxView(this);
        this.boardWindow.setContentPane(this.luxView);
        this.boardWindow.setSize(this.getStartingWidth(), this.getStartingHeight());
        this.boardWindow.show();
        this.luxView.init();
        if (yourTurnSound == null) {
            yourTurnSound = new SoundEffect("yourTurn.wav");
        }
        this.cardsAction = new cardsAction();
        this.cashCardsAction = new CashCardsAction();
        this.fortifyAction = new FortifyAction();
        this.endTurnAction = new EndTurnAction();
        this.endGameAction = new EndGameAction();
        this.nextMapAction = new NextMapAction();
        this.cashCardsAction.setEnabled(false);
        this.bonusesAction = new BonusesAction();
        if (!this.fullscreen || SS.isMacintosh) {
            this.boardWindow.setJMenuBar(this.makeJMenuBar(null));
        }
        this.buttonNextMap = new AquaButton(this.nextMapAction);
        this.buttonCards = new AquaButton(this.cardsAction);
        this.buttonInfo = new AquaButton(new InfoAction());
        this.buttonFortify = new AquaButton(this.fortifyAction);
        this.buttonEndTurn = new AquaButton(this.endTurnAction);
        this.buttonCashCards = new AquaButton(this.cashCardsAction);
        this.buttonReplay = new AquaButton(new ReplayAction());
        this.buttonGameOptions = new AquaButton(new GameOptionsAction());
        this.buttonBonuses = new AquaButton(this.bonusesAction);
        this.buttonMenu = new AquaButton(new MenuAction());
        Font buttonFont = AquaButton.getPlainFontSized(18);
        this.buttonBonuses.setFont(buttonFont);
        this.buttonNextMap.setFont(buttonFont);
        this.buttonCards.setFont(buttonFont);
        this.buttonInfo.setFont(buttonFont);
        this.buttonFortify.setFont(buttonFont);
        this.buttonEndTurn.setFont(buttonFont);
        this.buttonCashCards.setFont(buttonFont);
        this.buttonReplay.setFont(buttonFont);
        this.buttonGameOptions.setFont(buttonFont);
        this.buttonMenu.setFont(buttonFont);
        this.buttonBonuses.setTextColor(buttonColor);
        this.buttonNextMap.setTextColor(buttonColor);
        this.buttonCards.setTextColor(buttonColor);
        this.buttonInfo.setTextColor(buttonColor);
        this.buttonFortify.setTextColor(buttonColor);
        this.buttonEndTurn.setTextColor(buttonColor);
        this.buttonCashCards.setTextColor(buttonColor);
        this.buttonReplay.setTextColor(buttonColor);
        this.buttonGameOptions.setTextColor(buttonColor);
        this.buttonMenu.setTextColor(buttonColor);
        this.buttonMenu.setWidthForText();
        this.buttonBonuses.setWidthForText();
        this.buttonCards.setWidthForText();
        this.buttonInfo.setWidthForText();
        this.buttonGameOptions.setWidthForText();
        this.buttonReplay.setWidthForText();
        this.buttonNextMap.setWidthForText();
        this.buttonFortify.setWidthForText();
        this.buttonEndTurn.setWidthForText();
        this.buttonCashCards.setWidthForText();
        this.spacerLabel = new JLabel("                    ");
        this.buttonNextMap.setFocusable(this.netBoss == null);
        this.buttonCards.setFocusable(this.netBoss == null);
        this.buttonInfo.setFocusable(this.netBoss == null);
        this.buttonFortify.setFocusable(this.netBoss == null);
        this.buttonEndTurn.setFocusable(this.netBoss == null);
        this.buttonCashCards.setFocusable(this.netBoss == null);
        this.buttonReplay.setFocusable(this.netBoss == null);
        this.buttonGameOptions.setFocusable(this.netBoss == null);
        this.buttonBonuses.setFocusable(this.netBoss == null);
        this.buttonMenu.setFocusable(this.netBoss == null);
        if (SS.isMacintosh) {
            Color trans = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            this.buttonNextMap.setBackground(trans);
            this.buttonCards.setBackground(trans);
            this.buttonInfo.setBackground(trans);
            this.buttonFortify.setBackground(trans);
            this.buttonEndTurn.setBackground(trans);
            this.buttonCashCards.setBackground(trans);
            this.buttonReplay.setBackground(trans);
            this.buttonGameOptions.setBackground(trans);
            this.buttonBonuses.setBackground(trans);
            this.buttonMenu.setBackground(trans);
        }
        this.gamePanel = new JPanel();
        this.gamePanel.setLayout(new BoxLayout(this.gamePanel, 1));
        this.gamePanel.setFocusable(false);
        this.gamePanel.setBackground(Color.BLACK);
        this.widthBar = new WidthBar(300, 40, this);
        this.widthBar.setSize(300, 40);
        this.widthBar.setFocusable(false);
        this.armySelector = new ArmySelector(this.getStartingWidth(), this);
        this.armySelector.setFocusable(false);
        int vgap = 5;
        if (SS.isMacintosh) {
            vgap = 2;
        }
        this.armySelector.setLayout(new BoxLayout(this.armySelector, 0));
        this.bottomRow = new JPanel(new BorderLayout());
        this.bottomRow.setFocusable(false);
        this.bottomRow.add((Component)this.widthBar, "West");
        this.bottomRow.add((Component)this.armySelector, "Center");
        this.bottomRow.setBackground(Color.BLACK);
        this.scroller = new JScrollPane(this.luxView);
        this.scroller.setBorder(null);
        this.scroller.setBackground(Color.BLACK);
        this.scroller.getVerticalScrollBar().setUnitIncrement(16);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(16);
        this.scroller.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scroller.getVerticalScrollBar().addAdjustmentListener(this);
        this.scroller.setOpaque(true);
        this.scroller.setFocusable(false);
        this.scroller.setPreferredSize(new Dimension(this.getStartingWidth(), this.getStartingHeight()));
        this.gamePanel.add(this.scroller);
        this.gamePanel.add(this.bottomRow);
        this.gamePanel.setOpaque(true);
        this.gamePanel.addComponentListener(this);
        if (this.netBoss != null) {
            this.gamePanel.setMinimumSize(new Dimension(300, 200));
            this.netBoss.getChatView().setMinimumSize(new Dimension(300, 100));
            this.netBoss.prepForDrawer();
            this.splitPane = new JSplitPane(0, this.gamePanel, this.netBoss.getChatView());
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setContinuousLayout(true);
            this.splitPane.setBorder(null);
            this.splitPane.setOpaque(true);
            this.splitPane.setFocusable(false);
            this.boardWindow.setContentPane(this.splitPane);
            this.netBoss.focusChatField();
        } else {
            this.boardWindow.setContentPane(this.gamePanel);
            this.luxView.requestFocus();
        }
    }

    public JMenuBar makeJMenuBar(JFrame forWindow) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(LuxController.getInstance().makeFileMenu(forWindow));
        menuBar.add(LuxController.getInstance().makeEditMenu());
        JMenu menu = new JMenu(Translator.getString("Game"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(71);
        }
        JMenuItem menuItem = new JMenuItem(Translator.getString("PlayerInfo"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("playerInfoToggle");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.showContinentsMenuItem = new JCheckBoxMenuItem(Translator.getString("ShowContinents"));
        menuItem = this.showContinentsMenuItem;
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("showContinents");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(this.cardsAction);
        menu.add(menuItem);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem = new SSMenuItem(this.cashCardsAction);
        menu.add(menuItem);
        menuItem = new SSMenuItem(this.fortifyAction);
        menu.add(menuItem);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem = new SSMenuItem(this.endTurnAction);
        menu.add(menuItem);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.addSeparator();
        menuItem = new SSMenuItem(new SaveGameAction());
        menu.add(menuItem);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem = new SSMenuItem(Translator.getString("Screenshot"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("screenshot");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(new ReplayAction());
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("replay");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        if (forWindow == null) {
            menuItem = new SSMenuItem(this.endGameAction);
            menu.add(menuItem);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        menuBar.add(menu);
        menu = new JMenu(Translator.getString("Board"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(77);
        }
        menuItem = new SSMenuItem(Translator.getString("ResizeMapLarger"));
        menuItem.setActionCommand("resizeBigger");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("ResizeMapSmaller"));
        menuItem.setActionCommand("resizeSmaller");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Tooriginalsize"));
        menuItem.setActionCommand("resizeMapToOriginal");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Tofitscreen"));
        menuItem.setActionCommand("resizeMapToFit");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(57, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Fullscreen"));
        menuItem.setActionCommand("fullscreen");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("GotoSavedBoards"));
        menuItem.setActionCommand("gotoSavedBoard");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("SaveBoard"));
        menuItem.setActionCommand("saveBoard");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("DeleteBoard"));
        menuItem.setActionCommand("deleteBoard");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("RateMap") + " \u2605\u2605\u2605\u2605\u2605");
        menuItem.setActionCommand("rateMap5");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RateMap") + " \u2605\u2605\u2605\u2605");
        menuItem.setActionCommand("rateMap4");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RateMap") + " \u2605\u2605\u2605");
        menuItem.setActionCommand("rateMap3");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RateMap") + " \u2605\u2605");
        menuItem.setActionCommand("rateMap2");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RateMap") + " \u2605");
        menuItem.setActionCommand("rateMap1");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menuBar.add(LuxController.getInstance().makeOnlineMenu());
        if (Prefs.getBoolean("radioMenu", false)) {
            menuBar.add(LuxController.getInstance().makeRadioMenu());
        }
        menuBar.add(LuxController.getInstance().makeHelpMenu());
        return menuBar;
    }

    public void startGame() {
        new Thread((Runnable)this, "GameControllerGUI").start();
    }

    public void setBoardSize() {
        EventThread.runInEventThread(this.setBoardSizeRunnable);
    }

    protected void giveStartingNetworkButtons() {
    }

    private int musicSequenceForArmySet(int armySetID) {
        if (armySetID == 6 || armySetID == 1 || armySetID == 2) {
            return 25;
        }
        if (armySetID == 4 || armySetID == 5) {
            return 24;
        }
        return 23;
    }

    public void run() {
        try {
            if (this.boardWindow == null) {
                this.createBoardWindow();
            }
            GameControllerGUI.reloadTutorial();
            this.luxView.setLoadText(Translator.getString("Initializing"));
            this.world = new LuxWorld(this);
            if (this.ops.biohazardLevel > 0) {
                this.luxView.setLoadText(this.ops.boardName() + "  " + (SS.isMacintosh ? "\u2623 " : "") + "BIO " + this.ops.biohazardLevel + "\n\n" + Translator.getString("Initializing"));
            }
            try {
                new LoadBoard(this);
            }
            catch (Throwable e) {
                this.debug("Lux -> a GameControllerGUI failed to load his board. Kill him off");
                e.printStackTrace();
                this.ops.deleteRandomBoardFile();
                String boardName = null;
                if (this.ops != null) {
                    boardName = this.ops.boardName();
                }
                this.boardWindow.hide();
                this.showMessage("Error loading '" + boardName + "'. \n\n" + e);
                this.kill(this);
                return;
            }
            MusicEngine.startTrackSequence(this.musicSequenceForArmySet(this.ops.boardFile.armySet()));
            this.world.finishCreation();
            this.luxView.setColors(this.ops.colorPass());
            try {
                this.luxView.createBackgroundComposite();
                this.luxView.setLoadText(null);
            }
            catch (OutOfMemoryError memerr) {
                memerr.printStackTrace();
                this.luxView.setLoadText("Out of Memory Error - " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ", VM: " + System.getProperty("java.version") + " / " + System.getProperty("java.class.version") + ", maxmem " + Runtime.getRuntime().maxMemory() / 1000000L);
                return;
            }
            this.nextMapButtonVisible = true;
            this.armySelector.remove(this.buttonCards);
            this.armySelector.remove(this.buttonBonuses);
            this.armySelector.remove(this.buttonFortify);
            this.armySelector.remove(this.buttonEndTurn);
            this.armySelector.remove(this.buttonCashCards);
            this.armySelector.remove(this.buttonReplay);
            this.armySelector.remove(this.buttonGameOptions);
            this.armySelector.remove(this.buttonNextMap);
            if (this.netBoss != null) {
                this.voteCount = 0;
                boolean weControlSomeone = false;
                for (int i = 0; i < this.ops.guiControl.length; ++i) {
                    weControlSomeone = weControlSomeone || this.ops.guiControl[i];
                }
                if (this.fullscreen) {
                    this.armySelector.add(this.buttonMenu);
                }
                this.armySelector.add(this.buttonBonuses);
                this.armySelector.add(this.buttonInfo);
                this.armySelector.add(this.spacerGlue);
                if (!weControlSomeone) {
                    this.nextMapButtonVisible = false;
                }
            } else {
                this.armySelector.add(this.buttonMenu);
                this.armySelector.add(this.buttonBonuses);
                this.armySelector.add(this.buttonInfo);
                this.armySelector.add(this.spacerGlue);
            }
            this.gameIsOver = false;
            this.armySelector.revalidate();
            this.armySelector.repaint();
            if (Prefs.getBoolean("playerInfoOpen", true)) {
                if (!Prefs.getBoolean("playerInfoSeperate", false) || this.fullscreen) {
                    this.luxView.setContainsPlayerInfo(true);
                } else {
                    this.showPlayerInfo(false, false);
                }
            }
            new Thread((Runnable)this.world, "LuxWorld").start();
            this.doneCreation = true;
            this.doneCreationHandler();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BoardCache.fillUpCache();
        }
        catch (Throwable t) {
            this.debug("Bad map created while filling up the random cache. No need to worry.");
        }
    }

    public void updateCardButton(int numberCards, boolean hasSet) {
        if (numberCards == 1 && Translator.getLocale().equals(Locale.ENGLISH)) {
            this.buttonCards.setText("1 Card");
        } else {
            this.buttonCards.setText(numberCards + " " + Translator.getString("Cards"));
        }
        this.buttonCards.setWidthForText();
        this.armySelector.revalidate();
        this.buttonCards.revalidate();
        if (hasSet) {
            this.boardWindow.getRootPane().setDefaultButton(this.buttonCards);
        } else if (!this.nextMapButtonVisible) {
            this.boardWindow.getRootPane().setDefaultButton(null);
        }
    }

    public void autoplayHandler() {
        Runnable autoplayRunnable = new Runnable(){

            public void run() {
                if (GameControllerGUI.this.netBoss != null) {
                    for (int i = 0; GameControllerGUI.this.nextMapButtonVisible && i < 30; ++i) {
                        if (i % 5 == 0) {
                            GameControllerGUI.this.netBoss.printToAll("tra: 3 :Autoplaygamewillstart: " + (30 - i) + " :seconds: - " + (GameControllerGUI.this.netBoss.getNumberOfHumans() - GameControllerGUI.this.netBoss.getNumberOfGuestOnly()) + "/" + GameControllerGUI.this.netBoss.getNumberOfHumans() + " :players:");
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception e) {
                            GameControllerGUI.this.debug("autoplay exception 83746");
                        }
                    }
                } else if (!PrefsCache.superfast) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception e) {
                        GameControllerGUI.this.debug("autoplay exception 7128682173");
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GameControllerGUI.this.autoplayAction();
                    }
                });
            }
        };
        new Thread(autoplayRunnable, "Autoplay-runner").start();
    }

    public void autoplayAction() {
        if (this.nextMapButtonVisible) {
            if (LuxController.getInstance().mapGeneratorSelected()) {
                this.clickNextMap();
            } else {
                this.clickReplayMap();
            }
        }
    }

    public void gameOver() {
        EventThread.runInEventThread(this.gameOverRunnable);
    }

    public void clickCards() {
        EventThread.runInEventThread(this.clickCardsRunnable);
    }

    public void clickCashCards() {
        if (!this.ops.guiControl[this.world.currentPlayer]) {
            this.debug("Only the current player can cash!");
            return;
        }
        if (this.world.cashUserCards(this.luxView.getSelectedCards())) {
            Card[] cards;
            boolean hasSet;
            if (PrefsCache.cashCardsSound) {
                cashCardsSound.play(true);
            }
            this.luxView.hideCards();
            this.luxView.setHelperText(null);
            this.cardsAction.setEnabled(true);
            Card[] curCards = this.world.getCurrentPlayerCards();
            this.updateCardButton(curCards.length, Card.containsASet(curCards));
            this.cashCardsAction.setEnabled(false);
            this.armySelector.remove(this.buttonCashCards);
            this.armySelector.remove(this.buttonCards);
            this.armySelector.remove(this.spacerGlue);
            this.armySelector.remove(this.spacerLabel);
            this.armySelector.add(this.buttonBonuses);
            this.armySelector.add(this.buttonInfo);
            this.armySelector.add(this.buttonCards);
            this.armySelector.add(this.spacerGlue);
            if (this.armySelector.getFluxArmies() <= 0) {
                this.armySelector.add(this.spacerGlue);
                if (this.fortifyAction.isEnabled()) {
                    this.armySelector.add(this.buttonFortify);
                }
                this.armySelector.add(this.buttonEndTurn);
            }
            boolean bl = hasSet = (cards = this.world.getCurrentPlayerCards()).length > 4 || Card.containsASet(cards);
            if (cards.length > 4 || PrefsCache.whenShowCards == 1 && hasSet || PrefsCache.whenShowCards == 2 && cards.length > 0 || PrefsCache.whenShowCards == 3) {
                this.clickCards();
            }
        } else {
            this.luxView.showNoticeBottomRight(Translator.getString("CashError"));
            SS.beep();
        }
    }

    protected void ensureCashCardsAvailable() {
        EventThread.runInEventThread(this.ensureCanCashRunnable);
    }

    public void clickFortify() {
        if (!this.luxView.cardsMode() && this.world.userCanStartFortifyPhase()) {
            this.fortifyAction.setEnabled(false);
            this.armySelector.remove(this.buttonFortify);
            this.armySelector.repaint();
            if (tutorialFirstFortifyPhase) {
                tutorialFirstFortifyPhase = false;
                this.luxView.showNoticeBottomRight(Translator.getString("tutorialFirstFortifyPhase"));
            } else {
                this.luxView.setHelperText(null);
            }
        } else {
            SS.beep();
        }
    }

    public void clickEndTurn() {
        if (!this.luxView.cardsMode() && this.armySelector.getFluxArmies() < 1 && !this.gameIsOver) {
            this.killUserButtons();
            this.armySelector.revalidate();
            this.armySelector.repaint();
            this.luxView.clearNotices();
            this.world.endUserTurn();
        } else {
            SS.beep();
        }
    }

    public void giveStartingButtons() {
        this.nextMapButtonVisible = false;
        this.armySelector.remove(this.buttonReplay);
        this.armySelector.remove(this.buttonNextMap);
        this.cardsAction.setEnabled(true);
        this.fortifyAction.setEnabled(true);
        this.endTurnAction.setEnabled(true);
        if (this.fullscreen) {
            this.armySelector.add(this.buttonMenu);
        }
        this.armySelector.add(this.buttonBonuses);
        this.armySelector.add(this.buttonInfo);
        this.armySelector.add(this.buttonCards);
        this.armySelector.add(this.spacerGlue);
        if (this.armySelector.getFluxArmies() <= 0) {
            this.armySelector.add(this.buttonFortify);
            this.armySelector.add(this.buttonEndTurn);
        }
        this.armySelector.revalidate();
        this.armySelector.repaint();
        LuxController.getInstance().upSharewareCount();
    }

    public void countryClicked(int country, boolean shiftPressed, boolean flipTillDeath, int numberSelected) {
        if (this.nextMapButtonVisible && !this.gameIsOver) {
            this.giveStartingButtons();
        }
        this.luxView.setHelperText(null);
        this.world.countryClicked(country, shiftPressed, flipTillDeath, numberSelected);
    }

    public void kill(Object sender) {
        if (this.masterControl && !this.gameIsOver && this.netBoss != null && this.netBoss.hasPlayingConnections()) {
            this.netBoss.sendToAll("hostQuitOnPurpose:");
            this.debug("mc is shutting down a game with active players");
        }
        if (this.playerInfo != null) {
            this.playerInfo.kill();
            this.playerInfo = null;
        }
        this.boardWindow.hide();
        System.out.println("GameControllerGUI: kill world: " + this.world);
        this.luxView.kill();
        this.armySelector.kill();
        this.widthBar.kill();
        this.gamePanel.remove(this.luxView);
        this.gamePanel.remove(this.armySelector);
        this.gamePanel.remove(this.bottomRow);
        this.bottomRow.remove(this.widthBar);
        this.bottomRow.remove(this.armySelector);
        this.gamePanel.remove(this.luxView);
        this.armySelector.remove(this.buttonNextMap);
        this.armySelector.remove(this.buttonCards);
        this.armySelector.remove(this.buttonFortify);
        this.armySelector.remove(this.buttonMenu);
        this.armySelector.remove(this.buttonBonuses);
        this.armySelector.remove(this.buttonEndTurn);
        this.armySelector.remove(this.buttonCashCards);
        this.armySelector.remove(this.buttonReplay);
        this.armySelector.remove(this.buttonGameOptions);
        this.armySelector.remove(this.spacerGlue);
        this.armySelector.remove(this.spacerLabel);
        LuxController.getInstance().killGame(this);
        this.saveTutorialState();
        super.kill();
        this.buttonNextMap = null;
        this.buttonEndTurn = null;
        this.buttonFortify = null;
        this.buttonBonuses = null;
        this.buttonMenu = null;
        this.buttonCards = null;
        this.buttonCashCards = null;
        this.buttonReplay = null;
        this.buttonGameOptions = null;
        this.themeMenu = null;
        this.gamePanel = null;
        this.splitPane = null;
        this.showContinentsMenuItem = null;
        this.luxView = null;
        this.armySelector = null;
        this.widthBar = null;
        this.bottomRow = null;
        this.spacerGlue = null;
        this.spacerLabel = null;
        this.endGameAction = null;
        this.cardsAction = null;
        this.bonusesAction = null;
        this.fortifyAction = null;
        this.endTurnAction = null;
        this.cashCardsAction = null;
        this.nextMapAction = null;
        this.takenOverPlayerNames = null;
        if (this.fullscreen) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
            }
            catch (Exception e) {
                SS.debug(e + " while exiting fullscreen");
            }
        }
        SwingTool.destroyMenu(this.boardWindow.getJMenuBar());
        this.boardWindow.setJMenuBar(null);
        this.boardWindow.setMenuBar(null);
        this.boardWindow.setContentPane(new JPanel());
        this.boardWindow.dispose();
        this.boardWindow = null;
        this.setBoardSizeRunnable = null;
        this.gameOverRunnable = null;
        this.clickCardsRunnable = null;
        this.ensureCanCashRunnable = null;
    }

    public void giveUserButtons() {
        this.endTurnAction.setEnabled(true);
        this.cardsAction.setEnabled(true);
        this.cardsAction.putValue("name", this.world.getCurrentPlayerCards().length + " " + Translator.getString("Cards"));
        this.fortifyAction.setEnabled(true);
        this.bonusesAction.setEnabled(true);
        if (this.armySelector.getFluxArmies() <= 0) {
            this.armySelector.add(this.spacerGlue);
            this.armySelector.add(this.buttonFortify);
            this.armySelector.add(this.buttonEndTurn);
        }
    }

    public void killUserButtons() {
        this.armySelector.remove(this.buttonFortify);
        this.armySelector.remove(this.buttonEndTurn);
        this.endTurnAction.setEnabled(false);
        this.fortifyAction.setEnabled(false);
    }

    public void giveUpPlayer(int playerIndex) {
        if (this.ops.guiControl[playerIndex]) {
            this.ops.guiControl[playerIndex] = false;
            if (this.world.currentPlayer == playerIndex) {
                this.debug("lost control of a player when it was their turn");
                this.killUserButtons();
                this.setFluxBox(0);
                this.luxView.selectCountry(-1);
                this.world.giveUpCurrentPlayer();
            }
            this.netBoss.println("\u2731 " + Translator.getString("lostControl") + " " + this.ops.playerNames[playerIndex] + " \u2731");
            this.takenOverPlayerNames[playerIndex] = null;
        }
    }

    public void lostServer(String serverName) {
        this.boardWindow.show();
        if (PrefsCache.useSound) {
            SS.beep();
        }
        if (this.netBoss.hostQuitOnPurpose) {
            this.netBoss.println("\u2731 " + Translator.getString("Thehostofthisgame") + " (" + serverName + ") " + Translator.getString("justendedthegameonpurpose") + " \u2731");
            try {
                this.netBoss.println("\u2731 " + Translator.getString("hostcausesproblems") + " ``lux/rankings/hosts/rate.php?host=" + URLEncoder.encode(serverName, "UTF-8") + "`" + Translator.getString("hostcausesproblemsLinkText") + "`" + " \u2731");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.showMessage(Translator.getString("Thehostofthisgame") + " (" + serverName + ") " + Translator.getString("justendedthegameonpurpose"));
        } else {
            this.netBoss.println("\u2731 " + Translator.getString("ConnectionLostWords") + " \u2731");
        }
        this.luxView.lostServer();
        this.lostServer = true;
    }

    public void showMenuInline() {
        MenuView mp = new MenuView(this.boardWindow, this);
        mp.takeControl();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.netBoss == null && (this.gameIsOver || this.nextMapButtonVisible) || this.netBoss != null && this.lostServer) {
            this.kill(this);
            return;
        }
        int answer = 0;
        if (this.masterControl && !this.gameIsOver && this.netBoss != null && this.netBoss.hasPlayingConnections() && !this.fullscreen) {
            answer = SSOptionPane.showConfirmDialog(this.boardWindow, Translator.getString("endGameQuestionClients") + "     ", Translator.getString("endGameTitle"), 0);
        } else if (!this.fullscreen) {
            Object[] options = new Object[]{Translator.getString("ExitGame"), Translator.getString("SaveGame"), Translator.getString("Cancel")};
            answer = SSOptionPane.showOptionDialog(this.boardWindow, Translator.getString("endGameQuestion") + "     ", Translator.getString("endGameTitle"), options, Translator.getString("ExitGame"));
            if (answer == 0) {
                this.kill(this);
                return;
            }
            if (answer == 1) {
                if (this.saveGame()) {
                    this.kill(this);
                }
                return;
            }
            if (answer == 2) {
                return;
            }
        }
        if (answer == 0) {
            this.kill(this);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
        if (this.ignoreNextResizeEvent) {
            this.ignoreNextResizeEvent = false;
            return;
        }
        if (!SS.isMacintosh || !this.doneCreation || this.resizeInProgress || e.getOldState() != 0 || e.getNewState() != 6 || this.mapIsOriginalSize()) {
            // empty if block
        }
    }

    public void componentHidden(ComponentEvent e) {
        SS.debug("componentHiden");
    }

    public void componentMoved(ComponentEvent e) {
        SS.debug("componentMoved");
    }

    public void componentShown(ComponentEvent e) {
        SS.debug("componentShown");
    }

    public void componentResized(ComponentEvent e) {
        if (this.ignoreNextResizeEvent) {
            this.ignoreNextResizeEvent = false;
            return;
        }
        if (this.doneCreation && !this.resizeInProgress && !this.fullscreen) {
            SS.debug("componentResized(" + e + ") gamePanel: " + this.gamePanel.getWidth() + "," + this.gamePanel.getHeight() + "   luxView.map: " + this.luxView.mapWidth + "," + this.luxView.mapHeight);
            double percent = GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, this.gamePanel.getWidth(), this.gamePanel.getHeight() - 40);
            if (percent == this.luxView.resizePercent) {
                return;
            }
            this.luxView.prepareToResizeMap(percent);
            try {
                this.ops.boardFile.load(this.luxView);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (percent == 1.0) {
                Prefs.remove("rz_" + this.ops.boardName());
            } else {
                Prefs.putFloat("rz_" + this.ops.boardName(), (float)percent);
                SS.debug("saving new resize preference a: " + percent);
            }
        }
    }

    public JComponent getPlayerInfoViewForSlaveMode() {
        this.showPlayerInfo(true, true);
        return this.playerInfo.getViewAndEnterSlaveMode();
    }

    public void hidePlayerInfo() {
        if (this.playerInfo != null) {
            this.playerInfo.hide();
        }
        this.luxView.setContainsPlayerInfo(false);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            String command = event.getActionCommand();
            if ("playerInfoToggle".equals(command)) {
                this.toggleShowPlayerInfo();
            } else if ("playerInfoHide".equals(command)) {
                this.hidePlayerInfo();
            } else if ("playerInfoInsideMap".equals(command)) {
                if (this.luxView.containsPlayerInfo()) {
                    this.luxView.setContainsPlayerInfo(false);
                    Prefs.putBoolean("playerInfoSeperate", true);
                    this.showPlayerInfo(true, false);
                } else {
                    this.luxView.setContainsPlayerInfo(true);
                    Prefs.putBoolean("playerInfoSeperate", false);
                }
            } else if ("screenshot".equals(command)) {
                this.luxView.clearNotices();
                String dir = DesktopTool.supportFolderPath() + "Screenshots" + File.separator;
                File dirFile = new File(dir);
                dirFile.mkdirs();
                String filename = dir + this.ops.boardName() + " round " + this.world.gameRound;
                if (new File(filename + ".png").exists()) {
                    int i = 1;
                    while (new File(filename + "." + i + ".png").exists()) {
                        ++i;
                    }
                    filename = filename + "." + i;
                }
                GraphicsTool.saveComponentAsJPEG(this.luxView, filename, Prefs.getBoolean("makeScreenshotThumbnail", false), this.luxView.mapWidth, this.luxView.mapHeight, SSApp.isVox);
                GraphicsTool.saveComponentAsPNG(this.luxView, filename, false, this.luxView.mapWidth, this.luxView.mapHeight);
                this.showMessage("A screenshot has been saved in: \n" + dir);
            } else if ("gotoSavedBoard".equals(command)) {
                FolderLauncher.openPath(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved");
            } else if ("deleteBoard".equals(command)) {
                String path = this.ops.boardFile.pathCustom();
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                    String previousMap = LuxController.getInstance().getPreviousMapName();
                    LuxController.getInstance().fillMapSelector(previousMap);
                }
                this.showMessage(Translator.getString("boardHasBeenDeleted"));
            } else if ("showContinents".equals(command)) {
                this.toggleContinentBonuses();
            } else if ("toggleChat".equals(command)) {
                this.toggleChatWindow();
            } else if ("saveBoard".equals(command)) {
                this.saveBoard();
            } else if ("resizeMapToFit".equals(command)) {
                this.resizeMapToFitTheScreen();
            } else if ("fullscreen".equals(command)) {
                this.toggleFullscreen();
            } else if ("resizeMapToOriginal".equals(command)) {
                this.doResize(false, this.ops.width, this.ops.height, true);
            } else if ("resizeBigger".equals(command)) {
                this.doResize(false, (int)((double)this.luxView.mapWidth * 1.1), this.luxView.mapHeight, true);
            } else if ("resizeSmaller".equals(command)) {
                this.doResize(false, (int)((double)this.luxView.mapWidth / 1.1), this.luxView.mapHeight, true);
            } else if (command.startsWith("setTheme:")) {
                String theme = command.substring(9);
                this.luxView.changeTheme(theme);
            } else if (command.startsWith("rateMap")) {
                int rating = Integer.parseInt(command.substring(7));
                PluginRater.rateMapTitled(this.ops.boardFile.title(), rating);
            } else {
                this.debug("Lux -> Unimplemented action command: " + command);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void toggleChatWindow() {
        this.debug("toggle chat window");
        if (this.netBoss == null) {
            return;
        }
        if (this.netBoss.activeSoloWindow()) {
            this.netBoss.prepForDrawer();
            this.splitPane.setLeftComponent(this.gamePanel);
            this.splitPane.setRightComponent(this.netBoss.getChatView());
            this.boardWindow.setContentPane(this.splitPane);
            this.boardWindow.pack();
            this.splitPane.setDividerLocation(Math.min(this.ops.height + 40, (int)GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getHeight() - 128));
            Prefs.putBoolean("seperateChatWindow", false);
        } else {
            this.boardWindow.setContentPane(this.gamePanel);
            this.boardWindow.pack();
            this.netBoss.goSolo();
            Prefs.putBoolean("seperateChatWindow", true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GameControllerGUI.this.netBoss.focusChatField();
            }
        });
    }

    public void saveBoard() {
        if (this.ops.customBoard && this.ops.boardFile.existsCustom()) {
            this.showMessage(Translator.getString("boardAlreadySaved") + " " + this.ops.boardFile.pathCustom() + ".");
            return;
        }
        if (LuxController.getInstance().getSharewareVersion()) {
            new RegisterNag("Marketing_Plugins.jpg", "saveBoard");
            return;
        }
        String name = this.ops.customBoard ? this.ops.boardName() : this.ops.boardSize + this.ops.boardNumber;
        String filename = name;
        if (!this.fullscreen) {
            filename = SSOptionPane.showInputDialog(this.boardWindow, Translator.getString("SaveBoardAs") + ":", name);
        }
        if (filename == null) {
            return;
        }
        if (!filename.endsWith(".luxb")) {
            filename = filename + ".luxb";
        }
        this.ops.boardFile.saveCustom(filename);
        LuxController.getInstance().fillMapSelector(filename);
        this.showMessage("The board has been saved. It will now be available from your map selector.");
    }

    public void resizeMapToFitTheScreen() {
        this.doResize(true, 0, 0, true);
    }

    private void doResize(boolean toFitTheScreen, int newWidth, int newHeight, boolean userInitiated) {
        this.resizeInProgress = true;
        this.ignoreNextResizeEvent = true;
        try {
            double percent = 1.0;
            Dimension screenDimension = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
            if (toFitTheScreen) {
                percent = GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, screenDimension.getWidth() - (double)SwingTool.WINDOW_HORIZONTAL_PADDING, screenDimension.getHeight() - (double)SwingTool.WINDOW_VERTICAL_PADDING - (double)(this.ops.width < 730 ? 80 : 40) - (double)(this.ops.allowNetworkPlayers && !Prefs.getBoolean("seperateChatWindow", false) ? 128 : 0));
                if (this.fullscreen) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Dimension fulldim = toolkit.getScreenSize();
                    percent = GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, fulldim.getWidth(), fulldim.getHeight() - (double)(this.ops.width < 730 ? 80 : 40) - (double)(this.ops.allowNetworkPlayers ? 128 : 0));
                    int mapWidth = (int)((double)this.ops.width * percent);
                    int extrawidth = (int)fulldim.getWidth() - mapWidth;
                }
            } else if (newWidth == this.luxView.mapWidth) {
                if (newHeight == this.luxView.mapHeight) {
                    this.resizeInProgress = false;
                    return;
                }
                percent = GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, 1000000.0, newHeight);
            } else {
                percent = newHeight == this.luxView.mapHeight ? GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, newWidth, 1000000.0) : GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, newWidth, newHeight);
            }
            int WIDTHBAR_WIDTH = (int)((double)this.ops.width * percent * 0.35);
            this.widthBar.setWidth(WIDTHBAR_WIDTH);
            this.armySelector.setPreferredSize(new Dimension((int)((double)this.ops.width * percent) - WIDTHBAR_WIDTH, 40));
            this.bottomRow.setMaximumSize(new Dimension((int)((double)this.ops.width * percent), 40));
            if (this.fullscreen) {
                this.scroller.setMaximumSize(new Dimension(1 + (int)Math.ceil((double)this.ops.width * percent), 1 + (int)Math.ceil((double)this.ops.height * percent)));
                this.scroller.setPreferredSize(new Dimension(1 + (int)Math.ceil((double)this.ops.width * percent), 1 + (int)Math.ceil((double)this.ops.height * percent)));
            }
            this.luxView.prepareToResizeMap(percent);
            this.ops.boardFile.load(this.luxView);
            this.setWindowForSize(percent);
            if (userInitiated && !this.fullscreen) {
                if (percent == 1.0) {
                    Prefs.remove("rz_" + this.ops.boardName());
                } else {
                    Prefs.putFloat("rz_" + this.ops.boardName(), (float)percent);
                    this.debug("saving new resize preference b: " + percent);
                }
            }
            this.resizedMap = this.ops.boardName();
            this.resizedPercent = percent;
            if (this.netBoss != null) {
                int divide = Math.min((int)((double)this.ops.height * percent) + 40, (int)screenDimension.getHeight() - 100);
                SS.debug("setSplitDivider: " + divide);
                this.splitPane.setDividerLocation(divide);
                if (!this.netBoss.activeSoloWindow()) {
                    this.netBoss.scrollDown();
                }
            }
            if (this.luxView.containsPlayerInfo()) {
                this.luxView.setContainsPlayerInfo(true);
            }
        }
        catch (Exception e) {
            this.showMessage(Translator.getString("Error") + ": " + e);
            e.printStackTrace();
        }
        this.resizeInProgress = false;
    }

    public boolean mapIsOriginalSize() {
        return this.ops.width == this.luxView.mapWidth;
    }

    public void setWindowForSize(double percent) {
        boolean needsVerticalScrollbar;
        SS.debug("setWindowForSize: " + percent);
        int newWidth = (int)((double)this.ops.width * percent);
        int newHeight = (int)((double)this.ops.height * percent);
        if (!this.fullscreen) {
            newWidth += SwingTool.WINDOW_HORIZONTAL_PADDING;
        }
        if (this.netBoss != null && !this.netBoss.activeSoloWindow()) {
            newHeight += this.CHATPANEL_HEIGHT;
        }
        Dimension screenDimension = SwingTool.getUsableDimension();
        if (this.fullscreen) {
            Dimension fulldim;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            screenDimension = fulldim = toolkit.getScreenSize();
        }
        newHeight += this.ops.width < 730 ? 80 : 40;
        if (!this.fullscreen) {
            newHeight += SwingTool.WINDOW_VERTICAL_PADDING;
        }
        boolean bl = needsVerticalScrollbar = (double)newHeight > screenDimension.getHeight();
        if (needsVerticalScrollbar && !this.fullscreen) {
            newWidth += SwingTool.SCROLLBAR_SIZE;
            SS.debug("boosting width to compensate for vertical scroller: ");
        }
        newWidth = (int)Math.min(screenDimension.getWidth(), (double)newWidth);
        newHeight = (int)Math.min(screenDimension.getHeight() + (double)(SS.isMacintosh ? 0 : 8), (double)newHeight);
        if (this.fullscreen) {
            newHeight = (int)Math.min(screenDimension.getHeight(), (double)newHeight);
        }
        SS.debug("resize map final window size: (" + newWidth + "," + newHeight + ")");
        if (!this.fullscreen) {
            this.boardWindow.setSize(newWidth, newHeight);
        }
        if ((double)(newWidth + 20) > screenDimension.getWidth() && (double)(newHeight + 20) > screenDimension.getHeight() && !this.fullscreen) {
            this.boardWindow.setExtendedState(6);
            SS.debug("final setExtendedState(Frame.MAXIMIZED_BOTH)");
        }
    }

    public void createUserButtons() {
        this.nextMapButtonVisible = false;
        this.armySelector.remove(this.buttonReplay);
        this.armySelector.remove(this.buttonNextMap);
        if (this.fullscreen) {
            this.armySelector.add(this.buttonMenu);
        }
        this.armySelector.add(this.buttonInfo);
        this.armySelector.add(this.buttonCards);
        if (this.armySelector.getFluxArmies() <= 0) {
            this.armySelector.add(this.spacerGlue);
            this.armySelector.add(this.buttonFortify);
            this.armySelector.add(this.buttonEndTurn);
        }
        this.armySelector.revalidate();
    }

    public void toggleContinentBonuses() {
        this.continentMode = !this.continentMode;
        this.luxView.toggleContinentBonuses();
        this.armySelector.setContinentMode(this.continentMode);
        this.showContinentsMenuItem.setState(this.continentMode);
        if (this.continentMode) {
            this.armySelector.remove(this.buttonFortify);
            this.armySelector.remove(this.buttonEndTurn);
        } else if (this.armySelector.getFluxArmies() <= 0 && !this.luxView.cardsMode() && this.ops.guiControl[this.world.currentPlayer]) {
            this.armySelector.add(this.spacerGlue);
            if (this.fortifyAction.isEnabled()) {
                this.armySelector.add(this.buttonFortify);
            }
            this.armySelector.add(this.buttonEndTurn);
        }
    }

    public void setFluxBox(int n) {
        this.armySelector.setFluxBox(n);
        if (n > 0) {
            this.armySelector.remove(this.buttonEndTurn);
            this.armySelector.remove(this.buttonFortify);
        } else if (this.world.gamePhase == 3) {
            this.armySelector.add(this.spacerGlue);
            if (this.fortifyAction.isEnabled()) {
                this.armySelector.add(this.buttonFortify);
            }
            this.armySelector.add(this.buttonEndTurn);
            this.armySelector.revalidate();
        }
    }

    public boolean cardsMode() {
        return this.luxView.cardsMode();
    }

    public void forceClientEndTurn() {
        this.forceTurnEnd = true;
        if (this.luxView.cardsMode()) {
            this.clickCards();
        }
        this.world.endUserTurn();
        this.forceTurnEnd = false;
    }

    protected void forceLocalEndTurn() {
        if (!this.ops.guiControl[this.world.currentPlayer]) {
            this.debug("Oops. forceLocalEndTurn() error condition 2346527346");
            return;
        }
        if (this.luxView.cardsMode()) {
            this.clickCards();
        }
        if (this.armySelector.getFluxArmies() > 0) {
            this.world.forcePlaceFluxArmies();
        }
        this.clickEndTurn();
    }

    public void cardsWereCashed() {
        if (this.playerInfo != null) {
            this.playerInfo.cardsWereCashed();
        }
    }

    public int getViewportBottom() {
        try {
            Rectangle r = this.scroller.getViewport().getViewRect();
            return (int)(r.getY() + r.getHeight());
        }
        catch (Exception e) {
            return this.luxView.mapHeight;
        }
    }

    public int getViewportLeft() {
        try {
            return this.scroller.getViewport().getViewPosition().x;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setBoardName(String name) {
        if (name == null) {
            return;
        }
        StringBuffer titleBuffer = new StringBuffer("Lux Delux (");
        titleBuffer.append(name);
        if (this.ops.useCards) {
            titleBuffer.append(" - ");
            titleBuffer.append(CardSequence.sequences[this.ops.cardSequenceCode]);
        }
        if (this.ops.continentSequence.increases()) {
            titleBuffer.append(" - ");
            titleBuffer.append(this.ops.continentSequence.shortString());
        }
        if (this.ops.useTurnTimer) {
            titleBuffer.append(" - ");
            titleBuffer.append((int)this.ops.turnTimerLength);
            titleBuffer.append("s");
        }
        if (this.ops.internetPublic && this.ops.isRanked) {
            titleBuffer.append(" - ");
            titleBuffer.append(Translator.getString("Rankedgame"));
        }
        titleBuffer.append(")");
        this.boardWindow.setTitle(titleBuffer.toString());
        this.ops.setBoardTitle(name);
    }

    public static void reloadTutorial() {
        tutorialStart = Prefs.getBoolean("tutorialStart", true);
        tutorialStart2 = Prefs.getBoolean("tutorialStart2", true);
        tutorialStart3 = Prefs.getBoolean("tutorialStart3", true);
        tutorialPlaceInitialArmies = Prefs.getBoolean("tutorialPlaceInitialArmies", true);
        tutorialAttackDraw = Prefs.getBoolean("tutorialAttackDraw", true);
        tutorialTookCountry = Prefs.getBoolean("tutorialTookCountry", true);
        tutorialEliminatedPlayer = Prefs.getBoolean("tutorialEliminatedPlayer", true);
        tutorialAttackPhase = Prefs.getBoolean("tutorialAttackPhase", true);
        tutorialStartTurn = Prefs.getBoolean("tutorialStartTurn", true);
        tutorialStartTurnWithSet = Prefs.getBoolean("tutorialStartTurnWithSet", true);
        tutorialFirstCard = Prefs.getBoolean("tutorialFirstCard", true);
        tutorialFirstFortifyPhase = Prefs.getBoolean("tutorialFirstFortifyPhase", true);
        tutorialPlaceInitialArmiesAll = Prefs.getBoolean("tutorialPlaceInitialArmiesAll", true);
        tutorialPlaceInitialArmiesThird = Prefs.getBoolean("tutorialPlaceInitialArmiesThird", true);
        tutorialMoveInArmies = Prefs.getBoolean("tutorialMoveInArmies", true);
        tutorialShowCards = Prefs.getBoolean("tutorialShowCards", true);
        tutorialCashCards = Prefs.getBoolean("tutorialCashCards", true);
        tutorialIncomes = Prefs.getBoolean("tutorialIncomes", true);
        tutorialDoneMovingIn = Prefs.getBoolean("tutorialDoneMovingIn", true);
        tutorialEndTurn = Prefs.getBoolean("tutorialEndTurn", true);
    }

    protected void saveTutorialState() {
        Prefs.putBoolean("tutorialStart", tutorialStart);
        Prefs.putBoolean("tutorialStart2", tutorialStart2);
        Prefs.putBoolean("tutorialStart3", tutorialStart3);
        Prefs.putBoolean("tutorialPlaceInitialArmies", tutorialPlaceInitialArmies);
        Prefs.putBoolean("tutorialAttackDraw", tutorialAttackDraw);
        Prefs.putBoolean("tutorialTookCountry", tutorialTookCountry);
        Prefs.putBoolean("tutorialEliminatedPlayer", tutorialEliminatedPlayer);
        Prefs.putBoolean("tutorialAttackPhase", tutorialAttackPhase);
        Prefs.putBoolean("tutorialStartTurn", tutorialStartTurn);
        Prefs.putBoolean("tutorialStartTurnWithSet", tutorialStartTurnWithSet);
        Prefs.putBoolean("tutorialFirstCard", tutorialFirstCard);
        Prefs.putBoolean("tutorialFirstFortifyPhase", tutorialFirstFortifyPhase);
        Prefs.putBoolean("tutorialPlaceInitialArmiesAll", tutorialPlaceInitialArmiesAll);
        Prefs.putBoolean("tutorialPlaceInitialArmiesThird", tutorialPlaceInitialArmiesThird);
        Prefs.putBoolean("tutorialMoveInArmies", tutorialMoveInArmies);
        Prefs.putBoolean("tutorialShowCards", tutorialShowCards);
        Prefs.putBoolean("tutorialCashCards", tutorialCashCards);
        Prefs.putBoolean("tutorialIncomes", tutorialIncomes);
        Prefs.putBoolean("tutorialDoneMovingIn", tutorialDoneMovingIn);
        Prefs.putBoolean("tutorialEndTurn", tutorialEndTurn);
        Prefs.sync();
    }

    public void userChooseCountries() {
        if (tutorialStart) {
            tutorialStart = false;
            this.luxView.showNotice(Translator.getString("tutorialStart"));
        } else if (tutorialStart2) {
            tutorialStart2 = false;
            this.luxView.showNotice(Translator.getString("tutorialStart2"));
        } else if (tutorialStart3) {
            tutorialStart3 = false;
            this.luxView.showNotice(Translator.getString("tutorialStart3"));
        } else {
            this.luxView.setHelperText(null);
        }
        if (PrefsCache.startTurnSound) {
            yourTurnSound.play(true);
        }
    }

    public void userPlaceInitialArmies() {
        if (tutorialPlaceInitialArmies) {
            tutorialPlaceInitialArmies = false;
            this.luxView.showNotice(Translator.getString("tutorialPlaceInitialArmies"));
            this.luxView.showNoticeBottomRight(Translator.getString("tutorialWaitingArmies"));
        } else if (tutorialPlaceInitialArmiesAll) {
            tutorialPlaceInitialArmiesAll = false;
            this.luxView.showNotice(Translator.getString("tutorialPlaceInitialArmiesAll"));
        } else if (tutorialPlaceInitialArmiesThird) {
            tutorialPlaceInitialArmiesThird = false;
            this.luxView.showNotice(Translator.getString("tutorialPlaceInitialArmiesThird"));
        }
        if (PrefsCache.startTurnSound) {
            yourTurnSound.play(true);
        }
        this.luxView.setProperCursor();
    }

    public void userEliminatedPlayer() {
        if (tutorialEliminatedPlayer || LuxController.getInstance().getSharewareCount() < 3) {
            tutorialEliminatedPlayer = false;
            this.luxView.showNotice(Translator.getString("tutorialEliminatedPlayer"));
        }
    }

    private void earlyAttackWarningCheck(int cc) {
        if (LuxController.getInstance().getSharewareCount() < 5 && this.world.gameRound < 4 && !this.shownEarlyAttackTip) {
            ++this.earlyAttacks;
            if (this.earlyAttacks > 4) {
                this.luxView.showNoticeOnCountry(Translator.getString("tutorialEarlyAttacks"), cc);
                this.shownEarlyAttackTip = true;
            }
        }
    }

    public void userAttackWin(int cc) {
        this.earlyAttackWarningCheck(cc);
    }

    public void userAttackLose(int cc) {
    }

    public void userAttackDraw(int cc) {
        this.earlyAttackWarningCheck(cc);
        if (tutorialAttackDraw) {
            tutorialAttackDraw = false;
        }
    }

    public void userTookCountry() {
        if (tutorialTookCountry) {
            tutorialTookCountry = false;
        }
    }

    public void userMoveInArmies(int cc) {
        if (tutorialMoveInArmies) {
            tutorialMoveInArmies = false;
            this.luxView.showNoticeOnCountry(Translator.getString("tutorialMoveInArmies"), cc);
        }
    }

    public void doneMovingIn(int cc) {
        if (tutorialDoneMovingIn) {
            tutorialDoneMovingIn = false;
            this.luxView.showNoticeOnCountry(Translator.getString("tutorialDoneMovingIn"), cc);
        } else if (tutorialEndTurn || LuxController.getInstance().getSharewareCount() < 3 && this.world.gameRound < 4) {
            tutorialEndTurn = false;
            this.luxView.showNoticeOnCountry(Translator.getString("tutorialEndTurn"), cc);
        }
    }

    public void userAttackPhase(int cc) {
        this.earlyAttacks = 0;
        this.shownEarlyAttackTip = false;
        if (tutorialAttackPhase) {
            tutorialAttackPhase = false;
            this.luxView.showNoticeOnCountry(Translator.getString("tutorialAttackPhase"), cc);
        }
    }

    public void startUserTurn(Card[] cards) {
        boolean hasSet;
        this.boardWindow.toFront();
        this.giveUserButtons();
        boolean bl = hasSet = cards.length > 4 || Card.containsASet(cards);
        if (PrefsCache.startTurnSound) {
            yourTurnSound.play(true);
        }
        if (tutorialStartTurn) {
            tutorialStartTurn = false;
            this.luxView.showNotice(Translator.getString("tutorialStartTurn"));
        } else if (hasSet && tutorialStartTurnWithSet) {
            tutorialStartTurnWithSet = false;
            this.luxView.showNotice(Translator.getString("tutorialStartTurnWithSet"));
        } else if (tutorialFirstCard && cards.length == 1) {
            tutorialFirstCard = false;
            this.luxView.showNotice(Translator.getString("tutorialFirstCard"));
        } else if (tutorialIncomes) {
            tutorialIncomes = false;
        } else {
            this.luxView.setHelperText(null);
        }
        if (!this.luxView.cardsMode() && (cards.length > 4 || PrefsCache.whenShowCards == 1 && hasSet || PrefsCache.whenShowCards == 2 && cards.length > 0 || PrefsCache.whenShowCards == 3)) {
            this.clickCards();
        }
        if (this.luxView.cardsMode() && hasSet) {
            this.ensureCashCardsAvailable();
        }
        if (!this.luxView.cardsMode()) {
            this.updateCardButton(cards.length, hasSet);
        }
        this.luxView.setProperCursor();
    }

    protected void playNextMap() {
        this.luxView.setLoadText("Reticulating Splines");
        this.luxView.clearView();
        if (this.world != null) {
            this.world.kill();
            this.debug("killed world");
            this.world = null;
        }
        this.startGame();
    }

    public void setArrowOnCountry(int countryFrom, int countryTo) {
        this.luxView.setArrowOnCountry(countryFrom, countryTo);
    }

    public void setArrowOnCountry(int countryFrom, int[] countryToArray) {
        this.luxView.setArrowOnCountry(countryFrom, countryToArray);
    }

    public void setArrowOnCountry(int countryFrom, int[] countryToArray, boolean doubleArrow) {
        this.luxView.setArrowOnCountry(countryFrom, countryToArray, doubleArrow);
    }

    public void setLoadText(String text) {
        this.luxView.setLoadText(text);
    }

    public int getFluxArmies() {
        return this.armySelector.getFluxArmies();
    }

    public void setWinningImage(String imageURL) {
        this.luxView.setWinningImage(imageURL);
        this.netBoss.sendToAll("swi: " + imageURL);
    }

    public void flashContinent(int cont) {
        this.luxView.flashContinent(cont);
    }

    protected void lowTimerWarning() {
        if (LuxView.turnExpiredSound != null) {
            LuxView.turnExpiredSound.play();
        }
    }

    public void turnTimerTick() {
        Card[] cards;
        super.turnTimerTick();
        if (this.widthBar != null) {
            this.widthBar.repaint(0L, 0, 0, 50, 32);
        }
        if (this.turnSecondsLeft == 3 && this.luxView.cardsMode() && this.ops.guiControl[this.world.currentPlayer] && (cards = this.world.getPlayerCards(this.world.currentPlayer)).length > 4) {
            this.luxView.selectCardSet(Card.getBestSet(cards, this.world.currentPlayer, this.world.countries));
            this.buttonCashCards.doClick();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Adjustable source = evt.getAdjustable();
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.luxView.repaint();
    }

    public boolean saveGame() {
        if (this.world.gameRound < 1) {
            this.showMessage("You cannot save a game before round 1.");
            return false;
        }
        String filename = this.ops.boardTitle() + " round " + this.world.gameRound;
        if (!this.fullscreen) {
            filename = SSOptionPane.showInputDialog(this.boardWindow, Translator.getString("SaveBoardAs") + ":", filename);
        }
        SS.debug(filename);
        if (filename == null) {
            return false;
        }
        this.ops.boardFile.saveGame(this, filename);
        this.showMessage(Translator.getString("SavedGameFinished"));
        return true;
    }

    public void alertGameStarted() {
    }

    public void toggleShowPlayerInfo() {
        boolean open = Prefs.getBoolean("playerInfoOpen", true);
        if (open) {
            if (this.luxView.containsPlayerInfo()) {
                this.luxView.setContainsPlayerInfo(false);
            } else {
                this.playerInfo.hide();
            }
        } else if (!Prefs.getBoolean("playerInfoSeperate", false) || this.fullscreen) {
            this.luxView.setContainsPlayerInfo(true);
        } else {
            this.showPlayerInfo(true, false);
        }
        Prefs.putBoolean("playerInfoOpen", !open);
    }

    public void setPlacingKey(int placingKey) {
        this.luxView.setPlacingKey(placingKey);
    }

    public boolean usedPlacedDividerKey() {
        return this.luxView.usedPlacedDividerKey();
    }

    public void escapeKey() {
        this.luxView.escapeKeyActions();
    }

    public void columnsResizePI() {
        this.playerInfo.columnsResizePI();
    }

    public int getScreenWidth() {
        Dimension fulldim = Toolkit.getDefaultToolkit().getScreenSize();
        return fulldim.width;
    }

    public int getStartingWidth() {
        if (Prefs.getBoolean("fullscreen", false)) {
            Dimension fulldim = Toolkit.getDefaultToolkit().getScreenSize();
            return fulldim.width;
        }
        return 700;
    }

    public int getStartingHeight() {
        if (Prefs.getBoolean("fullscreen", false)) {
            Dimension fulldim = Toolkit.getDefaultToolkit().getScreenSize();
            return fulldim.height;
        }
        return 400;
    }

    public void showMessage(String message) {
        if (!this.fullscreen) {
            SSOptionPane.showMessageDialog(this.boardWindow, message, null, 1);
        } else {
            this.luxView.showNotice(message);
        }
    }

    public void showNoticeOnCountry(String text, int countryID) {
        this.luxView.showNoticeOnCountry(text, countryID);
    }

    static {
        buttonColor = new Color(77, 64, 222);
        tutorialStart = true;
        tutorialStart2 = true;
        tutorialStart3 = true;
        tutorialPlaceInitialArmies = true;
        tutorialAttackDraw = true;
        tutorialTookCountry = true;
        tutorialEliminatedPlayer = true;
        tutorialAttackPhase = true;
        tutorialStartTurn = true;
        tutorialStartTurnWithSet = true;
        tutorialFirstCard = true;
        tutorialFirstFortifyPhase = true;
        tutorialPlaceInitialArmiesAll = true;
        tutorialPlaceInitialArmiesThird = true;
        tutorialMoveInArmies = true;
        tutorialShowCards = true;
        tutorialCashCards = true;
        tutorialIncomes = true;
        tutorialDoneMovingIn = true;
        tutorialEndTurn = true;
        cashCardsSound = new SoundEffect("cashCards.wav");
    }

    public class GameOptionsAction
    extends AbstractAction {
        public GameOptionsAction() {
            super(Translator.getString("MainMenu"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.clickGameOptions();
        }
    }

    public class ReplayAction
    extends AbstractAction {
        public ReplayAction() {
            super(Translator.getString("ReplayMap"));
        }

        public void actionPerformed(ActionEvent e) {
            if (GameControllerGUI.this.doneCreation) {
                GameControllerGUI.this.doneCreation = false;
                GameControllerGUI.this.clickReplayMap();
            }
        }
    }

    public class NextMapAction
    extends AbstractAction {
        public NextMapAction() {
            super(Translator.getString("PlayNextMap"));
        }

        public void actionPerformed(ActionEvent e) {
            if (GameControllerGUI.this.doneCreation) {
                GameControllerGUI.this.doneCreation = false;
                GameControllerGUI.this.clickNextMap();
            }
        }
    }

    public class EndGameAction
    extends AbstractAction {
        public EndGameAction() {
            super(Translator.getString("EndGame"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.windowClosing(null);
        }
    }

    public class MenuAction
    extends AbstractAction {
        public MenuAction() {
            super(Translator.getString("Menu"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.showMenuInline();
        }
    }

    public class InfoAction
    extends AbstractAction {
        public InfoAction() {
            super(Translator.getString("InfoButton"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.toggleShowPlayerInfo();
        }
    }

    public class CashCardsAction
    extends AbstractAction {
        public CashCardsAction() {
            super(Translator.getString("CashCards"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.clickCashCards();
        }
    }

    public class EndTurnAction
    extends AbstractAction {
        public EndTurnAction() {
            super(Translator.getString("EndTurn"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.clickEndTurn();
        }
    }

    public class BonusesAction
    extends AbstractAction {
        public BonusesAction() {
            super(Translator.getString("Bonuses"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.toggleContinentBonuses();
        }
    }

    public class FortifyAction
    extends AbstractAction {
        public FortifyAction() {
            super(Translator.getString("Fortify"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.clickFortify();
        }
    }

    public class cardsAction
    extends AbstractAction {
        public cardsAction() {
            super(Translator.getString("Cards"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.clickCards();
        }
    }

    public class SaveGameAction
    extends AbstractAction {
        public SaveGameAction() {
            super(Translator.getString("SaveGame"));
        }

        public void actionPerformed(ActionEvent e) {
            GameControllerGUI.this.saveGame();
        }
    }
}

