/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.Stats;
import com.sillysoft.lux.ViewManager;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.PlayerInfoController;
import com.sillysoft.lux.gui.TurnTimerManager;
import com.sillysoft.lux.gui.TurnTimerTask;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.lux.net.NetConnection;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public abstract class GameControllerAbstract
implements TurnTimerManager {
    public ViewManager viewManager;
    public LuxOptions ops;
    public LuxWorld world;
    public boolean masterControl;
    public boolean doneCreation;
    protected boolean gameIsOver = false;
    protected boolean nextMapButtonVisible = false;
    protected boolean nextMapButtonDefault = true;
    protected int voteCount = 0;
    public NetBoss netBoss;
    public Stats stats;
    protected String lostClientName;
    private Timer turnTimer;
    public boolean forceTurnEnd = false;
    protected PlayerInfoController playerInfo;
    public String[] takenOverPlayerNames = new String[6];
    protected int turnSecondsLeft;
    public GameTimeLimiterThread gameLimitThread;

    public GameControllerAbstract(LuxOptions ops, boolean masterControl, NetBoss netBoss) {
        this.ops = ops;
        this.masterControl = masterControl;
        this.netBoss = netBoss;
        if (netBoss != null) {
            netBoss.setControl(this);
        }
        this.viewManager = new ViewManager();
        this.stats = new Stats(this);
        this.turnTimer = new Timer();
        this.turnTimer.schedule((TimerTask)new TurnTimerTask(this), 1000L, 1000L);
    }

    public abstract void flashContinent(int var1);

    public abstract void createUserButtons();

    public abstract void giveUserButtons();

    protected abstract void playNextMap();

    public abstract void updateCardButton(int var1, boolean var2);

    public abstract boolean cardsMode();

    public abstract void clickCards();

    public abstract void clickEndTurn();

    public abstract void startGame();

    public abstract void giveUpPlayer(int var1);

    protected abstract void forceLocalEndTurn();

    protected abstract void ensureCashCardsAvailable();

    public abstract void setFluxBox(int var1);

    public abstract void startUserTurn(Card[] var1);

    public abstract void userMoveInArmies(int var1);

    public abstract void doneMovingIn(int var1);

    public abstract void cardsWereCashed();

    public abstract void userChooseCountries();

    public abstract void userPlaceInitialArmies();

    public abstract void userAttackWin(int var1);

    public abstract void userAttackLose(int var1);

    public abstract void userAttackDraw(int var1);

    public abstract void userAttackPhase(int var1);

    public abstract void userEliminatedPlayer();

    public abstract void gameOver();

    public abstract void setArrowOnCountry(int var1, int var2);

    public abstract void setArrowOnCountry(int var1, int[] var2);

    public abstract void setArrowOnCountry(int var1, int[] var2, boolean var3);

    public abstract void setLoadText(String var1);

    public abstract int getFluxArmies();

    public void turnTimerExpired() {
        if (this.masterControl) {
            this.forceTurnEnd = true;
            if (this.netBoss != null) {
                String expiredPlayerName = this.ops.playerNames[this.world.currentPlayer];
                this.netBoss.printToAll("tra: 3 " + expiredPlayerName + " :ranOutOfTurnTime:");
            }
            if (this.ops.guiControl[this.world.currentPlayer]) {
                this.debug("time is up, force end a LOCAL player turn");
                this.forceLocalEndTurn();
            } else if (!"Human".equals(this.ops.playerTypes[this.world.currentPlayer])) {
                this.debug("A computer player ran out of time");
            } else {
                this.world.ignoreNextActiveCommandFrom(this.world.currentPlayer);
                this.world.gotoNextPlayer();
                Thread.yield();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.yield();
            }
            this.forceTurnEnd = false;
        }
    }

    public void turnTimerExpiredInitialPhases() {
        this.forceTurnEnd = true;
        if (this.masterControl && this.netBoss != null) {
            this.netBoss.printToAll("tra: 3 " + this.ops.playerNames[this.world.currentPlayer] + " :ranOutOfTurnTime:");
        }
        if (!"Human".equals(this.ops.playerTypes[this.world.currentPlayer])) {
            this.debug("A computer player ran out of time during initial phases");
        } else if (this.ops.guiControl[this.world.currentPlayer]) {
            this.debug("initial phase turn time limit exceeded, selecting for a local player");
            if (this.world.gamePhase == 1) {
                int randomCountry;
                Random rand = new Random();
                while (this.world.countries[randomCountry = rand.nextInt(this.world.countries.length)].getOwner() != -1) {
                }
                this.world.chooseUserCountry(randomCountry);
            } else if (this.world.gamePhase == 2 && this.getFluxArmies() > 0) {
                int randomCountry;
                Random rand = new Random();
                while (this.world.countries[randomCountry = rand.nextInt(this.world.countries.length)].getOwner() != this.world.currentPlayer) {
                }
                this.world.placeInitialUserArmies(randomCountry, true, 1);
            }
        } else if (this.masterControl) {
            this.world.ignoreNextActiveCommandFrom(this.world.currentPlayer);
            this.world.ignoreNextActiveCommandFrom(this.world.currentPlayer);
            this.debug("turn time limit exceeded, forcing an end to the turn of a REMOTE player in initial stages");
            Thread.yield();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.yield();
        }
        this.forceTurnEnd = false;
    }

    public void clickGameOptions() {
        if (this.netBoss == null) {
            ((GameControllerGUI)this).kill(this);
            LuxController.getInstance().showNewGameWindow();
        } else {
            LuxController.getInstance().showNewGameWindow();
        }
    }

    public void clickNextMap() {
        SS.debug("clickNextMap()");
        Prefs.putBoolean("nextMapButtonDefault", true);
        if (!this.ops.allowNetworkPlayers || !NetBoss.maplock) {
            LuxController.getInstance().cycleSaved();
        }
        if (this.netBoss != null) {
            this.netBoss.startGame();
        } else {
            this.ops = LuxController.getInstance().currentOptions().ensureProperOrder();
            this.ops.removeRemoteOnly();
            this.playNextMap();
        }
    }

    public void recieveVote(boolean voteFor) {
        if (voteFor) {
            ++this.voteCount;
            int humanCount = 0;
            for (int i = 0; i < this.ops.playerTypes.length; ++i) {
                if (!"Human".equals(this.ops.playerTypes[i])) continue;
                ++humanCount;
            }
            if (this.voteCount * 2 >= humanCount) {
                this.netBoss.println("\u2731 " + Translator.getString("playersVoted") + " \u2731");
                this.netBoss.sendToAll("tra: 2 playersVoted");
                if (!NetBoss.maplock) {
                    LuxController.getInstance().cycleSaved();
                }
                this.netBoss.startGame();
            }
        } else {
            --this.voteCount;
        }
    }

    public void takeNewOps(LuxOptions ops) {
        this.ops = ops;
        this.netBoss.println("\u2731 " + Translator.getString("loadingNext") + " \u2731");
        this.takenOverPlayerNames = new String[6];
        this.doneCreation = false;
        this.playNextMap();
    }

    public void setDelay(int delay) {
        if (this.world != null) {
            LuxWorld.setDelay(delay);
        }
    }

    public int getNextCardSetValue() {
        return this.world.getNextCardSetValue();
    }

    protected void debug(Object text) {
        if (PrefsCache.superfast) {
            return;
        }
        System.out.println("GC of " + this.world + " says: " + text);
        System.out.flush();
    }

    public void showPlayerInfo(boolean userInitiated, boolean forSlaveMode) {
        if (this.world == null) {
            this.debug("playerInfo.show() called with world == null");
            return;
        }
        if (this.playerInfo == null) {
            try {
                this.playerInfo = new PlayerInfoController((GameControllerGUI)this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.playerInfo.show((GameControllerGUI)this, userInitiated, forSlaveMode);
    }

    public void playerRejoined(NetConnection n) {
        String clientName = n.name();
        int player = this.playerCode(clientName);
        if (!this.checkLostPlayerIsEliminated(clientName)) {
            this.debug("restoring control to rejoined player " + clientName);
            this.netBoss.log("restoring control to rejoined player " + clientName);
            this.giveUpPlayer(player);
            this.world.restoreLostPlayer(player);
            this.netBoss.restoreLostPlayer(n, player);
        }
        if (clientName.equals(this.lostClientName)) {
            this.lostClientName = null;
        }
    }

    protected int playerCode(String playerName) {
        for (int i = 0; i < this.ops.playerNames.length; ++i) {
            if (!this.ops.playerNames[i].equals(playerName) && !playerName.equals(this.takenOverPlayerNames[i])) continue;
            return i;
        }
        this.debug("playerCode(" + playerName + ") failed");
        return -1;
    }

    protected boolean checkLostPlayerIsEliminated(String clientName) {
        if (this.gameIsOver) {
            return true;
        }
        boolean controlsSomebody = false;
        for (int i = 0; i < this.ops.playerNames.length; ++i) {
            if (!this.ops.playerNames[i].equals(clientName) && !clientName.equals(this.takenOverPlayerNames[i])) continue;
            if (this.stats.getOwned(i) == 0) {
                this.ops.guiControl[i] = true;
                continue;
            }
            controlsSomebody = true;
        }
        return !controlsSomebody;
    }

    public void giveGuestPlayer(String clientName) {
        this.debug("giveGuestPlayer: " + clientName);
        for (int i = 0; i < this.ops.playerNames.length; ++i) {
            if (!this.ops.playerNames[i].equals(clientName) && !clientName.equals(this.takenOverPlayerNames[i])) continue;
            this.giveUpPlayer(i);
            this.ops.playerTypes[i] = "Human";
            this.takenOverPlayerNames[i] = this.netBoss.giveGuestPlayer(i);
            this.debug("player " + this.ops.playerNames[i] + " is now controlled by " + this.takenOverPlayerNames[i]);
            this.netBoss.log("player " + this.ops.playerNames[i] + " is now controlled by " + this.takenOverPlayerNames[i]);
            return;
        }
    }

    public int getPlayerIndexForControllingName(String controllingName) {
        for (int i = 0; i < this.ops.playerNames.length; ++i) {
            if (!this.ops.playerTypes[i].equals("Human") || this.stats.getOwned(i) <= 0 || !this.ops.playerNames[i].equals(controllingName) && !controllingName.equals(this.takenOverPlayerNames[i])) continue;
            return i;
        }
        if (controllingName.endsWith(" (AI)")) {
            String shortName = controllingName.substring(0, controllingName.length() - 5);
            for (int i = 0; i < this.ops.playerNames.length; ++i) {
                if (this.ops.playerTypes[i].equals("Human") || this.stats.getOwned(i) <= 0 || !this.ops.playerNames[i].equals(shortName) && !controllingName.equals(shortName)) continue;
                return i;
            }
        }
        return -1;
    }

    public void takeOverPlayer(String clientName) {
        this.debug("taking control of name " + clientName);
        this.netBoss.log("mc=" + this.masterControl + " is taking control of name " + clientName);
        this.takeOverPlayer(this.getPlayerIndexForControllingName(clientName));
    }

    public void takeOverPlayer(int playerIndex) {
        this.debug("taking control of player # " + playerIndex);
        this.ops.guiControl[playerIndex] = true;
        this.ops.playerTypes[playerIndex] = "Human";
        this.takenOverPlayerNames[playerIndex] = this.netBoss.name();
        this.netBoss.println("\u2731 " + this.netBoss.name() + " " + Translator.getString("nowControlling") + " " + this.ops.playerNames[playerIndex] + " \u2731");
        this.netBoss.sendToAll("tra: 3 " + this.netBoss.name() + " :nowControlling: " + this.ops.playerNames[playerIndex]);
        this.createUserButtons();
        this.world.takeOverPlayer(playerIndex);
    }

    public void clickReplayMap() {
        if (this.netBoss == null) {
            Prefs.putBoolean("nextMapButtonDefault", false);
            BoardFile savedBF = this.ops.boardFile;
            int savedBN = this.ops.boardNumber;
            if (this.ops.savedGame) {
                LuxController.getInstance().fillMapSelector(this.ops.boardName());
                this.ops = LuxController.getInstance().currentOptions().ensureProperOrder();
            } else {
                this.ops = LuxController.getInstance().currentOptions().ensureProperOrder();
                this.ops.removeRemoteOnly();
                if (LuxController.getInstance().bioLevel() == 0) {
                    this.ops.boardFile = savedBF;
                    this.ops.boardNumber = savedBN;
                }
            }
            this.playNextMap();
            return;
        }
        if (this.masterControl) {
            this.netBoss.startGameWithSameBoard(this.ops);
        }
    }

    public void kill() {
        if (this.turnTimer != null) {
            this.turnTimer.cancel();
            this.turnTimer = null;
        }
        if (this.world != null) {
            this.world.kill();
        }
        this.world = null;
        this.viewManager.kill();
        this.viewManager = null;
        this.ops = null;
        if (this.netBoss != null) {
            this.netBoss.kill();
            this.netBoss = null;
        }
        if (this.stats != null) {
            this.stats.kill();
            this.stats = null;
        }
    }

    protected int whoseCardsToShow() {
        int checkPlayer = this.world.currentPlayer;
        for (int i = 0; i < this.ops.playerNames.length; ++i) {
            if (this.ops.guiControl[checkPlayer] && this.stats.getOwned(checkPlayer) > 0) {
                return checkPlayer;
            }
            checkPlayer = (checkPlayer + 1) % this.ops.playerNames.length;
        }
        return -1;
    }

    public void lostClient(String clientName, boolean freeGuests) {
        if (this.checkLostPlayerIsEliminated(clientName)) {
            return;
        }
        if (!PrefsCache.headless && PrefsCache.useSound) {
            SS.beep();
        }
        if (freeGuests) {
            this.giveGuestPlayer(clientName);
        } else {
            this.world.takeOverPlayerWithAI(this.getPlayerIndexForControllingName(clientName));
        }
    }

    public void setWinningImage(String imageURL) {
        this.netBoss.sendToAll("swi: " + imageURL);
    }

    public int getTurnSecondsLeft() {
        if (!this.ops.useTurnTimer) {
            return 100;
        }
        return this.turnSecondsLeft;
    }

    public void turnTimerTick() {
        long currentTime;
        if (this.world != null && this.ops.useTurnTimer && (this.world.gamePhase == 1 && !this.ops.initialCountries || this.world.gamePhase == 2 && this.ops.initialArmies == 1)) {
            currentTime = new Date().getTime();
            int selectionTimeLimit = 10;
            if (this.world.firstSelection) {
                selectionTimeLimit = 30;
            }
            this.turnSecondsLeft = (int)((double)selectionTimeLimit - (double)(currentTime - this.stats.getTurnTimerStart()) / 1000.0);
            if (this.turnSecondsLeft == 0) {
                this.turnTimerExpiredInitialPhases();
            } else if (this.turnSecondsLeft < 4 && PrefsCache.timerSound && this.turnSecondsLeft > 0) {
                this.lowTimerWarning();
            }
        }
        if (this.world != null && this.ops.useTurnTimer && 3 == this.world.gamePhase) {
            currentTime = new Date().getTime();
            this.turnSecondsLeft = (int)((double)this.ops.turnTimerLength - (double)(currentTime - this.stats.getTurnTimerStart()) / 1000.0);
            if (this.turnSecondsLeft == 0) {
                this.turnTimerExpired();
            } else if (this.turnSecondsLeft < 4 && PrefsCache.timerSound && this.turnSecondsLeft > 0) {
                this.lowTimerWarning();
            }
        }
    }

    protected void lowTimerWarning() {
    }

    public void alertGameStarted() {
    }

    public void setBoardName(String name) {
        if (name == null) {
            return;
        }
        if (PrefsCache.headless) {
            this.ops.setBoardTitle(name);
        }
    }

    public void escapeKey() {
    }

    public void showNoticeOnCountry(String text, int c) {
    }

    public void printGameLengthMessage(String text) {
        System.out.println(Translator.translateTokens(text));
        if (this.netBoss != null) {
            this.netBoss.printToAll("tra: 3 " + text);
        } else if (this instanceof GameControllerGUI) {
            ((GameControllerGUI)this).luxView.showNotice(Translator.translateTokens(text));
        }
    }

    protected void doneCreationHandler() {
        if (this.gameLimitThread != null) {
            this.gameLimitThread.stopLimit();
        }
        if (this.ops.gameLimitMinutes > 0 && this.masterControl && this.ops.allowNetworkPlayers) {
            this.gameLimitThread = new GameTimeLimiterThread();
            this.gameLimitThread.start();
        }
    }

    public abstract void showMessage(String var1);

    public class GameTimeLimiterThread
    extends Thread {
        private boolean alive = true;

        public void run() {
            try {
                if (GameControllerAbstract.this.ops.gameLimitMinutes > 1) {
                    Thread.sleep((GameControllerAbstract.this.ops.gameLimitMinutes - 30) * 60 * 1000);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 30 :minutes: :remaining:");
                    Thread.sleep(900000L);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 15 :minutes: :remaining:");
                    Thread.sleep(300000L);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 10 :minutes: :remaining:");
                    Thread.sleep(300000L);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 5 :minutes: :remaining:");
                    Thread.sleep(60000L);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 4 :minutes: :remaining:");
                    Thread.sleep(60000L);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 3 :minutes: :remaining:");
                    Thread.sleep(60000L);
                    if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                        return;
                    }
                    GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 2 :minutes: :remaining:");
                    Thread.sleep(60000L);
                }
                if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                    return;
                }
                GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 1 :minute: :remaining:");
                Thread.sleep(30000L);
                if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                    return;
                }
                GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 30 :seconds: :remaining:");
                Thread.sleep(15000L);
                if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                    return;
                }
                GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 15 :seconds: :remaining:");
                Thread.sleep(5000L);
                if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                    return;
                }
                GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 10 :seconds: :remaining:");
                Thread.sleep(5000L);
                if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                    return;
                }
                GameControllerAbstract.this.printGameLengthMessage(":gameLimitNearing: 5 :seconds: :remaining:");
                Thread.sleep(5000L);
                if (GameControllerAbstract.this.gameIsOver || !this.alive) {
                    return;
                }
                GameControllerAbstract.this.printGameLengthMessage(":gameLimitReached:");
                if (!GameControllerAbstract.this.gameIsOver && this.alive && GameControllerAbstract.this.netBoss != null) {
                    GameControllerAbstract.this.netBoss.gameLimitHit();
                }
            }
            catch (Exception e) {
                GameControllerAbstract.this.debug("gameLimit exception jiotty34");
                e.printStackTrace();
            }
        }

        public void stopLimit() {
            this.alive = false;
        }
    }
}

