/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.EsellerateWrapper;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnterRetailCodeWindow {
    private static EnterRetailCodeWindow instance = null;
    private SSFrame theFrame;
    private SSTextField nameField = null;
    private SSTextField codeField = null;
    private SSButton okButton = null;
    private SSButton cancelButton = null;
    ActionListener okButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EnterRetailCodeWindow.this.registerCode();
        }
    };
    ActionListener cancelButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EnterRetailCodeWindow.this.theFrame.hide();
            System.exit(0);
        }
    };
    private static SSApplicationGUI luxconBridge;

    public EnterRetailCodeWindow() {
        this.initGUI();
    }

    public void activate() {
    }

    public void initGUI() {
        JPanel gridPanel = new JPanel(new GridLayout(4, 1));
        JLabel label = new JLabel(Translator.getString("retailName") + ":  ");
        label.setHorizontalAlignment(2);
        gridPanel.add(label);
        this.nameField = new SSTextField(25);
        gridPanel.add(this.nameField);
        label = new JLabel(Translator.getString("retailKey") + ":  ");
        label.setHorizontalAlignment(2);
        gridPanel.add(label);
        this.codeField = new SSTextField(25);
        gridPanel.add(this.codeField);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add(gridPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.cancelButton = new SSButton(Translator.getString("Cancel"));
        this.cancelButton.addActionListener(this.cancelButtonPressed);
        JPanel cancelButtonPanel = new JPanel();
        cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 2, 0));
        cancelButtonPanel.add(this.cancelButton);
        buttonPanel.add(cancelButtonPanel);
        this.okButton = new SSButton(Translator.getString("OK"));
        this.okButton.addActionListener(this.okButtonPressed);
        JPanel okButtonPanel = new JPanel();
        okButtonPanel.setBorder(BorderFactory.createEmptyBorder(3, 50, 2, 0));
        okButtonPanel.add(this.okButton);
        buttonPanel.add(okButtonPanel);
        contentPanel.add((Component)buttonPanel, "South");
        JLabel imageLabel = new JLabel(new ImageIcon(GraphicsTool.getImageFromJAR("globe64.png")));
        imageLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)imageLabel, "West");
        this.theFrame = new SSFrame(Translator.getString("Registration"));
        this.theFrame.setLocationID("EnterRetailCode");
        this.theFrame.setContentPane(contentPanel);
        this.theFrame.setDefaultCloseOperation(3);
        this.theFrame.setResizable(false);
    }

    public void showFrame() {
        this.theFrame.pack();
        this.theFrame.show();
        this.theFrame.setLocationRelativeTo(null);
        this.activate();
        this.theFrame.getRootPane().setDefaultButton(this.okButton);
    }

    public static void show(SSApplicationGUI luxconBridgeNEW) {
        luxconBridge = luxconBridgeNEW;
        if (instance == null) {
            instance = new EnterRetailCodeWindow();
        }
        instance.showFrame();
    }

    private void registerCode() {
        String regName = this.nameField.getText().trim();
        String retailCode = this.codeField.getText().trim();
        if ("".equals(regName)) {
            SSOptionPane.showMessageDialog(this.theFrame, Translator.getString("retailName"), Translator.getString("ValidationError"), 0);
            return;
        }
        if (this.retailKeyWorks(regName, retailCode)) {
            SSOptionPane.showMessageDialog(this.theFrame, Translator.getString("ValidationSuccessMessage"), Translator.getString("ValidationSuccess"), 1);
            this.theFrame.hide();
            new LuxController();
        } else {
            SSOptionPane.showMessageDialog(this.theFrame, Translator.getString("ValidationErrorMessageRetail"), Translator.getString("ValidationError"), 0);
        }
    }

    private boolean retailKeyWorks(String retailName, String retailCode) {
        boolean result = EsellerateWrapper.validRegistration(retailName, retailCode);
        if (result) {
            Prefs.put("regName", retailName);
            Prefs.put("regCode", retailCode);
            Prefs.sync();
        }
        return result;
    }

    public static void hide() {
        if (instance != null) {
            instance.hideFrame();
        }
    }

    private void hideFrame() {
        this.theFrame.hide();
    }
}

