/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.NaughtyList;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.vox.VoxGUI;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSPopupMenu;
import com.sillysoft.widgets.SSTextField;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class EnterCodeWindow {
    public static EnterCodeWindow instance = null;
    public SSFrame theFrame;
    private SSTextField nameField = null;
    private SSTextField codeField = null;
    private SSButton okButton = null;
    private SSButton cancelButton = null;
    private JProgressBar progressBar;
    private JPanel progressPanel;
    private JLabel progressLabel;
    ActionListener okButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EnterCodeWindow.this.registerCode();
        }
    };
    ActionListener cancelButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EnterCodeWindow.this.theFrame.hide();
        }
    };
    ActionListener orderButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            UpdateController.gotoBuy("enterCodeWindow");
        }
    };
    private static SSApplicationGUI appBridge;

    public EnterCodeWindow() {
        this.initGUI();
    }

    public void initGUI() {
        GridBagLayout contentLayout = new GridBagLayout();
        JPanel contentPanel = new JPanel(contentLayout);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JLabel l = new JLabel(Translator.getString("Enteryournameandcode"));
        l.setHorizontalAlignment(0);
        contentLayout.setConstraints(l, c);
        contentPanel.add(l);
        c.gridwidth = 1;
        l = new JLabel(Translator.getString("Name") + ":  ");
        l.setHorizontalAlignment(0);
        contentLayout.setConstraints(l, c);
        contentPanel.add(l);
        c.gridwidth = 0;
        this.nameField = new SSTextField(29);
        contentLayout.setConstraints(this.nameField, c);
        contentPanel.add(this.nameField);
        c.gridwidth = 1;
        l = new JLabel(Translator.getString("Code") + ":   ");
        l.setHorizontalAlignment(0);
        contentLayout.setConstraints(l, c);
        contentPanel.add(l);
        c.gridwidth = 0;
        this.codeField = new SSTextField(29);
        contentLayout.setConstraints(this.codeField, c);
        contentPanel.add(this.codeField);
        this.progressBar = new JProgressBar();
        this.progressBar.putClientProperty("JProgressBar.style", "circular");
        this.progressBar.setIndeterminate(true);
        this.progressLabel = new JLabel("Validating...");
        c.gridwidth = 0;
        this.progressPanel = new JPanel(new FlowLayout());
        contentLayout.setConstraints(this.progressPanel, c);
        contentPanel.add(this.progressPanel);
        c.gridwidth = 2;
        SSButton orderButton = new SSButton(Translator.getString("RegisterOnline"));
        orderButton.addActionListener(this.orderButtonPressed);
        JPanel orderButtonPanel = new JPanel();
        orderButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 2, 0));
        orderButtonPanel.add(orderButton);
        contentLayout.setConstraints(orderButtonPanel, c);
        contentPanel.add(orderButtonPanel);
        SSButton reminderButton = new SSButton(Translator.getString("ForgotCode"));
        reminderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserLauncher.openURL("http://sillysoft.net/contact/registration.php");
            }
        });
        JPanel reminderButtonPanel = new JPanel();
        reminderButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 2, 0));
        reminderButtonPanel.add(reminderButton);
        contentLayout.setConstraints(reminderButtonPanel, c);
        contentPanel.add(reminderButtonPanel);
        this.cancelButton = new SSButton(Translator.getString("Cancel"));
        this.cancelButton.addActionListener(this.cancelButtonPressed);
        JPanel cancelButtonPanel = new JPanel();
        cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 2, 0));
        cancelButtonPanel.add(this.cancelButton);
        contentLayout.setConstraints(cancelButtonPanel, c);
        contentPanel.add(cancelButtonPanel);
        c.gridwidth = 0;
        this.okButton = new SSButton(Translator.getString("Enter"));
        this.okButton.addActionListener(this.okButtonPressed);
        JPanel okButtonPanel = new JPanel();
        okButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 2, 0));
        okButtonPanel.add(this.okButton);
        contentLayout.setConstraints(okButtonPanel, c);
        contentPanel.add(okButtonPanel);
        this.theFrame = new SSFrame(Translator.getString("Registration"));
        this.theFrame.setLocationID("EnterCode");
        this.theFrame.setContentPane(contentPanel);
        this.theFrame.setDefaultCloseOperation(1);
        this.theFrame.setResizable(false);
        if (SS.isMacintosh) {
            this.theFrame.setJMenuBar(appBridge.makeCommonMenuBar(this.theFrame));
        }
        SS.debug("entercode initGUI");
        SSPopupMenu.addCutCopyPasteMenu(this.nameField);
        SSPopupMenu.addCutCopyPasteMenu(this.codeField);
    }

    public void showFrame() {
        this.theFrame.pack();
        this.theFrame.show();
        this.theFrame.getRootPane().setDefaultButton(this.okButton);
    }

    public static void show(SSApplicationGUI appBridgeNEW) {
        appBridge = appBridgeNEW;
        if (instance == null) {
            instance = new EnterCodeWindow();
        }
        instance.showFrame();
    }

    private void registerCode() {
        String code = this.codeField.getText().trim();
        if (SSApp.isVox) {
            if ("unreg".equals(code) || "unregister".equals(code) || "demo".equals(code) || "de-register".equals(code)) {
                VoxGUI.getInstance().sharewareVersion = true;
                Prefs.put("regCode", "");
                Prefs.put("regName", "");
                Prefs.sync();
                try {
                    SS.debug("REGISTER: clearing out the plugin cache");
                    PluginManager.deleteCache();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                VoxGUI.getInstance().setRegistration();
                SSOptionPane.showMessageDialog(this.theFrame, "Your registration has been erased.", "", 0);
                this.theFrame.hide();
                return;
            }
            appBridge.registerCode(this.nameField.getText().trim(), code);
            return;
        }
        if (NaughtyList.contains(this.nameField.getText().trim(), code)) {
            SSOptionPane.showRegistrationDialog("Registration Error", "Yarrrr, thar be pirates! Defend the Sillysoft booty chest!!\n\nAvoid the hassle and buy " + SSApp.shortName() + " for the low price of $24.95 US. \n\nSupport indie games, you scurvy dawg! \n\nOrder online and you will get a real code instantly.", null, "piratebuy", new UpdateController(false));
        } else if (appBridge.registerCode(this.nameField.getText().trim(), code)) {
            SSOptionPane.showMessageDialog(this.theFrame, Translator.getString("ValidationSuccessMessage"), Translator.getString("ValidationSuccess"), 1);
            this.theFrame.hide();
        } else if (code.startsWith("luxpack000")) {
            SSOptionPane.showMessageDialog(this.theFrame, "It looks like you're trying to use a very old serial number. \n\nUse the 'I Lost My Code' button to get sent a new one. \nSorry for the inconvienience.", Translator.getString("ValidationError"), 0);
        } else {
            SSOptionPane.showMessageDialog(this.theFrame, Translator.getString("ValidationErrorMessage"), Translator.getString("ValidationError"), 0);
        }
    }

    public void setSpinner(boolean value) {
        if (value) {
            this.progressPanel.add(this.progressBar);
            this.progressPanel.add(this.progressLabel);
            this.progressPanel.revalidate();
        } else {
            this.progressPanel.remove(this.progressBar);
            this.progressPanel.remove(this.progressLabel);
            this.progressPanel.revalidate();
            this.progressPanel.repaint();
        }
    }

    public static void hide() {
        if (instance != null) {
            instance.hideFrame();
        }
    }

    private void hideFrame() {
        this.theFrame.hide();
    }
}

