/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.PlayerInfoController;
import com.sillysoft.widgets.SSTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class CustomTableCellRenderer
extends DefaultTableCellRenderer {
    GameControllerGUI control;
    private PlayerInfoController parent;
    Color ALT_HALF_TRANSPARENT_WHITE = new Color(1.0f, 1.0f, 1.0f, 0.85f);
    Color ALT_HALF_TRANSPARENT_WHITE2 = new Color(1.0f, 1.0f, 1.0f, 0.75f);

    public CustomTableCellRenderer(PlayerInfoController theParent, GameControllerGUI control) {
        this.parent = theParent;
        this.control = control;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            int player = row;
            if (this.parent.playerPositions != null && row < this.parent.playerPositions.length) {
                player = this.parent.playerPositions[row];
            }
            if (value.equals("")) {
                cell.setBackground(this.control.luxView.getColor(player));
            } else {
                if (row % 2 == 0) {
                    if (this.parent.slaveMode) {
                        cell.setBackground(this.ALT_HALF_TRANSPARENT_WHITE2);
                    } else {
                        cell.setBackground(SSTable.ROW_COLOR_2);
                    }
                } else if (this.parent.slaveMode) {
                    cell.setBackground(this.ALT_HALF_TRANSPARENT_WHITE);
                } else {
                    cell.setBackground(Color.WHITE);
                }
                if (this.control.stats.getOwned(player) == 0) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cell;
    }
}

