/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class BottomBarView
extends JPanel {
    private int bottomBarHeight;
    private Image shine;
    private boolean colorsAreSet;
    private int usableTurnBoxWidth;
    private int currentPlayer;
    private static int turnBoxMode;
    private float[] widths;
    private Color[] colors;
    private boolean drawArmyBoxes = true;
    private int fluxArmies;
    private Image oneDude;
    private Image fiveDude;
    private Image tenDude;
    private Image fiftyDude;
    private Image hundredDude;
    private boolean[] fluxSelected;
    private int dudeWidth = 32;
    private boolean cardsMode;
    private int numCards;
    private int nextSetValue;
    private boolean continentMode;
    private GameControllerGUI control;
    private static Image growbox;
    private static final Font arial;

    public BottomBarView(int width, int height, GameControllerGUI control) {
        this.setSize(width, height);
        this.setBackground(Color.black);
        this.control = control;
        this.bottomBarHeight = (int)this.bounds().getHeight();
        this.colorsAreSet = false;
        this.currentPlayer = 0;
        this.usableTurnBoxWidth = 300;
        turnBoxMode = 0;
        this.cardsMode = false;
        this.nextSetValue = -1;
        this.fluxArmies = 0;
        this.oneDude = GraphicsTool.getImageFromJAR("token_1.png");
        this.fiveDude = GraphicsTool.getImageFromJAR("token_5.png");
        this.tenDude = GraphicsTool.getImageFromJAR("token_10.png");
        this.fiftyDude = GraphicsTool.getImageFromJAR("token_50.png");
        this.hundredDude = GraphicsTool.getImageFromJAR("token_100.png");
        this.shine = GraphicsTool.getImageFromJAR("shine.png");
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.colorsAreSet = true;
        this.widths = new float[colors.length];
    }

    public void gotoPlayer(int player) {
        this.currentPlayer = player;
        this.repaintColors();
    }

    public void resetPlayer() {
        this.currentPlayer = 0;
        this.repaintColors();
    }

    public void clearView() {
        this.colorsAreSet = false;
        this.fluxArmies = 0;
        this.currentPlayer = 0;
        this.cardsMode = false;
        this.continentMode = false;
        this.repaint();
    }

    public void setFluxBox(int i) {
        this.fluxArmies = i;
        int numPictures = this.fluxArmies / 100;
        numPictures += this.fluxArmies % 100 / 50;
        numPictures += this.fluxArmies % 50 / 10;
        numPictures += this.fluxArmies % 10 / 5;
        if ((numPictures += this.fluxArmies % 5) < 0) {
            System.out.println("Lux -> ERROR. setFluxBox(" + i + ")");
        }
        this.fluxSelected = new boolean[numPictures];
        for (int f = 0; f < this.fluxSelected.length; ++f) {
            this.fluxSelected[f] = false;
        }
        this.repaintColors();
    }

    public int getFluxArmies() {
        return this.fluxArmies;
    }

    public int getNumberSelectedArmies() {
        if (this.fluxArmies <= 0) {
            return 0;
        }
        int number = 0;
        int toDraw = this.fluxArmies;
        for (int n = 0; n < this.fluxSelected.length; ++n) {
            if (toDraw > 99) {
                if (this.fluxSelected[n]) {
                    number += 100;
                }
                toDraw -= 100;
                continue;
            }
            if (toDraw > 49) {
                if (this.fluxSelected[n]) {
                    number += 50;
                }
                toDraw -= 50;
                continue;
            }
            if (toDraw > 9) {
                if (this.fluxSelected[n]) {
                    number += 10;
                }
                toDraw -= 10;
                continue;
            }
            if (toDraw > 4) {
                if (this.fluxSelected[n]) {
                    number += 5;
                }
                toDraw -= 5;
                continue;
            }
            if (toDraw <= 0) continue;
            if (this.fluxSelected[n]) {
                ++number;
            }
            --toDraw;
        }
        return number;
    }

    public void showCards(int numCards, int nextSetValue) {
        this.cardsMode = true;
        this.numCards = numCards;
        this.nextSetValue = nextSetValue;
        this.repaint();
    }

    public void hideCards() {
        this.cardsMode = false;
        this.repaint();
    }

    public void setContinentMode(boolean value) {
        this.continentMode = value;
        this.repaint();
    }

    void kill() {
        this.control = null;
    }

    public void paintComponent(Graphics badg) {
        int x;
        super.paintComponent(badg);
        Graphics2D g = (Graphics2D)badg;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(arial);
        if (this.cardsMode) {
            String top = this.numCards == 1 ? Translator.getString("Youhave1card") : Translator.getString("Youhave") + " " + this.numCards + " " + Translator.getString("cards") + ".";
            g.setColor(Color.white);
            g.drawString(top, 7, 13);
            g.drawString(Translator.getString("Thenextcardsetisworth") + " " + this.nextSetValue + " " + Translator.getString("armies") + ".", 7, 27);
            return;
        }
        if (this.continentMode) {
            String top = Translator.getString("Continentmodedescription");
            g.setColor(Color.white);
            g.drawString(top, 7, 13);
            return;
        }
        if (this.colorsAreSet) {
            this.calculateWidths();
            x = 3;
            for (int i = 0; i < this.widths.length; ++i) {
                int drawPlayerBox = (i + this.currentPlayer) % this.widths.length;
                if (!((double)this.widths[drawPlayerBox] > 0.001)) continue;
                g.setColor(this.colors[drawPlayerBox]);
                g.fillRect(x, 3, (int)this.widths[drawPlayerBox], this.bottomBarHeight - 6);
                if (this.widths[drawPlayerBox] == 0.0f) continue;
                x += (int)this.widths[drawPlayerBox];
            }
            if (x != 3 && x < this.usableTurnBoxWidth + 3) {
                g.fillRect(x, 3, this.usableTurnBoxWidth + 3 - x, this.bottomBarHeight - 6);
            }
            g.drawImage(this.shine, 3, 1, this.usableTurnBoxWidth, this.bottomBarHeight - 2, this);
        }
        if (this.fluxArmies != 0 && this.drawArmyBoxes) {
            x = 0;
            int toDraw = this.fluxArmies;
            int n = 0;
            while (n < this.fluxSelected.length) {
                if (this.fluxSelected[n]) {
                    g.setColor(Color.yellow);
                } else {
                    g.setColor(GraphicsTool.transparent(Color.white, 0.5f));
                }
                g.fillRect(x, 0, this.dudeWidth, this.bottomBarHeight);
                if (toDraw > 99) {
                    g.drawImage(this.hundredDude, x, 0, this);
                    toDraw -= 100;
                } else if (toDraw > 49) {
                    g.drawImage(this.fiftyDude, x, 0, this);
                    toDraw -= 50;
                } else if (toDraw > 9) {
                    g.drawImage(this.tenDude, x, 0, this);
                    toDraw -= 10;
                } else if (toDraw > 4) {
                    g.drawImage(this.fiveDude, x, 0, this);
                    toDraw -= 5;
                } else if (toDraw > 0) {
                    g.drawImage(this.oneDude, x, 1, this);
                    --toDraw;
                }
                ++n;
                x += this.dudeWidth;
            }
        }
        if (SS.isMacintosh && (this.control.netBoss == null || this.control.netBoss != null && this.control.netBoss.activeSoloWindow())) {
            g.drawImage(growbox, this.getWidth() - 11, this.bottomBarHeight - 11, this);
        }
    }

    private void calculateWidths() {
        int i;
        for (int i2 = 0; i2 < this.widths.length; ++i2) {
            this.widths[i2] = 0.0f;
        }
        int divideBy = 0;
        for (i = 0; i < this.widths.length; ++i) {
            this.widths[i] = this.control.stats.getArmies(i);
            divideBy = (int)((float)divideBy + this.widths[i]);
        }
        i = 0;
        while (i < this.widths.length) {
            int n = i++;
            this.widths[n] = this.widths[n] * ((float)this.usableTurnBoxWidth / (float)Math.max(1, divideBy));
        }
    }

    public void setSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, 40));
        super.setSize(width, 40);
    }

    public Dimension getMaximumSize() {
        Dimension parent = super.getMaximumSize();
        return new Dimension((int)parent.getWidth(), 40);
    }

    public void repaintColors() {
        this.repaint(0L, 0, 0, this.usableTurnBoxWidth + 5, 40);
    }

    public void setDrawArmyBoxes(boolean value) {
        this.drawArmyBoxes = value;
        this.repaint();
    }

    public boolean isOpaque() {
        return true;
    }

    static {
        if (SS.isMacintosh) {
            growbox = GraphicsTool.getImageFromJAR("growbox_black.gif");
        }
        arial = new Font("Arial", 0, 12);
    }
}

