/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class ArmySelector
extends JPanel
implements MouseListener,
MouseMotionListener {
    private boolean drawArmyBoxes = true;
    private int fluxArmies;
    private boolean[] fluxSelected;
    private static Image oneDude;
    private static Image fiveDude;
    private static Image tenDude;
    private static Image fiftyDude;
    private static Image hundredDude;
    private static Image fiveHundredDude;
    private static Image thousandDude;
    private static Image token_5k;
    private static Image token_10k;
    private static Image token_50k;
    private static int dudeWidth;
    private static Color selectedColor;
    private static float flashColorAlpha;
    private static Color flashColor;
    private boolean cardsMode;
    private int numCards;
    private int nextSetValue;
    private boolean continentMode;
    private GameControllerGUI control;
    private static Image growbox;
    private int mousePressedInPict = -1;
    private int lastMouseDraggedInPict = -1;
    private static final Font arial;
    private boolean flashDecreasing;

    public ArmySelector(int width, GameControllerGUI control) {
        this.setSize(width, 40);
        this.setPreferredSize(new Dimension(width, 40));
        this.setBackground(Color.black);
        this.control = control;
        this.cardsMode = false;
        this.nextSetValue = -1;
        this.fluxArmies = 0;
        if (oneDude == null) {
            oneDude = GraphicsTool.getImageFromJAR("token_1.png");
            fiveDude = GraphicsTool.getImageFromJAR("token_5.png");
            tenDude = GraphicsTool.getImageFromJAR("token_10.png");
            fiftyDude = GraphicsTool.getImageFromJAR("token_50.png");
            hundredDude = GraphicsTool.getImageFromJAR("token_100.png");
            fiveHundredDude = GraphicsTool.getImageFromJAR("token_500.png");
            thousandDude = GraphicsTool.getImageFromJAR("token_1000.png");
            token_5k = GraphicsTool.getImageFromJAR("token_5000.png");
            token_10k = GraphicsTool.getImageFromJAR("token_10000.png");
            token_50k = GraphicsTool.getImageFromJAR("token_50000.png");
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void clearView() {
        this.fluxArmies = 0;
        this.cardsMode = false;
        this.continentMode = false;
        this.repaint();
    }

    public void setFluxBox(int i) {
        this.fluxArmies = i;
        int numPictures = this.fluxArmies / 50000;
        numPictures += this.fluxArmies % 50000 / 10000;
        numPictures += this.fluxArmies % 10000 / 5000;
        numPictures += this.fluxArmies % 5000 / 1000;
        numPictures += this.fluxArmies % 1000 / 500;
        numPictures += this.fluxArmies % 500 / 100;
        numPictures += this.fluxArmies % 100 / 50;
        numPictures += this.fluxArmies % 50 / 10;
        numPictures += this.fluxArmies % 10 / 5;
        if ((numPictures += this.fluxArmies % 5) < 0) {
            System.out.println("Lux -> ERROR. setFluxBox(" + i + ")");
            numPictures = 0;
        }
        this.fluxSelected = new boolean[numPictures];
        for (int f = 0; f < this.fluxSelected.length; ++f) {
            this.fluxSelected[f] = false;
        }
        this.repaint();
        if (this.fluxArmies == 0) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(Translator.getString("ArmySelectorTooltip"));
        }
    }

    public int getFluxArmies() {
        return this.fluxArmies;
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseAction(e, e.isShiftDown() || e.getButton() == 2 || e.getButton() == 3);
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressedInPict = this.getInPicture(e.getPoint());
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (e.getPoint().getY() >= 40.0) {
            this.control.luxView.setScrolling(2);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getPoint().getY() >= 39.0) {
            this.control.luxView.setScrolling(2);
        }
    }

    public void mouseDragged(MouseEvent e) {
        int mouseDraggedInPict = this.getInPicture(e.getPoint());
        if (mouseDraggedInPict == this.lastMouseDraggedInPict) {
            return;
        }
        if (mouseDraggedInPict != -1) {
            for (int n = 0; n < this.fluxSelected.length; ++n) {
                this.fluxSelected[n] = n >= this.mousePressedInPict && n <= mouseDraggedInPict || n <= this.mousePressedInPict && n >= mouseDraggedInPict;
            }
            this.repaint();
        }
        this.lastMouseDraggedInPict = mouseDraggedInPict;
    }

    private int getInPicture(Point loc) {
        if (this.fluxSelected == null) {
            return -1;
        }
        int inPict = -1;
        for (int n = 0; n < this.fluxSelected.length; ++n) {
            if (!(loc.getX() >= (double)(this.getWidth() - dudeWidth * (n + 1)))) continue;
            inPict = n;
            break;
        }
        return inPict;
    }

    private void mouseAction(MouseEvent e, boolean shifted) {
        if (this.fluxArmies <= 0) {
            return;
        }
        int inPict = this.getInPicture(e.getPoint());
        for (int n = 0; n < this.fluxSelected.length; ++n) {
            if (!shifted) {
                this.fluxSelected[n] = false;
            }
            if (n != inPict) continue;
            this.fluxSelected[n] = !this.fluxSelected[n];
        }
        this.repaint();
    }

    public int getNumberSelectedArmies() {
        if (this.fluxArmies <= 0) {
            return 0;
        }
        int number = 0;
        int toDraw = this.fluxArmies;
        for (int n = 0; n < this.fluxSelected.length; ++n) {
            if (toDraw > 49999) {
                if (this.fluxSelected[n]) {
                    number += 50000;
                }
                toDraw -= 50000;
                continue;
            }
            if (toDraw > 9999) {
                if (this.fluxSelected[n]) {
                    number += 10000;
                }
                toDraw -= 10000;
                continue;
            }
            if (toDraw > 4999) {
                if (this.fluxSelected[n]) {
                    number += 5000;
                }
                toDraw -= 5000;
                continue;
            }
            if (toDraw > 999) {
                if (this.fluxSelected[n]) {
                    number += 1000;
                }
                toDraw -= 1000;
                continue;
            }
            if (toDraw > 499) {
                if (this.fluxSelected[n]) {
                    number += 500;
                }
                toDraw -= 500;
                continue;
            }
            if (toDraw > 99) {
                if (this.fluxSelected[n]) {
                    number += 100;
                }
                toDraw -= 100;
                continue;
            }
            if (toDraw > 49) {
                if (this.fluxSelected[n]) {
                    number += 50;
                }
                toDraw -= 50;
                continue;
            }
            if (toDraw > 9) {
                if (this.fluxSelected[n]) {
                    number += 10;
                }
                toDraw -= 10;
                continue;
            }
            if (toDraw > 4) {
                if (this.fluxSelected[n]) {
                    number += 5;
                }
                toDraw -= 5;
                continue;
            }
            if (toDraw <= 0) continue;
            if (this.fluxSelected[n]) {
                ++number;
            }
            --toDraw;
        }
        return number;
    }

    public void showCards(int numCards, int nextSetValue) {
        this.cardsMode = true;
        this.numCards = numCards;
        this.nextSetValue = nextSetValue;
        this.repaint();
    }

    public void hideCards() {
        this.cardsMode = false;
        this.repaint();
    }

    public void setContinentMode(boolean value) {
        this.continentMode = value;
        this.repaint();
    }

    void kill() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.control = null;
    }

    public void paintComponent(Graphics badg) {
        Graphics2D g = (Graphics2D)badg;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.fill(g.getClipBounds());
        if (SS.isMacintosh && !this.control.fullscreen && (this.control.netBoss == null || this.control.netBoss != null && this.control.netBoss.activeSoloWindow())) {
            g.drawImage(growbox, this.getWidth() - 11, 29, null);
        }
        if (this.cardsMode || this.continentMode) {
            return;
        }
        if (this.fluxArmies != 0 && this.drawArmyBoxes) {
            int x = this.getWidth() - dudeWidth;
            int y = 3;
            int toDraw = this.fluxArmies;
            int n = 0;
            while (n < this.fluxSelected.length) {
                if (this.fluxSelected[n]) {
                    g.setColor(selectedColor);
                } else {
                    g.setColor(flashColor);
                }
                g.fillRect(x, 0, dudeWidth, 40);
                if (toDraw > 49999) {
                    g.drawImage(token_50k, x, y + 1, null);
                    toDraw -= 50000;
                } else if (toDraw > 9999) {
                    g.drawImage(token_10k, x, y + 2, null);
                    toDraw -= 10000;
                } else if (toDraw > 4999) {
                    g.drawImage(token_5k, x, y, null);
                    toDraw -= 5000;
                } else if (toDraw > 999) {
                    g.drawImage(thousandDude, x, y, null);
                    toDraw -= 1000;
                } else if (toDraw > 499) {
                    g.drawImage(fiveHundredDude, x, y, null);
                    toDraw -= 500;
                } else if (toDraw > 99) {
                    g.drawImage(hundredDude, x, y, null);
                    toDraw -= 100;
                } else if (toDraw > 49) {
                    g.drawImage(fiftyDude, x, y, null);
                    toDraw -= 50;
                } else if (toDraw > 9) {
                    g.drawImage(tenDude, x, y, null);
                    toDraw -= 10;
                } else if (toDraw > 4) {
                    g.drawImage(fiveDude, x, y, null);
                    toDraw -= 5;
                } else if (toDraw > 0) {
                    g.drawImage(oneDude, x, y + 1, null);
                    --toDraw;
                }
                ++n;
                x -= dudeWidth;
            }
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, 40);
    }

    public Dimension getMaximumSize() {
        Dimension parent = super.getMaximumSize();
        return new Dimension((int)parent.getWidth(), 40);
    }

    public void setDrawArmyBoxes(boolean value) {
        this.drawArmyBoxes = value;
        this.repaint();
    }

    public boolean isOpaque() {
        return true;
    }

    public void tick() {
        if (this.fluxArmies > 0 && !this.cardsMode && !this.continentMode) {
            if ((double)flashColorAlpha < 0.05) {
                this.flashDecreasing = false;
            }
            if ((double)flashColorAlpha > 0.69) {
                this.flashDecreasing = true;
            }
            flashColorAlpha = this.flashDecreasing ? (float)((double)flashColorAlpha - 0.03) : (float)((double)flashColorAlpha + 0.03);
            flashColor = GraphicsTool.transparent(Color.RED, flashColorAlpha);
            this.repaint();
        }
    }

    static {
        dudeWidth = 32;
        selectedColor = new Color(118, 163, 251, 180);
        flashColorAlpha = 0.5f;
        if (SS.isMacintosh) {
            growbox = GraphicsTool.getImageFromJAR("growbox_black.gif");
        }
        arial = new Font("Arial", 0, 12);
    }
}

