/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.tools.GraphicsTool;
import java.awt.Dimension;
import java.awt.Image;

public class AnimationLoader
implements Runnable {
    private static Thread loadThread;
    private static boolean doneLoading;
    private static int[] animationFrameNumber;
    private static Dimension[] animationFrameSize;
    private static Image[][] explosionFramesArrays;

    public static void loadAnimationsInBackground() {
        if (doneLoading) {
            return;
        }
        loadThread = new Thread((Runnable)new AnimationLoader(), "AnimationLoader");
        loadThread.start();
    }

    public void run() {
        System.out.println("AnimationLoader: Starting background load");
        String[] animationNames = new String[]{"flash", "redblack2", "greenblack4", "purple", "explosion1", "black"};
        animationFrameNumber = new int[]{20, 27, 12, 27, 16, 27};
        Dimension size64 = new Dimension(64, 64);
        Dimension size100 = new Dimension(100, 100);
        Dimension size128 = new Dimension(128, 128);
        Dimension size240 = new Dimension(240, 240);
        Dimension size32 = new Dimension(32, 32);
        animationFrameSize = new Dimension[]{size128, size128, size64, size128, size100, size128};
        explosionFramesArrays = new Image[animationNames.length][];
        for (int i = 0; i < animationNames.length; ++i) {
            AnimationLoader.explosionFramesArrays[i] = this.loadAnimation(animationNames[i], animationFrameNumber[i]);
        }
        doneLoading = true;
        System.out.println("AnimationLoader: Finished background loading");
    }

    private Image[] loadAnimation(String filebase, int numberOfFrames) {
        Image[] animation = new Image[numberOfFrames];
        for (int i = 0; i < numberOfFrames; ++i) {
            animation[i] = i < 10 && numberOfFrames < 100 ? GraphicsTool.getImageFromJAR(filebase + "_0" + i + ".png") : (numberOfFrames < 100 ? GraphicsTool.getImageFromJAR(filebase + "_" + i + ".png") : (i < 10 ? GraphicsTool.getImageFromJAR(filebase + "_00" + i + ".png") : (i < 100 ? GraphicsTool.getImageFromJAR(filebase + "_0" + i + ".png") : GraphicsTool.getImageFromJAR(filebase + "_" + i + ".png"))));
        }
        return animation;
    }

    public static int[] getFrameCounts() {
        return animationFrameNumber;
    }

    public static Dimension[] getFrameDimensions() {
        return animationFrameSize;
    }

    public static Image[][] getFrameImages() {
        return explosionFramesArrays;
    }

    public static void tidy() {
        animationFrameNumber = null;
        animationFrameSize = null;
        explosionFramesArrays = null;
    }

    public static void blockTillLoaded() {
        if (loadThread == null) {
            System.out.println("AnimationLoader was not pre started. Starting now");
            AnimationLoader.loadAnimationsInBackground();
        }
        try {
            loadThread.join();
        }
        catch (InterruptedException ie) {
            System.out.println("AnimationLoader.blockTillLoaded() was Interrupted!");
        }
    }

    static {
        doneLoading = false;
    }
}

