/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.AddLineCommand;
import com.sillysoft.lux.editor.AddPointCommand;
import com.sillysoft.lux.editor.AdjoinBothCommand;
import com.sillysoft.lux.editor.CloseShapeCommand;
import com.sillysoft.lux.editor.Continent;
import com.sillysoft.lux.editor.ContinentAssignCommand;
import com.sillysoft.lux.editor.CountryShape;
import com.sillysoft.lux.editor.CreateStockShapeCommand;
import com.sillysoft.lux.editor.EditorCommand;
import com.sillysoft.lux.editor.EditorInfoPanel;
import com.sillysoft.lux.editor.EditorLoadBoard;
import com.sillysoft.lux.editor.EditorPlayerInfoPanel;
import com.sillysoft.lux.editor.InsertPointCommand;
import com.sillysoft.lux.editor.MoveArmyBoxCommand;
import com.sillysoft.lux.editor.MoveContinentLabelCommand;
import com.sillysoft.lux.editor.MovePICommand;
import com.sillysoft.lux.editor.MovePointCommand;
import com.sillysoft.lux.editor.MoveShapeCommand;
import com.sillysoft.lux.editor.MoveVoxPointCommand;
import com.sillysoft.lux.editor.PasteShapeCommand;
import com.sillysoft.lux.editor.RemoveAdjoiningCommand;
import com.sillysoft.lux.editor.RemoveLineCommand;
import com.sillysoft.lux.editor.RemoveShapeCommand;
import com.sillysoft.lux.editor.SwapPlayerIDCommand;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.StringTriple;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSCheckBox;
import com.sillysoft.widgets.SSCheckBoxMenuItemBinding;
import com.sillysoft.widgets.SSColorWell;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSMenuItem;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSRootPane;
import com.sillysoft.widgets.SSTextField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class MapEditor
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener,
WindowListener,
ComponentListener {
    private int mode;
    private static final int SHAPE_DRAW = 0;
    private static final int SHAPE_STOCK = 1;
    private static final int SHAPE_EDIT = 2;
    private static final int SHAPE_MOVE = 3;
    private static final int SHAPE_ADJOINING = 4;
    private static final int SHAPE_INFO = 5;
    private static final int CONT_SET = 6;
    private static final int CONT_INFO = 7;
    private static final int LINES = 8;
    private static int SHAPE_ARMY = 9;
    private static int PI_LOCATION = -999;
    private static int PREVIEW = 10;
    private static int VOX_POINTS = 99;
    private static int PLAYER_PANEL = 99;
    private static int INFO_PANEL = 99;
    private String savedMapDir;
    private SSTextField infoField4;
    private SSTextField[] voxUnitCount;
    private int numberOfVoxUnitsToShow = 3;
    private int voxPointIndex;
    SSComboBox contCombo;
    protected boolean voxEnabled = false;
    private String filename;
    private String theme;
    private String armySet;
    private String name;
    private float version;
    private String author;
    private String email;
    private String webpage;
    private String emptyPlayer;
    private String description;
    private int countryCodeCounter = 0;
    int mapwidth;
    int mapheight;
    private double PI_x = 0.0;
    private double PI_y = 0.0;
    protected List shapes = new Vector();
    private List continents = new Vector();
    private List lines = new Vector();
    private List aboveLines = new Vector();
    private Continent activeContinent;
    private CountryShape activeShape;
    private CountryShape armyShape;
    protected List activeShapeList;
    private boolean draggingMultipleSelection = false;
    private List copyShapeList;
    private int activeIndex = -1;
    private int activeContinentIndex = -1;
    private SSFrame window;
    private SSRootPane modePanel;
    private SSComboBox modeBox;
    private JPanel infoPanel;
    private SSButton nextButton;
    private SSButton previousButton;
    private SSTextField infoField;
    private SSTextField infoField2;
    private SSTextField infoField3;
    private SSComboBox infoComboBox;
    private SSColorWell colorWell;
    private SSCheckBox infoCheckBox;
    private Image background;
    private Image foreground;
    private Image overground;
    private boolean themeHasLoaded = false;
    private List initialOwnerColors = new ArrayList();
    private SSApplicationGUI appGUI;
    private boolean draggingPI = false;
    private Point mouseAt;
    private Point mouseAtLast;
    private Point mousePressedAt;
    private CountryShape editingShape;
    private int pointID = -1;
    private List undoList = new Vector();
    private List redoList = new Vector();
    boolean changedSinceSave = false;
    private String extraInfo;
    private boolean shortContinentLabels = true;
    private String[] teamNames;
    private String[] teamSymbols;
    private List[] teamPlayers;

    public MapEditor(SSApplicationGUI appGUI) {
        this(appGUI, false);
    }

    public MapEditor(SSApplicationGUI appGUI, boolean voxEd) {
        this.appGUI = appGUI;
        this.mode = 0;
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.voxEnabled = voxEd;
        this.savedMapDir = voxEd ? "Maps" : "Boards" + File.separator + "Saved";
        this.initWindow();
    }

    public void paintComponent(Graphics badg) {
        super.paintComponent(badg);
        Graphics2D g = (Graphics2D)badg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.background != null && !this.themeHasLoaded) {
            g.drawImage(this.background, 0, 0, this.mapwidth, this.mapheight, this);
        }
        if (this.mode == 0) {
            this.drawThemeOverground(g);
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            g.setColor(Color.BLACK);
            if (this.shapes.size() == 0) {
                GraphicsTool.drawBoxedString(g, Translator.getEditorString("EditorWelcome"), 375, 210, 10, Color.WHITE, 1);
            }
            for (int i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).draw(g);
            }
            this.drawHelperText(g, Translator.getEditorString("drawPointHelp"), this.mapheight);
        } else if (this.mode == 1) {
            this.drawThemeOverground(g);
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            g.setColor(Color.BLACK);
            for (int i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).draw(g);
            }
            if (this.mouseAt != null && this.mousePressedAt != null) {
                List newPoints = this.getEllipsePoints();
                CountryShape tempShape = new CountryShape(-1, this);
                tempShape.setPoints(newPoints);
                tempShape.close();
                tempShape.draw(g);
            }
            this.drawHelperText(g, Translator.getEditorString("stockShapeHelp"), this.mapheight);
        } else if (this.mode == 2) {
            int i;
            this.drawThemeOverground(g);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(0.5f, 1, 1));
            for (i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).draw(g);
            }
            for (i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).drawPoints(g);
            }
            this.drawHelperText(g, Translator.getEditorString("editPointHelp"), this.mapheight);
        } else if (this.mode == 3) {
            this.drawThemeOverground(g);
            g.setStroke(new BasicStroke(1.0f, 1, 1));
            for (int i = 0; i < this.shapes.size(); ++i) {
                CountryShape next = (CountryShape)this.shapes.get(i);
                if (next == this.activeShape || this.activeShapeList != null && this.activeShapeList.contains(next)) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLACK);
                }
                next.draw(g);
            }
            if (this.activeShape == null && !this.draggingMultipleSelection && this.mousePressedAt != null && this.mouseAt != null) {
                g.setColor(Color.RED);
                Rectangle box = new Rectangle(this.mousePressedAt);
                box.add(this.mouseAt);
                g.draw(box);
            }
            this.drawHelperText(g, Translator.getEditorString("moveShapeHelp"), this.mapheight);
        } else if (this.mode == SHAPE_ARMY) {
            this.drawThemeOverground(g);
            g.setColor(Color.BLACK);
            g.setFont(new Font("Arial", 0, 12));
            for (int i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).drawWithArmyBox(g);
            }
            this.drawHelperText(g, Translator.getEditorString("armyMoveHelp"), this.mapheight);
        } else if (this.mode == VOX_POINTS) {
            this.drawThemeOverground(g);
            for (int i = this.shapes.size() - 1; i > -1; --i) {
                ((CountryShape)this.shapes.get(i)).drawWithVoxPoints(g, this.theme);
            }
            this.drawPlayerInfo(g);
            this.drawHelperText(g, Translator.getEditorString("armyMoveHelp"), this.mapheight);
        } else if (this.mode == 4) {
            int i;
            this.drawThemeOverground(g);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(1.0f, 1, 1));
            for (i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).draw(g);
            }
            g.setColor(Color.DARK_GRAY);
            for (i = 0; i < this.shapes.size(); ++i) {
                ((CountryShape)this.shapes.get(i)).drawConnections(g);
            }
            if (this.activeShape != null && this.mouseAt != null) {
                Point center = this.activeShape.getCenterPoint();
                g.drawLine(center.x, center.y, this.mouseAt.x, this.mouseAt.y);
            }
            this.drawHelperText(g, Translator.getEditorString("connectionHelp"), this.mapheight);
        } else if (this.mode == 5) {
            this.drawThemeOverground(g);
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            Color noOwnerColor = GraphicsTool.transparent(Color.white, 0.75f);
            for (int i = 0; i < this.shapes.size(); ++i) {
                if (i == this.activeIndex) {
                    g.setColor(Color.RED);
                    ((CountryShape)this.shapes.get(i)).drawColored(g, Color.RED);
                    continue;
                }
                CountryShape next = (CountryShape)this.shapes.get(i);
                int ownerID = next.getInitialOwnerInt();
                if (ownerID > -1) {
                    g.setColor(this.getColorForOwnerID(ownerID));
                    if (this.voxEnabled) {
                        next.fillWithUnits(g, this.theme);
                        continue;
                    }
                    next.fillWithArmyBox(g);
                    continue;
                }
                g.setColor(Color.BLACK);
                if (this.voxEnabled) {
                    next.drawWithUnits(g, this.theme);
                    continue;
                }
                next.draw(g);
            }
            this.drawHelperText(g, Translator.getEditorString("countryDataHelp"), this.mapheight);
        } else if (this.mode == 7) {
            int i;
            Font oldFont = g.getFont();
            for (i = 0; i < this.continents.size(); ++i) {
                ((Continent)this.continents.get(i)).drawCountries(g);
            }
            this.drawThemeOverground(g);
            if (this.voxEnabled) {
                for (i = 0; i < this.shapes.size(); ++i) {
                    ((CountryShape)this.shapes.get(i)).drawCastles(g, this.theme);
                    ((CountryShape)this.shapes.get(i)).drawVoxCountryBonus(g);
                }
            }
            g.setFont(new Font("Arial", 0, 24));
            for (i = 0; i < this.continents.size(); ++i) {
                ((Continent)this.continents.get(i)).drawLabel(g, this.shortContinentLabels);
            }
            this.drawPlayerInfo(g);
            g.setFont(oldFont);
            this.drawHelperText(g, Translator.getEditorString("continentNameHelp"), this.mapheight);
        } else if (this.mode == 6) {
            int i;
            for (i = 0; i < this.continents.size(); ++i) {
                ((Continent)this.continents.get(i)).drawCountries(g);
            }
            this.drawThemeOverground(g);
            g.setFont(new Font("Arial", 0, 24));
            for (i = 0; i < this.continents.size(); ++i) {
                ((Continent)this.continents.get(i)).drawLabel(g, this.shortContinentLabels);
            }
            this.drawHelperText(g, Translator.getEditorString("continentAssignHelp"), this.mapheight);
        } else if (this.mode == 8) {
            int i;
            if (this.background != null && this.themeHasLoaded) {
                g.drawImage(this.background, 0, 0, this.mapwidth, this.mapheight, this);
            }
            this.drawThemeOverground(g);
            GraphicsTool.drawLines(g, this.lines, Color.WHITE);
            for (i = 0; i < this.continents.size(); ++i) {
                ((Continent)this.continents.get(i)).drawPreview(g);
            }
            g.setColor(GraphicsTool.transparent(Color.white, 0.75f));
            for (i = 0; i < this.shapes.size(); ++i) {
                g.fill(((CountryShape)this.shapes.get(i)).getGeneralPath());
            }
            if (this.mousePressedAt != null && this.mouseAt != null && this.mousePressedAt != this.mouseAt) {
                g.setColor(this.colorWell.getColor());
                int width = 1;
                try {
                    width = Integer.parseInt(this.infoField.getText());
                }
                catch (Exception e) {
                    // empty catch block
                }
                g.setStroke(new BasicStroke(width, 1, 1));
                g.drawLine(this.mousePressedAt.x, this.mousePressedAt.y, this.mouseAt.x, this.mouseAt.y);
            }
            GraphicsTool.drawLines(g, this.aboveLines, Color.WHITE);
            this.drawHelperText(g, Translator.getEditorString("extraLineHelp"), this.mapheight);
        } else if (this.mode == PI_LOCATION) {
            g.setStroke(new BasicStroke(1.0f, 1, 1));
            for (int i = 0; i < this.shapes.size(); ++i) {
                CountryShape next = (CountryShape)this.shapes.get(i);
                if (next == this.activeShape || this.activeShapeList != null && this.activeShapeList.contains(next)) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLACK);
                }
                next.draw(g);
            }
            this.drawThemeOverground(g);
            this.drawPlayerInfo(g);
            this.drawHelperText(g, Translator.getEditorString("PIHelp"), this.mapheight);
        } else if (this.mode == PREVIEW || this.mode == INFO_PANEL || this.mode == PLAYER_PANEL) {
            CountryShape next;
            int i;
            this.drawThemeBackground(g);
            for (i = 0; i < this.continents.size(); ++i) {
                ((Continent)this.continents.get(i)).drawPreview(g);
            }
            for (i = 0; i < this.shapes.size(); ++i) {
                next = (CountryShape)this.shapes.get(i);
                int ownerID = next.getInitialOwnerInt();
                g.setColor(this.getColorForOwnerID(ownerID));
                if (this.voxEnabled) {
                    next.fillWithUnits(g, this.theme);
                    continue;
                }
                next.fillWithArmyBox(g);
            }
            this.drawThemeOverground(g);
            if (this.voxEnabled) {
                for (i = 0; i < this.shapes.size(); ++i) {
                    next = (CountryShape)this.shapes.get(i);
                    next.drawUnits(g, this.theme);
                }
            }
            this.drawPlayerInfo(g);
        }
    }

    boolean playerInfoContains(Point p) {
        int piheight = 115;
        if (this.voxEnabled && this.teamPlayers != null) {
            piheight = 20 + this.getNumberOfPlayers() * 16;
        }
        Rectangle PI_rect = new Rectangle((int)this.PI_x, (int)this.PI_y, 300, piheight);
        return PI_rect.contains(p);
    }

    void drawPlayerInfo(Graphics2D g) {
        g.setColor(Color.RED);
        int height = 115;
        if (this.voxEnabled && this.teamPlayers != null) {
            height = 20 + this.getNumberOfPlayers() * 16;
        }
        Rectangle box = new Rectangle((int)this.PI_x, (int)this.PI_y, 300, height);
        g.draw(box);
        g.fill(box);
    }

    void drawThemeBackground(Graphics2D g) {
        if (this.background != null && this.themeHasLoaded) {
            g.drawImage(this.background, 0, 0, this.mapwidth, this.mapheight, this);
        }
        if (this.foreground == null) {
            this.foreground = GraphicsTool.getImageFromJAR(this.voxEnabled ? "foreground.jpg" : "land4.jpg");
        }
        Shape oldClip = g.getClip();
        g.setClip(null);
        for (int i = 0; i < this.shapes.size(); ++i) {
            g.setClip(((CountryShape)this.shapes.get(i)).getGeneralPath());
            g.drawImage(this.foreground, 0, 0, this.mapwidth, this.mapheight, this);
        }
        g.setClip(oldClip);
        GraphicsTool.drawLines(g, this.lines, Color.WHITE);
    }

    private void drawThemeOverground(Graphics2D g) {
        GraphicsTool.drawLines(g, this.aboveLines, Color.WHITE);
        if (this.overground != null && this.themeHasLoaded) {
            g.drawImage(this.overground, 0, 0, this.mapwidth, this.mapheight, this);
        }
    }

    protected Color getColorForOwnerID(int ID) {
        if (ID < 0) {
            return GraphicsTool.transparent(Color.white, 0.75f);
        }
        if (this.voxEnabled) {
            if (this.teamPlayers == null) {
                return Color.BLACK;
            }
            for (int i = 0; i < this.teamPlayers.length; ++i) {
                List players = this.teamPlayers[i];
                if (players == null) continue;
                for (int p = 0; p < players.size(); ++p) {
                    if (!("" + ID).equals(((StringTriple)players.get((int)p)).s1)) continue;
                    return GraphicsTool.transparent(GraphicsTool.colorFromString(((StringTriple)players.get((int)p)).s3), 0.71f);
                }
            }
            return Color.BLACK;
        }
        while (ID >= this.initialOwnerColors.size()) {
            this.initialOwnerColors.add(GraphicsTool.getNextColor());
        }
        return (Color)this.initialOwnerColors.get(ID);
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressedAt = this.mouseAt = e.getPoint();
        if (this.mode == 0) {
            if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown()) {
                CountryShape toDelete = this.shapeAt(this.mouseAt);
                if (toDelete != null) {
                    RemoveShapeCommand com = new RemoveShapeCommand(toDelete);
                    this.doCommand(com);
                }
                return;
            }
            if (this.activeShape == null) {
                this.activeShape = new CountryShape(this.countryCodeCounter, this);
                ++this.countryCodeCounter;
                this.getFirstContinent().addCountryShape(this.activeShape);
                this.shapes.add(this.activeShape);
            }
            if (this.mouseAt.equals(this.activeShape.lastPoint())) {
                SS.debug("Trying to add a point in the exact same place as the last point, block it");
                return;
            }
            AddPointCommand com = new AddPointCommand(this.activeShape, this.mouseAt);
            this.doCommand(com);
            this.requestFocus();
        } else if (this.mode == 2) {
            for (int i = 0; i < this.shapes.size(); ++i) {
                this.pointID = ((CountryShape)this.shapes.get(i)).getPointAt(this.mouseAt);
                if (this.pointID == -1) continue;
                this.editingShape = (CountryShape)this.shapes.get(i);
                return;
            }
        } else if (this.mode == SHAPE_ARMY) {
            this.armyShape = this.armyShapeAt(this.mouseAt);
        } else if (this.mode == VOX_POINTS) {
            for (int i = 0; i < this.shapes.size(); ++i) {
                this.voxPointIndex = ((CountryShape)this.shapes.get(i)).voxPointAt(this.mouseAt);
                if (this.voxPointIndex <= -1) continue;
                this.activeShape = (CountryShape)this.shapes.get(i);
                return;
            }
        } else if (this.mode == 3) {
            if (e.isShiftDown() || e.isAltDown()) {
                CountryShape clickedOn = this.shapeAt(this.mouseAt);
                if (clickedOn == null) {
                    return;
                }
                if (this.activeShapeList == null) {
                    this.activeShapeList = new ArrayList();
                }
                if (this.activeShapeList.contains(clickedOn)) {
                    this.activeShapeList.remove(clickedOn);
                } else {
                    this.activeShapeList.add(clickedOn);
                }
                this.repaint();
            } else if (this.pointIsInActiveShapeList(this.mouseAt)) {
                this.draggingMultipleSelection = true;
            } else {
                CountryShape clickedOn = this.shapeAt(this.mouseAt);
                if (clickedOn != null) {
                    this.activeShape = null;
                    this.activeShapeList = new ArrayList();
                    this.activeShapeList.add(clickedOn);
                }
                this.repaint();
            }
        } else if (this.mode == 6) {
            Continent assign;
            this.activeShape = this.shapeAt(this.mouseAt);
            if (this.activeShape != null && !(assign = (Continent)this.continents.get(this.contCombo.getSelectedIndex())).contains(this.activeShape)) {
                ContinentAssignCommand com = new ContinentAssignCommand(assign, this.activeShape);
                this.doCommand(com);
            }
        } else if (this.mode == 4) {
            if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown()) {
                for (int i = 0; i < this.shapes.size(); ++i) {
                    for (int j = 0; j < this.shapes.size(); ++j) {
                        Line2D.Float connectingLine;
                        if (i == j || !((CountryShape)this.shapes.get(i)).adjoins((CountryShape)this.shapes.get(j)) || !((connectingLine = new Line2D.Float(((CountryShape)this.shapes.get(i)).getCenterPoint(), ((CountryShape)this.shapes.get(j)).getCenterPoint())).ptSegDist(this.mouseAt) < 5.0)) continue;
                        SS.debug("removing a line between " + this.shapes.get(i) + " and " + this.shapes.get(j), 2);
                        SS.debug("line: " + ((Line2D)connectingLine).getP1() + "-" + ((Line2D)connectingLine).getP2() + ",  mouseClickPoint:" + this.mouseAt + ", distance:" + connectingLine.ptSegDist(this.mouseAt), 2);
                        RemoveAdjoiningCommand com = new RemoveAdjoiningCommand(this.shapes.get(i), this.shapes.get(j));
                        this.doCommand(com);
                        return;
                    }
                }
            } else {
                this.activeShape = this.shapeAt(this.mouseAt);
            }
        } else if (this.mode == 5) {
            this.setActiveIndex(this.shapeIndexAt(this.mouseAt));
        } else if (this.mode == 7) {
            if (this.voxEnabled) {
                this.armyShape = this.armyShapeAt(this.mouseAt);
            }
            this.activeContinent = this.continentAt(this.mouseAt);
            this.setActiveContinent(this.continentIndexAt(this.mouseAt));
            if (this.playerInfoContains(this.mouseAt)) {
                this.draggingPI = true;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        CountryShape connect;
        if (this.mode == 2 && e.getClickCount() == 2 && (connect = this.shapeAtBoundsIncluded(e.getPoint())) != null) {
            InsertPointCommand com = new InsertPointCommand(connect, e.getPoint());
            this.doCommand(com);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.mode == 2) {
            if (this.editingShape != null) {
                MovePointCommand com = new MovePointCommand(this.editingShape, this.pointID, this.mouseAt, this.mousePressedAt);
                this.doCommand(com);
            }
            this.editingShape = null;
            this.pointID = -1;
        } else if (this.mode == 4) {
            CountryShape connect;
            if (this.activeShape != null && (connect = this.shapeAt(e.getPoint())) != null) {
                int from = this.activeShape.getCode();
                int to = connect.getCode();
                AdjoinBothCommand com = new AdjoinBothCommand(from, to);
                this.doCommand(com);
            }
            this.activeShape = null;
            this.repaint();
        } else if (this.mode == 6) {
            this.activeShape = null;
            this.repaint();
        } else if (this.mode == 8) {
            if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown()) {
                int i;
                for (i = 0; i < this.lines.size(); ++i) {
                    if (!(((ExtraLine)this.lines.get(i)).distanceToPoint(this.mouseAt) < 5.0)) continue;
                    RemoveLineCommand com = new RemoveLineCommand((ExtraLine)this.lines.get(i));
                    this.doCommand(com);
                    return;
                }
                for (i = 0; i < this.aboveLines.size(); ++i) {
                    if (!(((ExtraLine)this.aboveLines.get(i)).distanceToPoint(this.mouseAt) < 5.0)) continue;
                    RemoveLineCommand com = new RemoveLineCommand((ExtraLine)this.aboveLines.get(i));
                    this.doCommand(com);
                    return;
                }
            } else if (this.mousePressedAt != null && !this.mousePressedAt.equals(this.mouseAt)) {
                int width = 1;
                try {
                    width = Integer.parseInt(this.infoField.getText());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                AddLineCommand com = new AddLineCommand(this.mousePressedAt, this.mouseAt, width, this.colorWell.getColor(), this.infoCheckBox.isSelected());
                this.doCommand(com);
            }
        } else if (this.mode == 3) {
            if (this.activeShape != null) {
                MoveShapeCommand com = new MoveShapeCommand(this.activeShape, this.mouseAt, this.mousePressedAt);
                this.activeShape.moveShape(this.mousePressedAt.x - this.mouseAt.x, this.mousePressedAt.y - this.mouseAt.y);
                this.activeShape = null;
                this.doCommand(com);
            } else if (this.draggingMultipleSelection) {
                MoveShapeCommand com = new MoveShapeCommand(this.activeShapeList, this.mouseAt, this.mousePressedAt);
                for (int i = 0; i < this.activeShapeList.size(); ++i) {
                    ((CountryShape)this.activeShapeList.get(i)).moveShape(this.mousePressedAt.x - this.mouseAt.x, this.mousePressedAt.y - this.mouseAt.y);
                }
                this.doCommand(com);
            } else {
                this.repaint();
            }
        } else if (this.mode == SHAPE_ARMY && this.armyShape != null) {
            MoveArmyBoxCommand com = new MoveArmyBoxCommand(this.armyShape, this.mouseAt, this.mousePressedAt);
            this.armyShape.moveArmyBoxLocation(this.mousePressedAt.x - this.mouseAt.x, this.mousePressedAt.y - this.mouseAt.y);
            this.armyShape = null;
            this.doCommand(com);
        } else if (this.mode == VOX_POINTS && this.voxPointIndex > -1) {
            MoveVoxPointCommand com = new MoveVoxPointCommand(this.activeShape, this.voxPointIndex, this.mousePressedAt, this.mouseAt);
            this.activeShape.moveVoxPoint(this.voxPointIndex, this.mouseAt.x - this.mousePressedAt.x, this.mouseAt.y - this.mousePressedAt.y);
            this.activeShape = null;
            this.doCommand(com);
        } else if (this.mode == 7) {
            EditorCommand com;
            if (this.playerInfoContains(this.mouseAt)) {
                com = new MovePICommand(this.mousePressedAt, this.mouseAt);
                this.PI_x -= (double)(this.mouseAt.x - this.mousePressedAt.x);
                this.PI_y -= (double)(this.mouseAt.y - this.mousePressedAt.y);
                this.doCommand(com);
            }
            this.draggingPI = false;
            if (this.voxEnabled && this.armyShape != null) {
                com = new MoveArmyBoxCommand(this.armyShape, this.mouseAt, this.mousePressedAt);
                this.armyShape.moveArmyBoxLocation(this.mousePressedAt.x - this.mouseAt.x, this.mousePressedAt.y - this.mouseAt.y);
                this.armyShape = null;
                this.doCommand(com);
                return;
            }
            if (this.activeContinent != null) {
                com = new MoveContinentLabelCommand(this.activeContinent, this.mouseAt, this.mousePressedAt);
                this.activeContinent.moveLabelLocation(this.mousePressedAt.x - this.mouseAt.x, this.mousePressedAt.y - this.mouseAt.y);
                this.activeContinent = null;
                this.doCommand(com);
            }
        } else if (this.mode == PI_LOCATION) {
            MovePICommand com = new MovePICommand(this.mousePressedAt, this.mouseAt);
            this.PI_x -= (double)(this.mouseAt.x - this.mousePressedAt.x);
            this.PI_y -= (double)(this.mouseAt.y - this.mousePressedAt.y);
            this.doCommand(com);
        } else if (this.mode == 1 && this.mouseAt != null && this.mousePressedAt != null) {
            List points = this.getEllipsePoints();
            this.activeShape = new CountryShape(-1, this);
            this.activeShape.setPoints(points);
            this.activeShape.close();
            if (this.activeShape.getBounds().getWidth() < 11.0 && this.activeShape.getBounds().getHeight() < 11.0) {
                this.activeShape = null;
                this.mouseAtLast = null;
                this.mouseAt = null;
                this.mousePressedAt = null;
                this.armyShape = null;
                this.draggingMultipleSelection = false;
                this.repaint();
                return;
            }
            CreateStockShapeCommand com = new CreateStockShapeCommand(this.activeShape, this.getFirstContinent());
            this.doCommand(com);
            this.activeShape = null;
        }
        this.mouseAtLast = null;
        this.mouseAt = null;
        this.mousePressedAt = null;
        this.armyShape = null;
        this.draggingMultipleSelection = false;
    }

    private List getEllipsePoints() {
        int a = (this.mouseAt.x - this.mousePressedAt.x) / 2;
        int b = (this.mouseAt.y - this.mousePressedAt.y) / 2;
        int np = 10;
        try {
            np = Integer.parseInt(this.infoField.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (np < 3) {
            np = 3;
        }
        return GraphicsTool.getEllipsePoints(this.mousePressedAt.x + a, this.mousePressedAt.y + b, a, b, np);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseAtLast = this.mouseAt;
        this.mouseAt = e.getPoint();
        if (this.mode == 2) {
            if (this.editingShape != null) {
                this.editingShape.movePointTo(this.pointID, this.mouseAt);
                this.repaint();
            }
        } else if (this.mode == SHAPE_ARMY && this.armyShape != null) {
            this.armyShape.moveArmyBoxLocation(this.mouseAt.x - this.mouseAtLast.x, this.mouseAt.y - this.mouseAtLast.y);
            this.repaint();
        } else if (this.mode == VOX_POINTS && this.voxPointIndex > -1) {
            this.activeShape.moveVoxPoint(this.voxPointIndex, this.mouseAtLast.x - this.mouseAt.x, this.mouseAtLast.y - this.mouseAt.y);
            this.repaint();
        } else if (this.mode == 7) {
            if (this.draggingPI) {
                this.PI_x -= (double)(this.mouseAtLast.x - this.mouseAt.x);
                this.PI_y -= (double)(this.mouseAtLast.y - this.mouseAt.y);
                this.repaint();
            } else if (this.activeContinent != null) {
                this.activeContinent.moveLabelLocation(this.mouseAt.x - this.mouseAtLast.x, this.mouseAt.y - this.mouseAtLast.y);
                this.repaint();
            } else if (this.voxEnabled && this.armyShape != null) {
                this.armyShape.moveArmyBoxLocation(this.mouseAt.x - this.mouseAtLast.x, this.mouseAt.y - this.mouseAtLast.y);
                this.repaint();
            }
        } else if (this.mode == 3) {
            if (this.activeShape != null) {
                this.activeShape.moveShape(this.mouseAt.x - this.mouseAtLast.x, this.mouseAt.y - this.mouseAtLast.y);
                this.repaint();
            } else if (this.draggingMultipleSelection) {
                for (int i = 0; i < this.activeShapeList.size(); ++i) {
                    ((CountryShape)this.activeShapeList.get(i)).moveShape(this.mouseAt.x - this.mouseAtLast.x, this.mouseAt.y - this.mouseAtLast.y);
                }
                this.repaint();
            } else {
                this.selectShapesIn(this.mousePressedAt, this.mouseAt);
                this.repaint();
            }
        } else if (this.mode == PI_LOCATION) {
            this.PI_x -= (double)(this.mouseAtLast.x - this.mouseAt.x);
            this.PI_y -= (double)(this.mouseAtLast.y - this.mouseAt.y);
            this.repaint();
        } else if (this.mode == 6) {
            Continent assign;
            this.activeShape = this.shapeAt(this.mouseAt);
            if (this.activeShape != null && !(assign = (Continent)this.continents.get(this.contCombo.getSelectedIndex())).contains(this.activeShape)) {
                ContinentAssignCommand com = new ContinentAssignCommand(assign, this.activeShape);
                this.doCommand(com);
            }
        } else if (this.mode == 4 || this.mode == 8 || this.mode == 1) {
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.mode == 0 && e.getKeyCode() == 32) {
            this.pressSpacebar();
        }
        if (this.mode == 3) {
            if (this.activeShapeList == null || this.activeShapeList.size() == 0) {
                return;
            }
            if (e.getKeyCode() == 38) {
                MoveShapeCommand com = new MoveShapeCommand(this.activeShapeList, new Point(0, 0), new Point(0, 1));
                this.doCommand(com);
            } else if (e.getKeyCode() == 40) {
                MoveShapeCommand com = new MoveShapeCommand(this.activeShapeList, new Point(0, 1), new Point(0, 0));
                this.doCommand(com);
            } else if (e.getKeyCode() == 37) {
                MoveShapeCommand com = new MoveShapeCommand(this.activeShapeList, new Point(0, 0), new Point(1, 0));
                this.doCommand(com);
            } else if (e.getKeyCode() == 39) {
                MoveShapeCommand com = new MoveShapeCommand(this.activeShapeList, new Point(1, 0), new Point(0, 0));
                this.doCommand(com);
            }
        }
    }

    private void pressSpacebar() {
        if (this.activeShape == null) {
            return;
        }
        if (this.activeShape.pointCount() < 3 || this.activeShape.getBounds().getWidth() < 11.0 && this.activeShape.getBounds().getHeight() < 11.0) {
            this.removeCountryFromAllContinents(this.activeShape);
            this.shapes.remove(this.activeShape);
            --this.countryCodeCounter;
        } else {
            CloseShapeCommand com = new CloseShapeCommand(this.activeShape);
            this.doCommand(com);
        }
        this.activeShape = null;
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean isFocusable() {
        return true;
    }

    private Continent continentAt(Point p) {
        for (int i = 0; i < this.continents.size(); ++i) {
            if (!((Continent)this.continents.get(i)).labelContains(p)) continue;
            return (Continent)this.continents.get(i);
        }
        return null;
    }

    private int continentIndexAt(Point p) {
        for (int i = 0; i < this.continents.size(); ++i) {
            if (!((Continent)this.continents.get(i)).labelContains(p)) continue;
            return i;
        }
        return -1;
    }

    private CountryShape armyShapeAt(Point p) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!((CountryShape)this.shapes.get(i)).armyBoxContains(p)) continue;
            return (CountryShape)this.shapes.get(i);
        }
        return null;
    }

    private void selectShapesIn(Point p1, Point p2) {
        this.activeShapeList = new ArrayList();
        Rectangle rect = new Rectangle(p1);
        rect.add(p2);
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!((CountryShape)this.shapes.get(i)).intersects(rect)) continue;
            this.activeShapeList.add(this.shapes.get(i));
        }
    }

    private boolean pointIsInActiveShapeList(Point p) {
        if (this.activeShapeList == null) {
            return false;
        }
        for (int i = 0; i < this.activeShapeList.size(); ++i) {
            if (!((CountryShape)this.activeShapeList.get(i)).contains(p)) continue;
            return true;
        }
        return false;
    }

    private CountryShape shapeAt(Point p) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!((CountryShape)this.shapes.get(i)).contains(p)) continue;
            return (CountryShape)this.shapes.get(i);
        }
        return null;
    }

    private CountryShape shapeAtBoundsIncluded(Point p) {
        CountryShape result = this.shapeAt(p);
        if (result != null) {
            return result;
        }
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!((CountryShape)this.shapes.get(i)).getBounds().contains(p)) continue;
            return (CountryShape)this.shapes.get(i);
        }
        return null;
    }

    private int shapeIndexAt(Point p) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!((CountryShape)this.shapes.get(i)).contains(p)) continue;
            return i;
        }
        return -1;
    }

    public Point getCenterOfShape(int code) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (((CountryShape)this.shapes.get(i)).getCode() != code) continue;
            return ((CountryShape)this.shapes.get(i)).getCenterPoint();
        }
        SS.debug("getCenterOfShape didn't find the shape " + code);
        return null;
    }

    public void initWindow() {
        this.window = new SSFrame(SSApp.fullName() + " " + Translator.getString("MapEditor"));
        this.window.addWindowListener(this);
        this.window.setLocationID("MapEditorWindow");
        this.window.setDefaultCloseOperation(0);
        JPanel root = new JPanel();
        root.setLayout(new BoxLayout(root, 1));
        root.addComponentListener(this);
        Dimension max = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
        max = new Dimension(max.width, max.height - 125);
        root.setMaximumSize(max);
        this.window.setMaximumSize(max);
        this.mapwidth = 900;
        this.mapheight = 500;
        this.setPreferredSize(new Dimension(this.mapwidth, this.mapheight));
        JScrollPane scroller = new JScrollPane(this);
        scroller.setBorder(null);
        scroller.setMaximumSize(max);
        root.add(scroller);
        Object[] objArray = new Object[]{"1: " + Translator.getEditorString("DrawCountryShapes"), "2: " + Translator.getEditorString("StockShapes"), "3: " + Translator.getEditorString("EditCountryShapes"), "4: " + Translator.getEditorString("MoveCountryShapes"), "5: " + Translator.getEditorString("SetCountryConnections"), "6: " + Translator.getEditorString("SetCountryNames"), "7: " + Translator.getEditorString("CreateContinents"), "B: " + Translator.getEditorString("SetContinentNames"), "9: " + Translator.getEditorString("DrawExtraLines"), "A: " + Translator.getEditorString("MoveArmyBoxes"), ": " + Translator.getEditorString("SetPILocation"), "P: " + Translator.getEditorString("Preview")};
        if (this.voxEnabled) {
            VOX_POINTS = 9;
            PREVIEW = 10;
            INFO_PANEL = 11;
            PLAYER_PANEL = 12;
            SHAPE_ARMY = 999;
            objArray = new Object[]{"1: " + Translator.getEditorString("DrawCountryShapes"), "2: " + Translator.getEditorString("StockShapes"), "3: " + Translator.getEditorString("EditCountryShapes"), "4: " + Translator.getEditorString("MoveCountryShapes"), "5: " + Translator.getEditorString("SetCountryConnections"), "6: " + Translator.getEditorString("SetCountryNames"), "7: " + Translator.getEditorString("CreateContinents"), "B: " + Translator.getEditorString("SetContinentNames"), "9: " + Translator.getEditorString("DrawExtraLines"), "D: " + Translator.getEditorString("SetVoxPoints"), "P: " + Translator.getEditorString("Preview"), "I: " + Translator.getEditorString("SetMapInfo"), "U: Set Scenario Player Info"};
        }
        this.modeBox = new SSComboBox(objArray);
        this.modeBox.setMinimumSize(new Dimension(100, 34));
        this.modeBox.setMaximumSize(new Dimension(100000, 34));
        this.modeBox.setFocusable(false);
        this.modeBox.setMaximumRowCount(20);
        this.modeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.setMode(MapEditor.this.modeBox.getSelectedIndex());
            }
        });
        Color trans = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.modePanel = new SSRootPane();
        this.modePanel.setLayout(new BoxLayout(this.modePanel, 0));
        JLabel words = new JLabel("  " + Translator.getEditorString("EditingMode") + ": ");
        this.modePanel.add(words);
        this.modePanel.add(this.modeBox);
        this.modePanel.add(Box.createHorizontalGlue());
        SSButton button = new SSButton(Translator.getEditorString("OpenMap"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.loadBoardFile();
            }
        });
        this.modePanel.add(button);
        button = new SSButton(Translator.getEditorString("SaveMap"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.saveBoard();
            }
        });
        this.modePanel.add(button);
        root.add(this.modePanel);
        this.window.setContentPane(root);
        this.initJMenuBar();
        this.window.pack();
        this.window.show();
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        scroller.getHorizontalScrollBar().setUnitIncrement(16);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int newMode) {
        if (this.mode == 0 && this.activeShape != null && (this.activeShape.pointCount() < 3 || this.activeShape.getBounds().getWidth() < 11.0 && this.activeShape.getBounds().getHeight() < 11.0)) {
            this.removeCountryFromAllContinents(this.activeShape);
            this.shapes.remove(this.activeShape);
            --this.countryCodeCounter;
            this.activeShape = null;
        }
        this.mode = newMode;
        this.exitInfoMode();
        this.modePanel.drawGrowbox = true;
        if (this.mode == 5) {
            this.enterShapeInfoMode();
        } else if (this.mode == 7) {
            this.enterContinentInfoMode();
        } else if (this.mode == 6) {
            this.enterContinentCreateMode();
        } else if (this.mode == 8) {
            this.enterLinesMode();
        } else if (this.mode == 1) {
            this.enterStockShapeMode();
        } else if (this.mode == INFO_PANEL) {
            this.setInfo();
        } else if (this.mode == PLAYER_PANEL) {
            new EditorPlayerInfoPanel(this, this.appGUI);
        }
        this.repaint();
    }

    public void enterStockShapeMode() {
        this.modePanel.drawGrowbox = false;
        this.infoPanel = new SSRootPane(new FlowLayout(0));
        this.infoPanel.add(new JLabel(" " + Translator.getEditorString("numberofpoints") + ":"));
        this.infoField = new SSTextField("10", 12);
        this.infoPanel.add(this.infoField);
        this.infoPanel.setMinimumSize(new Dimension(100, 34));
        this.infoPanel.setMaximumSize(new Dimension(100000, 34));
        this.window.getContentPane().add(this.infoPanel);
        this.window.pack();
    }

    public void enterLinesMode() {
        this.modePanel.drawGrowbox = false;
        this.infoPanel = new SSRootPane(new FlowLayout(0));
        this.infoPanel.add(new JLabel(" " + Translator.getString("Color") + ": "));
        this.colorWell = new SSColorWell(new Color(0.8f, 0.8f, 0.8f), this.appGUI);
        this.infoPanel.add(this.colorWell);
        this.infoPanel.add(new JLabel("   " + Translator.getString("Width") + ":"));
        this.infoField = new SSTextField("3", 2);
        this.infoPanel.add(this.infoField);
        this.infoPanel.add(new JLabel("   "));
        this.infoCheckBox = new SSCheckBox(Translator.getEditorString("aboveCountries"));
        this.infoPanel.add(this.infoCheckBox);
        this.infoPanel.setMinimumSize(new Dimension(100, 34));
        this.infoPanel.setMaximumSize(new Dimension(100000, 34));
        this.window.getContentPane().add(this.infoPanel);
        this.window.getRootPane().setDefaultButton(this.nextButton);
        this.window.pack();
    }

    public void enterContinentCreateMode() {
        this.modePanel.drawGrowbox = false;
        this.infoPanel = new SSRootPane(new FlowLayout(0));
        SSButton button = new SSButton(Translator.getEditorString("NewContinent"));
        button.setPreferredWidth(200);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String newName = JOptionPane.showInputDialog(MapEditor.this.window, (Object)"Enter the new continent name:");
                if (newName == null || "".equals(newName.trim())) {
                    return;
                }
                MapEditor.this.continents.add(new Continent(newName, 5, GraphicsTool.stringFromColor(GraphicsTool.getNextColor()), null));
                MapEditor.this.fillContinentCombo();
                MapEditor.this.contCombo.setSelectedItem(newName);
                MapEditor.this.repaint();
            }
        });
        this.infoPanel.add(button);
        this.contCombo = new SSComboBox();
        this.fillContinentCombo();
        this.infoPanel.add(new JLabel("Click or drag across countries to add them to the continent: "));
        this.infoPanel.add(this.contCombo);
        this.infoPanel.setMinimumSize(new Dimension(100, 34));
        this.infoPanel.setMaximumSize(new Dimension(100000, 34));
        this.window.getContentPane().add(this.infoPanel);
        this.window.getRootPane().setDefaultButton(this.nextButton);
        this.window.pack();
    }

    public void fillContinentCombo() {
        Object selection = this.contCombo.getSelectedItem();
        this.contCombo.removeAllItems();
        for (int j = 0; j < this.continents.size(); ++j) {
            this.contCombo.addItem(((Continent)this.continents.get(j)).getName());
        }
        if (selection != null) {
            this.contCombo.setSelectedItem(selection);
        }
    }

    public void enterShapeInfoMode() {
        this.modePanel.drawGrowbox = false;
        this.infoPanel = this.voxEnabled ? new JPanel(new FlowLayout(0)) : new SSRootPane(new FlowLayout(0));
        this.infoPanel.add(new JLabel(" " + Translator.getString("Name:")));
        this.infoField = new SSTextField(12);
        this.infoPanel.add(this.infoField);
        this.infoPanel.add(new JLabel(" " + Translator.getEditorString("InitialOwner")));
        this.infoField2 = new SSTextField(3);
        this.infoPanel.add(this.infoField2);
        if (this.voxEnabled) {
            this.infoPanel.add(new JLabel("Country Bonus:"));
            this.infoField4 = new SSTextField(2);
            this.infoPanel.add(this.infoField4);
        } else {
            this.infoPanel.add(new JLabel(" " + Translator.getString("InitialArmies:")));
            this.infoField3 = new SSTextField(3);
            this.infoPanel.add(this.infoField3);
        }
        this.infoPanel.add(new JLabel("  "));
        this.nextButton = new SSButton(Translator.getEditorString("Next"));
        this.nextButton.setFocusable(false);
        this.nextButton.setPreferredWidth(80);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.setActiveIndex((MapEditor.this.activeIndex + 1) % MapEditor.this.shapes.size());
            }
        });
        this.previousButton = new SSButton(Translator.getEditorString("Previous"));
        this.previousButton.setFocusable(false);
        this.previousButton.setPreferredWidth(80);
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int active = MapEditor.this.activeIndex - 1;
                if (active == -1) {
                    active = MapEditor.this.shapes.size() - 1;
                }
                MapEditor.this.setActiveIndex(active);
            }
        });
        this.infoPanel.add(this.previousButton);
        this.infoPanel.add(this.nextButton);
        this.infoPanel.setMinimumSize(new Dimension(100, 34));
        this.infoPanel.setMaximumSize(new Dimension(100000, 34));
        if (this.voxEnabled) {
            JPanel luxInfoPanel = this.infoPanel;
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
            this.infoPanel.add(luxInfoPanel);
            SSRootPane allUnitsPanel = new SSRootPane(new FlowLayout(0));
            allUnitsPanel.add(new JLabel(" Starting Units: "));
            this.voxUnitCount = new SSTextField[this.numberOfVoxUnitsToShow];
            for (int i = 0; i < this.numberOfVoxUnitsToShow; ++i) {
                JPanel unitsPanel = new JPanel(new FlowLayout(0));
                this.voxUnitCount[i] = new SSTextField(3);
                unitsPanel.add(this.voxUnitCount[i]);
                unitsPanel.add(new JLabel(i == 0 ? "pawns, " : (i == 1 ? "knights, " : "castle")));
                allUnitsPanel.add(unitsPanel);
            }
            allUnitsPanel.setMinimumSize(new Dimension(100, 34));
            allUnitsPanel.setMaximumSize(new Dimension(100000, 34));
            this.infoPanel.add(allUnitsPanel);
        }
        this.window.getContentPane().add(this.infoPanel);
        this.window.getRootPane().setDefaultButton(this.nextButton);
        this.window.pack();
        this.setActiveIndex(0);
    }

    public void enterContinentInfoMode() {
        this.modePanel.drawGrowbox = false;
        this.infoPanel = new SSRootPane(new FlowLayout(0));
        this.infoPanel.add(new JLabel(" " + Translator.getString("Name:")));
        this.infoField = new SSTextField(12);
        this.infoPanel.add(this.infoField);
        this.infoPanel.add(new JLabel("  " + Translator.getEditorString("Bonus:")));
        this.infoField2 = new SSTextField(3);
        this.infoPanel.add(this.infoField2);
        this.infoPanel.add(new JLabel("  " + Translator.getString("Color:")));
        this.colorWell = new SSColorWell(Color.BLACK, this.appGUI);
        this.infoPanel.add(this.colorWell);
        if (!this.voxEnabled) {
            this.infoCheckBox = new SSCheckBox(Translator.getEditorString("shortContinentLabels"), this.shortContinentLabels);
            this.infoCheckBox.setSelected(this.shortContinentLabels);
            this.infoCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MapEditor.this.shortContinentLabels = !MapEditor.this.shortContinentLabels;
                    MapEditor.this.repaint();
                }
            });
            this.infoPanel.add(this.infoCheckBox);
        }
        this.infoPanel.add(new JLabel("  "));
        this.nextButton = new SSButton(Translator.getEditorString("Next"));
        this.nextButton.setPreferredWidth(80);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.setActiveContinent((MapEditor.this.activeContinentIndex + 1) % MapEditor.this.continents.size());
            }
        });
        this.infoPanel.add(this.nextButton);
        this.infoPanel.setMinimumSize(new Dimension(100, 34));
        this.infoPanel.setMaximumSize(new Dimension(100000, 34));
        this.window.getContentPane().add(this.infoPanel);
        this.window.getRootPane().setDefaultButton(this.nextButton);
        this.window.pack();
        this.setActiveContinent(0);
    }

    public void setActiveIndex(int i) {
        int u;
        CountryShape c;
        if (this.activeIndex != -1 && this.shapes.size() != 0 && this.infoField != null) {
            this.changedSinceSave = true;
            c = (CountryShape)this.shapes.get(this.activeIndex);
            c.setName(this.infoField.getText());
            c.setInitialOwner(this.infoField2.getText());
            if (!this.voxEnabled) {
                c.setInitialArmies(this.infoField3.getText());
            } else {
                c.setWater(false);
                c.setCountryBonus(this.infoField4.getText());
                c.clearUnits();
                for (u = 0; u < this.numberOfVoxUnitsToShow; ++u) {
                    if (this.voxUnitCount[u].getTextAsInt() <= 0) continue;
                    int ownerID = this.infoField2.getTextAsInt();
                    c.addUnits(this.voxUnitCount[u].getTextAsInt(), u == 0 ? "pawn" : (u == 1 ? "knight" : "castle"), ownerID);
                }
            }
        }
        this.activeIndex = i;
        if (this.activeIndex != -1 && this.shapes.size() != 0 && this.infoField != null) {
            c = (CountryShape)this.shapes.get(this.activeIndex);
            this.infoField.setText(c.getName());
            this.infoField2.setText(c.getInitialOwner());
            if (!this.voxEnabled) {
                this.infoField3.setText(c.getInitialArmies());
                this.infoField3.selectIfFocused();
            } else {
                this.infoField4.setText(c.getCountryBonus());
                this.infoField4.selectIfFocused();
                this.voxUnitCount[0].setText("");
                this.voxUnitCount[1].setText("");
                this.voxUnitCount[2].setText("");
                for (u = 0; u < this.numberOfVoxUnitsToShow; ++u) {
                    String type = c.getUnitType(u);
                    if ("pawn".equalsIgnoreCase(type) || "infantry".equalsIgnoreCase(type)) {
                        this.voxUnitCount[0].setText(c.getUnitCount(u));
                    } else if ("knight".equalsIgnoreCase(type)) {
                        this.voxUnitCount[1].setText(c.getUnitCount(u));
                    } else if ("castle".equalsIgnoreCase(type)) {
                        this.voxUnitCount[2].setText(c.getUnitCount(u));
                    }
                    this.voxUnitCount[u].selectIfFocused();
                }
            }
            this.infoField2.selectIfFocused();
        }
        this.repaint();
    }

    public void setActiveContinent(int i) {
        if (this.activeContinentIndex != -1 && this.continents.size() != 0 && this.infoField != null) {
            this.changedSinceSave = true;
            ((Continent)this.continents.get(this.activeContinentIndex)).setName(this.infoField.getText());
            ((Continent)this.continents.get(this.activeContinentIndex)).setBonus(this.infoField2.getText());
            ((Continent)this.continents.get(this.activeContinentIndex)).setColor(this.colorWell.getColor());
        }
        this.activeContinentIndex = i;
        if (this.activeContinentIndex != -1 && this.continents.size() != 0 && this.infoField != null) {
            this.infoField.setText(((Continent)this.continents.get(this.activeContinentIndex)).getName());
            this.infoField2.setText(((Continent)this.continents.get(this.activeContinentIndex)).getBonus());
            this.infoField2.selectIfFocused();
            this.colorWell.setColor(((Continent)this.continents.get(this.activeContinentIndex)).getColor());
        }
        this.repaint();
    }

    public void exitInfoMode() {
        this.setActiveContinent(-1);
        this.setActiveIndex(-1);
        if (this.infoPanel != null) {
            this.window.getContentPane().remove(this.infoPanel);
            this.window.getRootPane().setDefaultButton(null);
            this.window.pack();
            this.infoPanel = null;
            this.infoField = null;
            this.infoField2 = null;
            this.colorWell = null;
            this.infoComboBox = null;
            this.requestFocus();
        }
    }

    public void initJMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.appGUI.makeFileMenu(this.window, false, true));
        JMenu menu = new JMenu(Translator.getString("MapEditor"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(69);
        }
        final MapEditor ed = this;
        JMenuItem menuItem = new SSMenuItem(Translator.getEditorString("Copy"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.copy();
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("Paste"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.paste();
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("UndoLastAction"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.undo();
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("RedoLastAction"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.redo();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("ResizeMapLarger"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.resizeMap(1.1);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("ResizeMapSmaller"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.resizeMap(0.9090909090909091);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getEditorString("OpenMapFile"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.loadBoardFile();
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("LoadBackgroundImage"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.loadBackground();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getEditorString("SetMapInfo"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.setInfo();
            }
        });
        menu.add(menuItem);
        if (this.voxEnabled) {
            menuItem = new SSMenuItem("Set Scenario Player Info");
            menuItem.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            final MapEditor maped = this;
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new EditorPlayerInfoPanel(maped, MapEditor.this.appGUI);
                }
            });
            menu.add(menuItem);
        }
        menuItem = new SSMenuItem(Translator.getEditorString("SaveMap"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.saveBoard();
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("SaveMapAs"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.saveBoardAs();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getEditorString("DrawCountryShapes"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(49, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(0);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("StockShapes"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(50, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(1);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("EditCountryShapes"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(51, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(2);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("MoveCountryShapes"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(52, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(3);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("SetCountryConnections"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(53, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(4);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("SetCountryNames"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(54, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(5);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getEditorString("CreateContinents"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(55, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(6);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("SetContinentNames"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(56, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(7);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("DrawExtraLines"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(57, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(8);
            }
        });
        menu.add(menuItem);
        if (!this.voxEnabled) {
            menuItem = new SSMenuItem(Translator.getEditorString("MoveArmyBoxes"));
            menuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MapEditor.this.modeBox.setSelectedIndex(SHAPE_ARMY);
                }
            });
            menu.add(menuItem);
        }
        menuItem = new SSMenuItem(Translator.getEditorString("SetContinentNames"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(7);
            }
        });
        menu.add(menuItem);
        if (this.voxEnabled) {
            menuItem = new SSMenuItem(Translator.getEditorString("SetVoxPoints"));
            menuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MapEditor.this.modeBox.setSelectedIndex(VOX_POINTS);
                }
            });
            menu.add(menuItem);
        }
        menuItem = new SSMenuItem(Translator.getEditorString("Preview"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.modeBox.setSelectedIndex(PREVIEW);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSCheckBoxMenuItemBinding(Translator.getEditorString("ShowHelperText"), "editor_help", true);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditor.this.repaint();
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu(Translator.getString("EditorTools"));
        if (!this.voxEnabled) {
            menuItem = new SSMenuItem(Translator.getEditorString("extrathickfield"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ed.createHexField(30);
                }
            });
            menu.add(menuItem);
        }
        menuItem = new SSMenuItem(Translator.getEditorString("thickfield"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.createHexField(40);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("mediumfield"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.createHexField(50);
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("thinfield"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.createHexField(60);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getEditorString("randomcountrynames"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.nameShapes();
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getEditorString("connectclosecountries"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ed.connectCloseShapes();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        if (this.voxEnabled) {
            menuItem = new SSMenuItem(Translator.getEditorString("resetcountrybonuslabels"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ed.resetCountryLabelLocations();
                }
            });
            menu.add(menuItem);
            menuItem = new SSMenuItem(Translator.getEditorString("resetvoxpoints1"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ed.resetVoxPointsSmallHexes();
                }
            });
            menu.add(menuItem);
            menuItem = new SSMenuItem(Translator.getEditorString("resetvoxpoints2"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ed.resetVoxPoints();
                }
            });
            menu.add(menuItem);
            menuItem = new SSMenuItem(Translator.getEditorString("resetvoxpoints3"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ed.resetVoxPointsBiggerHexes();
                }
            });
            menu.add(menuItem);
        } else {
            menuItem = new SSMenuItem(Translator.getEditorString("resetarmyboxes"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ed.resetCountryLabelLocations();
                }
            });
            menu.add(menuItem);
        }
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getEditorString("uploadmap"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserLauncher.openURL("http://sillysoft.net/" + (MapEditor.this.voxEnabled ? "vox" : "lux") + "/maps/upload/");
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menuBar.add(this.appGUI.makeOnlineMenu());
        menuBar.add(this.appGUI.makeHelpMenu());
        this.window.setJMenuBar(menuBar);
    }

    private void shiftUpPlayerID() {
        for (int j = 0; j < this.shapes.size(); ++j) {
            CountryShape cs = (CountryShape)this.shapes.get(j);
            cs.setInitialOwner("" + (cs.getInitialOwnerInt() + 1));
            for (int u = 0; u < this.numberOfVoxUnitsToShow; ++u) {
                cs.setUnitOwner(u, cs.getUnitOwnerInt(u) + 1);
            }
        }
        for (int i = 0; i < this.teamPlayers.length; ++i) {
            List players = this.teamPlayers[i];
            if (players == null) continue;
            for (int p = 0; p < players.size(); ++p) {
                StringTriple player = (StringTriple)players.get(p);
                player.s1 = "" + (Integer.parseInt(player.s1) + 1);
            }
        }
        int size = this.teamPlayers.length + 1;
        String[] teamNamesNew = new String[size];
        System.arraycopy(this.teamNames, 0, teamNamesNew, 1, this.teamNames.length);
        this.teamNames = teamNamesNew;
        String[] teamSymbolsNew = new String[size];
        System.arraycopy(this.teamSymbols, 0, teamSymbolsNew, 1, this.teamSymbols.length);
        this.teamSymbols = teamSymbolsNew;
        List[] teamPlayersNew = new List[size];
        System.arraycopy(this.teamPlayers, 0, teamPlayersNew, 1, this.teamPlayers.length);
        this.teamPlayers = teamPlayersNew;
        ArrayList<StringTriple> zeroPlayers = new ArrayList<StringTriple>();
        zeroPlayers.add(new StringTriple("0", "shifted name", GraphicsTool.stringFromColor(GraphicsTool.getNextColor())));
        this.teamPlayers[0] = zeroPlayers;
        this.teamSymbols[0] = "\u2022";
        this.teamNames[0] = "shift team";
    }

    private void swapPlayerID() {
        String IDS1 = JOptionPane.showInputDialog(this.window, (Object)"First player ID to swap");
        String IDS2 = JOptionPane.showInputDialog(this.window, (Object)"Second player ID to swap");
        int ID1 = Integer.parseInt(IDS1);
        int ID2 = Integer.parseInt(IDS2);
        SwapPlayerIDCommand com = new SwapPlayerIDCommand(ID1, ID2);
        this.doCommand(com);
    }

    protected void swapPlayerID(int ID1, int ID2) {
        for (int j = 0; j < this.shapes.size(); ++j) {
            int u;
            CountryShape cs = (CountryShape)this.shapes.get(j);
            if (cs.getInitialOwnerInt() == ID1) {
                cs.setInitialOwner("" + ID2);
                for (u = 0; u < this.numberOfVoxUnitsToShow; ++u) {
                    cs.setUnitOwner(u, ID2);
                }
                continue;
            }
            if (cs.getInitialOwnerInt() != ID2) continue;
            cs.setInitialOwner("" + ID1);
            for (u = 0; u < this.numberOfVoxUnitsToShow; ++u) {
                cs.setUnitOwner(u, ID1);
            }
        }
        StringTriple playerData1 = this.getPlayer(ID1);
        StringTriple playerData2 = this.getPlayer(ID2);
        if (playerData1 == null || playerData1.s1 == null) {
            playerData1 = new StringTriple("" + ID1, "name", GraphicsTool.stringFromColor(GraphicsTool.getNextColor()));
        }
        if (playerData2 == null || playerData2.s1 == null) {
            playerData2 = new StringTriple("" + ID2, "name", GraphicsTool.stringFromColor(GraphicsTool.getNextColor()));
        }
        boolean swappedIn1 = false;
        boolean swappedIn2 = false;
        for (int i = 0; i < this.teamPlayers.length; ++i) {
            List players = this.teamPlayers[i];
            if (players == null) continue;
            for (int p = 0; p < players.size(); ++p) {
                if (("" + ID1).equals(((StringTriple)players.get((int)p)).s1)) {
                    players.remove(p);
                    playerData2.s1 = "" + ID1;
                    players.add(p, playerData2);
                    swappedIn2 = true;
                    continue;
                }
                if (!("" + ID2).equals(((StringTriple)players.get((int)p)).s1)) continue;
                players.remove(p);
                playerData1.s1 = "" + ID2;
                players.add(p, playerData1);
                swappedIn1 = true;
            }
        }
        if (!swappedIn1) {
            this.setPlayer(ID2, playerData1.s2, GraphicsTool.colorFromString(playerData1.s3), "0");
        }
        if (!swappedIn2) {
            this.setPlayer(ID1, playerData2.s2, GraphicsTool.colorFromString(playerData2.s3), "0");
        }
        this.repaint();
    }

    private void resetVoxPoints() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            CountryShape cs = (CountryShape)this.shapes.get(i);
            cs.voxPoints = null;
            cs.ensureVoxPointsExists();
        }
        this.repaint();
    }

    private void resetVoxPointsSmallHexes() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            CountryShape cs = (CountryShape)this.shapes.get(i);
            cs.voxPoints = null;
            cs.ensureVoxPointsExistsSmallHexes();
        }
        this.repaint();
    }

    private void resetVoxPointsBiggerHexes() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            CountryShape cs = (CountryShape)this.shapes.get(i);
            cs.voxPoints = null;
            cs.ensureVoxPointsExistsBigHexes();
        }
        this.repaint();
    }

    private void resetCountryLabelLocations() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            CountryShape cs = (CountryShape)this.shapes.get(i);
            cs.armyBoxPoint = null;
            cs.ensureArmyBoxPointExists();
        }
        this.repaint();
    }

    private void loadBackground() {
        FileDialog d = new FileDialog((Frame)this.window, Translator.getEditorString("Selectanimage"), 0);
        d.setDirectory(Prefs.get("lastMapEditorBackgroundDir", DesktopTool.supportFolderPath() + "Themes"));
        d.pack();
        d.show();
        String dir = d.getDirectory();
        if (dir != null) {
            Prefs.put("lastMapEditorBackgroundDir", dir);
        }
        String file = d.getFile();
        d.dispose();
        if (dir != null && file != null) {
            this.loadBackground(dir + file, false);
        }
    }

    private void loadBackground(String path, boolean asThemeBackground) {
        block3: {
            try {
                SS.debug("Loading map editor background image: " + path + " asThemeBackground=" + asThemeBackground, 2);
                this.background = new ImageIcon(path).getImage();
                if (!asThemeBackground) {
                    this.setPreferredSize(new Dimension(this.background.getWidth(null), this.background.getHeight(null)));
                    this.mapwidth = this.background.getWidth(null);
                    this.mapheight = this.background.getHeight(null);
                    this.window.pack();
                }
                this.themeHasLoaded = asThemeBackground;
            }
            catch (Exception ex) {
                if (asThemeBackground) break block3;
                SSOptionPane.showMessageDialog(this.window, (Object)Translator.getEditorString("errorLoadingImage"));
            }
        }
        this.repaint();
    }

    private void loadBoardFile() {
        FileDialog d = new FileDialog((Frame)this.window, Translator.getEditorString("Selectaboardfile"), 0);
        d.setDirectory(Prefs.get("lastMapEditorDir", DesktopTool.supportFolderPath() + this.savedMapDir));
        d.pack();
        d.show();
        String dir = d.getDirectory();
        if (dir != null) {
            Prefs.put("lastMapEditorDir", dir);
        }
        String file = d.getFile();
        d.dispose();
        if (dir != null && file != null) {
            this.loadBoardFile(dir + file);
        }
    }

    private void loadBoardFile(String path) {
        this.clear();
        this.setMode(0);
        try {
            new EditorLoadBoard(this, path);
            this.cleanUp();
            this.filename = path.substring(path.lastIndexOf(File.separatorChar) + 1);
            if (this.voxEnabled && this.filename.endsWith(".luxb")) {
                this.filename = StringTool.stripLastDotWord(this.filename);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SSOptionPane.showMessageDialog(this.window, (Object)(Translator.getEditorString("Errorloadingfile") + "\n\n" + ex));
        }
        this.repaint();
    }

    public void setBoardName(String title) {
        this.name = title;
        this.window.setTitle(SSApp.fullName() + " " + Translator.getString("MapEditor") + ": " + title);
    }

    public void setBoardSize(int w, int h) {
        this.mapwidth = w;
        this.mapheight = h;
        Dimension d = new Dimension(w, h);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.window.pack();
    }

    public void setTheme(String theme) {
        this.theme = theme;
        this.overground = null;
        this.foreground = null;
        File themeDir = new File(DesktopTool.supportFolderPath() + "Themes" + File.separator + theme);
        if (themeDir != null && themeDir.isDirectory()) {
            File[] themeFiles = themeDir.listFiles();
            for (int i = 0; i < themeFiles.length; ++i) {
                if (themeFiles[i].getName().equalsIgnoreCase("black.color")) continue;
                if (themeFiles[i].getName().startsWith("background.")) {
                    this.loadBackground(themeFiles[i].getPath(), true);
                    continue;
                }
                if (themeFiles[i].getName().startsWith("overground.png")) {
                    this.overground = new ImageIcon(themeFiles[i].getPath()).getImage();
                    this.themeHasLoaded = true;
                    continue;
                }
                if (!themeFiles[i].getName().startsWith("foreground.")) continue;
                this.foreground = new ImageIcon(themeFiles[i].getPath()).getImage();
            }
        }
    }

    public void setAuthor(String value) {
        this.author = value;
    }

    public void setArmySet(String value) {
        this.armySet = value;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public void setDescription(String value) {
        this.description = StringTool.xmlSafeReverse(value);
    }

    public void setVersion(String value) {
        try {
            this.version = Float.parseFloat(value);
        }
        catch (Exception e) {
            this.version = 1.0f;
        }
    }

    public void setWebpage(String value) {
        this.webpage = value;
    }

    public void setEmptyPlayer(String value) {
        this.emptyPlayer = value;
    }

    public String getTitle() {
        return this.name == null ? "" : this.name;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getArmySet() {
        return this.armySet;
    }

    public String getAuthor() {
        return this.author == null ? "" : this.author;
    }

    public String getVersion() {
        return this.version == 0.0f ? "1.0" : String.valueOf(this.version);
    }

    public String getEmail() {
        return this.email == null ? "" : this.email;
    }

    public String getWebpage() {
        return this.webpage == null ? "" : this.webpage;
    }

    public String getEmptyPlayer() {
        return this.emptyPlayer == null ? "" : this.emptyPlayer;
    }

    public String getBoardWidth() {
        return String.valueOf(this.mapwidth);
    }

    public String getBoardHeight() {
        return String.valueOf(this.mapheight);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public int createContinent(String continentName, int bonus, String colorString, String labelLocation) {
        this.continents.add(new Continent(continentName, bonus, colorString, labelLocation));
        return this.continents.size() - 1;
    }

    public void addUnits(int fromCode, String count, String type, String ownerID) {
        try {
            for (int i = 0; i < this.shapes.size(); ++i) {
                if (((CountryShape)this.shapes.get(i)).getCode() != fromCode) continue;
                ((CountryShape)this.shapes.get(i)).addUnits(Integer.parseInt(count), type, Integer.parseInt(ownerID));
                return;
            }
        }
        catch (Exception e) {
            SSOptionPane.showMessageDialog(this.window, (Object)("Error in units: " + e));
            return;
        }
        SSOptionPane.showMessageDialog(this.window, (Object)Translator.getEditorString("Erroradjoining"));
    }

    public void addAdjoining(int fromCode, int toCode) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (((CountryShape)this.shapes.get(i)).getCode() != fromCode) continue;
            ((CountryShape)this.shapes.get(i)).addAdjoining(toCode);
            return;
        }
        SSOptionPane.showMessageDialog(this.window, (Object)Translator.getEditorString("Erroradjoining"));
    }

    public void removeAdjoining(int fromCode, int toCode) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (((CountryShape)this.shapes.get(i)).getCode() != fromCode) continue;
            ((CountryShape)this.shapes.get(i)).removeAdjoining(toCode);
            return;
        }
    }

    public void addCountryToContinent(int code, String countryName, GeneralPath shape, List points, String armyLocation, String initialOwner, String initialArmies, int contID, String water, String income, String voxPoints) {
        CountryShape cs = new CountryShape(code, countryName, shape, points, armyLocation, initialOwner, initialArmies, this, water, income);
        ((Continent)this.continents.get(contID)).addCountryShape(cs);
        this.shapes.add(cs);
        if (voxPoints != null) {
            StringTokenizer tok = new StringTokenizer(voxPoints, " ,");
            while (tok.hasMoreTokens()) {
                cs.addVoxPoint(tok.nextToken(), tok.nextToken());
            }
        }
        if (code >= this.countryCodeCounter) {
            this.countryCodeCounter = code + 1;
        }
    }

    public void addLine(ExtraLine line, boolean flip) {
        if (flip) {
            line.flipY(this.mapheight);
        }
        if (line.above) {
            this.aboveLines.add(line);
        } else {
            this.lines.add(line);
        }
    }

    public void removeLine(ExtraLine line) {
        this.lines.remove(line);
        this.aboveLines.remove(line);
    }

    private void setInfo() {
        new EditorInfoPanel(this, this.appGUI);
    }

    private void saveBoard() {
        if (this.filename == null || "".equals(this.filename.trim())) {
            this.saveBoardAs();
        } else {
            this.saveBoardWithFilename(this.filename);
        }
    }

    private void saveBoardAs() {
        String oldFilename = this.filename;
        this.filename = SSOptionPane.showInputDialog(this.window, Translator.getEditorString("SaveMapAs"), this.filename);
        if (this.filename == null) {
            this.filename = oldFilename;
            return;
        }
        if ("".equals(this.filename.trim())) {
            this.saveBoardAs();
            return;
        }
        this.saveBoardWithFilename(this.filename);
    }

    public void saveBoardWithFilename(String filename) {
        if (this.mode == 7) {
            this.setActiveContinent(this.activeContinentIndex);
        } else if (this.mode == 5) {
            this.setActiveIndex(this.activeIndex);
        }
        this.pressSpacebar();
        try {
            int i;
            if (filename == null) {
                return;
            }
            String extension = this.voxEnabled ? ".voxb" : ".luxb";
            String parentTag = this.voxEnabled ? "voxmap" : "luxboard";
            String path = DesktopTool.supportFolderPath() + this.savedMapDir + File.separator + filename;
            if (!path.endsWith(extension)) {
                path = path + extension;
            }
            if (this.voxEnabled && (this.teamNames == null || this.teamNames.length == 0)) {
                this.setTeam(0, "non-playable", "\u2022");
                this.setTeam(1, "team1", "\u221e");
                this.setTeam(2, "team2", "\u00a7");
                this.setPlayer(0, "name0", GraphicsTool.colorFromString("0.2/0.2/0.2"), "0");
                this.setPlayer(1, "name1", GraphicsTool.getNextColor(), "1");
                this.setPlayer(2, "name2", GraphicsTool.getNextColor(), "2");
            }
            SS.debug("MapEditor: Saving file to: " + path);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8")));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<" + parentTag + ">");
            out.println("<version>" + this.version + "</version>");
            out.println("<width>" + this.mapwidth + "</width>");
            out.println("<height>" + this.mapheight + "</height>");
            if (this.theme == null) {
                this.theme = this.voxEnabled ? "Black" : "Ocean";
            }
            out.println("<theme>" + this.theme + "</theme>");
            out.println("");
            out.println("<author>" + (this.author == null ? "" : this.author) + "</author>");
            out.println("<email>" + (this.email == null ? "" : this.email) + "</email>");
            out.println("<webpage>" + (this.webpage == null ? "" : this.webpage) + "</webpage>");
            out.println("");
            out.println("<title>" + (this.name == null ? "" : StringTool.xmlSafe(this.name)) + "</title>");
            out.println("<description>" + (this.description == null ? "" : StringTool.xmlSafe(this.description)) + "</description>");
            if (this.shortContinentLabels) {
                out.println("<shortContinentLabels>true</shortContinentLabels>");
            }
            if (this.armySet != null && !this.armySet.equals("Normal") && !this.armySet.equals("Modern")) {
                out.println("<armySet>" + this.armySet + "</armySet>");
            }
            out.println("");
            if (this.emptyPlayer != null && !"".equals(this.emptyPlayer)) {
                out.println("<emptyPlayerID>" + this.emptyPlayer + "</emptyPlayerID>");
            }
            out.println("");
            if (this.PI_x != 0.0 || this.PI_y != 0.0) {
                out.println("<playerInfoLocation>" + (int)this.PI_x + "," + (int)this.PI_y + "</playerInfoLocation>");
                out.println("");
            }
            if (this.voxEnabled && this.teamNames != null) {
                for (i = 0; i < this.teamNames.length; ++i) {
                    if (this.teamPlayers[i] == null || this.teamPlayers[i].size() <= 0) continue;
                    out.println("<team name=\"" + StringTool.xmlSafe(this.teamNames[i]) + "\" symbol=\"" + this.teamSymbols[i] + "\">");
                    for (int p = 0; p < this.teamPlayers[i].size(); ++p) {
                        StringTriple playerData = (StringTriple)this.teamPlayers[i].get(p);
                        out.println("\t<player id=\"" + playerData.s1 + "\" name=\"" + StringTool.xmlSafe(playerData.s2) + "\" color=\"" + playerData.s3 + "\" " + (playerData.s4 == null ? "" : "agent=\"" + playerData.s4 + "\" ") + (playerData.s5 == null ? "" : "money=\"" + playerData.s5 + "\" ") + " />");
                    }
                    out.println("</team>");
                }
            }
            if (this.extraInfo != null) {
                out.println("<extraInfo>" + this.extraInfo + "</extraInfo>");
                out.println("");
            }
            for (i = 0; i < this.continents.size(); ++i) {
                out.println(((Continent)this.continents.get(i)).getXML(this.mapheight));
            }
            for (i = 0; i < this.lines.size(); ++i) {
                out.println(((ExtraLine)this.lines.get(i)).getXML(this.mapheight));
            }
            for (i = 0; i < this.aboveLines.size(); ++i) {
                out.println(((ExtraLine)this.aboveLines.get(i)).getXML(this.mapheight));
            }
            out.print("\n</" + parentTag + ">");
            out.close();
            SS.debug("MapEditor: Finished saving file.");
            this.appGUI.fillMapSelector(filename);
            SSOptionPane.showMessageDialog(this.window, (Object)Translator.getEditorString("Maphasbeensaved"));
            this.changedSinceSave = false;
        }
        catch (Exception e) {
            SSOptionPane.showMessageDialog(this.window, (Object)(Translator.getEditorString("Errorsaving") + "\n(" + e + ")"));
            e.printStackTrace();
        }
    }

    private void clear() {
        this.theme = null;
        this.name = null;
        this.armySet = null;
        this.version = 1.0f;
        this.author = null;
        this.email = null;
        this.webpage = null;
        this.description = null;
        this.mode = 0;
        this.shapes = new Vector();
        this.continents = new Vector();
        this.lines = new Vector();
        this.aboveLines = new Vector();
        this.activeContinent = null;
        this.activeShape = null;
        this.armyShape = null;
        this.background = null;
        this.repaint();
    }

    private void doCommand(EditorCommand com) {
        this.changedSinceSave = true;
        com.execute(this);
        this.undoList.add(com);
        this.redoList = new Vector();
    }

    private void undo() {
        this.changedSinceSave = true;
        if (this.undoList.size() == 0) {
            SS.beep();
            return;
        }
        EditorCommand com = (EditorCommand)this.undoList.remove(this.undoList.size() - 1);
        com.undo(this);
        this.redoList.add(com);
    }

    private void redo() {
        if (this.redoList.size() == 0) {
            SS.beep();
            return;
        }
        EditorCommand com = (EditorCommand)this.redoList.remove(this.redoList.size() - 1);
        com.execute(this);
        this.undoList.add(com);
    }

    public void setActiveShape(CountryShape s) {
        this.activeShape = s;
    }

    public Continent removeCountryFromAllContinents(CountryShape c) {
        Continent toReturn = null;
        for (int i = 0; i < this.continents.size(); ++i) {
            if (!((Continent)this.continents.get(i)).removeCountryShape(c)) continue;
            toReturn = (Continent)this.continents.get(i);
        }
        return toReturn;
    }

    public Continent getContinent(CountryShape c) {
        for (int i = 0; i < this.continents.size(); ++i) {
            if (!((Continent)this.continents.get(i)).contains(c)) continue;
            return (Continent)this.continents.get(i);
        }
        return null;
    }

    public void removeCountryFromShapes(CountryShape c) {
        this.shapes.remove(c);
        int code = c.getCode();
        for (int i = 0; i < this.shapes.size(); ++i) {
            ((CountryShape)this.shapes.get(i)).removeAdjoining(code);
        }
        this.ensureCountryCodeSanity(code);
    }

    public void addShapeInContinent(CountryShape country, Continent cont) {
        this.shapes.add(country);
        if (cont != null) {
            cont.addCountryShape(country);
        } else {
            this.getFirstContinent().addCountryShape(country);
        }
        country.setCode(this.countryCodeCounter);
        ++this.countryCodeCounter;
    }

    private void ensureCountryCodeSanity(int removedCode) {
        int maxCode = this.countryCodeCounter - 1;
        for (int i = 0; i < this.shapes.size(); ++i) {
            CountryShape shape = (CountryShape)this.shapes.get(i);
            if (shape.getCode() == maxCode) {
                shape.setCode(removedCode);
                continue;
            }
            if (!shape.adjoins(maxCode)) continue;
            shape.removeAdjoining(maxCode);
            shape.addAdjoining(removedCode);
        }
        this.countryCodeCounter = this.shapes.size();
    }

    private void cleanUp() {
        for (int i = 0; i < this.shapes.size(); ++i) {
            CountryShape shape = (CountryShape)this.shapes.get(i);
            if (shape.pointCount() >= 3) continue;
            this.removeCountryFromAllContinents(shape);
            this.removeCountryFromShapes(shape);
            --i;
        }
    }

    public void componentShown(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentResized(ComponentEvent evt) {
        if (this.shapes.size() == 0) {
            SS.debug("MapEd: componentResized: " + evt.getComponent().getWidth() + "," + evt.getComponent().getHeight(), 0);
            SS.debug("MapEd: this.size: " + this.getWidth() + "," + this.getHeight(), 0);
            this.mapwidth = this.getWidth();
            this.mapheight = this.getHeight();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.changedSinceSave) {
            int answer = SSOptionPane.showConfirmDialog(this, Translator.getEditorString("closeSaveText"), "", 1);
            if (answer == 0) {
                this.saveBoard();
            }
            if (answer == 2) {
                return;
            }
        }
        this.kill();
    }

    public void kill() {
        if (this.window == null) {
            return;
        }
        this.window.removeWindowListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        this.continents = null;
        this.shapes = null;
        this.lines = null;
        this.aboveLines = null;
        SwingTool.removeActionListeners(this.modeBox);
        SwingTool.removeActionListeners(this.nextButton);
        this.modeBox = null;
        this.infoPanel = null;
        this.nextButton = null;
        this.infoField = null;
        this.infoField2 = null;
        this.infoField3 = null;
        this.colorWell = null;
        this.infoCheckBox = null;
        this.background = null;
        this.foreground = null;
        this.undoList = null;
        this.redoList = null;
        this.initialOwnerColors = null;
        SwingTool.destroyMenu(this.window.getJMenuBar());
        this.window.setContentPane(new JPanel());
        this.window.setJMenuBar(null);
        this.window.setMenuBar(null);
        this.window.dispose();
        this.window = null;
    }

    public void setExtraInfo(String extraXML) {
        this.extraInfo = extraXML;
    }

    public void setPlayerInfoLocation(String playerInfoLocationString) {
        if (playerInfoLocationString == null) {
            return;
        }
        Point p = GraphicsTool.pointFromString(playerInfoLocationString);
        this.PI_x = p.x;
        this.PI_y = p.y;
    }

    public void movePIArea(int dx, int dy) {
        this.PI_x -= (double)dx;
        this.PI_y -= (double)dy;
    }

    private void drawHelperText(Graphics2D g, String text, int height) {
        if (Prefs.getBoolean("editor_help", true)) {
            g.setFont(new Font("Arial", 0, 12));
            GraphicsTool.drawHelperText(g, text, height);
        }
    }

    public void setShortContinentLabels(boolean shortContinentLabels) {
        this.shortContinentLabels = shortContinentLabels;
        if (this.voxEnabled) {
            this.shortContinentLabels = true;
        }
    }

    protected Continent getFirstContinent() {
        if (this.continents.size() == 0) {
            this.continents.add(new Continent("region 0", 5, null, null));
        }
        return (Continent)this.continents.get(0);
    }

    public void addTeam(int ID, String teamName, String teamSymbol, List playerList) {
        if (ID == 0) {
            SS.debug("Team with ID of 0");
        }
        this.ensureTeamArraysSize(ID + 1);
        this.teamNames[ID] = teamName;
        this.teamSymbols[ID] = teamSymbol;
        this.teamPlayers[ID] = playerList;
    }

    public void setTeam(int ID, String teamName, String teamSymbol) {
        this.ensureTeamArraysSize(ID + 1);
        if (ID == 0 && teamName.equals("")) {
            teamName = "non-playable";
        }
        this.teamNames[ID] = teamName;
        this.teamSymbols[ID] = teamSymbol;
    }

    private void ensureTeamArraysSize(int size) {
        if (this.teamNames == null) {
            this.teamNames = new String[size];
            this.teamSymbols = new String[size];
            this.teamPlayers = new List[size];
        }
        if (this.teamNames.length < size) {
            String[] teamNamesNew = new String[size];
            System.arraycopy(this.teamNames, 0, teamNamesNew, 0, this.teamNames.length);
            this.teamNames = teamNamesNew;
            String[] teamSymbolsNew = new String[size];
            System.arraycopy(this.teamSymbols, 0, teamSymbolsNew, 0, this.teamSymbols.length);
            this.teamSymbols = teamSymbolsNew;
            List[] teamPlayersNew = new List[size];
            System.arraycopy(this.teamPlayers, 0, teamPlayersNew, 0, this.teamPlayers.length);
            this.teamPlayers = teamPlayersNew;
        }
    }

    public int getNumberOfTeams() {
        if (this.teamPlayers == null) {
            return 0;
        }
        return this.teamPlayers.length;
    }

    public int getNumberOfPlayers() {
        int result = 0;
        if (this.teamPlayers == null) {
            return 0;
        }
        for (int i = 0; i < this.teamPlayers.length; ++i) {
            List players = this.teamPlayers[i];
            if (players == null) continue;
            result += players.size();
        }
        return result;
    }

    public StringTriple getPlayer(int ID) {
        if (this.teamPlayers == null) {
            return null;
        }
        for (int i = 0; i < this.teamPlayers.length; ++i) {
            List players = this.teamPlayers[i];
            if (players == null) continue;
            for (int p = 0; p < players.size(); ++p) {
                if (!("" + ID).equals(((StringTriple)players.get((int)p)).s1)) continue;
                return (StringTriple)players.get(p);
            }
        }
        return null;
    }

    public int getTeamIDForPlayerID(int ID) {
        if (this.teamPlayers == null) {
            return -1;
        }
        for (int i = 0; i < this.teamPlayers.length; ++i) {
            List players = this.teamPlayers[i];
            if (players == null) continue;
            for (int p = 0; p < players.size(); ++p) {
                if (!("" + ID).equals(((StringTriple)players.get((int)p)).s1)) continue;
                return i;
            }
        }
        return -1;
    }

    public String getTeamName(int ID) {
        if (this.teamPlayers == null) {
            return "";
        }
        return ID >= this.teamNames.length || this.teamNames[ID] == null ? "" : this.teamNames[ID];
    }

    public String getTeamSymbol(int ID) {
        if (this.teamSymbols == null) {
            return "";
        }
        return ID >= this.teamSymbols.length || this.teamSymbols[ID] == null ? "" : this.teamSymbols[ID];
    }

    public void setPlayer(int ID, String name, Color color, String teamIDstring) {
        if (ID == 0) {
            name = "non-playable";
            teamIDstring = "0";
        }
        if (teamIDstring == null || "".equals(teamIDstring)) {
            int teamID = this.getTeamIDForPlayerID(ID);
            if (teamID > -1) {
                List players = this.teamPlayers[teamID];
                for (int p = 0; p < players.size(); ++p) {
                    if (!("" + ID).equals(((StringTriple)players.get((int)p)).s1)) continue;
                    StringTriple playerData = (StringTriple)players.get(p);
                    players.remove(p);
                    return;
                }
            }
            return;
        }
        int teamID = 0;
        try {
            teamID = Integer.parseInt(teamIDstring);
        }
        catch (Exception e) {
            SS.debug("BAD team ID (" + teamIDstring + ") - must be an integer.");
            return;
        }
        this.ensureTeamArraysSize(teamID + 1);
        int alreadyOnTeamID = this.getTeamIDForPlayerID(ID);
        if (alreadyOnTeamID == -1) {
            if (this.teamPlayers[teamID] == null) {
                this.teamPlayers[teamID] = new ArrayList();
            }
            this.teamPlayers[teamID].add(new StringTriple("" + ID, name, GraphicsTool.stringFromColor(color)));
            return;
        }
        List players = this.teamPlayers[alreadyOnTeamID];
        for (int p = 0; p < players.size(); ++p) {
            if (!("" + ID).equals(((StringTriple)players.get((int)p)).s1)) continue;
            StringTriple playerData = (StringTriple)players.get(p);
            playerData.s2 = name;
            playerData.s3 = GraphicsTool.stringFromColor(color);
            if (alreadyOnTeamID != teamID) {
                this.teamPlayers[alreadyOnTeamID].remove(playerData);
                this.teamPlayers[teamID].add(playerData);
            }
            return;
        }
    }

    private void checkFileForMissingID() {
        String contents = StringTool.fileToString(DesktopTool.supportFolderPath() + "MiddleEastIId.luxb");
        for (int i = 0; i < 125; ++i) {
            if (contents.indexOf("<id>" + i + "</id>") != -1) continue;
            SS.debug("map editor missing ID: " + i);
        }
    }

    public void resizeMap(double percent) {
        int i;
        for (i = 0; i < this.shapes.size(); ++i) {
            ((CountryShape)this.shapes.get(i)).resize(percent);
        }
        for (i = 0; i < this.continents.size(); ++i) {
            ((Continent)this.continents.get(i)).resize(percent);
        }
        for (i = 0; i < this.lines.size(); ++i) {
            ((ExtraLine)this.lines.get(i)).resize(percent);
        }
        for (i = 0; i < this.aboveLines.size(); ++i) {
            ((ExtraLine)this.aboveLines.get(i)).resize(percent);
        }
        this.PI_x *= percent;
        this.PI_y *= percent;
        this.mapwidth = (int)Math.round((double)this.mapwidth * percent);
        this.mapheight = (int)Math.round((double)this.mapheight * percent);
        this.repaint();
        this.setPreferredSize(new Dimension(this.mapwidth, this.mapheight));
        this.window.pack();
    }

    public void copy() {
        this.copyShapeList = new ArrayList();
        for (int i = 0; i < this.activeShapeList.size(); ++i) {
            CountryShape cs = (CountryShape)this.activeShapeList.get(i);
            CountryShape copy = new CountryShape(cs);
            copy.setCode(-1);
            this.copyShapeList.add(copy);
        }
    }

    public void paste() {
        PasteShapeCommand com = new PasteShapeCommand(this.activeShapeList);
        this.doCommand(com);
    }

    public void cleanUpIDs() {
    }

    public int getNextCountryCode() {
        ++this.countryCodeCounter;
        return this.countryCodeCounter - 1;
    }

    public void createHexField(int radius) {
        if (this.shapes.size() > 0) {
            SSOptionPane.showMessageDialog(this.window, (Object)Translator.getEditorString("You can only create a hex field in a blank file."));
            return;
        }
        int col = 0;
        int x = radius;
        while (x < this.mapwidth) {
            int y = radius + col % 2 * (int)((double)radius * 0.9);
            while (y + radius / 2 < this.mapheight) {
                List newPoints = GraphicsTool.getEllipsePoints(x, y, radius, radius, 6);
                CountryShape tempShape = new CountryShape(-1, this);
                tempShape.setCountryBonus("1");
                tempShape.setPoints(newPoints);
                tempShape.close();
                this.addShapeInContinent(tempShape, this.getFirstContinent());
                y += (int)((double)radius * 1.8);
            }
            ++col;
            x = (int)((double)x + (double)radius * 1.6);
        }
        this.connectCloseShapes();
    }

    public void connectCloseShapes() {
        for (int j = 0; j < this.shapes.size(); ++j) {
            CountryShape from = (CountryShape)this.shapes.get(j);
            for (int k = 0; k < this.shapes.size(); ++k) {
                CountryShape to = (CountryShape)this.shapes.get(k);
                int extraTestSize = 25;
                Rectangle testRect = new Rectangle(from.getBounds().x - extraTestSize, from.getBounds().y - extraTestSize, from.getBounds().width + extraTestSize + extraTestSize, from.getBounds().height + extraTestSize + extraTestSize);
                Rectangle debugRect = to.getBounds();
                if (j == k || !testRect.intersects(to.getBounds())) continue;
                this.addAdjoining(to.getCode(), from.getCode());
                this.addAdjoining(from.getCode(), to.getCode());
            }
        }
        this.repaint();
    }

    public void nameShapes() {
        String[] preModifiers = new String[]{"New ", "Old ", "Upper ", "Lower ", "United ", "East ", "West ", "North ", "South ", "Free ", "Mount "};
        String[] starts = new String[]{"Afr", "Ark", "Aus", "Ava", "Bos", "Braz", "Can", "Cal", "Cauc", "Chech", "Chin", "Con", "Cthon", "Cyp", "Dan", "Djib", "Dus", "El", "Eng", "Fin", "Flon", "Fran", "Germ", "Green", "Hib", "Is", "Ital", "Jap", "Ken", "Khaz", "Kol", "Lat", "Lon", "Mex", "Mus", "Nun", "O", "Ore", "Per", "Pol", "Proc", "Q", "Qu\u00e9b", "Russ", "R\u00fct", "S\u00f8r", "Shamb", "Slov", "Span", "Spok", "Tex", "Thail", "Trans", "Uz", "Vir", "Viet", "Wow", "Xux", "Yin", "Zool"};
        String[] ends = new String[]{"a", "ya", "ia", "ica", "ada", "ane", "i", "ubi", "alia", "ico", "go", "u", "us", "y", "any", "aq", "an", "stan", "istan", "egon", "il", "land", "mark", "isis", "asis", "emnos", "\u00f8n", "\u00fck", "\u00e9", "ypt", "\u00e9c"};
        String[] postModifiers = new String[]{" Kingdom", " Duchy", " Proper", " Vale", " Valley", " Heights", " Minor", " Knell"};
        for (int j = 0; j < this.shapes.size(); ++j) {
            CountryShape from = (CountryShape)this.shapes.get(j);
            if (from.getName() != null && !"".equals(from.getName())) continue;
            String name = null;
            int format = SS.rand.nextInt(100);
            name = format < 30 ? preModifiers[SS.rand.nextInt(preModifiers.length)] + starts[SS.rand.nextInt(starts.length)] + ends[SS.rand.nextInt(ends.length)] : (format < 45 ? starts[SS.rand.nextInt(starts.length)] + ends[SS.rand.nextInt(ends.length)] + postModifiers[SS.rand.nextInt(postModifiers.length)] : starts[SS.rand.nextInt(starts.length)] + ends[SS.rand.nextInt(ends.length)]);
            from.setName(name);
        }
    }
}

