/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.MapEditor;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTriple;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSColorWell;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EditorPlayerInfoPanel {
    int showPlayers = 10;
    int showTeams = 8;
    private SSFrame window;
    private JTextArea desc;
    SSTextField[] playerName;
    SSTextField[] playerTeam;
    SSTextField[] teamName;
    SSComboBox[] teamSymbol;
    SSColorWell[] playerColor;

    public static JPanel getJPanelAround(String text) {
        JPanel jpanel = new JPanel(new FlowLayout(0));
        jpanel.add(new JLabel(text, 2));
        return jpanel;
    }

    public static JPanel getJPanelAroundTextField() {
        JPanel jpanel = new JPanel();
        jpanel.add(new SSTextField(7));
        return jpanel;
    }

    public static JPanel getJPanelAroundTextField(String startingText) {
        JPanel jpanel = new JPanel();
        jpanel.add(new SSTextField(startingText, 7));
        return jpanel;
    }

    public static JPanel getJPanelAround(Component c) {
        JPanel jpanel = new JPanel();
        jpanel.add(c);
        return jpanel;
    }

    public EditorPlayerInfoPanel(final MapEditor editor, SSApplicationGUI luxconBridge) {
        this.showPlayers = Math.max(this.showPlayers, editor.getNumberOfPlayers() + 1);
        this.showTeams = Math.max(this.showTeams, editor.getNumberOfTeams() + 1);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel playerPanel = new JPanel(new FlowLayout(0, 5, 0));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("ID"));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("Name              "));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("Color   "));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("TeamID        "));
        topPanel.add(playerPanel);
        this.playerName = new SSTextField[this.showPlayers];
        this.playerTeam = new SSTextField[this.showPlayers];
        this.playerColor = new SSColorWell[this.showPlayers];
        playerPanel = new JPanel(new FlowLayout(0));
        StringTriple playerData = editor.getPlayer(0);
        if (playerData == null || playerData.s1 == null) {
            playerData = new StringTriple("", "", "0.2/0.2/0.2");
        }
        this.playerName[0] = new SSTextField(playerData.s2, 8);
        this.playerColor[0] = new SSColorWell(GraphicsTool.colorFromString(playerData.s3), luxconBridge);
        int teamID = editor.getTeamIDForPlayerID(0);
        this.playerTeam[0] = new SSTextField(teamID > -1 ? teamID + "" : "", 2);
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("0"));
        playerPanel.add(new JLabel("   non-playable    "));
        playerPanel.add(this.playerColor[0]);
        playerPanel.add(new JLabel("  0"));
        topPanel.add(playerPanel);
        for (int i = 1; i < this.showPlayers; ++i) {
            playerPanel = new JPanel(new FlowLayout(0));
            playerData = editor.getPlayer(i);
            if (playerData == null || playerData.s1 == null) {
                playerData = new StringTriple("", "", GraphicsTool.stringFromColor(GraphicsTool.getNextColor()));
            }
            this.playerName[i] = new SSTextField(playerData.s2, 8);
            this.playerColor[i] = new SSColorWell(GraphicsTool.colorFromString(playerData.s3), luxconBridge);
            teamID = editor.getTeamIDForPlayerID(i);
            this.playerTeam[i] = new SSTextField(teamID > -1 ? teamID + "" : "", 2);
            playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("" + i));
            playerPanel.add(this.playerName[i]);
            playerPanel.add(this.playerColor[i]);
            playerPanel.add(this.playerTeam[i]);
            topPanel.add(playerPanel);
        }
        contentPanel.add((Component)topPanel, "West");
        JPanel teamsPanel = new JPanel();
        teamsPanel.setLayout(new BoxLayout(teamsPanel, 1));
        playerPanel = new JPanel(new FlowLayout(0));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("Teams"));
        teamsPanel.add(playerPanel);
        playerPanel = new JPanel(new FlowLayout(0));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("ID"));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("Team Name                "));
        playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("Symbol"));
        teamsPanel.add(playerPanel);
        this.teamName = new SSTextField[this.showTeams];
        this.teamSymbol = new SSComboBox[this.showTeams];
        Object[] symbols = new String[]{"\u2022", "\u221e", "\u00a7", "\u25d9", "\u2605", "\u262f", "\u2638", "\u263c", "\u263f", "\u2641", "\u265b", "\u265d", "\u265f", "\u2656", "\u265e", "\u265a", "\u2652", "\u2660", "\u2666", "\u2665", "\u2663", "\u2670", "\u2600", "\u2609", "\u2720", "\u0298", "\ufb3e", "\u2730", "\u00a5", "\u00a4", "\u00a3", "\u00a2", "$", "\u00bb", "\u019f", "\u02d0", "\u02e0", "\u03a8", "\u03df", "\u03eb", "\u0424", "\u05e9", "\u05d2", "\u203b", "\u2021", "\u2042", "\u21cc", "\u2318", "\u2615", "\u2622", "\u2623", "\u2624", "\u2625", "\u262a", "\u262d", "\u2646", "\u2668", "\u266b", "\u266a", "\u266e", "\u2690", "\u26a1", "\u2694", "\u2693", "\u269c", "\u2696", "\u2603", "\u2601", "\u271e", "\u271f", "\u2721", "\u2620", "\u262c", "\u2735", "\u3036", "\u2122", "\u00b6", "\u0153", "\u00ae", "\u2020", "\u2211", "\u00df", "\u2206", "\u02da", "\u00a9", "\u0192", "\u2202", "\u221a", "\u00b5", "+", "@", "\u03c0", "\u229a", "\u0277", "\u21ad"};
        for (int i = 0; i < this.showTeams; ++i) {
            playerPanel = new JPanel(new FlowLayout(0));
            playerPanel.add(EditorPlayerInfoPanel.getJPanelAround("" + i));
            this.teamName[i] = new SSTextField(editor.getTeamName(i), 18);
            if (i == 0) {
                playerPanel.add(new JLabel("   non-playable                "));
            } else {
                playerPanel.add(this.teamName[i]);
            }
            this.teamSymbol[i] = new SSComboBox(symbols);
            this.teamSymbol[i].setSelectedItem(editor.getTeamSymbol(i));
            if (SS.isWindows) {
                this.teamSymbol[i].setFont(GraphicsTool.getSymbolFont());
            }
            playerPanel.add(this.teamSymbol[i]);
            teamsPanel.add(playerPanel);
        }
        teamsPanel.add(new JLabel("    "));
        teamsPanel.add(new JLabel("    "));
        teamsPanel.add(new JLabel("    "));
        teamsPanel.add(new JLabel("    "));
        contentPanel.add((Component)teamsPanel, "East");
        contentPanel.add((Component)new JLabel("       "), "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.add(new JLabel("Use as many players as you want, leave the rest blank."));
        bottomPanel.add(new JLabel("To get more players, you can edit the map XML manually."));
        bottomPanel.add(new JLabel("    "));
        SSButton cancelButton = new SSButton(Translator.getString("Cancel"));
        cancelButton.setPreferredWidth(100);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPlayerInfoPanel.this.window.hide();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(EditorPlayerInfoPanel.getJPanelAround(cancelButton));
        SSButton saveButton = new SSButton(Translator.getString("Save"));
        saveButton.setPreferredWidth(100);
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorPlayerInfoPanel.this.save(editor);
            }
        });
        buttonPanel.add(EditorPlayerInfoPanel.getJPanelAround(saveButton));
        bottomPanel.add(buttonPanel);
        contentPanel.add((Component)bottomPanel, "South");
        this.window = new SSFrame("Set Player Info");
        this.window.setLocationID("editorPlayerInfo");
        this.window.setContentPane(contentPanel);
        this.window.setDefaultCloseOperation(2);
        if (SS.isMacintosh) {
            this.window.setJMenuBar(luxconBridge.makeCommonMenuBar(this.window));
        }
        this.window.pack();
        this.window.show();
        this.window.getRootPane().setDefaultButton(saveButton);
    }

    private void save(MapEditor editor) {
        int i;
        editor.changedSinceSave = true;
        for (i = 0; i < this.showTeams; ++i) {
            editor.setTeam(i, this.teamName[i].getText(), this.teamSymbol[i].getSelectedString());
        }
        for (i = 0; i < this.showPlayers; ++i) {
            editor.setPlayer(i, this.playerName[i].getText(), this.playerColor[i].getColor(), this.playerTeam[i].getText());
        }
        this.window.hide();
        editor.repaint();
    }
}

