/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.MapEditor;
import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.StringTriple;
import com.sillysoft.tools.XMLTool;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class EditorLoadBoard {
    private String contents;
    private int mark = 0;

    public EditorLoadBoard(MapEditor editor, String path) throws Exception {
        this.createFromPath(path);
        this.load(editor);
    }

    private void createFromPath(String path) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
        this.createFromReader(in);
    }

    private void createFromReader(BufferedReader in) throws Exception {
        StringBuffer inputBuffer = new StringBuffer();
        String temp = in.readLine();
        inputBuffer.append(temp);
        inputBuffer.append("\n");
        if ("luxboard-1.0".equals(temp)) {
            throw new Exception("The board file is malformed");
        }
        while ((temp = in.readLine()) != null) {
            inputBuffer.append(temp);
            inputBuffer.append("\n");
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.contents = inputBuffer.toString();
    }

    void load(MapEditor editor) throws Exception {
        String temp;
        boolean usedZeroPlayerID = false;
        boolean usedZeroCountryOwnerID = false;
        editor.setBoardName(StringTool.xmlSafeReverse(XMLTool.extract("title", this.contents)));
        int height = 0;
        try {
            height = Integer.parseInt(XMLTool.extract("height", this.contents));
            editor.setBoardSize(Integer.parseInt(XMLTool.extract("width", this.contents)), height);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error in <width> or <height>: " + e.getMessage());
        }
        editor.setTheme(XMLTool.extract("theme", this.contents));
        editor.setArmySet(XMLTool.extract("armySet", this.contents));
        editor.setAuthor(XMLTool.extract("author", this.contents));
        editor.setDescription(XMLTool.extract("description", this.contents));
        editor.setWebpage(XMLTool.extract("webpage", this.contents));
        editor.setVersion(XMLTool.extract("version", this.contents));
        editor.setEmail(XMLTool.extract("email", this.contents));
        editor.setEmptyPlayer(XMLTool.extract("emptyPlayerID", this.contents));
        int c = 0;
        while ((temp = XMLTool.extractFull("team", this.contents, c)) != null) {
            String player;
            ArrayList<StringTriple> playerList = new ArrayList<StringTriple>();
            int p = 0;
            while ((player = XMLTool.extractContained("player", temp, p)) != null) {
                String playerID = XMLTool.extractAttribute("id", player);
                if ("0".equals(playerID)) {
                    usedZeroPlayerID = true;
                }
                StringTriple playerData = new StringTriple(playerID, StringTool.xmlSafeReverse(XMLTool.extractAttribute("name", player)), XMLTool.extractAttribute("color", player));
                playerData.s4 = XMLTool.extractAttribute("agent", player);
                playerData.s5 = XMLTool.extractAttribute("money", player);
                playerList.add(playerData);
                ++p;
            }
            editor.addTeam(c, StringTool.xmlSafeReverse(XMLTool.extractAttribute("name", temp)), XMLTool.extractAttribute("symbol", temp), playerList);
            ++c;
        }
        editor.setExtraInfo(XMLTool.extract("extraInfo", this.contents));
        editor.setShortContinentLabels("true".equals(XMLTool.extract("shortContinentLabels", this.contents)));
        editor.setPlayerInfoLocation(XMLTool.extract("playerInfoLocation", this.contents));
        int numCountries = XMLTool.count("country", this.contents);
        int[] contCodes = new int[numCountries];
        for (int i = 0; i < numCountries; ++i) {
            contCodes[i] = -1;
        }
        int maxCont = XMLTool.count("continent", this.contents);
        int cont = 0;
        while ((temp = XMLTool.extract("continent", this.contents, cont)) != null) {
            String country;
            String continentName = StringTool.xmlSafeReverse(XMLTool.extract("continentname", temp));
            int bonus = 0;
            String colorString = null;
            String labelLocation = null;
            try {
                bonus = Integer.parseInt(XMLTool.extract("bonus", temp));
            }
            catch (Exception e) {
                throw new Exception("Error in the <bonus> tag for continent '" + continentName + "': " + e.getMessage());
            }
            try {
                colorString = XMLTool.extract("color", temp);
            }
            catch (Exception e) {
                throw new Exception("Error in the <color> tag for continent '" + continentName + "': " + e.getMessage());
            }
            try {
                labelLocation = GraphicsTool.flipPointStringY(XMLTool.extract("labellocation", temp), height);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("Error in the <labellocation> tag in continent '" + continentName + "': " + e.getMessage());
            }
            int contID = editor.createContinent(continentName, bonus, colorString, labelLocation);
            int c2 = 0;
            while ((country = XMLTool.extract("country", temp, c2)) != null) {
                String countryName = StringTool.xmlSafeReverse(XMLTool.extract("name", country));
                try {
                    String unit;
                    StringTokenizer tok;
                    String poly;
                    int code = Integer.parseInt(XMLTool.extract("id", country));
                    if (code >= contCodes.length) {
                        throw new Exception("You are using an <id> that is too high (" + code + "). Note that the <id>s must start at 0, not 1.");
                    }
                    if (contCodes[code] != -1) {
                        throw new Exception("Duplicate <id>: " + code);
                    }
                    contCodes[code] = cont;
                    GeneralPath shape = new GeneralPath();
                    Vector<Point> points = new Vector<Point>();
                    int s = 0;
                    while ((poly = XMLTool.extract("polygon", country, s)) != null) {
                        tok = new StringTokenizer(poly, " ,");
                        int firstX = Integer.parseInt(tok.nextToken());
                        int firstY = height - Integer.parseInt(tok.nextToken());
                        points.add(new Point(firstX, firstY));
                        shape.moveTo(firstX, firstY);
                        while (tok.hasMoreTokens()) {
                            int x = Integer.parseInt(tok.nextToken());
                            int y = height - Integer.parseInt(tok.nextToken());
                            points.add(new Point(x, y));
                            shape.lineTo(x, y);
                        }
                        shape.closePath();
                        ++s;
                    }
                    String initialOwner = XMLTool.extract("initialOwner", country);
                    if ("0".equals(initialOwner)) {
                        usedZeroCountryOwnerID = true;
                    }
                    editor.addCountryToContinent(code, countryName, shape, points, GraphicsTool.flipPointStringY(XMLTool.extract("armylocation", country), height), initialOwner, XMLTool.extract("initialArmies", country), contID, XMLTool.extract("water", country), XMLTool.extract("income", country), XMLTool.extract("voxPoints", country));
                    tok = new StringTokenizer(XMLTool.extract("adjoining", country), ",");
                    while (tok.hasMoreTokens()) {
                        editor.addAdjoining(code, Integer.parseInt(tok.nextToken()));
                    }
                    int s2 = 0;
                    while ((unit = XMLTool.extractContained("unit", country, s2)) != null) {
                        SS.debug(unit);
                        editor.addUnits(code, XMLTool.extractAttribute("number", unit), XMLTool.extractAttribute("type", unit), XMLTool.extractAttribute("owner", unit));
                        ++s2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("Error in country '" + countryName + "': " + e.getMessage());
                }
                ++c2;
            }
            ++cont;
        }
        try {
            int h = 0;
            while ((temp = XMLTool.extract("line", this.contents, h)) != null) {
                String tempPosition = XMLTool.extract("position", temp);
                if (!tempPosition.trim().equals("")) {
                    editor.addLine(new ExtraLine(temp), true);
                } else {
                    SS.debug("There is a <line> with an empty <position>");
                }
                ++h;
            }
        }
        catch (Exception e) {
            throw new Exception("Error in <line>: " + e.getMessage());
        }
        if (!usedZeroPlayerID || editor.voxEnabled) {
            // empty if block
        }
    }

    private String readLine() {
        int nextMark = this.contents.indexOf(10, this.mark);
        if (nextMark == -1) {
            this.mark = 0;
            return null;
        }
        String foo = this.contents.substring(this.mark, nextMark);
        this.mark = nextMark + 1;
        return foo;
    }
}

