/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.MapEditor;
import com.sillysoft.lux.gui.PluginLocalMemory;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EditorInfoPanel {
    private SSFrame window;
    private SSTextField titleField;
    private SSTextField versionField;
    private SSTextField widthField;
    private SSTextField heightField;
    private SSComboBox themeCombo;
    private SSComboBox armyCombo;
    private SSTextField authorField;
    private SSTextField emailField;
    private SSTextField webpageField;
    private SSTextField emptyPlayerField;
    private JTextArea desc;

    public static JPanel getJPanelAround(String text) {
        JPanel jpanel = new JPanel(new FlowLayout(0));
        jpanel.add(new JLabel(text, 2));
        return jpanel;
    }

    public static JPanel getJPanelAroundTextField() {
        JPanel jpanel = new JPanel();
        jpanel.add(new SSTextField(7));
        return jpanel;
    }

    public static JPanel getJPanelAroundTextField(String startingText) {
        JPanel jpanel = new JPanel();
        jpanel.add(new SSTextField(startingText, 7));
        return jpanel;
    }

    public static JPanel getJPanelAround(Component c) {
        JPanel jpanel = new JPanel();
        jpanel.add(c);
        return jpanel;
    }

    public EditorInfoPanel(final MapEditor editor, SSApplicationGUI luxconBridge) {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getString("Title:")), "West");
        this.titleField = new SSTextField(editor.getTitle(), 20);
        panel.add((Component)EditorInfoPanel.getJPanelAround(this.titleField), "Center");
        contentPanel.add(panel);
        JPanel topPanel = new JPanel(new GridLayout(2, 4));
        topPanel.add(EditorInfoPanel.getJPanelAround(Translator.getString("Version:")));
        this.versionField = new SSTextField(editor.getVersion(), 7);
        topPanel.add(EditorInfoPanel.getJPanelAround(this.versionField));
        topPanel.add(new JLabel(" "));
        topPanel.add(new JLabel(" "));
        topPanel.add(EditorInfoPanel.getJPanelAround(Translator.getString("Width:")));
        this.widthField = new SSTextField(editor.getBoardWidth(), 7);
        topPanel.add(EditorInfoPanel.getJPanelAround(this.widthField));
        topPanel.add(EditorInfoPanel.getJPanelAround(Translator.getString("Height:")));
        this.heightField = new SSTextField(editor.getBoardHeight(), 7);
        topPanel.add(EditorInfoPanel.getJPanelAround(this.heightField));
        contentPanel.add(topPanel);
        Object[] themes = PluginLocalMemory.getLocalThemeList(false);
        this.themeCombo = new SSComboBox(themes);
        this.themeCombo.insertItemAt("Black", 0);
        this.themeCombo.setMaximumRowCount(30);
        String theTheme = editor.getTheme();
        if (theTheme == null) {
            theTheme = editor.voxEnabled ? "Black" : "Ocean";
        }
        this.themeCombo.setSelectedItem(theTheme);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getString("Theme") + ":   "), "West");
        panel.add((Component)EditorInfoPanel.getJPanelAround(this.themeCombo), "Center");
        contentPanel.add(panel);
        if (!editor.voxEnabled) {
            this.armyCombo = new SSComboBox();
            this.armyCombo.insertItemAt("Ancient", 0);
            this.armyCombo.insertItemAt("Ancient-Oriental", 1);
            this.armyCombo.insertItemAt("Medieval", 2);
            this.armyCombo.insertItemAt("Colonial", 3);
            this.armyCombo.insertItemAt("Pre-Modern", 4);
            this.armyCombo.insertItemAt("Modern", 5);
            this.armyCombo.insertItemAt("Future Mech", 6);
            this.armyCombo.insertItemAt("Space Ships", 7);
            this.armyCombo.insertItemAt("None", 8);
            String theSet = editor.getArmySet();
            if (theSet == null || theSet.equals("Normal")) {
                this.armyCombo.setSelectedIndex(5);
            } else {
                this.armyCombo.setSelectedItem(theSet);
            }
            panel = new JPanel(new BorderLayout());
            panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getEditorString("ArmySet") + ":   "), "West");
            panel.add((Component)EditorInfoPanel.getJPanelAround(this.armyCombo), "Center");
            contentPanel.add(panel);
        }
        panel = new JPanel(new BorderLayout());
        panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getString("Author") + ":   "), "West");
        this.authorField = new SSTextField(editor.getAuthor(), 20);
        panel.add((Component)EditorInfoPanel.getJPanelAround(this.authorField), "Center");
        contentPanel.add(panel);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getString("Email") + ":     "), "West");
        this.emailField = new SSTextField(editor.getEmail(), 20);
        panel.add((Component)EditorInfoPanel.getJPanelAround(this.emailField), "Center");
        contentPanel.add(panel);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getString("Webpage:")), "West");
        this.webpageField = new SSTextField(editor.getWebpage(), 20);
        panel.add((Component)EditorInfoPanel.getJPanelAround(this.webpageField), "Center");
        contentPanel.add(panel);
        contentPanel.add(EditorInfoPanel.getJPanelAround(Translator.getString("Description:")));
        this.desc = new JTextArea(editor.getDescription(), 8, 35);
        this.desc.setLineWrap(true);
        this.desc.setWrapStyleWord(true);
        contentPanel.add(new JScrollPane(this.desc));
        if (!editor.voxEnabled) {
            panel = new JPanel(new BorderLayout());
            panel.add((Component)EditorInfoPanel.getJPanelAround(Translator.getEditorString("emptyPlayerField")), "West");
            this.emptyPlayerField = new SSTextField(editor.getEmptyPlayer(), 4);
            panel.add((Component)EditorInfoPanel.getJPanelAround(this.emptyPlayerField), "Center");
            contentPanel.add(panel);
        }
        SSButton cancelButton = new SSButton(Translator.getString("Cancel"));
        cancelButton.setPreferredWidth(100);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorInfoPanel.this.window.hide();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(EditorInfoPanel.getJPanelAround(cancelButton));
        SSButton saveButton = new SSButton(Translator.getString("Save"));
        saveButton.setPreferredWidth(100);
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorInfoPanel.this.save(editor);
            }
        });
        buttonPanel.add(EditorInfoPanel.getJPanelAround(saveButton));
        contentPanel.add(buttonPanel);
        this.window = new SSFrame(Translator.getEditorString("SetMapInfo"));
        this.window.setLocationID("editorSave");
        this.window.setContentPane(contentPanel);
        this.window.setDefaultCloseOperation(2);
        if (SS.isMacintosh) {
            this.window.setJMenuBar(luxconBridge.makeCommonMenuBar(this.window));
        }
        this.window.pack();
        this.window.show();
        this.window.getRootPane().setDefaultButton(saveButton);
    }

    private void save(MapEditor editor) {
        editor.changedSinceSave = true;
        editor.setBoardName(this.titleField.getText());
        editor.setVersion(this.versionField.getText());
        editor.setTheme(this.themeCombo.getSelectedString());
        editor.setAuthor(this.authorField.getText());
        editor.setEmail(this.emailField.getText());
        editor.setWebpage(this.webpageField.getText());
        editor.setDescription(this.desc.getText());
        if (!editor.voxEnabled) {
            editor.setArmySet(this.armyCombo.getSelectedString());
            editor.setEmptyPlayer(this.emptyPlayerField.getText());
        }
        try {
            editor.setBoardSize(Integer.parseInt(this.widthField.getText()), Integer.parseInt(this.heightField.getText()));
        }
        catch (Exception e) {
            SSOptionPane.showMessageDialog(this.window, (Object)Translator.getEditorString("The width and height must be integers."));
            return;
        }
        this.window.hide();
    }
}

