/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.MapEditor;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.StringTool;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitPack;
import com.sillysoft.vox.UnitStack;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CountryShape {
    private GeneralPath path;
    private List points;
    private boolean atLeastTwoPoints = false;
    private boolean closed = false;
    protected Point armyBoxPoint;
    private int countryCode;
    private String name;
    private int initialOwner;
    private int initialArmies;
    private List adjoiningList = new Vector();
    private MapEditor mapEditor;
    protected List voxPoints;
    private int MATCHING_DISTANCE = 4;
    private boolean water = false;
    private int countryBonus = 0;
    private List units = new Vector();

    public CountryShape(int code, String countryName, GeneralPath shape, List points, String armylocation, String initialOwnerString, String initialArmiesString, MapEditor mapEditor, String water, String income) {
        this.countryCode = code;
        this.name = countryName;
        this.path = shape;
        this.points = points;
        this.mapEditor = mapEditor;
        this.closed = true;
        this.water = water != null && water.equals("true");
        this.setCountryBonus(income);
        this.armyBoxPoint = GraphicsTool.pointFromString(armylocation);
        this.setInitialOwner(initialOwnerString);
        this.setInitialArmies(initialArmiesString);
    }

    public CountryShape(CountryShape copy) {
        this.countryCode = copy.countryCode;
        this.name = copy.name;
        this.path = copy.path;
        this.points = copy.points;
        this.refreshGeneralPath();
        this.refreshPoints();
        this.close();
        this.mapEditor = copy.mapEditor;
        this.closed = true;
        this.water = copy.water;
        this.countryBonus = copy.countryBonus;
        this.armyBoxPoint = GraphicsTool.pointFromString(GraphicsTool.stringFromPoint(copy.armyBoxPoint));
        this.initialOwner = copy.initialOwner;
        this.initialArmies = copy.initialArmies;
    }

    public CountryShape(int code, MapEditor mapEditor) {
        this.countryCode = code;
        this.path = new GeneralPath();
        this.points = new Vector();
        this.initialOwner = -1;
        this.initialArmies = 1;
        this.mapEditor = mapEditor;
    }

    public int getCode() {
        return this.countryCode;
    }

    public void setCode(int newCode) {
        this.countryCode = newCode;
    }

    public List getAdjoiningList() {
        return this.adjoiningList;
    }

    public void addAdjoining(int toCode) {
        if (!this.adjoiningList.contains(new Integer(toCode)) && toCode != this.countryCode) {
            this.adjoiningList.add(new Integer(toCode));
        }
    }

    public void removeAdjoining() {
        this.adjoiningList = new Vector();
    }

    public void removeAdjoining(int toCode) {
        this.adjoiningList.remove(new Integer(toCode));
    }

    public boolean adjoins(CountryShape other) {
        Integer code = new Integer(other.countryCode);
        return this.adjoiningList.contains(code);
    }

    public boolean adjoins(int otherCode) {
        Integer code = new Integer(otherCode);
        return this.adjoiningList.contains(code);
    }

    public void addPoint(Point p) {
        if (this.points.size() == 0) {
            this.path.moveTo(p.x, p.y);
        } else {
            this.path.lineTo(p.x, p.y);
        }
        this.points.add(p);
    }

    public void addPointAtClosestSpot(Point p) {
        int minDistance = 100000000;
        int minSegment = -1;
        for (int i = 0; i < this.points.size(); ++i) {
            Line2D.Double line = i == this.points.size() - 1 ? new Line2D.Double((Point)this.points.get(i), (Point)this.points.get(0)) : new Line2D.Double((Point)this.points.get(i), (Point)this.points.get(i + 1));
            int distance = (int)Math.abs(line.ptLineDist(p));
            if (distance >= minDistance) continue;
            minDistance = distance;
            minSegment = i;
        }
        if (minSegment != -1) {
            this.points.add(minSegment + 1, p);
            this.refreshGeneralPath();
        }
    }

    public void setPoints(List newPoints) {
        this.points = newPoints;
        this.refreshGeneralPath();
    }

    public void removePoint(Point p) {
        this.points.remove(p);
        this.refreshGeneralPath();
    }

    public void close() {
        this.closed = true;
        this.path.closePath();
    }

    public void undoClose() {
        this.closed = false;
        this.refreshGeneralPath();
    }

    public void drawVoxCountryBonus(Graphics2D g) {
        if (this.countryBonus != 0) {
            this.ensureArmyBoxPointExists();
            g.setFont(GraphicsTool.getSymbolFontForBonus(g, this.countryBonus));
            GraphicsTool.drawBoxedString(g, this.countryBonus + " \u2605", this.armyBoxPoint.x, this.armyBoxPoint.y, 4, 2, GraphicsTool.transparent(Color.WHITE, 0.4f), Color.BLACK, 2, Color.BLACK);
        }
    }

    public void drawWithArmyBox(Graphics2D g) {
        this.draw(g);
        this.ensureArmyBoxPointExists();
        GraphicsTool.drawBoxedString(g, "10", this.armyBoxPoint.x, this.armyBoxPoint.y, 2, 1, Color.WHITE, Color.DARK_GRAY, 1, Color.BLACK);
    }

    public void drawWithVoxPoints(Graphics2D g, String theme) {
        g.setColor(Color.BLACK);
        this.draw(g);
        this.ensureVoxPointsExists();
        for (int i = 0; i < this.voxPoints.size(); ++i) {
            Point p = (Point)this.voxPoints.get(i);
            String type = "castle";
            Color color = GraphicsTool.transparent(Color.WHITE, 0.8f);
            if (i == 1) {
                color = Color.BLACK;
                type = "knight";
            } else if (i == 2) {
                color = Color.BLACK;
                type = "pawn";
            }
            UnitStack us = new UnitStack(UnitPack.createUnitSafe(type, new Player("map_editor", Team.WATER, color)), this.countryCode);
            us.setDrawPoint(p);
            us.draw(g, theme);
        }
    }

    protected void ensureVoxPointsExists() {
        if (this.voxPoints == null) {
            this.voxPoints = new ArrayList();
            Point center = GraphicsTool.getCenterOfShape(this.path);
            this.voxPoints.add(new Point(center.x - 20, center.y - 50));
            this.voxPoints.add(new Point(center.x, center.y - 20));
            this.voxPoints.add(new Point(center.x - 40, center.y - 20));
        }
    }

    protected void ensureVoxPointsExistsSmallHexes() {
        if (this.voxPoints == null) {
            this.voxPoints = new ArrayList();
            Point center = GraphicsTool.getCenterOfShape(this.path);
            this.voxPoints.add(new Point(center.x - 23, center.y - 44));
            this.voxPoints.add(new Point(center.x - 10, center.y - 30));
            this.voxPoints.add(new Point(center.x - 35, center.y - 30));
        }
    }

    protected void ensureVoxPointsExistsBigHexes() {
        if (this.voxPoints == null) {
            this.voxPoints = new ArrayList();
            Point center = GraphicsTool.getCenterOfShape(this.path);
            this.voxPoints.add(new Point(center.x - 20, center.y - 50));
            this.voxPoints.add(new Point(center.x + 5, center.y - 15));
            this.voxPoints.add(new Point(center.x - 45, center.y - 15));
        }
    }

    public void fillWithArmyBox(Graphics2D g) {
        g.fill(this.path);
        this.ensureArmyBoxPointExists();
        if (this.initialArmies > 1) {
            GraphicsTool.drawBoxedString(g, String.valueOf(this.initialArmies - 1), this.armyBoxPoint.x, this.armyBoxPoint.y, 2, 1, Color.WHITE, Color.DARK_GRAY, 1, Color.BLACK);
        }
    }

    public void fillWithUnits(Graphics2D g, String theme) {
        g.fill(this.path);
        this.ensureArmyBoxPointExists();
        this.drawUnits(g, theme);
    }

    public void drawWithUnits(Graphics2D g, String theme) {
        if (this.points.size() == 1) {
            CountryShape.drawPoint(g, this.firstPoint());
            return;
        }
        g.draw(this.path);
        this.drawUnits(g, theme);
    }

    public void drawUnits(Graphics2D g, String theme) {
        this.ensureVoxPointsExists();
        for (int i = this.units.size() - 1; i > -1; --i) {
            UnitStackString ugs = (UnitStackString)this.units.get(i);
            Unit unit = UnitPack.createUnitSafe(ugs.type, new Player("editor", Team.WATER, this.mapEditor.getColorForOwnerID(ugs.ownerID)));
            if (unit == null) continue;
            UnitStack us = new UnitStack(unit, ugs.count);
            us.setDrawPoint((Point)this.voxPoints.get(unit.getType()));
            us.draw(g, theme);
            if ("castle".equalsIgnoreCase(ugs.type)) continue;
            us.drawBubbleNumber(g);
        }
    }

    public void drawCastles(Graphics2D g, String theme) {
        this.ensureVoxPointsExists();
        for (int i = 0; i < this.units.size(); ++i) {
            Unit unit;
            UnitStackString ugs = (UnitStackString)this.units.get(i);
            if (!"castle".equalsIgnoreCase(ugs.type) || (unit = UnitPack.createUnitSafe(ugs.type, new Player("editor", Team.WATER, this.mapEditor.getColorForOwnerID(ugs.ownerID)))) == null) continue;
            UnitStack us = new UnitStack(unit, ugs.count);
            us.setDrawPoint((Point)this.voxPoints.get(unit.getType()));
            us.draw(g, theme);
        }
    }

    public void draw(Graphics2D g) {
        if (this.points.size() == 1) {
            CountryShape.drawPoint(g, this.firstPoint());
            return;
        }
        g.draw(this.path);
    }

    public void drawColored(Graphics2D g, Color contColor) {
        g.setColor(contColor);
        this.draw(g);
        g.fill(this.path);
    }

    public void drawPoints(Graphics2D g) {
        for (int i = 0; i < this.points.size(); ++i) {
            CountryShape.drawPoint(g, (Point)this.points.get(i));
        }
    }

    public void drawConnections(Graphics2D g) {
        Point center = this.getCenterPoint();
        for (int i = 0; i < this.adjoiningList.size(); ++i) {
            int adjoinCode = (Integer)this.adjoiningList.get(i);
            Point adjoinCenter = this.mapEditor.getCenterOfShape(adjoinCode);
            g.drawLine(adjoinCenter.x, adjoinCenter.y, center.x, center.y);
            GraphicsTool.drawArrow(g, center.x, center.y, adjoinCenter.x, adjoinCenter.y, 1.0f, 1.0f);
        }
    }

    public Point getCenterPoint() {
        return GraphicsTool.getCenterOfShape(this.path);
    }

    private Point firstPoint() {
        if (this.points.size() == 0) {
            return null;
        }
        return (Point)this.points.get(0);
    }

    public Point lastPoint() {
        if (this.points.size() == 0) {
            return null;
        }
        return (Point)this.points.get(this.points.size() - 1);
    }

    public int pointCount() {
        return this.points.size();
    }

    public int getPointAt(Point p) {
        for (int i = 0; i < this.points.size(); ++i) {
            if (!(p.distance((Point)this.points.get(i)) < (double)this.MATCHING_DISTANCE)) continue;
            return i;
        }
        return -1;
    }

    public void movePointTo(int pointIndex, Point p) {
        Point old = (Point)this.points.get(pointIndex);
        old.setLocation(p);
        this.refreshGeneralPath();
    }

    public void moveShape(int dx, int dy) {
        AffineTransform translate = AffineTransform.getTranslateInstance(dx, dy);
        this.path.transform(translate);
        this.refreshPoints();
        this.moveArmyBoxLocation(dx, dy);
        this.moveVoxPoints(dx, dy);
    }

    private void refreshGeneralPath() {
        GeneralPath newPath = new GeneralPath();
        Point first = this.firstPoint();
        if (first != null) {
            newPath.moveTo(this.firstPoint().x, this.firstPoint().y);
            for (int i = 1; i < this.points.size(); ++i) {
                Point p = (Point)this.points.get(i);
                newPath.lineTo(p.x, p.y);
            }
            if (this.closed) {
                newPath.closePath();
            }
        }
        this.path = newPath;
    }

    private void refreshPoints() {
        PathIterator it = this.path.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        Vector<Point> newPoints = new Vector<Point>();
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                newPoints.add(new Point((int)point[0], (int)point[1]));
            } else if (segType == 0) {
                newPoints.add(new Point((int)point[0], (int)point[1]));
            } else if (segType != 4) {
                System.out.println("refreshPoints() unknown segType: " + segType);
            }
            it.next();
        }
        this.points = newPoints;
    }

    public GeneralPath getGeneralPath() {
        return this.path;
    }

    public static void drawLinesFromPoints(Graphics2D g, List points) {
        Point start = null;
        Point end = null;
        for (int i = 0; i < points.size(); ++i) {
            if (start == null) {
                start = (Point)points.get(i);
                continue;
            }
            if (end != null) {
                start = end;
            }
            end = (Point)points.get(i);
            g.drawLine(start.x, start.y, end.x, end.y);
        }
    }

    public static void drawPoint(Graphics2D g, Point p) {
        g.fillRect(p.x - 1, p.y - 1, 2, 2);
    }

    public void moveVoxPoints(int x, int y) {
        if (this.voxPoints == null) {
            return;
        }
        for (int i = 0; i < this.voxPoints.size(); ++i) {
            Point vp = (Point)this.voxPoints.get(i);
            vp.setLocation(new Point(vp.x + x, vp.y + y));
        }
    }

    public void moveArmyBoxLocation(int x, int y) {
        if (this.armyBoxPoint != null) {
            this.armyBoxPoint.setLocation(new Point(this.armyBoxPoint.x + x, this.armyBoxPoint.y + y));
        }
    }

    public boolean contains(Point p) {
        return this.path.contains(p);
    }

    public boolean intersects(Rectangle r) {
        return this.path.intersects(r);
    }

    public boolean armyBoxContains(Point p) {
        this.ensureArmyBoxPointExists();
        return Math.abs(p.x - this.armyBoxPoint.x) < 10 && Math.abs(p.y - this.armyBoxPoint.y) < 10;
    }

    public int voxPointAt(Point p) {
        this.ensureVoxPointsExists();
        for (int i = 0; i < this.voxPoints.size(); ++i) {
            Point vp = (Point)this.voxPoints.get(i);
            if (p.x <= vp.x || p.x >= vp.x + 40 || p.y <= vp.y || p.y >= vp.y + 40) continue;
            return i;
        }
        return -1;
    }

    public void addVoxPoint(String x, String y) {
        try {
            this.addVoxPoint(Integer.parseInt(x), Integer.parseInt(y));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addVoxPoint(int x, int y) {
        if (this.voxPoints == null) {
            this.voxPoints = new ArrayList();
        }
        if (this.voxPoints.size() > 2) {
            return;
        }
        this.voxPoints.add(new Point(x, y));
    }

    public void moveVoxPoint(int voxPointIndex, int dx, int dy) {
        Point p = (Point)this.voxPoints.get(voxPointIndex);
        p.setLocation(p.x - dx, p.y - dy);
    }

    protected void ensureArmyBoxPointExists() {
        if (this.armyBoxPoint == null) {
            this.armyBoxPoint = GraphicsTool.getCenterOfShape(this.path);
        }
    }

    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    public String getXML(int height) {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("<country>\n");
        result.append("\t\t<id>");
        result.append(this.countryCode);
        result.append("</id>\n");
        if (this.name != null) {
            result.append("\t\t<name>");
            result.append(StringTool.xmlSafe(this.name));
            result.append("</name>\n");
        }
        result.append("\t\t<initialOwner>");
        if (this.initialOwner != -1) {
            result.append(this.initialOwner);
        } else {
            result.append("0");
        }
        result.append("</initialOwner>\n");
        if (this.initialArmies != 1) {
            result.append("\t\t<initialArmies>");
            result.append(this.initialArmies);
            result.append("</initialArmies>\n");
        }
        if (this.water) {
            result.append("\t\t<water>true</water>\n");
        }
        if (this.countryBonus != 0) {
            result.append("\t\t<income>");
            result.append(this.countryBonus);
            result.append("</income>\n");
        }
        for (i = 0; i < this.units.size(); ++i) {
            UnitStackString ugs = (UnitStackString)this.units.get(i);
            result.append("\t\t<unit type=\"" + ugs.type + "\" owner=\"" + ugs.ownerID + "\" number=\"" + ugs.count + "\" />");
            result.append("\n");
        }
        result.append("\t\t<adjoining>");
        for (i = 0; i < this.adjoiningList.size(); ++i) {
            result.append((Integer)this.adjoiningList.get(i));
            if (i + 1 == this.adjoiningList.size()) continue;
            result.append(",");
        }
        result.append("</adjoining>\n");
        if (this.armyBoxPoint != null) {
            result.append("\t\t<armylocation>");
            result.append(this.armyBoxPoint.x);
            result.append(",");
            result.append(height - this.armyBoxPoint.y);
            result.append("</armylocation>\n");
        }
        if (this.voxPoints != null) {
            result.append("\t\t<voxPoints>");
            for (i = 0; i < this.voxPoints.size(); ++i) {
                Point vp = (Point)this.voxPoints.get(i);
                result.append(vp.x);
                result.append(",");
                result.append(vp.y);
                if (i + 1 >= this.voxPoints.size()) continue;
                result.append(" ");
            }
            result.append("</voxPoints>\n");
        }
        result.append(GraphicsTool.getGeneralPathXML(this.path, height));
        result.append("\t</country>\n");
        return result.toString();
    }

    public String toString() {
        return "<CountryShape name:" + this.name + ">";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getInitialOwnerInt() {
        return this.initialOwner;
    }

    public String getInitialOwner() {
        if (this.initialOwner == -1) {
            return "";
        }
        return String.valueOf(this.initialOwner);
    }

    public void setInitialOwner(String initialOwnerString) {
        try {
            this.initialOwner = Integer.parseInt(initialOwnerString);
            if (!this.mapEditor.voxEnabled) {
                this.initialOwner = Math.min(6, this.initialOwner);
            }
        }
        catch (Exception e) {
            this.initialOwner = -1;
        }
    }

    public String getInitialArmies() {
        if (this.initialArmies < 2) {
            return "";
        }
        return String.valueOf(this.initialArmies);
    }

    public void setInitialArmies(String initialArmiesString) {
        try {
            this.initialArmies = Integer.parseInt(initialArmiesString);
        }
        catch (Exception e) {
            this.initialArmies = 1;
        }
        if (this.initialArmies < 1) {
            this.initialArmies = 1;
        }
    }

    public boolean getWater() {
        return this.water;
    }

    public void setWater(boolean b) {
        this.water = b;
    }

    public String getCountryBonus() {
        return "" + this.countryBonus;
    }

    public void setCountryBonus(String b) {
        try {
            this.countryBonus = Integer.parseInt(b);
        }
        catch (Exception e) {
            this.countryBonus = 0;
        }
    }

    public void clearUnits() {
        this.units = new Vector();
    }

    public void addUnits(int number, String type, int ownerID) {
        if ("castle".equals(type)) {
            number = Math.min(1, number);
        }
        this.units.add(new UnitStackString(number, type, ownerID));
    }

    public String getUnitCount(int i) {
        if (i >= this.units.size()) {
            return "";
        }
        return "" + ((UnitStackString)this.units.get((int)i)).count;
    }

    public String getUnitType(int i) {
        if (i >= this.units.size()) {
            return "";
        }
        return ((UnitStackString)this.units.get((int)i)).type;
    }

    public int getUnitOwnerInt(int i) {
        if (i >= this.units.size()) {
            return -1;
        }
        return ((UnitStackString)this.units.get((int)i)).ownerID;
    }

    public String getUnitOwner(int i) {
        if (i >= this.units.size()) {
            return "";
        }
        return "" + ((UnitStackString)this.units.get((int)i)).ownerID;
    }

    public void setUnitOwner(int i, int newOwner) {
        if (i >= this.units.size()) {
            return;
        }
        ((UnitStackString)this.units.get((int)i)).ownerID = newOwner;
    }

    public void resize(double percent) {
        AffineTransform translate = AffineTransform.getScaleInstance(percent, percent);
        this.path.transform(translate);
        this.refreshPoints();
        Point p = this.armyBoxPoint;
        if (p != null) {
            p.setLocation(p.getX() * percent, p.getY() * percent);
        }
        if (this.voxPoints != null) {
            for (int i = 0; i < this.voxPoints.size(); ++i) {
                p = (Point)this.voxPoints.get(i);
                p.setLocation(p.getX() * percent, p.getY() * percent);
            }
        }
    }

    private class UnitStackString {
        public int count;
        public int ownerID;
        public String type;

        public UnitStackString(int count, String type, int ownerID) {
            this.count = count;
            this.type = type;
            this.ownerID = ownerID;
        }
    }
}

