/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.Continent;
import com.sillysoft.lux.editor.CountryShape;
import com.sillysoft.lux.editor.EditorCommand;
import com.sillysoft.lux.editor.MapEditor;

public class ContinentAssignCommand
extends EditorCommand {
    private Continent assign;
    private Continent oldContinent;
    private CountryShape country;

    public ContinentAssignCommand(Continent assign, CountryShape c) {
        this.assign = assign;
        this.country = c;
    }

    public void execute(MapEditor ed) {
        this.oldContinent = ed.removeCountryFromAllContinents(this.country);
        this.assign.addCountryShape(this.country);
        ed.repaint();
    }

    public void undo(MapEditor ed) {
        this.assign.removeCountryShape(this.country);
        if (this.oldContinent != null) {
            this.oldContinent.addCountryShape(this.country);
        }
        ed.repaint();
    }
}

