/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.editor;

import com.sillysoft.lux.editor.CountryShape;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApp;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Vector;

public class Continent {
    private List countries = new Vector();
    private Point labelPoint;
    private int bonus;
    private String name;
    private Color color;
    private boolean colorSet = false;

    public Continent(String name, int bonus, String colorString, String labelLocation) {
        this.name = name;
        this.bonus = bonus;
        if (colorString == null) {
            this.color = GraphicsTool.getNextColor();
        } else {
            this.colorSet = true;
            this.color = GraphicsTool.colorFromString(colorString);
        }
        if (labelLocation != null) {
            this.labelPoint = GraphicsTool.pointFromString(labelLocation);
        }
    }

    public void drawPreview(Graphics2D g) {
        int i;
        g.setStroke(new BasicStroke(10.0f, 1, 1));
        g.setColor(GraphicsTool.transparent(Color.cyan, 0.44f));
        for (i = 0; i < this.countries.size(); ++i) {
            ((CountryShape)this.countries.get(i)).draw(g);
        }
        g.setStroke(new BasicStroke(7.0f, 1, 1));
        g.setColor(this.color);
        for (i = 0; i < this.countries.size(); ++i) {
            ((CountryShape)this.countries.get(i)).draw(g);
        }
    }

    public void drawCountries(Graphics2D g) {
        for (int i = 0; i < this.countries.size(); ++i) {
            ((CountryShape)this.countries.get(i)).drawColored(g, GraphicsTool.transparent(this.color, 0.95f));
        }
    }

    public void drawCountriesColored(Graphics2D g, Color c) {
        for (int i = 0; i < this.countries.size(); ++i) {
            ((CountryShape)this.countries.get(i)).drawColored(g, c);
        }
    }

    public void drawLabel(Graphics2D g, boolean shortContinentLabels) {
        if (this.countries.size() > 0 && this.bonus != 0) {
            this.ensureLabelPointExists();
            String contTitle = this.name + (shortContinentLabels ? "" : "\n" + Translator.getString("bonus")) + ": " + this.bonus + (SSApp.isVox ? " \u2605" : "");
            Color contrastingBase = GraphicsTool.getContrastingBase(this.color);
            Color contrastingBaseOpposite = contrastingBase == Color.BLACK ? Color.WHITE : Color.BLACK;
            GraphicsTool.drawBoxedString(g, contTitle, this.labelPoint.x, this.labelPoint.y, 10, 2, GraphicsTool.transparent(contrastingBaseOpposite, 0.4f), this.color, 2, contrastingBase);
        }
    }

    public void moveLabelLocation(int x, int y) {
        this.labelPoint.setLocation(new Point(this.labelPoint.x + x, this.labelPoint.y + y));
    }

    public boolean labelContains(Point p) {
        if (this.countries.size() == 0) {
            return false;
        }
        this.ensureLabelPointExists();
        return Math.abs(p.x - this.labelPoint.x) < 65 && Math.abs(p.y - this.labelPoint.y) < 30;
    }

    private void ensureLabelPointExists() {
        if (this.labelPoint == null) {
            Rectangle bounds = Continent.getBoundsOfCountryShapes(this.countries);
            this.labelPoint = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        }
    }

    public void addCountryShape(CountryShape cs) {
        if (!this.countries.contains(cs)) {
            this.countries.add(cs);
        }
    }

    public boolean removeCountryShape(CountryShape cs) {
        return this.countries.remove(cs);
    }

    public boolean contains(CountryShape cs) {
        return this.countries.contains(cs);
    }

    public String getXML(int height) {
        if (this.countries.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append("<continent>\n");
        if (this.name != null) {
            result.append("\t<continentname>");
            result.append(StringTool.xmlSafe(this.name));
            result.append("</continentname>\n");
        }
        result.append("\t<bonus>");
        result.append(this.bonus);
        result.append("</bonus>\n");
        if (this.labelPoint != null) {
            result.append("\t<labellocation>");
            result.append(this.labelPoint.x);
            result.append(",");
            result.append(height - this.labelPoint.y);
            result.append("</labellocation>\n");
        }
        if (this.colorSet) {
            result.append("\t<color>");
            result.append(GraphicsTool.stringFromColor(this.color));
            result.append("</color>\n");
        }
        for (int i = 0; i < this.countries.size(); ++i) {
            result.append("\t");
            result.append(((CountryShape)this.countries.get(i)).getXML(height));
        }
        result.append("</continent>\n");
        return result.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBonus(String bonus) {
        try {
            this.bonus = Integer.parseInt(bonus);
        }
        catch (Exception e) {
            this.bonus = 0;
        }
    }

    public String getBonus() {
        return String.valueOf(this.bonus);
    }

    public void setColor(Color c) {
        this.colorSet = true;
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public static Rectangle getBoundsOfCountryShapes(List shapes) {
        Rectangle bounds = null;
        for (int i = 0; i < shapes.size(); ++i) {
            bounds = null == bounds ? ((CountryShape)shapes.get(i)).getBounds() : bounds.union(((CountryShape)shapes.get(i)).getBounds());
        }
        return bounds;
    }

    public void resize(double percent) {
        if (this.labelPoint == null) {
            return;
        }
        Point p = this.labelPoint;
        p.setLocation(p.getX() * percent, p.getY() * percent);
    }
}

