/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.util.BoardHelper;

public class Yakool
extends Cluster {
    public Yakool() {
        this.mustKillPlayer = -1;
    }

    public String name() {
        return "Yakool";
    }

    public String description() {
        return "Yakool is wary of those who get to strong.";
    }

    public void placeArmies(int numberOfArmies) {
        if (this.placeArmiesToKillDominantPlayer(numberOfArmies)) {
            return;
        }
        if (BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board)) {
            int ownCont = this.getMostValuablePositiveOwnedCont();
            this.placeArmiesOnClusterBorder(numberOfArmies, this.countries[BoardHelper.getCountryInContinent(ownCont, this.countries)]);
        } else {
            int wantCont = this.getEasiestContToTake();
            this.placeArmiesToTakeCont(numberOfArmies, wantCont);
        }
    }

    public void attackPhase() {
        if (this.mustKillPlayer != -1) {
            this.attackToKillPlayer(this.mustKillPlayer);
        }
        if (BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board)) {
            int ownCont = this.getMostValuablePositiveOwnedCont();
            Country root = this.countries[BoardHelper.getCountryInContinent(ownCont, this.countries)];
            this.attackFromCluster(root);
        } else {
            Country root = BoardHelper.getPlayersBiggestArmy(this.ID, this.countries);
            this.attackFromCluster(root);
        }
        this.attackForCard();
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void attackFromCluster(Country root) {
        if (root == null) {
            System.out.println("ERROR in Yakool.attackFromCluster(). root==null 654978789654");
            return;
        }
        while (this.tripleAttackPack(root)) {
        }
        int numPlayers = this.board.getNumberOfPlayers();
        int[] incomes = new int[numPlayers];
        int[] armies = new int[numPlayers];
        int maxEnemyIncome = 0;
        int aveEnemyIncome = 0;
        int enemyArmies = 0;
        for (int i = 0; i < numPlayers; ++i) {
            incomes[i] = this.board.getPlayerIncome(i);
            armies[i] = BoardHelper.getPlayerArmies(i, this.countries);
            if (i == this.ID) continue;
            enemyArmies += armies[i];
            aveEnemyIncome += incomes[i];
            if (incomes[i] <= maxEnemyIncome) continue;
            maxEnemyIncome = incomes[i];
        }
        if (!BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board) || incomes[this.ID] < (aveEnemyIncome /= numPlayers) || incomes[this.ID] > maxEnemyIncome || armies[this.ID] > enemyArmies) {
            this.debug("Yakool has decided to do the worse attacks");
            while (this.attackSplitUp(root, 1.2f)) {
            }
        }
    }

    protected void setmoveInMemoryBeforeCardAttack(Country attacker) {
    }

    public String youWon() {
        String[] answers = new String[]{"All I want is for the village and forest \nto live together in peace", "Gone fishing", "Red Elk Rule", "Good Morrow", "Ah...\nTime to relax and smell the flowers", "Loyalty to a good master is paramount", "Go away", "Here pixie, pixie, pixie...", "I fight for peace, \nbut war is all I ever see!", "When the power of love overcomes the love of power \nthe world will know peace", "I must see with eyes unclouded by hate", "Look, everyone! \nThis is what hatred looks like!", "It's eating me alive, \nand very soon now it will kill me! \nFear and anger only make it grow faster!"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

