/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.CountryCluster;
import com.sillysoft.lux.util.CountryClusterSet;
import com.sillysoft.lux.util.CountryRoute;
import java.util.ArrayList;
import java.util.List;

public class Vulture
extends SmartAgentBase {
    protected LuxAgent backer;
    protected List attackRoutes = new ArrayList();
    protected int toKillPlayer = -1;
    protected boolean placedToKill = false;

    public Vulture() {
        this.backer = new Cluster();
    }

    public void setPrefs(int ID, Board board) {
        this.backer.setPrefs(ID, board);
        super.setPrefs(ID, board);
    }

    public int pickCountry() {
        return this.backer.pickCountry();
    }

    public void placeInitialArmies(int numberOfArmies) {
        this.backer.placeInitialArmies(numberOfArmies);
    }

    public int moveArmiesIn(int countryCodeAttacker, int countryCodeDefender) {
        return this.backer.moveArmiesIn(countryCodeAttacker, countryCodeDefender);
    }

    public void fortifyPhase() {
        this.backer.fortifyPhase();
    }

    public String message(String message, Object data) {
        return this.backer.message(message, data);
    }

    public String name() {
        return "Vulture";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Vulture likes to pick at carcases.";
    }

    public void cardsPhase(Card[] cards) {
        this.cashCardsIfPossible(cards);
        this.backer.cardsPhase(cards);
    }

    protected void setToKillPlayer(int numberOfArmies) {
        int cardsWorth = this.board.getNextCardSetValue();
        int lowestArmyCount = 1000000;
        int lowestArmyPlayer = -1;
        int numPlayers = this.board.getNumberOfPlayers();
        int[] armies = new int[numPlayers];
        int ourArmies = 0;
        for (int i = 0; i < numPlayers; ++i) {
            armies[i] = BoardHelper.getPlayerArmies(i, this.countries);
            if (i == this.ID) {
                ourArmies = armies[i];
                continue;
            }
            int n = i;
            armies[n] = (int)((double)armies[n] - (double)cardsWorth * ((double)this.board.getPlayerCards(i) / 3.0));
            if (BoardHelper.getPlayerCountries(i, this.countries) <= 0 || armies[i] >= lowestArmyCount || BoardHelper.getPlayersBiggestArmyWithEnemyNeighbor(this.ID, this.countries).getArmies() + numberOfArmies <= BoardHelper.getPlayerArmies(i, this.countries) + BoardHelper.getPlayerCountries(i, this.countries)) continue;
            lowestArmyCount = armies[i];
            lowestArmyPlayer = i;
        }
        this.toKillPlayer = -1;
        if (ourArmies > lowestArmyCount * 2) {
            this.toKillPlayer = lowestArmyPlayer;
            this.debug("We are going to try and totally kill player " + this.board.getPlayerName(this.toKillPlayer));
        }
    }

    public void placeArmies(int numberOfArmies) {
        this.debug("Placing " + numberOfArmies + " armies...");
        this.placedToKill = false;
        this.setToKillPlayer(numberOfArmies);
        if (this.toKillPlayer == -1) {
            this.backer.placeArmies(numberOfArmies);
            return;
        }
        this.placeToKill(numberOfArmies);
    }

    protected void placeToKill(int numberOfArmies) {
        CountryClusterSet clusters = CountryClusterSet.getAllCountriesOwnedBy(this.toKillPlayer, this.countries);
        if (clusters.numberOfClusters() == 1) {
            this.debug("They only have 1 cluster!");
            CountryCluster cluster = clusters.getCluster(0);
            CountryRoute clusterRoute = null;
            if (cluster.size() < 21) {
                clusterRoute = cluster.getSimpleRoute(true, this.ID);
            }
            if (clusterRoute != null) {
                CountryRoute attackRoute;
                CountryRoute routeToCluster;
                this.debug("It has a simple path! " + clusterRoute);
                Country start = clusterRoute.start();
                Country end = clusterRoute.end();
                CountryRoute routeToStart = new CountryRoute(BoardHelper.easyCostCountryWithOwner(start, this.ID, this.countries));
                CountryRoute routeToEnd = new CountryRoute(BoardHelper.easyCostCountryWithOwner(end, this.ID, this.countries));
                if (routeToStart.costNotCountingPlayer(this.ID, this.toKillPlayer) - routeToStart.start().getArmies() < routeToEnd.costNotCountingPlayer(this.ID, this.toKillPlayer) - routeToEnd.start().getArmies()) {
                    routeToCluster = routeToStart;
                    attackRoute = routeToStart.append(clusterRoute);
                } else {
                    routeToCluster = routeToEnd;
                    attackRoute = routeToEnd.append(clusterRoute.reverse());
                }
                Country placeOnCountry = routeToCluster.start();
                this.debug("Our closest country is " + placeOnCountry);
                this.debug("We have " + placeOnCountry.getArmies() + " + " + numberOfArmies + " armies. They have " + clusterRoute.getArmies() + " armies + " + (routeToCluster.costNotCountingPlayer(this.ID) - routeToCluster.end().getArmies()) + " needed to get there.");
                if (placeOnCountry.getArmies() + numberOfArmies > clusterRoute.getArmies() + routeToCluster.costNotCountingPlayer(this.ID) - routeToCluster.end().getArmies()) {
                    this.placedToKill = true;
                    this.debug("Placing all armies on " + placeOnCountry);
                    this.board.placeArmies(numberOfArmies, placeOnCountry);
                    this.attackRoutes.add(attackRoute);
                    return;
                }
            }
        } else {
            this.debug("They have " + clusters.numberOfClusters() + " clusters.");
        }
        this.backer.placeArmies(numberOfArmies);
    }

    public void attackPhase() {
        if (!this.placedToKill) {
            this.backer.attackPhase();
            return;
        }
        while (this.attackRoutes.size() > 0) {
            CountryRoute attackRoute = (CountryRoute)this.attackRoutes.remove(0);
            this.debug("We are attacking to kill off the player along the route: " + attackRoute);
            this.attackAlongRoute(attackRoute);
        }
        this.attackHogWild();
    }

    protected boolean attackAlongRoute(CountryRoute route) {
        for (int i = 1; i < route.size(); ++i) {
            ((SmartAgentBase)this.backer).moveInMemory = 1000000;
            if (route.get(i - 1).getArmies() <= 1 || !route.get(i - 1).canGoto(route.get(i)) || route.get(i - 1).getOwner() != this.ID || this.board.attack(route.get(i - 1), route.get(i), true) != 13) continue;
            ((SmartAgentBase)this.backer).moveInMemory = -1;
            return false;
        }
        ((SmartAgentBase)this.backer).moveInMemory = -1;
        return true;
    }

    public String youWon() {
        return "Picked off";
    }
}

