/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Communist;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.ArrayList;
import java.util.List;

public class Trotsky
extends Communist {
    protected List targetContinents;

    public String name() {
        return "Trotsky";
    }

    public float version() {
        return 1.3f;
    }

    public String description() {
        return "Communism with some added smarts.";
    }

    public void cardsPhase(Card[] cards) {
        if (Card.containsASet(cards)) {
            Card[] set = Card.getBestSet(cards, this.ID, this.countries);
            this.board.cashCards(set[0], set[1], set[2]);
        }
    }

    protected void setTargetContinents() {
        int i;
        this.debug("trotsky's setTargetContinents() called");
        this.targetContinents = new ArrayList();
        double[] friendlyRatio = new double[this.numContinents];
        for (int i2 = 0; i2 < this.numContinents; ++i2) {
            if (BoardHelper.playerOwnsContinent(this.ID, i2, this.countries)) {
                if (this.board.getContinentBonus(i2) > 0) {
                    this.targetContinents.add(new Integer(i2));
                }
                friendlyRatio[i2] = -1.0;
                continue;
            }
            int friendlies = BoardHelper.getPlayerArmiesInContinent(this.ID, i2, this.countries);
            int enemies = BoardHelper.getEnemyArmiesInContinent(this.ID, i2, this.countries);
            friendlyRatio[i2] = (double)(friendlies += BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, i2, this.countries)) / (double)Math.max(enemies, 1);
        }
        double bestRatio = -1.0;
        int bestCont = -1;
        for (i = 0; i < this.numContinents; ++i) {
            this.debug("friendlyRatio[i]=" + friendlyRatio[i]);
            if (!(friendlyRatio[i] > bestRatio) || this.board.getContinentBonus(i) <= 0) continue;
            bestRatio = friendlyRatio[i];
            bestCont = i;
        }
        if (bestRatio == 0.0) {
            for (i = 0; i < this.numContinents; ++i) {
                if (!(friendlyRatio[i] > bestRatio) || this.board.getContinentBonus(i) != 0) continue;
                bestRatio = friendlyRatio[i];
                bestCont = i;
            }
            if (bestRatio != 0.0) {
                this.targetContinents.add(new Integer(bestCont));
            } else {
                for (i = 0; i < this.numContinents; ++i) {
                    if (!(friendlyRatio[i] > bestRatio)) continue;
                    bestRatio = friendlyRatio[i];
                    bestCont = i;
                }
                this.targetContinents.add(new Integer(bestCont));
            }
        } else if (bestCont == -1) {
            this.debug("Trotsky cannot find a good continent, going for 0.");
            this.targetContinents.add(new Integer(0));
        } else {
            this.targetContinents.add(new Integer(bestCont));
        }
    }

    public int pickCountry() {
        return this.pickCountryInSmallContinent();
    }

    protected int pickCountryInSmallContinent() {
        if (this.goalCont == -1) {
            this.goalCont = -1;
            this.goalCont = BoardHelper.getSmallestPositiveEmptyCont(this.countries, this.board);
            if (this.goalCont == -1) {
                this.goalCont = BoardHelper.getSmallestPositiveOpenCont(this.countries, this.board);
            }
        }
        if (this.goalCont == -1 || this.board.getContinentBonus(this.goalCont) < 1) {
            return this.pickCountryTouchingUs();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    public void placeArmies(int numberOfArmies) {
        if (this.hogWildCheck()) {
            Country root = BoardHelper.getPlayersBiggestArmy(this.ID, this.countries);
            this.placeArmiesOnClusterBorder(numberOfArmies, root);
            return;
        }
        this.setTargetContinents();
        int leftToPlace = numberOfArmies;
        while (leftToPlace > 0) {
            Country us;
            int leastArmies = 1000000;
            PlayerIterator ours = new PlayerIterator(this.ID, this.countries);
            while (ours.hasNext() && leftToPlace > 0) {
                us = ours.next();
                if (!this.isTargetContinent(us.getContinent())) continue;
                leastArmies = Math.min(leastArmies, us.getArmies());
            }
            if (leastArmies == 1000000) {
                while (leftToPlace > 0) {
                    ours = new PlayerIterator(this.ID, this.countries);
                    while (ours.hasNext() && leftToPlace > 0) {
                        us = ours.next();
                        this.board.placeArmies(1, us);
                        --leftToPlace;
                    }
                }
            }
            ArmiesIterator placers = new ArmiesIterator(this.ID, -leastArmies, this.countries);
            while (placers.hasNext()) {
                Country us2 = placers.next();
                if (!this.isTargetContinent(us2.getContinent()) && !this.adjoinsTargetContinent(us2)) continue;
                this.board.placeArmies(1, us2);
                --leftToPlace;
            }
        }
    }

    protected void setExpandos() {
        int j;
        Country[] neighbors;
        int i;
        this.debug("trotsky's setexpando called");
        int leastNeighborArmies = 1000000;
        this.expando = -1;
        this.expandTo = -1;
        for (i = 0; i < this.board.getNumberOfCountries(); ++i) {
            if (this.countries[i].getOwner() != this.ID) continue;
            neighbors = this.countries[i].getAdjoiningList();
            for (j = 0; j < neighbors.length; ++j) {
                if (neighbors[j].getOwner() == this.ID || neighbors[j].getArmies() >= leastNeighborArmies || !this.isTargetContinent(neighbors[j].getContinent())) continue;
                leastNeighborArmies = neighbors[j].getArmies();
                this.expando = i;
                this.expandTo = neighbors[j].getCode();
            }
        }
        if (this.expando == -1) {
            for (i = 0; i < this.board.getNumberOfCountries(); ++i) {
                if (this.countries[i].getOwner() != this.ID) continue;
                neighbors = this.countries[i].getAdjoiningList();
                for (j = 0; j < neighbors.length; ++j) {
                    if (neighbors[j].getOwner() == this.ID || neighbors[j].getArmies() >= leastNeighborArmies || this.countries[i].getArmies() <= neighbors[j].getArmies() + 20) continue;
                    leastNeighborArmies = neighbors[j].getArmies();
                    this.expando = i;
                    this.expandTo = neighbors[j].getCode();
                }
            }
        }
        if (this.expando != -1 && this.expandTo != -1) {
            this.debug(" -> expando is " + this.expando + ", in cont " + this.board.getContinentName(this.countries[this.expando].getContinent()));
            this.debug(" -> expandTo is " + this.expandTo + ", in cont " + this.board.getContinentName(this.countries[this.expandTo].getContinent()));
        } else {
            this.debug(" -> expando or expandTo is -1");
        }
    }

    public void attackPhase() {
        this.setExpandos();
        if (this.expando == -1) {
            return;
        }
        if (this.expandTo != -1 && this.countries[this.expando].getArmies() > this.countries[this.expandTo].getArmies()) {
            this.board.attack(this.expando, this.expandTo, true);
        }
        this.attackHogWild();
        this.attackStalemate();
    }

    protected boolean isTargetContinent(int contCode) {
        if (this.targetContinents == null) {
            return false;
        }
        return this.targetContinents.contains(new Integer(contCode));
    }

    protected boolean adjoinsTargetContinent(Country c) {
        Country[] adjoins = c.getAdjoiningList();
        for (int i = 0; i < adjoins.length; ++i) {
            if (!this.isTargetContinent(adjoins[i].getContinent())) continue;
            return true;
        }
        return false;
    }

    public void fortifyPhase() {
        if (this.hogWildCheck()) {
            Country root = BoardHelper.getPlayersBiggestArmy(this.ID, this.countries);
            this.fortifyCluster(root);
        } else {
            super.fortifyPhase();
        }
    }

    public String youWon() {
        return "Communism with smarts and style.\nWhat a fun combination!";
    }

    public int moveArmiesIn(int cca, int ccd) {
        if (this.hogWildCheck()) {
            int Denemies;
            int Aenemies = this.countries[cca].getNumberEnemyNeighbors();
            if (Aenemies > (Denemies = this.countries[ccd].getNumberEnemyNeighbors())) {
                return 0;
            }
            return this.countries[cca].getArmies() - 1;
        }
        return super.moveArmiesIn(cca, ccd);
    }
}

