/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ClusterBorderIterator;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.NeighborIterator;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.ArrayList;
import java.util.Random;

public abstract class SmartAgentBase
implements LuxAgent {
    protected int ID;
    protected Board board;
    protected Country[] countries;
    protected int numCountries;
    protected int numContinents;
    protected int moveInMemory = -1;
    protected int goalCont = -1;
    protected Random rand = new Random();
    protected int mustKillPlayer;
    protected boolean[] mustKillPlayerOwnsCont;

    public void setPrefs(int newID, Board theboard) {
        this.ID = newID;
        this.board = theboard;
        this.countries = this.board.getCountries();
        this.numCountries = this.countries.length;
        this.numContinents = this.board.getNumberOfContinents();
    }

    public abstract String name();

    public abstract int pickCountry();

    public abstract void placeArmies(int var1);

    public abstract void attackPhase();

    public abstract int moveArmiesIn(int var1, int var2);

    public abstract void fortifyPhase();

    public abstract String youWon();

    public void cardsPhase(Card[] cards) {
        this.mustKillPlayer = -1;
    }

    public void cashCardsIfPossible(Card[] cards) {
        if (Card.containsASet(cards)) {
            Card[] set = Card.getBestSet(cards, this.ID, this.countries);
            this.board.cashCards(set[0], set[1], set[2]);
        }
    }

    protected void setGoalToLeastBordersCont() {
        int i;
        this.goalCont = -1;
        int[] borderSizes = new int[this.numContinents];
        int smallBorders = 1000000;
        for (i = 0; i < this.numContinents; ++i) {
            if (this.board.getContinentBonus(i) <= 0) continue;
            borderSizes[i] = BoardHelper.getContinentSize(i, this.countries);
            if (borderSizes[i] >= smallBorders || !BoardHelper.playerOwnsContinent(-1, i, this.countries)) continue;
            smallBorders = borderSizes[i];
            this.goalCont = i;
        }
        if (this.goalCont == -1) {
            smallBorders = 1000000;
            for (i = 0; i < this.numContinents; ++i) {
                if (this.board.getContinentBonus(i) <= 0 || borderSizes[i] >= smallBorders || !BoardHelper.playerOwnsContinentCountry(-1, i, this.countries)) continue;
                smallBorders = borderSizes[i];
                this.goalCont = i;
            }
        }
    }

    protected int pickCountryInSmallContinent() {
        if (this.goalCont == -1 || !BoardHelper.playerOwnsContinentCountry(-1, this.goalCont, this.countries)) {
            this.goalCont = -1;
            this.goalCont = BoardHelper.getSmallestPositiveEmptyCont(this.countries, this.board);
            if (this.goalCont == -1) {
                this.goalCont = BoardHelper.getSmallestPositiveOpenCont(this.countries, this.board);
            }
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    protected int pickCountryInContinent(int continent) {
        ContinentIterator continentIter = new ContinentIterator(continent, this.countries);
        while (continentIter.hasNext()) {
            Country c = continentIter.next();
            if (c.getOwner() != -1 || c.getNumberPlayerNeighbors(this.ID) <= 0) continue;
            return c.getCode();
        }
        continentIter = new ContinentIterator(continent, this.countries);
        int bestCode = -1;
        int fewestNeib = 1000000;
        while (continentIter.hasNext()) {
            Country c = continentIter.next();
            if (c.getOwner() != -1 || c.getNumberNeighbors() >= fewestNeib) continue;
            bestCode = c.getCode();
            fewestNeib = c.getNumberNeighbors();
        }
        if (bestCode == -1) {
            return this.pickCountryTouchingUs();
        }
        return bestCode;
    }

    protected int pickCountryTouchingUs() {
        int maxTouches = -1;
        int maxCode = -1;
        PlayerIterator ci = new PlayerIterator(-1, this.countries);
        while (ci.hasNext()) {
            Country open = ci.next();
            if (open.getNumberPlayerNeighbors(this.ID) <= maxTouches || this.board.getContinentBonus(open.getContinent()) < 0) continue;
            maxTouches = open.getNumberPlayerNeighbors(this.ID);
            maxCode = open.getCode();
        }
        if (maxTouches < 1) {
            ArrayList<Country> ourBorderCountries = new ArrayList<Country>();
            ci = new PlayerIterator(this.ID, this.countries);
            while (ci.hasNext()) {
                Country open = ci.next();
                if (open.getNumberNotPlayerNeighbors(this.ID) <= 0) continue;
                ourBorderCountries.add(open);
            }
            return BoardHelper.closestCountryWithOwner(ourBorderCountries, -1, this.countries);
        }
        return maxCode;
    }

    protected int pickCountryNearCluster(Country root) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        ArrayList<Country> cluster = new ArrayList<Country>();
        while (borders.hasNext()) {
            cluster.add(borders.next());
        }
        for (int i = 0; i < cluster.size(); ++i) {
            NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == -1) {
                    return neighbor.getCode();
                }
                if (cluster.contains(neighbor)) continue;
                cluster.add(neighbor);
            }
        }
        System.out.println("ERROR in smartbase.pickCountryNearCluster() 65465477");
        return -1;
    }

    public void placeInitialArmies(int numberOfArmies) {
        this.placeArmies(numberOfArmies);
    }

    protected int getEasiestContToTake() {
        float easiestContRatio = -1.0f;
        int easiestCont = -1;
        for (int cont = 0; cont < this.numContinents; ++cont) {
            int enemies = BoardHelper.getEnemyArmiesInContinent(this.ID, cont, this.countries);
            int ours = BoardHelper.getPlayerArmiesInContinent(this.ID, cont, this.countries);
            float newratio = (float)ours / (float)enemies;
            if (!(newratio > easiestContRatio) || this.board.getContinentBonus(cont) <= 0) continue;
            easiestCont = cont;
            easiestContRatio = newratio;
        }
        return easiestCont;
    }

    protected boolean weOwnContsArround(Country center) {
        int cont = center.getContinent();
        NeighborIterator n = new NeighborIterator(center);
        while (n.hasNext()) {
            Country neib = n.next();
            if (neib.getContinent() == cont || BoardHelper.playerOwnsContinent(this.ID, neib.getContinent(), this.countries)) continue;
            return false;
        }
        return true;
    }

    protected void placeArmiesToTakeCont(int numberOfArmies, int wantCont) {
        if (wantCont == -1) {
            this.placeArmiesOnClusterBorder(numberOfArmies, BoardHelper.getPlayersBiggestArmy(this.ID, this.countries));
            return;
        }
        if (BoardHelper.playerOwnsContinent(this.ID, wantCont, this.countries)) {
            int[] borders = BoardHelper.getContinentBorders(wantCont, this.countries);
            for (int placed = 0; placed < numberOfArmies; ++placed) {
                int leastArmies = 1000000;
                int leastID = -1;
                for (int i = 0; i < borders.length; ++i) {
                    if (this.countries[borders[i]].getArmies() >= leastArmies || this.weOwnContsArround(this.countries[borders[i]])) continue;
                    leastArmies = this.countries[borders[i]].getArmies();
                    leastID = borders[i];
                }
                if (leastID == -1) {
                    leastID = borders[this.rand.nextInt(borders.length)];
                }
                this.board.placeArmies(1, leastID);
            }
            return;
        }
        ContinentIterator want = new ContinentIterator(wantCont, this.countries);
        Country bestPlace = null;
        int mostEnemies = 0;
        while (want.hasNext()) {
            Country us = want.next();
            if (us.getOwner() != this.ID) continue;
            int enemyNeighbors = 0;
            NeighborIterator neighbors = new NeighborIterator(us);
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID || neighbor.getContinent() != wantCont) continue;
                ++enemyNeighbors;
            }
            if (enemyNeighbors <= mostEnemies) continue;
            mostEnemies = enemyNeighbors;
            bestPlace = us;
        }
        if (bestPlace != null) {
            this.board.placeArmies(numberOfArmies, bestPlace);
            return;
        }
        int[] route = BoardHelper.cheapestRouteFromOwnerToCont(this.ID, wantCont, this.countries);
        this.debug("BoardHelper.cheapestRouteFromOwnerToCont(" + this.ID + ", " + wantCont + ") = " + new CountryRoute(route, this.countries));
        int placer = route[0];
        this.board.placeArmies(numberOfArmies, placer);
    }

    protected void placeArmiesOnClusterBorder(int numberOfArmies, Country root) {
        if (root == null) {
            System.out.println("SmartBase.placeArmiesOnClusterBorder() -> the cluster root==null. 654213465");
        }
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        Country weakest = null;
        int weakestArmies = 1000000;
        while (borders.hasNext()) {
            Country border = borders.next();
            if (border.getArmies() >= weakestArmies) continue;
            weakestArmies = border.getArmies();
            weakest = border;
        }
        if (weakest == null) {
            System.out.println("SmartBase.placeArmiesOnClusterBorder() -> weakest==null. 7404524");
            this.board.placeArmies(numberOfArmies, root);
            return;
        }
        int numberToPlace = Math.min(numberOfArmies, Math.max(1, numberOfArmies / 100));
        this.board.placeArmies(numberToPlace, weakest);
        if (numberOfArmies > numberToPlace) {
            this.placeArmiesOnClusterBorder(numberOfArmies - numberToPlace, root);
        }
    }

    protected boolean attackEasyExpand(Country root) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            int enemies = 0;
            Country enemy = null;
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID) continue;
                ++enemies;
                enemy = neighbor;
            }
            if (enemies != true || border.getArmies() <= enemy.getArmies()) continue;
            this.moveInMemory = 1000000;
            if (this.board.attack(border, enemy, true) > 0) {
                wonAttack = true;
            }
            this.moveInMemory = -1;
        }
        return wonAttack;
    }

    protected boolean attackFillOut(Country root) {
        boolean wonAttack = false;
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID || neighbor.getNumberNotPlayerNeighbors(this.ID) != 0 || neighbor.getArmies() >= border.getArmies()) continue;
                this.moveInMemory = 0;
                if (this.board.attack(border, neighbor, true) == 7) {
                    wonAttack = true;
                }
                this.moveInMemory = -1;
            }
        }
        return wonAttack;
    }

    protected boolean attackConsolidate(Country root) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            int i;
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            int enemies = 0;
            Country enemy = null;
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID) continue;
                ++enemies;
                enemy = neighbor;
            }
            if (enemies != true || enemy.getNumberPlayerNeighbors(this.ID) <= 1) continue;
            ArrayList<Country> ours = new ArrayList<Country>();
            NeighborIterator possibles = new NeighborIterator(enemy);
            while (possibles.hasNext()) {
                Country poss = possibles.next();
                if (poss.getOwner() != this.ID || poss.getNumberEnemyNeighbors() != 1) continue;
                ours.add(poss);
            }
            int ourArmies = 0;
            for (i = 0; i < ours.size(); ++i) {
                ourArmies += ((Country)ours.get(i)).getArmies();
            }
            if (ourArmies <= enemy.getArmies()) continue;
            for (i = 0; i < ours.size() && enemy.getOwner() != this.ID; ++i) {
                if (((Country)ours.get(i)).getArmies() <= 1 || !((Country)ours.get(i)).canGoto(enemy)) continue;
                this.moveInMemory = 1000000;
                if (this.board.attack((Country)ours.get(i), enemy, true) <= 0) continue;
                wonAttack = true;
            }
            this.moveInMemory = -1;
        }
        return wonAttack;
    }

    protected boolean attackSplitOff(Country root) {
        this.moveInMemory = -1;
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID || neighbor.getArmies() >= border.getArmies() || this.board.attack(border, neighbor, true) <= 0) continue;
                wonAttack = true;
            }
        }
        return wonAttack;
    }

    protected boolean attackSplitUp(Country root, float attackRatio) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            int enemies = 0;
            int enemiesArmies = 0;
            Country enemy = null;
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID) continue;
                ++enemies;
                enemiesArmies += neighbor.getArmies();
                enemy = neighbor;
            }
            if (!((float)border.getArmies() > (float)enemiesArmies * attackRatio)) continue;
            int armiesPer = border.getArmies() / Math.max(enemies, 1);
            neighbors = new NeighborIterator(border);
            while (neighbors.hasNext() && border.getArmies() > 1) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() == this.ID) continue;
                this.moveInMemory = armiesPer;
                if (this.board.attack(border, neighbor, true) > 0) {
                    wonAttack = true;
                }
                this.moveInMemory = -1;
                wonAttack = true;
            }
        }
        return wonAttack;
    }

    protected boolean tripleAttackPack(Country root) {
        boolean won = false;
        while (this.attackEasyExpand(root)) {
            won = true;
        }
        this.attackFillOut(root);
        while (this.attackConsolidate(root)) {
            won = true;
        }
        return won;
    }

    protected boolean hogWildCheck() {
        int numPlayers = this.board.getNumberOfPlayers();
        int[] armies = new int[numPlayers];
        int enemyArmies = 0;
        for (int i = 0; i < numPlayers; ++i) {
            armies[i] = BoardHelper.getPlayerArmies(i, this.countries);
            if (i == this.ID) continue;
            enemyArmies += armies[i];
        }
        return armies[this.ID] > enemyArmies;
    }

    protected void attackHogWild() {
        if (this.hogWildCheck()) {
            this.attackAsMuchAsPossible();
        }
    }

    protected void attackStalemate() {
        if (BoardHelper.getPlayerArmies(this.ID, this.countries) > 1500) {
            this.attackAsMuchAsPossible();
        }
    }

    protected void attackAsMuchAsPossible() {
        boolean attacked = true;
        while (attacked) {
            attacked = false;
            PlayerIterator e = new PlayerIterator(this.ID, this.countries);
            while (e.hasNext()) {
                Country c = e.next();
                while (this.tripleAttackPack(c)) {
                    attacked = true;
                }
                while (this.attackSplitUp(c, 0.01f)) {
                    attacked = true;
                }
            }
        }
    }

    protected void attackForCard() {
        this.attackForCard(1);
    }

    protected void attackForCard(int outnumberTimes) {
        if (!this.board.useCards() || this.board.tookOverACountry()) {
            return;
        }
        float bestRatio = 0.0f;
        Country bestUs = null;
        Country bestThem = null;
        PlayerIterator ours = new PlayerIterator(this.ID, this.countries);
        while (ours.hasNext()) {
            Country us = ours.next();
            NeighborIterator thems = new NeighborIterator(us);
            while (thems.hasNext()) {
                Country them = thems.next();
                if (them.getOwner() == this.ID || !((double)us.getArmies() * 1.0 / (double)them.getArmies() > (double)bestRatio) || !us.canGoto(them)) continue;
                bestRatio = (float)us.getArmies() * 1.0f / (float)them.getArmies();
                bestUs = us;
                bestThem = them;
            }
        }
        if (bestUs != null && bestUs.getArmies() > bestThem.getArmies() * outnumberTimes) {
            this.debug("executing an attackForCard attack");
            this.setmoveInMemoryBeforeCardAttack(bestUs);
            this.board.attack(bestUs, bestThem, true);
            this.moveInMemory = -1;
        }
    }

    protected void setmoveInMemoryBeforeCardAttack(Country attacker) {
    }

    protected int obviousMoveArmiesInTest(int cca, int ccd) {
        if (this.countries[cca].getNumberNeighbors() == 1) {
            this.moveInMemory = -1;
            return 1000000;
        }
        if (this.countries[ccd].getNumberNeighbors() == 1) {
            this.moveInMemory = -1;
            return 0;
        }
        return -1;
    }

    protected int memoryMoveArmiesInTest(int cca, int ccd) {
        if (this.moveInMemory != -1) {
            int temp = this.moveInMemory == -2 ? this.countries[cca].getArmies() / 2 : this.moveInMemory;
            this.moveInMemory = -1;
            return temp;
        }
        return -1;
    }

    protected void fortifyCluster(Country root) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        ArrayList<Country> cluster = new ArrayList<Country>();
        while (borders.hasNext()) {
            cluster.add(borders.next());
        }
        for (int i = 0; i < cluster.size(); ++i) {
            NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() != this.ID || cluster.contains(neighbor)) continue;
                if (neighbor.canGoto((Country)cluster.get(i))) {
                    this.board.fortifyArmies(neighbor.getMoveableArmies(), neighbor, (Country)cluster.get(i));
                }
                cluster.add(neighbor);
            }
        }
    }

    protected int getBiggestOwnedCont() {
        int bestCont = -1;
        int bestContSize = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            if (!BoardHelper.playerOwnsContinent(this.ID, i, this.countries) || BoardHelper.getContinentSize(i, this.countries) <= bestContSize) continue;
            bestCont = i;
            bestContSize = BoardHelper.getContinentSize(i, this.countries);
        }
        return bestCont;
    }

    protected int getMostValuablePositiveOwnedCont() {
        int bestCont = -1;
        int bestContBonus = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            if (!BoardHelper.playerOwnsContinent(this.ID, i, this.countries) || this.board.getContinentBonus(i) <= bestContBonus) continue;
            bestCont = i;
            bestContBonus = this.board.getContinentBonus(i);
        }
        return bestCont;
    }

    public String message(String message, Object data) {
        return null;
    }

    protected boolean placeArmiesToKillDominantPlayer(int numberOfArmies) {
        int numPlayers = this.board.getNumberOfPlayers();
        int[] incomes = new int[numPlayers];
        int[] armies = new int[numPlayers];
        int[] ownedCountries = new int[numPlayers];
        int totalArmies = 0;
        int totalIncome = 0;
        for (int i = 0; i < numPlayers; ++i) {
            armies[i] = BoardHelper.getPlayerArmies(i, this.countries);
            incomes[i] = this.board.getPlayerIncome(i);
            ownedCountries[i] = BoardHelper.getPlayerCountries(i, this.countries);
            totalArmies += armies[i];
            totalIncome += incomes[i];
        }
        int playerToAttack = -1;
        for (int i = 0; i < numPlayers; ++i) {
            if (i == this.ID || !((double)armies[i] >= (double)totalArmies * 0.5) && !((double)incomes[i] >= (double)totalIncome * 0.5) && !((double)ownedCountries[i] >= (double)this.numCountries * 0.5)) continue;
            playerToAttack = i;
        }
        if (playerToAttack != -1) {
            this.mustKillPlayer = playerToAttack;
            if (this.placeArmiesToKillPlayer(numberOfArmies, playerToAttack)) {
                return true;
            }
        }
        return false;
    }

    protected boolean placeArmiesToKillPlayer(int numberOfArmies, int playerToAttack) {
        this.mustKillPlayerOwnsCont = new boolean[this.numContinents];
        for (int i = 0; i < this.numContinents; ++i) {
            this.mustKillPlayerOwnsCont[i] = false;
            if (!BoardHelper.playerOwnsContinent(playerToAttack, i, this.countries)) continue;
            this.mustKillPlayerOwnsCont[i] = true;
        }
        int[] cost = new int[this.numContinents];
        int smallestCost = 1000000;
        int placer = -1;
        for (int i = 0; i < this.numContinents; ++i) {
            int[] path;
            cost[i] = -1;
            if (!this.mustKillPlayerOwnsCont[i] || (path = BoardHelper.cheapestRouteFromOwnerToCont(this.ID, i, this.countries)) == null) continue;
            cost[i] = this.pathCost(path);
            if (cost[i] >= smallestCost) continue;
            smallestCost = cost[i];
            placer = path[0];
        }
        if (placer == -1) {
            return false;
        }
        this.board.placeArmies(numberOfArmies, placer);
        return true;
    }

    protected void attackToKillPlayer(int player) {
        this.debug("starting attackToKillPlayer -> " + player);
        int[] ownContValue = new int[this.numContinents];
        for (int i = 0; i < this.numContinents; ++i) {
            ownContValue[i] = this.mustKillPlayerOwnsCont[i] ? this.board.getContinentBonus(i) : -1;
        }
        int biggestCont = 0;
        int biggestContValue = 0;
        while (biggestCont != -1) {
            biggestCont = -1;
            biggestContValue = 0;
            for (int i = 0; i < this.numContinents; ++i) {
                if (ownContValue[i] <= biggestContValue) continue;
                biggestContValue = ownContValue[i];
                biggestCont = i;
            }
            if (biggestCont == -1) continue;
            this.attackToKillContinent(biggestCont);
            ownContValue[biggestCont] = -1;
        }
        this.debug("ending attackToKillPlayer -> " + player);
    }

    protected boolean attackToKillContinent(int cont) {
        this.debug("starting attackToKillContinent -> " + cont);
        ArmiesIterator armies = new ArmiesIterator(this.ID, 2, this.countries);
        while (armies.hasNext()) {
            Country us = armies.next();
            int[] path = BoardHelper.easyCostFromCountryToContinent(us.getCode(), cont, this.countries);
            if (path == null || this.pathCost(path) >= us.getArmies() || !this.attackAlongPath(path)) continue;
            return true;
        }
        return false;
    }

    protected int pathCost(int[] path) {
        if (path == null) {
            System.out.println("SmartAgentBase.pathCost() -> the path was null!");
            return 1000000;
        }
        int cost = 0;
        for (int p = 0; p < path.length; ++p) {
            if (this.countries[path[p]].getOwner() == this.ID) continue;
            cost += this.countries[path[p]].getArmies();
        }
        return cost;
    }

    protected boolean attackAlongPath(int[] path) {
        for (int i = 1; i < path.length; ++i) {
            this.moveInMemory = 1000000;
            if (this.countries[path[i - 1]].getArmies() != 1 && this.board.attack(path[i - 1], path[i], true) != 13) continue;
            this.moveInMemory = -1;
            return false;
        }
        this.moveInMemory = -1;
        return true;
    }

    public void debug(Object text) {
    }
}

