/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ClusterBorderIterator;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;
import java.util.List;

public class Shaft
extends Cluster {
    public String name() {
        return "Shaft";
    }

    public String description() {
        return "Shaft is a bad mutha.";
    }

    public int pickCountry() {
        if (this.goalCont == -1 || !BoardHelper.playerOwnsContinentCountry(-1, this.goalCont, this.countries)) {
            this.setGoalToLeastBordersCont();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    protected void attackFromCluster(Country root) {
        if (root != null) {
            if (!this.attackEasyExpand(root)) {
                this.attackFillOut(root);
            }
            while (this.attackConsolidate(root)) {
            }
            if (!this.board.tookOverACountry()) {
                ClusterBorderIterator borders = new ClusterBorderIterator(root);
                while (borders.hasNext()) {
                    this.sweepForwardBorder(borders.next());
                }
            }
        }
    }

    protected void sweepForwardBorder(Country sweep) {
        Country n;
        NeighborIterator neib = new NeighborIterator(sweep);
        ArrayList q = new ArrayList();
        ArrayList<Country> seen = new ArrayList<Country>();
        while (neib.hasNext()) {
            n = neib.next();
            if (n.getOwner() == this.ID) continue;
            seen.add(n);
        }
        this.startSweep(sweep, q, seen, false);
        while (this.advanceSweep(q, seen, false)) {
        }
        if (q.size() == 1) {
            neib = new NeighborIterator(sweep);
            q = new ArrayList();
            seen = new ArrayList();
            while (neib.hasNext()) {
                n = neib.next();
                if (n.getOwner() == this.ID) continue;
                seen.add(n);
            }
            this.startSweep(sweep, q, seen, true);
            while (this.advanceSweep(q, seen, true)) {
            }
        }
    }

    protected int countUnseenEnemies(Country c, List seen) {
        int enemies = 0;
        NeighborIterator neib = new NeighborIterator(c);
        while (neib.hasNext()) {
            Country n = neib.next();
            if (n.getOwner() == this.ID || seen.contains(n)) continue;
            ++enemies;
        }
        return enemies;
    }

    protected void startSweep(Country from, List q, List seen, boolean forReal) {
        if (forReal) {
            q.add(seen.get(0));
            this.debug("startSweep");
            if (from.getArmies() > 1) {
                this.board.attack(from, (Country)seen.get(0), true);
            }
        } else {
            for (int i = 0; i < seen.size(); ++i) {
                q.add(seen.get(i));
            }
        }
    }

    protected boolean advanceSweep(List q, List seen, boolean forReal) {
        if (forReal) {
            this.takeOverEnveloped(seen);
        }
        boolean swept = false;
        for (int i = 0; i < q.size(); ++i) {
            int enemies = 0;
            Country e = null;
            NeighborIterator neib = new NeighborIterator((Country)q.get(i));
            while (neib.hasNext()) {
                Country n = neib.next();
                if (n.getOwner() == this.ID || seen.contains(n)) continue;
                ++enemies;
                e = n;
            }
            if (enemies == 0) {
                q.remove(q.get(i));
                continue;
            }
            if (enemies != true) continue;
            if (forReal) {
                this.debug("advanceSweep");
                Country from = (Country)q.get(i);
                if (from.getOwner() == this.ID && from.getArmies() > 1) {
                    this.board.attack(from, e, true);
                }
            }
            q.remove(q.get(i));
            q.add(e);
            seen.add(e);
            swept = true;
        }
        return swept;
    }

    protected void takeOverEnveloped(List seen) {
        for (int i = 0; i < seen.size(); ++i) {
            if (((Country)seen.get(i)).getOwner() == this.ID) continue;
            this.takeCountry(seen.get(i));
        }
    }

    protected void takeCountry(Object c) {
        Country into = (Country)c;
        NeighborIterator neighbors = new NeighborIterator(into);
        while (neighbors.hasNext() && into.getOwner() != this.ID) {
            Country possAttack = neighbors.next();
            if (possAttack.getOwner() != this.ID || possAttack.getArmies() <= into.getArmies() || !possAttack.canGoto(into)) continue;
            this.debug("take country");
            this.board.attack(possAttack, into, true);
        }
    }

    public String youWon() {
        String[] answers = new String[]{"Can you dig it?", "Damn right", "You sure got a lotta mouth on you", "c'mere, baby!", "Why don't you stop playin' with yourself", "You a cagey spook, Bumpy", "You know me. \nIt's my duty to please that booty", "You're too hot, man. \nYou gotta step off a bit", "Chicks dig me because I rarely wear underwear", "If brains were dynamite \nyou couldn't blow your nose"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

