/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;

public class Pixie
extends SmartAgentBase {
    float outnumberBy = 1.0f;
    protected int borderForce = 20;
    boolean[] ourConts;

    public String name() {
        return "Pixie";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Pixie is a lovable little sprite. She enjoys kicking your ass.";
    }

    public int pickCountry() {
        if (this.goalCont == -1 || !BoardHelper.playerOwnsContinentCountry(-1, this.goalCont, this.countries)) {
            this.setGoalToLeastBordersCont();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    boolean placeHogWild(int numberOfArmies) {
        return false;
    }

    boolean setupOurConts(int numberOfArmies) {
        if (this.ourConts == null) {
            this.ourConts = new boolean[this.numContinents];
        }
        int[] neededForCont = new int[this.numContinents];
        for (int i = 0; i < this.numContinents; ++i) {
            neededForCont[i] = BoardHelper.getEnemyArmiesInContinent(this.ID, i, this.countries);
            int n = i;
            neededForCont[n] = neededForCont[n] - BoardHelper.getPlayerArmiesInContinent(this.ID, i, this.countries);
            int n2 = i;
            neededForCont[n2] = neededForCont[n2] - BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, i, this.countries);
        }
        boolean wantACont = false;
        for (int i = 0; i < this.numContinents; ++i) {
            if ((double)neededForCont[i] < 1.0 / (double)this.numContinents * (double)numberOfArmies && this.board.getContinentBonus(i) > 0) {
                this.ourConts[i] = true;
                wantACont = true;
                continue;
            }
            this.ourConts[i] = false;
        }
        return wantACont;
    }

    public void placeArmies(int numberOfArmies) {
        if (this.placeHogWild(numberOfArmies)) {
            return;
        }
        if (!this.setupOurConts(numberOfArmies)) {
            this.placeArmiesToTakeCont(numberOfArmies, this.getEasiestContToTake());
            return;
        }
        int armiesPlaced = 0;
        boolean oneNeedsHelp = true;
        while (armiesPlaced < numberOfArmies && oneNeedsHelp) {
            oneNeedsHelp = false;
            for (int c = 0; c < this.numContinents; ++c) {
                if (!this.ourConts[c] || !this.continentNeedsHelp(c)) continue;
                this.placeArmiesToTakeCont(1, c);
                ++armiesPlaced;
                oneNeedsHelp = true;
            }
        }
        this.placeRemainder(numberOfArmies - armiesPlaced);
    }

    protected void placeRemainder(int numberOfArmies) {
        this.placeNearEnemies(numberOfArmies);
    }

    protected void placeNearEnemies(int numberOfArmies) {
        int i = 0;
        while (numberOfArmies > 0) {
            if (this.countries[i].getOwner() == this.ID && this.countries[i].getNumberEnemyNeighbors() > 0) {
                this.board.placeArmies(1, i);
                --numberOfArmies;
            }
            i = (i + 1) % this.numCountries;
        }
    }

    protected boolean weOwnContsArround(Country center) {
        int cont = center.getContinent();
        NeighborIterator n = new NeighborIterator(center);
        while (n.hasNext()) {
            Country neib = n.next();
            if (neib.getContinent() == cont || BoardHelper.playerOwnsContinent(this.ID, neib.getContinent(), this.countries)) continue;
            return false;
        }
        return true;
    }

    boolean borderCountryNeedsHelp(Country border) {
        return border.getArmies() <= this.borderForce;
    }

    protected boolean continentNeedsHelp(int cont) {
        if (!BoardHelper.playerOwnsContinent(this.ID, cont, this.countries)) {
            return true;
        }
        int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
        for (int i = 0; i < borders.length; ++i) {
            if (!this.borderCountryNeedsHelp(this.countries[borders[i]])) continue;
            return true;
        }
        return false;
    }

    public void attackPhase() {
        for (int i = 0; i < this.numContinents; ++i) {
            if (!this.ourConts[i]) continue;
            this.attackInContinent(i);
        }
        this.attackForCard();
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void attackInContinent(int cont) {
        ContinentIterator continent = new ContinentIterator(cont, this.countries);
        while (continent.hasNext()) {
            Country c = continent.next();
            if (c.getOwner() == this.ID) continue;
            NeighborIterator neighbors = new NeighborIterator(c);
            while (neighbors.hasNext()) {
                Country possAttack = neighbors.next();
                if (possAttack.getOwner() != this.ID || !((float)possAttack.getArmies() > (float)c.getArmies() * this.outnumberBy) || c.getOwner() == this.ID || !possAttack.canGoto(c)) continue;
                this.board.attack(possAttack, c, true);
            }
        }
    }

    public int moveArmiesIn(int cca, int ccd) {
        Country test;
        int defenderEnemies;
        int attackerEnemies = this.countries[cca].getNumberEnemyNeighbors();
        if (attackerEnemies > (defenderEnemies = this.countries[ccd].getNumberEnemyNeighbors())) {
            return 0;
        }
        if (defenderEnemies > attackerEnemies) {
            return 1000000;
        }
        if (attackerEnemies > 0) {
            return this.countries[cca].getArmies() / 2;
        }
        if (this.ourConts[this.countries[cca].getContinent()] && this.ourConts[this.countries[ccd].getContinent()]) {
            return this.countries[cca].getArmies() / 2;
        }
        if (this.ourConts[this.countries[cca].getContinent()]) {
            return 0;
        }
        if (this.ourConts[this.countries[ccd].getContinent()]) {
            return 1000000;
        }
        int attackerEnemiesWanted = 0;
        int defenderEnemiesWanted = 0;
        NeighborIterator e = new NeighborIterator(this.countries[cca]);
        while (e.hasNext()) {
            test = e.next();
            if (test.getOwner() == this.ID || !this.ourConts[test.getContinent()]) continue;
            ++attackerEnemiesWanted;
        }
        e = new NeighborIterator(this.countries[ccd]);
        while (e.hasNext()) {
            test = e.next();
            if (test.getOwner() == this.ID || !this.ourConts[test.getContinent()]) continue;
            ++defenderEnemiesWanted;
        }
        if (attackerEnemiesWanted > defenderEnemiesWanted) {
            return 0;
        }
        if (defenderEnemiesWanted > attackerEnemiesWanted) {
            return 1000000;
        }
        if (attackerEnemiesWanted > 0) {
            return this.countries[cca].getArmies() / 2;
        }
        this.debug("Pixie moveArmiesIn not fully imped");
        return this.countries[cca].getArmies() / 2;
    }

    public void fortifyPhase() {
        for (int i = 0; i < this.numContinents; ++i) {
            if (BoardHelper.playerOwnsContinent(this.ID, i, this.countries)) {
                this.fortifyContinent(i);
                continue;
            }
            this.fortifyContinentScraps(i);
        }
    }

    protected void fortifyContinent(int cont) {
        int i;
        int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
        ArrayList<Country> cluster = new ArrayList<Country>();
        for (i = 0; i < borders.length; ++i) {
            cluster.add(this.countries[borders[i]]);
        }
        for (i = 0; i < cluster.size(); ++i) {
            NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() != this.ID || cluster.contains(neighbor) || neighbor.getContinent() != cont) continue;
                this.board.fortifyArmies(neighbor.getMoveableArmies(), neighbor, (Country)cluster.get(i));
                cluster.add(neighbor);
            }
        }
    }

    protected void fortifyContinentScraps(int cont) {
        ContinentIterator e = new ContinentIterator(cont, this.countries);
        while (e.hasNext()) {
            Country c = e.next();
            if (c.getOwner() != this.ID || c.getMoveableArmies() <= 0) continue;
            int weakestArmies = 1000000;
            Country weakestLink = null;
            NeighborIterator n = new NeighborIterator(c);
            while (n.hasNext()) {
                Country themWeak;
                Country possMoveTo = n.next();
                if (possMoveTo.getOwner() != this.ID || (themWeak = possMoveTo.getWeakestEnemyNeighbor()) == null || themWeak.getArmies() >= weakestArmies) continue;
                weakestArmies = possMoveTo.getWeakestEnemyNeighbor().getArmies();
                weakestLink = possMoveTo;
            }
            Country hereWeakest = c.getWeakestEnemyNeighbor();
            if (hereWeakest != null && weakestArmies >= hereWeakest.getArmies() || weakestLink == null) continue;
            this.board.fortifyArmies(c.getMoveableArmies(), c, weakestLink);
        }
    }

    public String youWon() {
        String[] answers = new String[]{"Eat my dust", "You didn't clap loud enough", "Make a wish", "Now fetch me Yakool", "Careful what you wish for", "Love one another, and be happy", "You can come out now Satyrs, \nit's pixie party time", "I'm the strongest woman in the world", "I want to be the girl with the most bracelets", "I'm not just cute! \nI am a serious fighter!", "All this bloodshed,\nI think I'm going to be sick..."};
        return answers[this.rand.nextInt(answers.length)];
    }
}

