/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.util.ClusterBorderIterator;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;

public class HumanFriendly
extends Cluster {
    public String name() {
        return "HumanFriendly";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "HumanFriendly likes is a radical bot. He likes Humans.";
    }

    protected void attackFromCluster(Country root) {
        if (root != null) {
            while (this.attackEasyExpand(root)) {
            }
            this.attackFillOut(root);
            while (this.attackEasyExpand(root)) {
            }
            while (this.attackConsolidate(root)) {
            }
            while (this.attackSplitUp(root, 1.2f)) {
            }
        }
    }

    protected boolean attackEasyExpand(Country root) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            int enemies = 0;
            Country enemy = null;
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (this.board.getAgentName(neighbor.getOwner()).equals("Human")) continue;
                ++enemies;
                enemy = neighbor;
            }
            if (enemies != true || border.getArmies() <= enemy.getArmies()) continue;
            this.moveInMemory = 1000000;
            if (this.board.attack(border, enemy, true) > 0) {
                wonAttack = true;
            }
            this.moveInMemory = -1;
        }
        return wonAttack;
    }

    protected boolean attackFillOut(Country root) {
        boolean wonAttack = false;
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (this.board.getAgentName(neighbor.getOwner()).equals("Human") || neighbor.getNumberPlayerNotNamedNeighbors("Human", this.board) != 0 || neighbor.getArmies() >= border.getArmies()) continue;
                this.moveInMemory = 0;
                if (this.board.attack(border, neighbor, true) == 7) {
                    wonAttack = true;
                }
                this.moveInMemory = -1;
            }
        }
        return wonAttack;
    }

    protected boolean attackConsolidate(Country root) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            int i;
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            int enemies = 0;
            Country enemy = null;
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (this.board.getAgentName(neighbor.getOwner()).equals("Human")) continue;
                ++enemies;
                enemy = neighbor;
            }
            if (enemies != true || enemy.getNumberPlayerNeighbors(this.ID) <= 1) continue;
            ArrayList<Country> ours = new ArrayList<Country>();
            NeighborIterator possibles = new NeighborIterator(enemy);
            while (possibles.hasNext()) {
                Country poss = possibles.next();
                if (poss.getOwner() != this.ID || poss.getNumberPlayerNotNamedNeighbors("Human", this.board) != 1) continue;
                ours.add(poss);
            }
            int ourArmies = 0;
            for (i = 0; i < ours.size(); ++i) {
                ourArmies += ((Country)ours.get(i)).getArmies();
            }
            if (ourArmies <= enemy.getArmies()) continue;
            for (i = 0; i < ours.size() && enemy.getOwner() != this.ID; ++i) {
                if (((Country)ours.get(i)).getArmies() <= 1) continue;
                this.moveInMemory = 1000000;
                if (this.board.attack((Country)ours.get(i), enemy, true) <= 0) continue;
                wonAttack = true;
            }
            this.moveInMemory = -1;
        }
        return wonAttack;
    }

    protected boolean attackSplitUp(Country root, float attackRatio) {
        ClusterBorderIterator borders = new ClusterBorderIterator(root);
        boolean wonAttack = false;
        while (borders.hasNext()) {
            Country border = borders.next();
            NeighborIterator neighbors = new NeighborIterator(border);
            int enemies = 0;
            int enemiesArmies = 0;
            Country enemy = null;
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (this.board.getAgentName(neighbor.getOwner()).equals("Human")) continue;
                ++enemies;
                enemiesArmies += neighbor.getArmies();
                enemy = neighbor;
            }
            if (!((float)border.getArmies() > (float)enemiesArmies * attackRatio)) continue;
            int armiesPer = border.getArmies() / Math.max(enemies, 1);
            neighbors = new NeighborIterator(border);
            while (neighbors.hasNext() && border.getArmies() > 1) {
                Country neighbor = neighbors.next();
                if (this.board.getAgentName(neighbor.getOwner()).equals("Human")) continue;
                this.moveInMemory = armiesPer;
                if (this.board.attack(border, neighbor, true) > 0) {
                    wonAttack = true;
                }
                this.moveInMemory = -1;
                wonAttack = true;
            }
        }
        return wonAttack;
    }
}

