/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.Pixie;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.NeighborIterator;

public class EvilPixie
extends Pixie {
    public EvilPixie() {
        this.mustKillPlayer = -1;
        this.outnumberBy = 1.3f;
        this.borderForce = 7 + this.rand.nextInt(15);
    }

    public String name() {
        return "EvilPixie";
    }

    public String description() {
        return "EvilPixie is Pixie's evil twin sister.";
    }

    public void cardsPhase(Card[] cards) {
        super.cardsPhase(cards);
        this.cashCardsIfPossible(cards);
    }

    public void placeArmies(int numberOfArmies) {
        if (this.placeArmiesToKillDominantPlayer(numberOfArmies)) {
            this.setupOurConts(0);
            return;
        }
        super.placeArmies(numberOfArmies);
    }

    protected void placeArmiesToTakeCont(int numberOfArmies, int wantCont) {
        if (BoardHelper.playerOwnsContinent(this.ID, wantCont, this.countries)) {
            int[] borders = BoardHelper.getContinentBorders(wantCont, this.countries);
            for (int placed = 0; placed < numberOfArmies; ++placed) {
                int leastArmies = 1000000;
                int leastID = -1;
                for (int i = 0; i < borders.length; ++i) {
                    if (this.countries[borders[i]].getArmies() >= leastArmies || !this.borderCountryNeedsHelp(this.countries[borders[i]])) continue;
                    leastArmies = this.countries[borders[i]].getArmies();
                    leastID = this.countries[borders[i]].getCode();
                }
                this.board.placeArmies(1, leastID);
            }
            return;
        }
        super.placeArmiesToTakeCont(numberOfArmies, wantCont);
    }

    boolean placeHogWild(int numberOfArmies) {
        if (!this.hogWildCheck()) {
            return false;
        }
        this.placeToOutnumberEnemies(numberOfArmies);
        return true;
    }

    void placeToOutnumberEnemies(int numberOfArmies) {
        int i;
        boolean[] outnumber = new boolean[this.countries.length];
        for (i = 0; i < this.countries.length; ++i) {
            outnumber[i] = false;
        }
        for (i = 0; i < this.countries.length; ++i) {
            if (this.countries[i].getOwner() != this.ID) {
                Country[] neigbors = this.countries[i].getAdjoiningList();
                for (int n = 0; n < neigbors.length; ++n) {
                    if (neigbors[n].getOwner() != this.ID || neigbors[n].getArmies() <= this.countries[i].getArmies()) continue;
                    outnumber[i] = true;
                }
                continue;
            }
            outnumber[i] = true;
        }
        for (i = 0; i < this.countries.length && numberOfArmies > 0; ++i) {
            if (outnumber[i]) continue;
            int armies = 0;
            Country us = null;
            Country[] neigbors = this.countries[i].getAdjoiningList();
            for (int n = 0; n < neigbors.length; ++n) {
                if (neigbors[n].getOwner() != this.ID || neigbors[n].getArmies() <= armies) continue;
                us = neigbors[n];
            }
            if (us == null) continue;
            int numToPlace = this.countries[i].getArmies() - us.getArmies();
            numToPlace = Math.max(numToPlace, 1);
            this.board.placeArmies(numToPlace, us);
            numberOfArmies -= numToPlace;
        }
        if (numberOfArmies > 0) {
            this.debug("placeToOutnumberEnemies didn't use up all the armies: " + numberOfArmies);
            this.placeNearEnemies(numberOfArmies);
        }
    }

    protected void placeRemainder(int numberOfArmies) {
        this.debug("placeRemainder: " + numberOfArmies);
        this.placeToOutnumberEnemies(numberOfArmies);
    }

    boolean borderCountryNeedsHelp(Country border) {
        return border.getArmies() <= this.borderForce && !this.weOwnContsArround(border);
    }

    public void attackPhase() {
        if (this.mustKillPlayer != -1) {
            this.attackToKillPlayer(this.mustKillPlayer);
        }
        for (int i = 0; i < this.numContinents; ++i) {
            if (this.ourConts[i]) {
                this.attackInContinent(i);
            }
            this.takeOutContinentCheck(i);
        }
        int numPlayers = this.board.getNumberOfPlayers();
        for (int p = 0; p < numPlayers; ++p) {
            if (p == this.ID) continue;
            this.takeOutPlayerCheck(p);
        }
        this.attackForCard(5);
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void takeOutContinentCheck(int cont) {
        if (BoardHelper.anyPlayerOwnsContinent(cont, this.countries) && this.countries[BoardHelper.getCountryInContinent(cont, this.countries)].getOwner() != this.ID) {
            this.debug("enemy owns continent " + cont);
            int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
            for (int b = 0; b < borders.length; ++b) {
                Country[] neigbors = this.countries[borders[b]].getAdjoiningList();
                for (int n = 0; n < neigbors.length; ++n) {
                    if (neigbors[n].getOwner() != this.ID || neigbors[n].getArmies() <= this.countries[borders[b]].getArmies() || !neigbors[n].canGoto(this.countries[borders[b]])) continue;
                    this.debug("attacking to take out continent " + cont);
                    if (this.board.attack(neigbors[n], this.countries[borders[b]], true) <= 0) continue;
                    return;
                }
            }
        }
    }

    protected void takeOutPlayerCheck(int player) {
        if (BoardHelper.getPlayerArmies(this.ID, this.countries) > 5 * BoardHelper.getPlayerArmies(player, this.countries)) {
            this.debug("try to eliminate player " + player);
            for (int i = 0; i < this.countries.length; ++i) {
                if (this.countries[i].getOwner() != player) continue;
                Country[] list = this.countries[i].getAdjoiningList();
                for (int l = 0; l < list.length && this.countries[i].getOwner() == player; ++l) {
                    if (list[l].getOwner() != this.ID || list[l].getArmies() <= 1 || !list[l].canGoto(i)) continue;
                    this.board.attack(list[l], this.countries[i], true);
                }
            }
        }
    }

    protected void fortifyContinentScraps(int cont) {
        ContinentIterator e = new ContinentIterator(cont, this.countries);
        while (e.hasNext()) {
            Country c = e.next();
            NeighborIterator n = new NeighborIterator(c);
            while (c.getOwner() == this.ID && c.getMoveableArmies() > 0 && n.hasNext()) {
                Country usToHelp = n.next();
                if (usToHelp.getOwner() != this.ID || !BoardHelper.playerOwnsContinent(this.ID, usToHelp.getContinent(), this.countries)) continue;
                this.debug("fortifying armies to aid continent " + cont);
                this.board.fortifyArmies(c.getMoveableArmies(), c, usToHelp);
            }
        }
        super.fortifyContinentScraps(cont);
    }

    protected void fortifyContinent(int cont) {
        super.fortifyContinent(cont);
        int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
        for (int i = 0; i < borders.length; ++i) {
            for (int j = 0; j < borders.length; ++j) {
                int numberToMove;
                int diff;
                if (!this.countries[borders[i]].canGoto(borders[j]) || (diff = Math.abs(this.countries[borders[i]].getArmies() - this.countries[borders[j]].getArmies()) / 2) == 0 || this.countries[borders[i]].getArmies() <= this.countries[borders[j]].getArmies() || (numberToMove = Math.min(this.countries[borders[i]].getMoveableArmies(), (this.countries[borders[i]].getArmies() - this.countries[borders[j]].getArmies()) / 2)) <= 0) continue;
                this.board.fortifyArmies(numberToMove, borders[i], borders[j]);
            }
        }
    }

    public String youWon() {
        String[] answers = new String[]{"You'd be evil too if you grew \nup in this wacko forest", "Always look on the dark side on life", "Vader ain't got nothin on me", "mmmm... Your spleen is so tasty", "Your failure is now complete", "My powers are unrivaled in this quadrant of space-time", "Time to go look for a new world to conquer", "She chose fashion, \nand I chose evil", "Your friends have failed you", "You rebel scum", "You can call me Pixie Worldwalker", "Join me, and together we can rule the universe!\n \n Oh wait, you're dead", "Fetch me the head of John Galt", "Now you shall dance for my entertainment", "You shall now become a part of my petting zoo", "Evil shall always prevail,\nbecause good is dumb", "All the best things come in evil packages"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

