/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.PlayerIterator;

public class Communist
extends SmartAgentBase {
    protected int expando;
    protected int expandTo;

    public String name() {
        return "Communist";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Communist is the worker's AI. All countries are equal. Knock them over like dominoes.";
    }

    public int pickCountry() {
        return this.pickCountryInSmallContinent();
    }

    public void placeArmies(int numberOfArmies) {
        int leftToPlace = numberOfArmies;
        while (leftToPlace > 0) {
            int leastArmies = 1000000;
            PlayerIterator ours = new PlayerIterator(this.ID, this.countries);
            while (ours.hasNext() && leftToPlace > 0) {
                Country us = ours.next();
                leastArmies = Math.min(leastArmies, us.getArmies());
            }
            ArmiesIterator placers = new ArmiesIterator(this.ID, -leastArmies, this.countries);
            while (placers.hasNext()) {
                Country us = placers.next();
                this.board.placeArmies(1, us);
                --leftToPlace;
            }
        }
    }

    protected void setExpandos() {
        int leastNeighborArmies = 1000000;
        this.expando = -1;
        this.expandTo = -1;
        for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
            if (this.countries[i].getOwner() != this.ID) continue;
            Country[] neighbors = this.countries[i].getAdjoiningList();
            for (int j = 0; j < neighbors.length; ++j) {
                if (neighbors[j].getOwner() == this.ID || neighbors[j].getArmies() >= leastNeighborArmies || this.board.getAgentName(neighbors[j].getOwner()).equals(this.name()) && !this.communismWins()) continue;
                leastNeighborArmies = neighbors[j].getArmies();
                this.expando = i;
                this.expandTo = neighbors[j].getCode();
            }
        }
    }

    protected boolean communismWins() {
        for (int i = 0; i < this.board.getNumberOfPlayers(); ++i) {
            if (this.board.getAgentName(i).equals(this.name()) || !BoardHelper.playerIsStillInTheGame(i, this.countries)) continue;
            return false;
        }
        this.debug("communism has won!");
        return true;
    }

    public void attackPhase() {
        this.setExpandos();
        if (this.expando == -1) {
            return;
        }
        if (this.expandTo != -1 && this.countries[this.expando].getArmies() > this.countries[this.expandTo].getArmies()) {
            this.board.attack(this.expando, this.expandTo, true);
        }
        this.attackHogWild();
        this.attackStalemate();
    }

    public int moveArmiesIn(int countryCodeAttacker, int countryCodeDefender) {
        int totalArmies = this.countries[countryCodeAttacker].getArmies();
        return (totalArmies + 1) / 2;
    }

    public void fortifyPhase() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
                if (this.countries[i].getOwner() != this.ID || this.countries[i].getMoveableArmies() <= 0) continue;
                Country[] neighbors = this.countries[i].getAdjoiningList();
                for (int j = 0; j < neighbors.length && this.countries[i].getMoveableArmies() > 0; ++j) {
                    int difference;
                    if (neighbors[j].getOwner() != this.ID || (difference = this.countries[i].getArmies() - neighbors[j].getArmies()) <= 1) continue;
                    this.board.fortifyArmies(difference / 2, i, neighbors[j].getCode());
                    changed = true;
                    this.debug("fort");
                }
            }
        }
    }

    public String youWon() {
        return "Welcome to the new world, Comrade.";
    }
}

