/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;

public class Cluster
extends SmartAgentBase {
    public String name() {
        return "Cluster";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Cluster is a radical dude. He enjoys starting a party and then spreading it.";
    }

    public int pickCountry() {
        if (this.goalCont == -1 || !BoardHelper.playerOwnsContinentCountry(-1, this.goalCont, this.countries)) {
            this.goalCont = this.pickGoalContChoosing();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    protected int pickGoalContChoosing() {
        int size;
        int cont;
        int max = (int)Math.ceil((double)this.numCountries * 1.25 / (double)this.board.getNumberOfPlayers());
        int bigUnownedContSize = 0;
        int bigUnownedCont = -1;
        for (cont = 0; cont < this.numContinents; ++cont) {
            if (this.board.getContinentBonus(cont) <= 0 || (size = BoardHelper.getContinentSize(cont, this.countries)) >= max || size <= bigUnownedContSize || !BoardHelper.playerOwnsContinent(-1, cont, this.countries)) continue;
            bigUnownedContSize = size;
            bigUnownedCont = cont;
        }
        if (bigUnownedCont != -1) {
            return bigUnownedCont;
        }
        bigUnownedContSize = 0;
        bigUnownedCont = -1;
        for (cont = 0; cont < this.numContinents; ++cont) {
            if (this.board.getContinentBonus(cont) <= 0 || (size = BoardHelper.getContinentSize(cont, this.countries)) >= max || size <= bigUnownedContSize || !BoardHelper.playerOwnsContinentCountry(-1, cont, this.countries)) continue;
            bigUnownedContSize = size;
            bigUnownedCont = cont;
        }
        if (bigUnownedCont != -1) {
            return bigUnownedCont;
        }
        for (cont = 0; cont < this.numContinents; ++cont) {
            if (this.board.getContinentBonus(cont) != 0) continue;
            return cont;
        }
        int smallestOpenCont = -1;
        int smallestSize = 1000;
        for (int cont2 = 0; cont2 < this.numContinents; ++cont2) {
            int size2 = BoardHelper.getContinentSize(cont2, this.countries);
            if (size2 < max || size2 >= smallestSize || !BoardHelper.playerOwnsContinentCountry(-1, cont2, this.countries)) continue;
            smallestOpenCont = cont2;
            smallestSize = size2;
        }
        if (smallestOpenCont != -1) {
            return smallestOpenCont;
        }
        System.out.println("ERROR in Cluster.pickGoalContChoosing  323230032");
        return -1;
    }

    public void placeArmies(int numberOfArmies) {
        if (BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board)) {
            int ownCont = this.getMostValuablePositiveOwnedCont();
            this.placeArmiesOnClusterBorder(numberOfArmies, this.countries[BoardHelper.getCountryInContinent(ownCont, this.countries)]);
        } else {
            int wantCont = this.getEasiestContToTake();
            this.placeArmiesToTakeCont(numberOfArmies, wantCont);
        }
    }

    public void attackPhase() {
        if (BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board)) {
            int ownCont = this.getMostValuablePositiveOwnedCont();
            Country root = this.countries[BoardHelper.getCountryInContinent(ownCont, this.countries)];
            this.attackFromCluster(root);
        } else {
            Country root = BoardHelper.getPlayersBiggestArmy(this.ID, this.countries);
            this.attackFromCluster(root);
        }
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void attackFromCluster(Country root) {
        if (root != null) {
            while (this.attackEasyExpand(root)) {
            }
            this.attackFillOut(root);
            while (this.attackEasyExpand(root)) {
            }
            while (this.attackConsolidate(root)) {
            }
            while (this.attackSplitUp(root, 1.2f)) {
            }
        }
    }

    public int moveArmiesIn(int cca, int ccd) {
        int test = this.obviousMoveArmiesInTest(cca, ccd);
        if (test != -1) {
            return test;
        }
        test = this.memoryMoveArmiesInTest(cca, ccd);
        if (test != -1) {
            return test;
        }
        Country aweakest = this.countries[cca].getWeakestEnemyNeighborInContinent(this.goalCont);
        Country dweakest = this.countries[ccd].getWeakestEnemyNeighborInContinent(this.goalCont);
        if (dweakest == null || aweakest != null && aweakest.getArmies() < dweakest.getArmies()) {
            return 0;
        }
        return 1000000;
    }

    public void fortifyPhase() {
        if (BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board)) {
            int ownCont = this.getMostValuablePositiveOwnedCont();
            this.fortifyCluster(this.countries[BoardHelper.getCountryInContinent(ownCont, this.countries)]);
        } else {
            Country root = BoardHelper.getPlayersBiggestArmy(this.ID, this.countries);
            this.fortifyCluster(root);
        }
    }

    public String youWon() {
        String[] answers = new String[]{"Sweetness...", "Milkshakes for everyone", "Time for the global underground \nto rock the overground", "Silly little muggles", "My middle name is Beowulf", "Clusta da Busta", "Cluster knows how to muster his troops", "I declare today a global day of funk", "Dude! That was sweet!"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

