/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.agent.Cluster;
import com.sillysoft.lux.agent.LuxAgent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;

public class Chimera
implements LuxAgent {
    protected LuxAgent backer;
    private static Random staticRand = new Random();
    private Board board;
    protected static String[] possibleAgentTypes;
    protected static String optionsFile;

    public void setPrefs(int ID, Board board) {
        this.createOptionsFileIfNeeded();
        this.loadOptionsFileIfNeeded();
        this.board = board;
        for (int i = 0; i < 10 && this.backer == null; ++i) {
            try {
                String tryAgent = possibleAgentTypes[staticRand.nextInt(possibleAgentTypes.length)];
                this.backer = board.getAgentInstance(tryAgent);
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.backer == null) {
            this.backer = new Cluster();
        }
        this.backer.setPrefs(ID, board);
    }

    public String name() {
        return "Chimera";
    }

    public String realName() {
        return this.backer.name();
    }

    public float version() {
        return 1.2f;
    }

    public String description() {
        return "Chimera has many different heads.";
    }

    public String message(String message, Object data) {
        if ("youLose".equals(message)) {
            this.board.sendEmote("reveals the shattered core of a " + this.backer.name(), this);
        }
        return this.backer.message(message, data);
    }

    public String youWon() {
        return this.backer.youWon() + "\n(" + this.backer.name() + ")";
    }

    public int pickCountry() {
        return this.backer.pickCountry();
    }

    public void placeInitialArmies(int numberOfArmies) {
        this.backer.placeInitialArmies(numberOfArmies);
    }

    public int moveArmiesIn(int countryCodeAttacker, int countryCodeDefender) {
        return this.backer.moveArmiesIn(countryCodeAttacker, countryCodeDefender);
    }

    public void fortifyPhase() {
        this.backer.fortifyPhase();
    }

    public void cardsPhase(Card[] cards) {
        this.backer.cardsPhase(cards);
    }

    public void placeArmies(int numberOfArmies) {
        this.backer.placeArmies(numberOfArmies);
    }

    public void attackPhase() {
        this.backer.attackPhase();
    }

    protected void createOptionsFileIfNeeded() {
        Chimera chimera = this;
        File file = new File(chimera.board.getAgentPath() + optionsFile);
        if (!file.exists()) {
            this.createOptionsFile();
        }
    }

    protected void createOptionsFile() {
        try {
            Chimera chimera = this;
            PrintWriter p = new PrintWriter(new FileWriter(chimera.board.getAgentPath() + optionsFile));
            p.println("# Chimera configuration file");
            p.println("# Lines beginning with # are comments and will be ignored.");
            p.println();
            p.println("# List the bots you want Chimera to randomly select from, one per line:");
            p.println();
            p.println("Bort");
            p.println("Boscoe");
            p.println("BotOfDoom");
            p.println("Brainiac");
            p.println("EvilPixie");
            p.println("Killbot");
            p.println("Nefarious");
            p.println("Quo");
            p.println("Reaper");
            p.println("Sparrow");
            p.println("Trotsky");
            p.close();
        }
        catch (IOException e) {
            System.out.println(this.name() + " createKeywordsFile() exception " + e);
        }
    }

    protected void loadOptionsFileIfNeeded() {
        if (possibleAgentTypes == null) {
            BufferedReader inputStream = null;
            try {
                String line;
                Chimera chimera = this;
                inputStream = new BufferedReader(new FileReader(chimera.board.getAgentPath() + optionsFile));
                Vector<String> agentList = new Vector<String>();
                while ((line = inputStream.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().equals("")) continue;
                    agentList.add(line);
                }
                possibleAgentTypes = new String[agentList.size()];
                for (int i = 0; i < possibleAgentTypes.length; ++i) {
                    Chimera.possibleAgentTypes[i] = (String)agentList.get(i);
                }
            }
            catch (IOException e) {
                System.out.println(this.name() + " loadOptionsFileIfNeeded() exception " + e);
            }
            if (possibleAgentTypes == null) {
                possibleAgentTypes = new String[]{"Boscoe", "EvilPixie", "Killbot", "Quo", "Nefarious", "BotOfDoom", "Brainiac", "Trotsky", "Reaper", "Bort", "Sparrow"};
            }
        }
    }

    static {
        optionsFile = "Chimera.txt";
    }
}

