/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.SmartAgentBase;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.CountryCluster;
import com.sillysoft.lux.util.CountryClusterSet;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.NeighborIterator;
import java.util.ArrayList;

public class BetterPixie
extends SmartAgentBase {
    float outnumberBy = 1.0f;
    protected int borderForce = 20;
    boolean[] ourConts;

    public String name() {
        return "BetterPixie";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "BetterPixie is a lovable little sprite. She enjoys kicking your ass.";
    }

    public void cardsPhase(Card[] cards) {
        super.cardsPhase(cards);
        this.cashCardsIfPossible(cards);
    }

    public int pickCountry() {
        if (this.goalCont == -1) {
            this.setGoalToLeastBordersCont();
        }
        return this.pickCountryInContinent(this.goalCont);
    }

    boolean placeHogWild(int numberOfArmies) {
        return false;
    }

    boolean setupOurConts(int numberOfArmies) {
        if (this.ourConts == null) {
            this.ourConts = new boolean[this.numContinents];
        }
        int[] neededForCont = new int[this.numContinents];
        int i = 0;
        while (i < this.numContinents) {
            neededForCont[i] = BoardHelper.getEnemyArmiesInContinent(this.ID, i, this.countries);
            int n = i;
            neededForCont[n] = (int)((double)neededForCont[n] * 1.3);
            int ourArmiesNearCont = BoardHelper.getPlayerArmiesInContinent(this.ID, i, this.countries) + BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, i, this.countries);
            CountryRoute bestRoute = new CountryRoute(BoardHelper.cheapestRouteFromOwnerToCont(this.ID, i, this.countries), this.countries);
            int ourArmiesFartherAway = bestRoute.start().getArmies() - (int)((double)bestRoute.costNotCountingPlayer(this.ID) * 1.2);
            int n2 = i++;
            neededForCont[n2] = neededForCont[n2] - Math.max(ourArmiesNearCont, ourArmiesFartherAway);
        }
        boolean ownNoContinents = !BoardHelper.playerOwnsAnyPositiveContinent(this.ID, this.countries, this.board);
        int lowestArmiesNeededToTake = 1000000;
        int targetCont = -1;
        boolean wantACont = false;
        for (int i2 = 0; i2 < this.numContinents; ++i2) {
            if (ownNoContinents) {
                if (neededForCont[i2] < lowestArmiesNeededToTake && this.board.getContinentBonus(i2) > 0) {
                    lowestArmiesNeededToTake = neededForCont[i2];
                    targetCont = i2;
                }
                this.ourConts[i2] = false;
                continue;
            }
            if ((double)neededForCont[i2] < (double)numberOfArmies / ((double)this.numContinents / 4.0) && this.board.getContinentBonus(i2) > 0) {
                this.ourConts[i2] = true;
                wantACont = true;
                continue;
            }
            this.ourConts[i2] = false;
        }
        if (ownNoContinents) {
            if (targetCont == -1) {
                return false;
            }
            this.ourConts[targetCont] = true;
            return true;
        }
        return wantACont;
    }

    public void placeArmies(int numberOfArmies) {
        if (this.placeHogWild(numberOfArmies)) {
            return;
        }
        if (!this.setupOurConts(numberOfArmies)) {
            this.placeArmiesToTakeCont(numberOfArmies, this.getEasiestContToTake());
            return;
        }
        int armiesPlaced = 0;
        boolean oneNeedsHelp = true;
        while (armiesPlaced < numberOfArmies && oneNeedsHelp) {
            oneNeedsHelp = false;
            for (int c = 0; c < this.numContinents; ++c) {
                if (!this.ourConts[c] || !this.continentNeedsHelp(c)) continue;
                this.debug("Placing an army to take continent " + this.board.getContinentName(c));
                this.placeArmiesToTakeCont(1, c);
                ++armiesPlaced;
                oneNeedsHelp = true;
            }
        }
        if (armiesPlaced < numberOfArmies) {
            this.placeRemainder(numberOfArmies - armiesPlaced);
        }
    }

    protected void placeRemainder(int numberOfArmies) {
        this.placeNearEnemies(numberOfArmies, true);
    }

    protected void placeNearEnemies(int numberOfArmies, boolean minimumToWin) {
        int i;
        ArrayList clustersWeBorder = new ArrayList();
        CountryClusterSet clusters = CountryClusterSet.getAllCountriesNotOwnedBy(this.ID, this.countries);
        if (minimumToWin) {
            clusters.orderWeakestFirst();
        }
        for (i = 0; i < clusters.size() && numberOfArmies > 0; ++i) {
            CountryCluster cluster = clusters.getCluster(i);
            Country placeOn = cluster.getStrongestNeighborOwnedBy(this.ID);
            if (placeOn == null) continue;
            int numberToPlace = numberOfArmies / clusters.size();
            if (minimumToWin) {
                numberToPlace = cluster.estimatedNumberOfArmiesNeededToConquer() - placeOn.getArmies();
            }
            this.board.placeArmies(numberToPlace, placeOn);
            numberOfArmies -= numberToPlace;
        }
        if (numberOfArmies > 0) {
            System.out.println("BetterPixie still has " + numberOfArmies + " left to place in a really bad manner");
            i = 0;
            while (numberOfArmies > 0) {
                if (this.countries[i].getOwner() == this.ID && this.countries[i].getNumberEnemyNeighbors() > 0) {
                    this.board.placeArmies(1, i);
                    --numberOfArmies;
                }
                i = (i + 1) % this.numCountries;
            }
        }
    }

    boolean borderCountryNeedsHelp(Country border) {
        return border.getArmies() <= this.borderForce && !this.weOwnContsArround(border);
    }

    protected boolean continentNeedsHelp(int cont) {
        if (!BoardHelper.playerOwnsContinent(this.ID, cont, this.countries)) {
            return true;
        }
        int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
        for (int i = 0; i < borders.length; ++i) {
            if (!this.borderCountryNeedsHelp(this.countries[borders[i]])) continue;
            return true;
        }
        return false;
    }

    public void attackPhase() {
        int i;
        for (i = 0; i < this.numContinents; ++i) {
            if (!this.ourConts[i]) continue;
            this.attackInContinent(i);
        }
        for (i = 0; i < this.numContinents; ++i) {
            this.takeOutContinentCheck(i);
        }
        this.attackForCard();
        this.attackHogWild();
        this.attackStalemate();
    }

    protected void attackInContinent(int cont) {
        int enemyCount = BoardHelper.getEnemyArmiesInContinent(this.ID, cont, this.countries);
        enemyCount = (int)((double)enemyCount * 1.3);
        ContinentIterator continent = new ContinentIterator(cont, this.countries);
        while (continent.hasNext()) {
            if (continent.next().getOwner() == this.ID) continue;
            ++enemyCount;
        }
        int friendlyCount = BoardHelper.getPlayerArmiesInContinent(this.ID, cont, this.countries);
        this.debug("Attacking in continent " + this.board.getContinentName(cont) + ". friendlies = " + (friendlyCount += BoardHelper.getPlayerArmiesAdjoiningContinent(this.ID, cont, this.countries)) + ", enemies = " + enemyCount);
        if (enemyCount > friendlyCount) {
            return;
        }
        boolean attackMade = true;
        while (attackMade) {
            Country c;
            while (attackMade) {
                attackMade = false;
                continent = new ContinentIterator(cont, this.countries);
                while (continent.hasNext()) {
                    c = continent.next();
                    if (c.getOwner() != this.ID || this.getNumberOfEnemyNeighborsInOurConts(c) != 1 || c.getArmies() <= 1) continue;
                    Country[] adjoining = c.getAdjoiningList();
                    for (int i = 0; i < adjoining.length; ++i) {
                        if (adjoining[i].getOwner() == this.ID || !this.ourConts[adjoining[i].getContinent()] || !((float)c.getArmies() > (float)adjoining[i].getArmies() * this.outnumberBy)) continue;
                        this.board.attack(c, adjoining[i], true);
                        attackMade = true;
                    }
                }
            }
            continent = new ContinentIterator(cont, this.countries);
            while (continent.hasNext()) {
                c = continent.next();
                if (c.getOwner() == this.ID) continue;
                NeighborIterator neighbors = new NeighborIterator(c);
                while (neighbors.hasNext()) {
                    Country possAttack = neighbors.next();
                    if (possAttack.getOwner() != this.ID || !((float)possAttack.getArmies() > (float)c.getArmies() * this.outnumberBy) || c.getOwner() == this.ID || !possAttack.canGoto(c)) continue;
                    this.board.attack(possAttack, c, true);
                    attackMade = true;
                }
            }
        }
    }

    protected void takeOutContinentCheck(int cont) {
        if (BoardHelper.anyPlayerOwnsContinent(cont, this.countries) && this.board.getContinentBonus(cont) > 0 && this.countries[BoardHelper.getCountryInContinent(cont, this.countries)].getOwner() != this.ID) {
            this.debug("enemy owns continent " + cont);
            int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
            for (int b = 0; b < borders.length; ++b) {
                Country[] neigbors = this.countries[borders[b]].getAdjoiningList();
                for (int n = 0; n < neigbors.length; ++n) {
                    if (neigbors[n].getOwner() != this.ID || neigbors[n].getArmies() <= this.countries[borders[b]].getArmies() * 2 || !neigbors[n].canGoto(this.countries[borders[b]])) continue;
                    this.debug("attacking to take out continent " + cont);
                    if (this.board.attack(neigbors[n], this.countries[borders[b]], true) <= 0) continue;
                    return;
                }
            }
        }
    }

    protected int getNumberOfEnemyNeighborsInOurConts(Country c) {
        int result = 0;
        Country[] adjoining = c.getAdjoiningList();
        for (int i = 0; i < adjoining.length; ++i) {
            if (adjoining[i].getOwner() == this.ID || !this.ourConts[adjoining[i].getContinent()]) continue;
            ++result;
        }
        return result;
    }

    public int moveArmiesIn(int cca, int ccd) {
        int i;
        int testCode = this.obviousMoveArmiesInTest(cca, ccd);
        if (testCode != -1) {
            return testCode;
        }
        testCode = this.memoryMoveArmiesInTest(cca, ccd);
        if (testCode != -1) {
            return testCode;
        }
        int attackerEnemies = this.countries[cca].getNumberEnemyNeighbors();
        int defenderEnemies = this.countries[ccd].getNumberEnemyNeighbors();
        if (attackerEnemies == 0 && defenderEnemies != 0) {
            return 1000000;
        }
        if (attackerEnemies != 0 && defenderEnemies == 0) {
            return 0;
        }
        if (defenderEnemies == 0) {
            return this.countries[cca].getArmies() / 2;
        }
        ArrayList<Country> attackerEnemyList = new ArrayList<Country>();
        ArrayList<Country> defenderEnemyList = new ArrayList<Country>();
        attackerEnemies = 0;
        defenderEnemies = 0;
        Country[] adjoining = this.countries[cca].getAdjoiningList();
        for (i = 0; i < adjoining.length; ++i) {
            if (adjoining[i].getOwner() == this.ID || !this.ourConts[adjoining[i].getContinent()]) continue;
            attackerEnemyList.add(adjoining[i]);
        }
        adjoining = this.countries[ccd].getAdjoiningList();
        for (i = 0; i < adjoining.length; ++i) {
            if (adjoining[i].getOwner() == this.ID || !this.ourConts[adjoining[i].getContinent()]) continue;
            defenderEnemyList.add(adjoining[i]);
        }
        if (attackerEnemyList.size() == 0 && defenderEnemyList.size() != 0) {
            return 1000000;
        }
        if (attackerEnemyList.size() != 0 && defenderEnemyList.size() == 0) {
            return 0;
        }
        if (attackerEnemyList.size() == 0) {
            return this.countries[cca].getArmies() / 2;
        }
        ArrayList allEnemies = new ArrayList(attackerEnemyList);
        for (int i2 = 0; i2 < defenderEnemyList.size(); ++i2) {
            if (allEnemies.contains(defenderEnemyList.get(i2))) continue;
            allEnemies.add(defenderEnemyList.get(i2));
        }
        CountryClusterSet enemySet = CountryClusterSet.getHostileCountries(this.ID, allEnemies);
        if (enemySet.numberOfClusters() == 1) {
            return 1000000;
        }
        return this.countries[cca].getArmies() / 2;
    }

    public void fortifyPhase() {
        for (int i = 0; i < this.numContinents; ++i) {
            if (BoardHelper.playerOwnsContinent(this.ID, i, this.countries)) {
                while (this.fortifyContinent(i)) {
                    this.debug("Fortifying continent " + this.board.getContinentName(i));
                }
                continue;
            }
            this.fortifyContinentScraps(i);
        }
    }

    protected boolean fortifyContinent(int cont) {
        int i;
        boolean fortifiedSomething = false;
        int[] borders = BoardHelper.getContinentBorders(cont, this.countries);
        ArrayList<Country> cluster = new ArrayList<Country>();
        for (i = 0; i < borders.length; ++i) {
            cluster.add(this.countries[borders[i]]);
        }
        for (i = 0; i < cluster.size(); ++i) {
            NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() != this.ID || cluster.contains(neighbor) || neighbor.getContinent() != cont || neighbor.getMoveableArmies() <= 0) continue;
                this.debug(" -> fortify " + neighbor.getMoveableArmies() + " armies from " + neighbor + " to " + cluster.get(i));
                if (this.board.fortifyArmies(neighbor.getMoveableArmies(), neighbor, (Country)cluster.get(i)) == 1) {
                    fortifiedSomething = true;
                }
                cluster.add(neighbor);
            }
        }
        return fortifiedSomething;
    }

    protected void fortifyContinentScraps(int cont) {
        ContinentIterator e = new ContinentIterator(cont, this.countries);
        while (e.hasNext()) {
            Country c = e.next();
            if (c.getOwner() != this.ID || c.getMoveableArmies() <= 0) continue;
            int weakestArmies = 1000000;
            Country weakestLink = null;
            NeighborIterator n = new NeighborIterator(c);
            while (n.hasNext()) {
                Country themWeak;
                Country possMoveTo = n.next();
                if (possMoveTo.getOwner() != this.ID || (themWeak = possMoveTo.getWeakestEnemyNeighbor()) == null || themWeak.getArmies() >= weakestArmies) continue;
                weakestArmies = possMoveTo.getWeakestEnemyNeighbor().getArmies();
                weakestLink = possMoveTo;
            }
            Country hereWeakest = c.getWeakestEnemyNeighbor();
            if (hereWeakest != null && weakestArmies >= hereWeakest.getArmies() || weakestLink == null) continue;
            this.board.fortifyArmies(c.getMoveableArmies(), c, weakestLink);
        }
    }

    public String youWon() {
        String[] answers = new String[]{"Poof! I win"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

