/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.agent;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.util.ArmiesIterator;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.List;
import java.util.Random;

public class Angry
implements LuxAgent {
    protected int ID;
    protected Board board;
    protected Country[] countries;
    protected Random rand = new Random();

    public void setPrefs(int newID, Board theboard) {
        this.ID = newID;
        this.board = theboard;
        this.countries = this.board.getCountries();
    }

    public String name() {
        return "Angry";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Angry is an AI that likes to attack.";
    }

    public int pickCountry() {
        int goalCont = BoardHelper.getSmallestPositiveEmptyCont(this.countries, this.board);
        if (goalCont == -1) {
            goalCont = BoardHelper.getSmallestPositiveOpenCont(this.countries, this.board);
        }
        return this.pickCountryInContinent(goalCont);
    }

    protected int pickCountryInContinent(int cont) {
        ContinentIterator continent = new ContinentIterator(cont, this.countries);
        while (continent.hasNext()) {
            Country c = continent.next();
            if (c.getOwner() != -1 || c.getNumberPlayerNeighbors(this.ID) <= 0) continue;
            return c.getCode();
        }
        continent = new ContinentIterator(cont, this.countries);
        int bestCode = -1;
        int fewestNeib = 1000000;
        while (continent.hasNext()) {
            Country c = continent.next();
            if (c.getOwner() != -1 || c.getNumberNeighbors() >= fewestNeib) continue;
            bestCode = c.getCode();
            fewestNeib = c.getNumberNeighbors();
        }
        if (bestCode == -1) {
            System.out.println("ERROR in Angry.pickCountryInContinent() -> there are no open countries");
        }
        return bestCode;
    }

    public void placeInitialArmies(int numberOfArmies) {
        this.placeArmies(numberOfArmies);
    }

    public void cardsPhase(Card[] cards) {
    }

    public void placeArmies(int numberOfArmies) {
        int mostEnemies = -1;
        Country placeOn = null;
        int subTotalEnemies = 0;
        Object neighbors = null;
        PlayerIterator own = new PlayerIterator(this.ID, this.countries);
        while (own.hasNext()) {
            Country us = own.next();
            subTotalEnemies = us.getNumberEnemyNeighbors();
            if (subTotalEnemies <= mostEnemies) continue;
            mostEnemies = subTotalEnemies;
            placeOn = us;
        }
        this.board.placeArmies(numberOfArmies, placeOn);
    }

    public void attackPhase() {
        boolean madeAttack = true;
        while (madeAttack) {
            madeAttack = false;
            ArmiesIterator armies = new ArmiesIterator(this.ID, 2, this.countries);
            while (armies.hasNext()) {
                Country us = armies.next();
                Country weakestNeighbor = us.getWeakestEnemyNeighbor();
                if (weakestNeighbor == null || us.getArmies() <= weakestNeighbor.getArmies()) continue;
                this.board.attack(us, weakestNeighbor, true);
                madeAttack = true;
            }
        }
    }

    public int moveArmiesIn(int cca, int ccd) {
        int Denemies;
        int Aenemies = this.countries[cca].getNumberEnemyNeighbors();
        if (Aenemies > (Denemies = this.countries[ccd].getNumberEnemyNeighbors())) {
            return 0;
        }
        return this.countries[cca].getArmies() - 1;
    }

    public void fortifyPhase() {
        for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
            if (this.countries[i].getOwner() != this.ID || this.countries[i].getMoveableArmies() <= 0) continue;
            Country[] neighbors = this.countries[i].getAdjoiningList();
            int countryCodeBestProspect = -1;
            int bestEnemyNeighbors = 0;
            int enemyNeighbors = 0;
            for (int j = 0; j < neighbors.length; ++j) {
                if (neighbors[j].getOwner() != this.ID || (enemyNeighbors = neighbors[j].getNumberEnemyNeighbors()) <= bestEnemyNeighbors) continue;
                countryCodeBestProspect = neighbors[j].getCode();
                bestEnemyNeighbors = enemyNeighbors;
            }
            enemyNeighbors = this.countries[i].getNumberEnemyNeighbors();
            if (bestEnemyNeighbors > enemyNeighbors) {
                this.board.fortifyArmies(this.countries[i].getMoveableArmies(), i, countryCodeBestProspect);
                continue;
            }
            if (enemyNeighbors != 0) continue;
            int randCC = this.rand.nextInt(neighbors.length);
            this.board.fortifyArmies(this.countries[i].getMoveableArmies(), i, neighbors[randCC].getCode());
        }
    }

    public String youWon() {
        String[] answers = new String[]{"Muh-Ha-Ha-Ha\nAngry now very happy!", "Your skull is squishy and mellon-like", "ME STILL ANGRY!!!"};
        return answers[this.rand.nextInt(answers.length)];
    }

    public String message(String message, Object data) {
        if ("youLose".equals(message)) {
            int conqueringPlayerID = (Integer)data;
        } else if ("attackNotice".equals(message)) {
            List dataList = (List)data;
            int attackingCountryCode = (Integer)dataList.get(0);
            int defendingCountryCode = (Integer)dataList.get(1);
        } else if ("chat".equals(message)) {
            List dataList = (List)data;
            String from = (String)dataList.get(0);
            String chatText = (String)dataList.get(1);
        } else if ("emote".equals(message)) {
            List dataList = (List)data;
            String from = (String)dataList.get(0);
            String emoteText = (String)dataList.get(1);
        }
        return null;
    }
}

