/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.LuxObserver;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.Date;

public class Stats
implements LuxObserver {
    GameControllerAbstract control;
    private boolean[] armiesDirty;
    private boolean ownedDirty;
    private boolean incomesDirty;
    private int[] armies;
    private int[] owned;
    private int[] incomes;
    private long turnTimerStart = -1L;

    public Stats(GameControllerAbstract control) {
        this.control = control;
        int players = 6;
        this.armiesDirty = new boolean[players];
        for (int i = 0; i < players; ++i) {
            this.armiesDirty[i] = true;
        }
        this.ownedDirty = true;
        this.incomesDirty = true;
        this.armies = new int[players];
        this.owned = new int[players];
        this.incomes = new int[players];
        control.viewManager.addObserver(this);
    }

    public synchronized void setCountryOwner(int countryCode, int ownerCode) {
        this.ownedDirty = true;
        this.incomesDirty = true;
        if (ownerCode == -1) {
            return;
        }
        this.armiesDirty[ownerCode] = true;
    }

    public synchronized void setCountryArmies(int countryCode, int armies) {
        int owner = this.control.world.countries[countryCode].getOwner();
        if (owner != -1) {
            this.armiesDirty[owner] = true;
        }
    }

    public void gotoPlayer(int player) {
        if (this.control.ops.useTurnTimer) {
            this.turnTimerStart = new Date().getTime();
        }
    }

    public void gameOver(String endText) {
    }

    public void selectCountry(int code) {
    }

    public void explode(int code) {
    }

    public synchronized int getArmies(int player) {
        if (this.armiesDirty[player]) {
            this.armies[player] = 0;
            PlayerIterator owned = new PlayerIterator(player, this.control.world.countries);
            while (owned.hasNext()) {
                int n = player;
                this.armies[n] = this.armies[n] + owned.next().getArmies();
            }
            this.armiesDirty[player] = false;
        }
        return this.armies[player];
    }

    public synchronized int getOwned(int player) {
        if (this.ownedDirty) {
            this.countOwned();
        }
        return this.owned[player];
    }

    private void countOwned() {
        this.ownedDirty = true;
        for (int p = 0; p < this.owned.length; ++p) {
            this.owned[p] = 0;
        }
        Country[] countries = this.control.world.countries;
        if (countries != null) {
            for (int i = 0; i < countries.length; ++i) {
                int owner = countries[i].getOwner();
                if (owner == -1) continue;
                int n = owner;
                this.owned[n] = this.owned[n] + 1;
            }
        }
        this.ownedDirty = false;
    }

    public synchronized int getIncome(int player) {
        if (this.incomesDirty) {
            if (this.ownedDirty) {
                this.countOwned();
            }
            Country[] countries = this.control.world.countries;
            LuxWorld world = this.control.world;
            for (int p = 0; p < this.incomes.length; ++p) {
                if (this.owned[p] < 1) {
                    this.incomes[p] = 0;
                } else {
                    this.incomes[p] = this.owned[p] / 3;
                    this.incomes[p] = Math.max(this.incomes[p], 3);
                    if (this.control.ops.firstTurnContBonus || this.control.world.gameRound > 1) {
                        for (int i = 0; i < world.getNumberOfContinents(); ++i) {
                            if (!BoardHelper.playerOwnsContinent(p, i, countries)) continue;
                            int n = p;
                            this.incomes[n] = this.incomes[n] + world.getContinentBonus(i);
                        }
                    }
                    this.incomes[p] = Math.max(this.incomes[p], 3);
                }
                if (!"Empty".equals(world.getBoard().getAgentName(p))) continue;
                this.incomes[p] = 0;
            }
            this.incomesDirty = false;
        }
        return this.incomes[player];
    }

    public synchronized int getCards(int player) {
        if (player < 0 || this.control.world == null) {
            return 0;
        }
        return this.control.world.agentsCards[player].size();
    }

    public void kill() {
        if (this.control.viewManager != null) {
            this.control.viewManager.removeObserver(this);
        }
        this.control = null;
        this.owned = null;
        this.armies = null;
        this.incomes = null;
        this.armiesDirty = null;
    }

    public void reset() {
    }

    public void dirtyIncomes() {
        this.incomesDirty = true;
    }

    public void dirtyArmies(int player) {
        this.armiesDirty[player] = true;
    }

    public long getTurnTimerStart() {
        return this.turnTimerStart;
    }
}

