/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSOptionPane;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;

public class SSClassLoader
extends ClassLoader {
    private static Hashtable classes = new Hashtable();
    private char classNameReplacementChar;
    private String[] resourcesDirs;

    public static LuxMapGenerator getMapGeneratorNamed(String name) {
        SSClassLoader loader = new SSClassLoader(DesktopTool.supportFolderPath() + "MapGenerators");
        try {
            Class mapClass = loader.loadClass(name);
            LuxMapGenerator instance = (LuxMapGenerator)mapClass.newInstance();
            return instance;
        }
        catch (UnsupportedClassVersionError versionx) {
            System.out.println("SSClassLoader.getMapGeneratorNamed(" + name + ") failed on versioning.");
            SSOptionPane.showMessageDialog("'" + name + "' " + Translator.getString("javaUpdateText") + " " + Translator.getString(SS.isMacintosh ? "javaUpdateInstructionsMac" : "javaUpdateInstructionsOther"), Translator.getString("javaUpdateTitle"));
            return null;
        }
        catch (Throwable t) {
            System.out.println("SSClassLoader.getMapGeneratorNamed(" + name + ") failed.");
            t.printStackTrace();
            return null;
        }
    }

    public static LuxAgent getAgentNamed(String name) {
        SSClassLoader loader = new SSClassLoader(DesktopTool.supportFolderPath() + "Agents");
        try {
            Class agentClass = loader.loadClass(name);
            LuxAgent instance = (LuxAgent)agentClass.newInstance();
            return instance;
        }
        catch (UnsupportedClassVersionError versionx) {
            System.out.println("SSClassLoader.getAgentNamed(" + name + ") failed on versioning.");
            SSOptionPane.showMessageDialog("'" + name + "' " + Translator.getString("javaUpdateText") + " " + Translator.getString(SS.isMacintosh ? "javaUpdateInstructionsMac" : "javaUpdateInstructionsOther"), Translator.getString("javaUpdateTitle"));
            return null;
        }
        catch (Throwable t) {
            System.out.println("SSClassLoader.getAgentNamed(" + name + ") failed.");
            t.printStackTrace();
            return null;
        }
    }

    public SSClassLoader(String resourcesDir) {
        this.resourcesDirs = new String[]{resourcesDir};
    }

    public SSClassLoader(String[] resourcesDirsNew) {
        this.resourcesDirs = resourcesDirsNew;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)classes.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (ClassNotFoundException e) {
            try {
                result = super.findSystemClass("com.sillysoft.lux.agent." + className);
                return result;
            }
            catch (ClassNotFoundException e2) {
                byte[] classBytes = this.loadClassBytes(className);
                if (classBytes == null) {
                    throw new ClassNotFoundException();
                }
                result = this.defineClass(null, classBytes, 0, classBytes.length);
                if (result == null) {
                    throw new ClassFormatError();
                }
                if (resolveIt) {
                    this.resolveClass(result);
                }
                classes.put(className, result);
                return result;
            }
        }
    }

    public void setClassNameReplacementChar(char replacement) {
        this.classNameReplacementChar = replacement;
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        for (int l = 0; l < this.resourcesDirs.length; ++l) {
            String fileName = this.resourcesDirs[l] + File.separator + className;
            try {
                FileInputStream inStream = new FileInputStream(fileName);
                byte[] result = new byte[inStream.available()];
                inStream.read(result);
                inStream.close();
                return result;
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    protected String formatClassName(String className) {
        if (this.classNameReplacementChar == '\u0000') {
            return className.replace('.', '/') + ".class";
        }
        return className.replace('.', this.classNameReplacementChar) + ".class";
    }
}

