/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.MapLoader;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class RandomMapGenerator
implements LuxMapGenerator {
    private MapLoader loader;
    private Random rand;
    private int topx;
    private int topy;
    private int variance = 3;
    private double fullCircle = Math.PI * 2;
    private double thetaStep = this.fullCircle / 20.0;
    private int minRadius = 13;
    private GeneralPath[] shapes;
    private Rectangle2D[] shapeBounds;
    private int shapeCount;
    private Vector lines;
    private boolean[] connected;
    private int numCountries;
    private Country[] countries;
    private int[] contCodes;
    private int numContinents;
    private int[] contBonus;
    private Vector[] points;
    private Hashtable allPoints;
    private int[][] distanceMemory;
    private String boardSize;
    private static List choices;

    public String name() {
        return "Random";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "RandomMapGenerator is the class that Lux uses to generate the tiny-huge maps.";
    }

    public List getChoices() {
        if (choices == null) {
            choices = new Vector();
            choices.add("tiny");
            choices.add("small");
            choices.add("medium");
            choices.add("large");
            choices.add("huge");
        }
        return choices;
    }

    public boolean generate(PrintWriter out, String choice, int seed, MapLoader loader) {
        this.loader = loader;
        this.boardSize = choice;
        this.rand = new Random(seed);
        this.generateBoard();
        this.loader = null;
        return this.saveBoard(out, this.boardSize + " ID#" + seed);
    }

    public boolean canCache() {
        return true;
    }

    public void generateBoard() {
        int i;
        this.numCountries = this.boardSize.equals("tiny") ? 6 + this.rand.nextInt(11) : (this.boardSize.equals("small") ? 10 + this.rand.nextInt(11) : (this.boardSize.equals("large") ? 20 + this.rand.nextInt(11) : (this.boardSize.equals("huge") ? 30 + this.rand.nextInt(11) : 15 + this.rand.nextInt(11))));
        this.initialize();
        this.topx = RandomMapGenerator.getWidthForSize(this.boardSize);
        this.topy = RandomMapGenerator.getHeightForSize(this.boardSize);
        while (this.shapeCount < this.numCountries) {
            this.generateNugget();
        }
        this.loader.setLoadText("adding easy connections");
        this.connectShapesAt(5);
        this.loader.setLoadText("choosing continent nuggets");
        this.contCodes = new int[this.numCountries];
        this.connected = new boolean[this.numCountries];
        for (int i2 = 0; i2 < this.numCountries; ++i2) {
            this.connected[i2] = false;
            this.contCodes[i2] = -1;
        }
        int averageContinentCountries = 5;
        this.numContinents = (int)Math.ceil((double)this.numCountries / (double)averageContinentCountries);
        for (int nextContCode = 0; nextContCode < this.numContinents; ++nextContCode) {
            int biggestTreeSize = 0;
            int inBiggestTree = -1;
            for (int i3 = 0; i3 < this.numCountries; ++i3) {
                Vector tree;
                if (this.contCodes[i3] != -1 || (tree = this.getTouching(i3)).size() <= biggestTreeSize) continue;
                biggestTreeSize = tree.size();
                inBiggestTree = i3;
            }
            if (inBiggestTree != -1) {
                this.markConnectedFrom(inBiggestTree);
                this.markContinentCodeFrom(inBiggestTree, nextContCode);
                continue;
            }
            this.numContinents = nextContCode;
        }
        String currentLoadText = new String("building up nuggets");
        this.loader.setLoadText(currentLoadText);
        while (!this.isFullyConnected()) {
            int from = this.rand.nextInt(this.numCountries);
            while (this.contCodes[from] != -1) {
                from = (from + 1) % this.numCountries;
            }
            int closestShape = -1;
            int closestDistance = 1000000;
            for (int j = 0; j < this.countries.length; ++j) {
                int distance;
                if (from == j || this.countries[from].canGoto(j) || (distance = this.distanceBetween(from, j)) >= closestDistance || !this.lineCanExistBetween(from, j)) continue;
                closestDistance = distance;
                closestShape = j;
            }
            if (closestShape != -1) {
                this.makeCountriesTouch(from, closestShape);
                this.addLineBetweenShapes(from, closestShape);
                if (this.contCodes[closestShape] != -1) {
                    this.markConnectedFrom(from);
                    this.markContinentCodeFrom(from, this.contCodes[closestShape]);
                }
            } else {
                System.out.println("ERROR in RandomMapGenerator.generateBoard() -> (closestShape == -1) while building up nuggets");
                System.out.println("\t-> from = " + from);
                this.markConnectedFrom(from);
                this.markContinentCodeFrom(from, this.numContinents);
                ++this.numContinents;
            }
            currentLoadText = currentLoadText + ".";
            this.loader.setLoadText(currentLoadText);
        }
        this.contBonus = new int[this.numContinents];
        for (i = 0; i < this.numContinents; ++i) {
            int size;
            this.contBonus[i] = size = BoardHelper.getContinentSize(i, this.countries);
        }
        currentLoadText = new String("fully connecting");
        this.loader.setLoadText(currentLoadText);
        this.connectShapesAt(12);
        for (i = 0; i < this.numCountries; ++i) {
            this.connected[i] = false;
        }
        this.markConnectedFrom(0);
        this.connectContinentsAt(50);
        Vector tree = this.getTouching(0);
        while (tree.size() < this.numCountries) {
            int closestShapeFrom = -1;
            int closestShapeTo = -1;
            int closestDistance = 1000000;
            for (int i4 = 0; i4 < tree.size(); ++i4) {
                int in = ((Country)tree.get(i4)).getCode();
                for (int out = 0; out < this.numCountries; ++out) {
                    int dist;
                    if (tree.contains(this.countries[out]) || (dist = this.distanceBetween(in, out)) >= closestDistance || !this.lineCanExistBetween(in, out)) continue;
                    closestDistance = dist;
                    closestShapeFrom = in;
                    closestShapeTo = out;
                }
            }
            if (closestShapeFrom == -1) {
                System.out.println("ERROR in RandomMapGenerator.generateBoard() -> (closestShapeFrom == -1) while fully connecting");
                break;
            }
            this.makeCountriesTouch(closestShapeFrom, closestShapeTo);
            this.addLineBetweenShapes(closestShapeFrom, closestShapeTo);
            tree = this.getTouching(0);
            currentLoadText = currentLoadText + ".";
            this.loader.setLoadText(currentLoadText);
        }
        double lowWrapDistance = 1000000.0;
        int lowShape = -1;
        int highShape = -1;
        for (int i5 = 0; i5 < this.numCountries; ++i5) {
            for (int j = 0; j < this.numCountries; ++j) {
                double dist = this.wrappedDistance(i5, j);
                if (!(dist < lowWrapDistance)) continue;
                lowWrapDistance = dist;
                if (this.shapeBounds[i5].getX() < this.shapeBounds[j].getX()) {
                    lowShape = i5;
                    highShape = j;
                    continue;
                }
                lowShape = j;
                highShape = i5;
            }
        }
        this.makeCountriesTouch(lowShape, highShape);
        Point2D lowPoint = null;
        Point2D highPoint = null;
        double smallestDist = 1000000.0;
        for (int i6 = 0; i6 < this.points[lowShape].size(); ++i6) {
            for (int j = 0; j < this.points[highShape].size(); ++j) {
                Point2D.Double mapHigherPoint = new Point2D.Double(((Point2D)this.points[lowShape].get(i6)).getX() + (double)this.topx, ((Point2D)this.points[lowShape].get(i6)).getY());
                double dist = mapHigherPoint.distance((Point2D)this.points[highShape].get(j));
                if (!(dist < smallestDist)) continue;
                smallestDist = dist;
                lowPoint = (Point2D)this.points[lowShape].get(i6);
                highPoint = (Point2D)this.points[highShape].get(j);
            }
        }
        Point2D.Double mapHigherPoint = new Point2D.Double(lowPoint.getX() + (double)this.topx, lowPoint.getY());
        Point2D.Double mapLowerPoint = new Point2D.Double(highPoint.getX() - (double)this.topx, highPoint.getY());
        this.lines.add(new Line2D.Float(highPoint, mapHigherPoint));
        this.lines.add(new Line2D.Float(mapLowerPoint, lowPoint));
    }

    public static int getWidthForSize(String boardSize) {
        if ("tiny".equals(boardSize)) {
            return 600;
        }
        if ("small".equals(boardSize)) {
            return 675;
        }
        if ("large".equals(boardSize)) {
            return 850;
        }
        if ("huge".equals(boardSize)) {
            return 1000;
        }
        return 750;
    }

    public static int getHeightForSize(String boardSize) {
        if ("tiny".equals(boardSize)) {
            return 266;
        }
        if ("small".equals(boardSize)) {
            return 366;
        }
        if ("large".equals(boardSize)) {
            return 566;
        }
        if ("huge".equals(boardSize)) {
            return 666;
        }
        return 466;
    }

    private double wrappedDistance(int i, int j) {
        int higher;
        int lower;
        if (this.shapeBounds[i].getX() < this.shapeBounds[j].getX()) {
            lower = i;
            higher = j;
        } else {
            lower = j;
            higher = i;
        }
        Point2D.Double mapHigherPoint = new Point2D.Double(this.shapeBounds[lower].getX() + (double)this.topx, this.shapeBounds[lower].getY());
        Point2D.Double highPoint = new Point2D.Double(this.shapeBounds[higher].getX() + this.shapeBounds[higher].getWidth(), this.shapeBounds[higher].getY());
        return mapHigherPoint.distance(highPoint);
    }

    private void initialize() {
        this.shapeCount = 0;
        this.shapes = new GeneralPath[this.numCountries];
        this.shapeBounds = new Rectangle2D[this.numCountries];
        this.points = new Vector[this.numCountries];
        this.allPoints = new Hashtable();
        this.countries = new Country[this.numCountries];
        this.lines = new Vector();
        this.distanceMemory = new int[this.numCountries][this.numCountries];
        for (int i = 0; i < this.numCountries; ++i) {
            this.points[i] = new Vector();
            this.countries[i] = new Country(i, -1, this);
            for (int j = 0; j < this.numCountries; ++j) {
                this.distanceMemory[i][j] = -1;
            }
        }
    }

    private void connectShapesAt(int level) {
        for (int i = 0; i < this.numCountries; ++i) {
            for (int j = 0; j < this.numCountries; ++j) {
                if (i == j || this.countries[i].canGoto(this.countries[j]) || this.distanceBetween(i, j) >= level) continue;
                this.makeCountriesTouch(i, j);
                this.addLineBetweenShapes(i, j);
            }
        }
    }

    private void connectContinentsAt(int level) {
        for (int i = 0; i < this.numCountries; ++i) {
            for (int j = 0; j < this.numCountries; ++j) {
                if (i == j || this.countries[i].canGoto(this.countries[j]) || this.countries[i].getContinent() == this.countries[j].getContinent() || this.distanceBetween(i, j) >= level || !this.lineCanExistBetween(i, j)) continue;
                this.makeCountriesTouch(i, j);
                this.addLineBetweenShapes(i, j);
            }
        }
    }

    private void generateNugget() {
        double x = 30 + this.rand.nextInt(this.topx - 60);
        double y = 30 + this.rand.nextInt(this.topy - 60);
        if (x < 300.0 && y < 120.0) {
            this.generateNugget();
            return;
        }
        if (!this.createShapeAt(x, y)) {
            this.generateNugget();
            return;
        }
        int nuggetBase = this.shapeCount - 1;
        Vector<Integer> nuggetShapeIndexes = new Vector<Integer>();
        nuggetShapeIndexes.add(new Integer(nuggetBase));
        int desiredContSize = 2 + this.rand.nextInt(8);
        for (int tries = 0; nuggetShapeIndexes.size() < desiredContSize && tries < 30 && this.shapeCount < this.numCountries; ++tries) {
            int closeToShape = nuggetBase;
            Point2D randPoint = (Point2D)this.points[closeToShape].get(this.rand.nextInt(this.points[closeToShape].size()));
            if (this.shapes[closeToShape].contains(randPoint.getX() - 5.0, randPoint.getY())) {
                x = randPoint.getX() + (double)(this.minRadius * 2);
                y = randPoint.getY();
            } else {
                x = randPoint.getX() - (double)(this.minRadius * 2);
                y = randPoint.getY();
            }
            if (!this.createShapeAt(x, y)) continue;
            nuggetShapeIndexes.add(new Integer(this.shapeCount - 1));
        }
    }

    private boolean createShapeAt(double x, double y) {
        this.generateNextShapeAroundPoint(x, y);
        if (this.shapes[this.shapeCount] != null) {
            this.shapeBounds[this.shapeCount] = this.shapes[this.shapeCount].getBounds2D();
        }
        if (this.shapes[this.shapeCount] != null && this.shapeBounds[this.shapeCount].getWidth() > 40.0 && this.shapeBounds[this.shapeCount].getHeight() > 40.0 && this.shapeBounds[this.shapeCount].getWidth() < (double)(this.topx / 3) && this.shapeBounds[this.shapeCount].getHeight() < (double)(this.topy / 3)) {
            this.addReverseLinks(this.countries[this.shapeCount]);
            for (int p = 0; p < this.points[this.shapeCount].size(); ++p) {
                Object key = this.allPoints.get(this.points[this.shapeCount].get(p));
                if (key == null) {
                    this.allPoints.put(this.points[this.shapeCount].get(p), new Integer(1));
                    continue;
                }
                this.allPoints.put(this.points[this.shapeCount].get(p), new Integer((Integer)key + 1));
            }
            ++this.shapeCount;
            this.loader.setLoadText("creating board. shapeCount -> " + this.shapeCount + "/" + this.numCountries);
            return true;
        }
        this.countries[this.shapeCount].clearAdjoiningList(this);
        this.points[this.shapeCount] = new Vector();
        return false;
    }

    public void generateNextShapeAroundPoint(double pointx, double pointy) {
        int i;
        Point2D.Double shapeOrigin = new Point2D.Double(pointx, pointy);
        if (this.isInShapes(shapeOrigin) != -1) {
            this.shapes[this.shapeCount] = null;
            return;
        }
        this.shapes[this.shapeCount] = new GeneralPath();
        GeneralPath shape = this.shapes[this.shapeCount];
        double theta = 0.001;
        double radius = 35 + this.rand.nextInt(30);
        Point2D p = this.pointFromPolar(shapeOrigin, theta, radius);
        Point2D mid = this.getMiddlePoint(shapeOrigin, p);
        if (this.isInShapes(mid) != -1) {
            p = mid;
            radius = shapeOrigin.distance(p);
        }
        while (radius >= (double)this.minRadius && this.isInShapes(p) != -1) {
            p = this.pointFromPolar(shapeOrigin, theta, radius -= 5.0);
        }
        if (radius < (double)this.minRadius) {
            this.shapes[this.shapeCount] = null;
            return;
        }
        if (!this.validPoint(p)) {
            this.shapes[this.shapeCount] = null;
            return;
        }
        this.points[this.shapeCount].add(p);
        shape.moveTo((float)p.getX(), (float)p.getY());
        double initialRadius = radius;
        while (theta < 6.2 && theta != 0.0) {
            int conflict;
            radius = shapeOrigin.distance(shape.getCurrentPoint());
            if (radius < (double)this.minRadius) {
                this.shapes[this.shapeCount] = null;
                return;
            }
            theta = this.calcTheta(shapeOrigin, shape.getCurrentPoint());
            if (theta == -1.0) {
                this.shapes[this.shapeCount] = null;
                return;
            }
            radius = Math.max(this.nearNumber(radius), (double)this.minRadius);
            if ((theta += this.thetaStep) > this.fullCircle - this.thetaStep || theta == 0.0) break;
            if (theta > 4.712) {
                double maxDifference = (this.fullCircle - theta) * 360.0 / (2.0 * this.fullCircle);
                if (initialRadius - radius > (maxDifference = Math.abs(maxDifference))) {
                    radius = initialRadius - maxDifference;
                } else if (radius - initialRadius > maxDifference) {
                    radius = initialRadius + maxDifference;
                }
            }
            if ((conflict = this.isInShapes(p = this.pointFromPolar(shapeOrigin, theta, radius))) == -1) {
                mid = this.getMiddlePoint(shape.getCurrentPoint(), p);
                conflict = this.isInShapes(mid);
            }
            if (conflict == -1) {
                if (!this.validPoint(p)) {
                    this.shapes[this.shapeCount] = null;
                    return;
                }
                this.points[this.shapeCount].add(p);
                shape.lineTo((float)p.getX(), (float)p.getY());
                continue;
            }
            this.countries[this.shapeCount].addToAdjoiningList(this.countries[conflict], this);
            int borderPoint = this.getClosestBorderNotInShape(shape.getCurrentPoint(), conflict, this.shapeCount);
            if (borderPoint == -1) {
                this.shapes[this.shapeCount] = null;
                return;
            }
            p = (Point2D)this.points[conflict].get(borderPoint);
            this.points[this.shapeCount].add(p);
            shape.lineTo((float)p.getX(), (float)p.getY());
            double lastRadius = shapeOrigin.distance(p);
            double lastTheta = this.calcTheta(shapeOrigin, p);
            if (lastTheta == -1.0) {
                this.shapes[this.shapeCount] = null;
                return;
            }
            boolean keepFollowingBorder = true;
            while (keepFollowingBorder && theta < this.fullCircle - this.thetaStep && theta != 0.0) {
                if (--borderPoint == -1) {
                    borderPoint = this.points[conflict].size() - 1;
                }
                p = (Point2D)this.points[conflict].get(borderPoint);
                radius = shapeOrigin.distance(p);
                theta = this.calcTheta(shapeOrigin, p);
                if (theta == -1.0) {
                    this.shapes[this.shapeCount] = null;
                    return;
                }
                if (theta < lastTheta && lastRadius < radius) {
                    keepFollowingBorder = false;
                    continue;
                }
                lastTheta = theta;
                lastRadius = radius;
                this.points[this.shapeCount].add(p);
                shape.lineTo((float)p.getX(), (float)p.getY());
                Object key = this.allPoints.get(p);
                if (key == null || (Integer)key <= 1) continue;
                keepFollowingBorder = false;
            }
        }
        shape.closePath();
        Rectangle2D eatCheck = shape.getBounds2D();
        eatCheck = new Rectangle2D.Double(eatCheck.getX() - 2.0, eatCheck.getY() - 2.0, eatCheck.getWidth() + 4.0, eatCheck.getHeight() + 4.0);
        for (i = 0; i < this.shapeCount; ++i) {
            if (!eatCheck.contains(this.shapeBounds[i])) continue;
            this.shapes[this.shapeCount] = null;
            return;
        }
        eatCheck = shape.getBounds2D();
        for (i = 0; i < this.shapeCount; ++i) {
            if (!this.shapeBounds[i].contains(eatCheck)) continue;
            this.shapes[this.shapeCount] = null;
            return;
        }
    }

    private Point2D pointFromPolar(Point2D origin, double theta, double radius) {
        return new Point2D.Double(origin.getX() + Math.cos(theta) * radius, origin.getY() + Math.sin(theta) * radius);
    }

    private double calcTheta(Point2D origin, Point2D p) {
        double ydiff = p.getY() - origin.getY();
        double xdiff = p.getX() - origin.getX();
        double yabs = Math.abs(ydiff);
        double radius = p.distance(origin);
        if (radius <= 0.0) {
            return -1.0;
        }
        double lastTheta = ydiff >= 0.0 && xdiff >= 0.0 ? Math.asin(yabs / radius) : (ydiff >= 0.0 ? Math.PI - Math.asin(yabs / radius) : (ydiff < 0.0 && xdiff < 0.0 ? Math.PI + Math.asin(yabs / radius) : Math.PI * 2 - Math.asin(yabs / radius)));
        return lastTheta;
    }

    private void addReverseLinks(Country c) {
        Country[] adList = c.getAdjoiningList();
        if (adList != null) {
            for (int i = 0; i < adList.length; ++i) {
                adList[i].addToAdjoiningList(c, this);
            }
        }
    }

    private int getClosestBorderNotInShape(Point2D p, int shape, int notShape) {
        int closestPoint = -1;
        double closestDistance = 1.0E8;
        for (int i = 0; i < this.points[shape].size(); ++i) {
            Point2D next = (Point2D)this.points[shape].get(i);
            double dist = p.distance(next);
            if (!(dist < closestDistance)) continue;
            boolean usePoint = true;
            for (int j = 0; j < this.points[notShape].size() && usePoint; ++j) {
                Point2D point = (Point2D)this.points[notShape].get(j);
                if (next.getX() != point.getX() || next.getY() != point.getY()) continue;
                usePoint = false;
            }
            if (!usePoint) continue;
            closestDistance = dist;
            closestPoint = i;
        }
        if (closestPoint == -1) {
            System.out.println("Error in CreateBoard.getClosestBorderNotInShape p=" + p + ", shape=" + shape);
        }
        return closestPoint;
    }

    private int getClosestBorder(Point2D p, int shape) {
        int closestPoint = -1;
        double closestDistance = 1.0E8;
        for (int i = 0; i < this.points[shape].size(); ++i) {
            double dist;
            Point2D next = (Point2D)this.points[shape].get(i);
            if (next.getX() == p.getX() && next.getY() == p.getY() || !((dist = p.distance(next)) < closestDistance)) continue;
            closestDistance = dist;
            closestPoint = i;
        }
        if (closestPoint == -1) {
            System.out.println("Error in CreateBoard.getClosestBorder p=" + p + ", shape=" + shape);
        }
        return closestPoint;
    }

    private Vector getTouching(int from) {
        Vector<Country> touches = new Vector<Country>();
        touches.add(this.countries[from]);
        for (int i = 0; i < touches.size(); ++i) {
            Country[] lookTouches = ((Country)touches.get(i)).getAdjoiningList();
            if (lookTouches == null) continue;
            for (int n = 0; n < lookTouches.length; ++n) {
                if (touches.contains(lookTouches[n])) continue;
                touches.add(lookTouches[n]);
            }
        }
        return touches;
    }

    private void markConnectedFrom(int from) {
        Vector<Country> toLookAt = new Vector<Country>();
        toLookAt.add(this.countries[from]);
        while (toLookAt.size() > 0) {
            this.connected[((Country)toLookAt.get((int)0)).getCode()] = true;
            Country[] lookTouches = ((Country)toLookAt.get(0)).getAdjoiningList();
            if (lookTouches != null) {
                for (int i = 0; i < lookTouches.length; ++i) {
                    if (this.connected[lookTouches[i].getCode()]) continue;
                    toLookAt.add(lookTouches[i]);
                }
            }
            toLookAt.removeElementAt(0);
        }
    }

    private void markContinentCodeFrom(int from, int code) {
        Vector touches = this.getTouching(from);
        for (int i = 0; i < touches.size(); ++i) {
            this.countries[((Country)touches.get(i)).getCode()].setContinentCode(code, this);
            this.contCodes[((Country)touches.get((int)i)).getCode()] = code;
        }
    }

    private boolean isFullyConnected() {
        for (int i = 0; i < this.connected.length; ++i) {
            if (this.connected[i]) continue;
            return false;
        }
        return true;
    }

    private int isInShapes(Point2D p) {
        for (int i = 0; i < this.shapeCount; ++i) {
            if (!this.shapeBounds[i].contains(p) || !this.shapes[i].contains(p)) continue;
            return i;
        }
        return -1;
    }

    public double nearNumber(double near) {
        double next = this.rand.nextGaussian();
        next *= (double)this.variance;
        return next += near;
    }

    private boolean validPoint(Point2D point) {
        double x = point.getX();
        double y = point.getY();
        int minX = 20;
        int minY = 15;
        int maxX = this.topx - 20;
        int maxY = this.topy - 40;
        return !(x < (double)minX || y < (double)minY || x > (double)maxX) && !(y > (double)maxY);
    }

    public boolean lineCanExistBetween(int s1, int s2) {
        int i;
        Point2D p1 = null;
        Point2D p2 = null;
        int smallDist = this.distanceBetween(s1, s2);
        for (i = 0; i < this.points[s1].size() && p1 == null; ++i) {
            for (int j = 0; j < this.points[s2].size() && p1 == null; ++j) {
                int dist = (int)((Point2D)this.points[s1].get(i)).distance((Point2D)this.points[s2].get(j));
                if (dist != smallDist) continue;
                p1 = (Point2D)this.points[s1].get(i);
                p2 = (Point2D)this.points[s2].get(j);
            }
        }
        for (i = 0; i < this.lines.size(); ++i) {
            Line2D check = (Line2D)this.lines.get(i);
            if (!check.intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY())) continue;
            return false;
        }
        for (i = 0; i < this.shapeCount; ++i) {
            if (i == s1 || i == s2 || !this.shapeBounds[i].intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY())) continue;
            return false;
        }
        return true;
    }

    public Point2D getMiddlePoint(Point2D p1, Point2D p2) {
        return new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
    }

    private void addLineBetweenShapes(int from, int to) {
        int smallDist = this.distanceBetween(from, to);
        for (int i = 0; i < this.points[from].size(); ++i) {
            for (int j = 0; j < this.points[to].size(); ++j) {
                int dist = (int)((Point2D)this.points[from].get(i)).distance((Point2D)this.points[to].get(j));
                if (dist != smallDist) continue;
                this.lines.add(new Line2D.Double((Point2D)this.points[from].get(i), (Point2D)this.points[to].get(j)));
                return;
            }
        }
    }

    private void makeCountriesTouch(int from, int to) {
        this.countries[from].addToAdjoiningListBoth(this.countries[to], this);
    }

    private int distanceBetween(int from, int to) {
        if (this.distanceMemory[from][to] == -1) {
            double smallDist = 1000000.0;
            for (int i = 0; i < this.points[from].size(); ++i) {
                for (int j = 0; j < this.points[to].size(); ++j) {
                    double dist = ((Point2D)this.points[from].get(i)).distance((Point2D)this.points[to].get(j));
                    if (!(dist < smallDist)) continue;
                    smallDist = dist;
                }
            }
            this.distanceMemory[from][to] = (int)smallDist;
            this.distanceMemory[to][from] = (int)smallDist;
        }
        return this.distanceMemory[from][to];
    }

    private String getRandomTheme() {
        int code = this.rand.nextInt(11);
        if (code < 5) {
            return "Ocean";
        }
        if (code < 8) {
            return "Space";
        }
        if (code < 10) {
            return "Air";
        }
        return "Huh";
    }

    public boolean saveBoard(PrintWriter file, String mapName) {
        int i;
        if (this.numContinents < 2) {
            return false;
        }
        file.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard>");
        file.println("<version>1.1</version>");
        file.println("<width>" + this.topx + "</width>");
        file.println("<height>" + this.topy + "</height>");
        file.println("<title>" + mapName + "</title>");
        file.println("<theme>" + this.getRandomTheme() + "</theme>");
        RandomMapGenerator randomMapGenerator = this;
        file.println("<author>Lux version " + randomMapGenerator.loader.getLuxVersion() + "</author>");
        file.println("<email>lux@sillysoft.net</email>");
        file.println("<webpage>http://sillysoft.net</webpage>");
        file.println("<description>A randomly generated map.</description>");
        file.println("");
        int scenarioOwnerCount = this.getScenarioPlayerCountForSize(this.boardSize) - 1;
        for (i = 0; i < this.numContinents; ++i) {
            file.println("<continent>");
            file.println("<bonus>" + this.contBonus[i] + "</bonus>");
            ContinentIterator continentIter = new ContinentIterator(i, this.countries);
            while (continentIter.hasNext()) {
                Country c = continentIter.next();
                int code = c.getCode();
                String pointList = "";
                for (int n = 0; n < this.points[code].size(); ++n) {
                    pointList = pointList + (int)((Point2D)this.points[code].get(n)).getX() + "," + (int)((Point2D)this.points[code].get(n)).getY() + " ";
                }
                Country[] neighbors = c.getAdjoiningList();
                String adList = String.valueOf(neighbors[0].getCode());
                for (int n = 1; n < neighbors.length; ++n) {
                    adList = adList + "," + neighbors[n].getCode();
                }
                file.println("<country><id>" + code + "</id><polygon>" + pointList + "</polygon><adjoining>" + adList + "</adjoining><initialOwner>" + scenarioOwnerCount + "</initialOwner></country>");
                if (--scenarioOwnerCount >= 0) continue;
                scenarioOwnerCount = this.getScenarioPlayerCountForSize(this.boardSize) - 1;
            }
            file.println("</continent>");
        }
        for (i = 0; i < this.lines.size(); ++i) {
            Line2D line = (Line2D)this.lines.get(i);
            file.println("<line><position>" + (int)line.getP1().getX() + "," + (int)line.getP1().getY() + " " + (int)line.getP2().getX() + "," + (int)line.getP2().getY() + "</position></line>");
        }
        file.println("</luxboard>");
        file.close();
        return true;
    }

    public int getScenarioPlayerCountForSize(String boardSize) {
        if (boardSize.equals("tiny")) {
            return 3;
        }
        if (boardSize.equals("small")) {
            return 4;
        }
        if (boardSize.equals("medium")) {
            return 4;
        }
        if (boardSize.equals("large")) {
            return 5;
        }
        if (boardSize.equals("huge")) {
            return 6;
        }
        return 0;
    }

    public String message(String message, Object data) {
        if ("scenarioPlayerCount".equals(message)) {
            String choice = (String)data;
            return "" + this.getScenarioPlayerCountForSize(choice);
        }
        return null;
    }
}

