/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.ContinentSequence;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.DelayedRecordBookEntry;
import com.sillysoft.lux.DelayedRecordBookEntryEndGame;
import com.sillysoft.lux.Dice;
import com.sillysoft.lux.DiceOdds;
import com.sillysoft.lux.SSClassLoader;
import com.sillysoft.lux.agent.Boring;
import com.sillysoft.lux.agent.HumanAgent;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.agent.Pixie;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.LuxView;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.widgets.SoundEffect;
import java.util.Random;
import java.util.Vector;

public class LuxWorld
implements Runnable {
    private int[] finalRounds;
    public int[] finalPosition;
    private int playersEliminated = 0;
    private Thread worldThread;
    private boolean killed = false;
    private static int delay;
    private Board board;
    public int currentPlayer;
    public int gamePhase;
    public int turnPhase;
    public int gameRound;
    public Country[] countries;
    private LuxAgent[] agents;
    Vector[] agentsCards;
    private Vector cardDeck;
    private int wildsInDeck;
    private int armiesFromCards;
    private boolean tookOverACountry;
    private Random rand;
    private int userArmiesToPlace;
    private int armiesLeftToPlace;
    private int eachPlayerGetsArmies;
    public int userSelectedCountry;
    private int placeInitialPerCall = 4;
    private boolean userAttackWasShifted;
    private boolean userFlipTillDeath;
    public int userAttackedTo;
    private int userAttackedFrom;
    GameControllerAbstract control;
    private int[] contBonus;
    private int[] contBonusOriginal;
    private boolean stasisMode = false;
    private boolean noHumanSpeedupActive = false;
    private Dice dice = new DiceOdds();
    private boolean[] playerActiveMemory1;
    private boolean[] playerActiveMemory2;
    public boolean firstSelection = false;
    private boolean canChooseCountry = false;
    boolean takingOverTurn = false;
    private boolean restoringSavedGame = false;
    private int lastAttackTo = -1;
    private int lastAttackFrom = -1;
    private int sameCountryAttackCount = 0;
    private static SoundEffect armySound;
    private static SoundEffect playerEliminatedSound;
    private int ignoreNextActiveCommandFromPlayerIndex = -1;
    private int ignoreNextCount = 0;
    private static String oftooltip;
    private int lastPlaceTo = -1;
    private int sameCountryPlaceCount = 1;
    private boolean emptyDefendersAttackMode = false;
    private boolean usedZeroAttack = false;

    public LuxWorld(GameControllerAbstract controlNew) {
        this.control = controlNew;
        this.userArmiesToPlace = 0;
        this.userSelectedCountry = -1;
        delay = (int)Prefs.getFloat("agentDelay", 400.0f);
        this.board = new Board(this);
        this.rand = new Random();
        this.currentPlayer = 0;
        this.turnPhase = -1;
        this.gamePhase = -1;
    }

    public void setNumCountries(int n) {
        int i;
        this.countries = new Country[n];
        this.cardDeck = new Vector();
        for (i = 0; i < n; ++i) {
            this.countries[i] = new Country(i, -1, this);
            this.cardDeck.add(new Card(i, this.rand.nextInt(3)));
        }
        this.wildsInDeck = (int)Math.ceil((double)n / 15.0);
        for (i = 0; i < this.wildsInDeck; ++i) {
            this.cardDeck.add(new Card(-1, 3));
        }
        this.cardDeck = ArrayTool.randomize(this.cardDeck);
        this.playerActiveMemory1 = new boolean[this.control.ops.playerNames.length];
        this.playerActiveMemory2 = new boolean[this.control.ops.playerNames.length];
        for (i = 0; i < this.control.ops.playerNames.length; ++i) {
            this.playerActiveMemory1[i] = true;
            this.playerActiveMemory2[i] = true;
        }
    }

    public void addCountryAdjoining(int country, int adjoining) {
        this.countries[country].addToAdjoiningList(this.countries[adjoining], this);
    }

    public void setInitialValues(int[] countryContinents, int[] countryInitialOwners, int[] countryInitialArmies, int[] contBonus, String[] contNames) throws Exception {
        int i;
        if (this.control == null) {
            try {
                Thread.yield();
                Thread.sleep(100L);
                Thread.yield();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.control == null) {
                this.debug(Thread.currentThread() + " Setting a world's values when control == null !!!!");
            }
        }
        for (i = 0; i < this.countries.length; ++i) {
            this.countries[i].setContinentCode(countryContinents[i], this);
            this.countries[i].setViewManager(this.control.viewManager);
            this.countries[i].ensureAdjoiningList(this);
            if (!this.control.ops.useScenario || !this.control.masterControl) continue;
            if (countryInitialOwners[i] < 0 || countryInitialOwners[i] >= this.control.ops.playerNames.length) {
                throw new Exception("This starting scenario in this map is broken. You must give an initial owner to every country.\n\n Bad (or missing) initialOwner in country with ID: " + i + ". \nThe bad ID was: " + countryInitialOwners[i] + ".");
            }
            this.countries[i].setOwner(countryInitialOwners[i], this);
            this.countries[i].setArmies(Math.max(1, countryInitialArmies[i]), this);
        }
        this.board.setCountries(this.countries);
        this.board.setContinentNames(contNames);
        this.contBonus = contBonus;
        this.contBonusOriginal = new int[contBonus.length];
        for (i = 0; i < this.contBonusOriginal.length; ++i) {
            this.contBonusOriginal[i] = contBonus[i];
        }
    }

    public int getContinentBonus(int cont) {
        if (this.contBonus == null) {
            return 0;
        }
        return this.contBonus[cont];
    }

    public int getNumberOfContinents() {
        return this.contBonus.length;
    }

    public void setCountryName(int country, String name) {
        this.countries[country].setName(name, this);
    }

    public void finishCreation() {
        int i;
        String[] agentTitles = this.control.ops.playerTypes;
        this.agents = new LuxAgent[agentTitles.length];
        this.agentsCards = new Vector[this.agents.length];
        this.control.setLoadText(Translator.getString("waking") + " AIs");
        SSClassLoader agentLoader = new SSClassLoader(new String[]{DesktopTool.supportFolderPath() + "Agents"});
        for (i = 0; i < this.agents.length; ++i) {
            if (agentTitles[i].equals("Human")) {
                this.agents[i] = new HumanAgent();
                continue;
            }
            if (agentTitles[i].equals("BoringAgent")) {
                this.agents[i] = new Boring();
                continue;
            }
            try {
                Class agentClass = agentLoader.loadClass(agentTitles[i]);
                this.agents[i] = (LuxAgent)agentClass.newInstance();
                this.agents[i].name();
                this.control.ops.playerTypes[i] = this.agents[i].name();
                continue;
            }
            catch (Throwable e) {
                if (this.control.masterControl) {
                    this.debug("Error in LuxWorld.initAgents() -> could not load agent '" + agentTitles[i] + "', using BoringAgent instead. 65445688");
                    e.printStackTrace();
                }
                this.agents[i] = new Boring();
            }
        }
        this.board.setAgents(this.agents);
        this.board.finished();
        for (i = 0; i < this.agents.length; ++i) {
            if (this.killed) {
                return;
            }
            try {
                this.control.setLoadText(Translator.getString("waking") + " " + agentTitles[i] + " " + Translator.getString("AI"));
                this.agents[i].setPrefs(i, this.board);
            }
            catch (Throwable e) {
                this.debug("There was an error setting prefs by " + this.agents[i].name() + ":");
                e.printStackTrace();
            }
            this.agentsCards[i] = new Vector();
        }
        this.eachPlayerGetsArmies = this.getStartingArmiesPerPlayer(this.agents.length);
        System.out.println("Starting armies per player: " + this.eachPlayerGetsArmies);
        this.finalRounds = new int[this.agents.length];
        this.finalPosition = new int[this.agents.length];
        this.playersEliminated = 0;
        this.control.setLoadText(Translator.getString("loadingComplete"));
    }

    public String getPlayerName(int player) {
        if (player < 0 || player >= this.control.ops.playerNames.length) {
            return "getPlayerName(bad index)";
        }
        return this.control.ops.playerNames[player];
    }

    public int getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void chooseCountriesRandomly() {
        for (int i = 0; !this.killed && i < this.countries.length; ++i) {
            int temp;
            while (this.countries[temp = this.rand.nextInt(this.countries.length)].getOwner() != -1 && !this.killed) {
            }
            this.countries[temp].setOwner(i % this.agents.length, this);
            if (PrefsCache.superfast) continue;
            try {
                Thread.sleep(5000 / this.countries.length);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void chooseInitialCountry() {
        if (this.gamePhase != 1) {
            this.debug("gamePhase != chooseCountryPhase in chooseInitialCountry()");
            return;
        }
        if (this.control.ops.guiControl[this.currentPlayer]) {
            this.canChooseCountry = true;
            this.control.userChooseCountries();
            this.stasis();
            return;
        }
        if (!"Human".equals(this.control.ops.playerTypes[this.currentPlayer]) && this.control.masterControl) {
            int choice;
            block8: {
                choice = -1;
                try {
                    choice = this.agents[this.currentPlayer].pickCountry();
                }
                catch (Throwable e) {
                    this.debug("There was an error choosing countries by " + this.agents[this.currentPlayer].name() + ":");
                    if (PrefsCache.superfast) break block8;
                    e.printStackTrace();
                }
            }
            if (choice < 0 || choice >= this.board.getNumberOfCountries() || this.countries[choice].getOwner() != -1) {
                while (this.countries[choice = this.rand.nextInt(this.countries.length)].getOwner() != -1) {
                }
            }
            this.countries[choice].setOwner(this.currentPlayer, this);
        } else {
            this.debug(this + " is going into stasis while a network player chooses a country");
            this.stasis();
            this.debug(this + " is leaving stasis after a network player chooses a country");
        }
    }

    public void chooseUserCountry(int c) {
        if (this.canChooseCountry && this.countries[c].getOwner() == -1) {
            this.countries[c].setOwner(this.currentPlayer, this);
            this.canChooseCountry = false;
            this.resumeWorldThread();
        }
    }

    private int getStartingArmiesPerPlayer(int numberOfPlayers) {
        float adjustFactor = (float)((double)this.countries.length / 42.0);
        adjustFactor -= 1.0f;
        adjustFactor /= 2.0f;
        adjustFactor += 1.0f;
        if (numberOfPlayers == 2) {
            return Math.round(adjustFactor * 40.0f);
        }
        if (numberOfPlayers == 3) {
            return Math.round(adjustFactor * 35.0f);
        }
        if (numberOfPlayers == 4) {
            return Math.round(adjustFactor * 30.0f);
        }
        if (numberOfPlayers == 5) {
            return Math.round(adjustFactor * 25.0f);
        }
        if (numberOfPlayers == 6) {
            return Math.round(adjustFactor * 20.0f);
        }
        return -1;
    }

    public int getTotalStartingArmies(int numberOfPlayers) {
        int oldValue = this.getTotalStartingArmiesOld(numberOfPlayers);
        float adjustFactor = (float)((double)this.countries.length / 42.0);
        SS.debug("totalSTartingArmies = " + oldValue + " * " + adjustFactor + " = " + Math.round((float)oldValue * adjustFactor));
        return Math.round((float)oldValue * adjustFactor);
    }

    public int getTotalStartingArmiesOld(int numberOfPlayers) {
        if (numberOfPlayers == 2) {
            return 80;
        }
        if (numberOfPlayers == 3) {
            return 105;
        }
        if (numberOfPlayers == 4) {
            return 120;
        }
        if (numberOfPlayers == 5) {
            return 125;
        }
        if (numberOfPlayers == 6) {
            return 120;
        }
        return -1;
    }

    private void placeInitialArmiesRandomly() {
        int i = 0;
        while (!this.killed && !this.initialArmiesGone()) {
            int agent = i % this.agents.length;
            if (!this.killed && BoardHelper.getPlayerArmies(i, this.countries) < this.eachPlayerGetsArmies) {
                int code;
                while (this.countries[code = this.rand.nextInt(this.countries.length)].getOwner() != agent) {
                }
                this.countries[code].addArmy(this);
                if (!PrefsCache.superfast) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private void placeInitialArmiesEvenly() {
        boolean placedArmy = true;
        while (placedArmy) {
            placedArmy = false;
            for (int i = 0; !this.killed && i < this.countries.length; ++i) {
                if (BoardHelper.getPlayerArmies(this.countries[i].getOwner(), this.countries) >= this.eachPlayerGetsArmies) continue;
                this.countries[i].addArmy(this);
                placedArmy = true;
                if (PrefsCache.superfast) continue;
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private boolean initialArmiesGone() {
        for (int i = 0; i < this.agents.length; ++i) {
            if (BoardHelper.getPlayerArmies(i, this.countries) >= this.eachPlayerGetsArmies) continue;
            return false;
        }
        return true;
    }

    public void placeInitialArmiesPoll() {
        if (this.control.ops.guiControl[this.currentPlayer]) {
            int leftToPlace = this.eachPlayerGetsArmies - BoardHelper.getPlayerArmies(this.currentPlayer, this.countries);
            System.out.println(this + " start placing " + leftToPlace + " armies");
            if (leftToPlace > 0) {
                int toPlace = Math.min(this.placeInitialPerCall, leftToPlace);
                if (leftToPlace == this.placeInitialPerCall + 1) {
                    ++toPlace;
                }
                this.armiesLeftToPlace = toPlace;
                this.control.setFluxBox(toPlace);
                this.control.userPlaceInitialArmies();
                this.stasis();
            } else {
                this.debug("the human doesn't have any armies left to place -- but placeInitialArmiesPoll() was called. currentPlayer:" + this.currentPlayer);
                if (!this.initialArmiesGone()) {
                    this.debug("other people still have armies to place");
                    if (this.control.masterControl) {
                        this.gotoNextPlayer();
                    } else {
                        this.gotoNextPlayer();
                        this.debug("re-encoding a gotoPlayer when skipping over our placeInitial: " + this.currentPlayer);
                        this.control.netBoss.sendToAll("gt: " + this.currentPlayer);
                    }
                }
            }
        } else {
            if (!"Human".equals(this.control.ops.playerTypes[this.currentPlayer]) && this.control.masterControl) {
                block15: {
                    int leftToPlace = this.eachPlayerGetsArmies - BoardHelper.getPlayerArmies(this.currentPlayer, this.countries);
                    if (leftToPlace > 0) {
                        int toPlace = Math.min(this.placeInitialPerCall, leftToPlace);
                        if (leftToPlace == this.placeInitialPerCall + 1) {
                            ++toPlace;
                        }
                        try {
                            this.armiesLeftToPlace = toPlace;
                            this.agents[this.currentPlayer].placeInitialArmies(toPlace);
                            if (this.armiesLeftToPlace != 0) {
                                this.debug("Agent " + this.agents[this.currentPlayer].name() + " didn't place all of his initial armies. We will place them on the biggest army.");
                                Country owned = BoardHelper.getPlayersBiggestArmy(this.currentPlayer, this.countries);
                                owned.setArmies(owned.getArmies() + this.armiesLeftToPlace, this);
                            }
                        }
                        catch (Throwable e) {
                            this.debug("There was an error placing armies by " + this.agents[this.currentPlayer].name() + ":");
                            if (!PrefsCache.superfast) {
                                e.printStackTrace();
                            }
                            if (this.armiesLeftToPlace == 0) break block15;
                            this.debug("Agent " + this.agents[this.currentPlayer].name() + " didn't place all of his initial armies. We will place them on the biggest army.");
                            Country owned = BoardHelper.getPlayersBiggestArmy(this.currentPlayer, this.countries);
                            owned.setArmies(owned.getArmies() + this.armiesLeftToPlace, this);
                        }
                    }
                }
                this.gotoNextPlayer();
                return;
            }
            this.stasis();
        }
    }

    public void placeInitialUserArmies(int country, boolean shiftPressed, int numberSelected) {
        if (this.armiesLeftToPlace < 1) {
            SS.debug("blocked placeInitialUserArmies when armiesLeftToPlace=" + this.armiesLeftToPlace);
            return;
        }
        if (this.countries[country].getOwner() == this.currentPlayer) {
            this.playArmySound();
            if (shiftPressed) {
                this.countries[country].setArmies(this.countries[country].getArmies() + this.armiesLeftToPlace, this);
                this.armiesLeftToPlace = 0;
                this.control.setFluxBox(0);
            } else {
                this.countries[country].setArmies(this.countries[country].getArmies() + numberSelected, this);
                this.armiesLeftToPlace -= numberSelected;
                this.control.setFluxBox(this.armiesLeftToPlace);
            }
            if (this.armiesLeftToPlace == 0) {
                this.gotoNextPlayer(0);
                if (this.control instanceof GameControllerGUI) {
                    ((GameControllerGUI)this.control).luxView.setProperCursor();
                }
                this.resumeWorldThread();
            }
        } else if (LuxController.getInstance().getSharewareCount() < 10) {
            this.control.showNoticeOnCountry(Translator.getString("Youmustplaceoncountryyouown"), country);
        }
    }

    public boolean cardPhase() {
        return this.turnPhase == 0;
    }

    public boolean cashUserCards(Vector cards) {
        boolean cashed = false;
        while (cards.size() > 2) {
            Object[] arr = new Card[cards.size()];
            cards.copyInto(arr);
            if (!Card.containsASet((Card[])arr)) {
                return cashed;
            }
            Card[] set = Card.getBestSet((Card[])arr, this.currentPlayer, this.countries);
            if (this.cashCards(set[0], set[1], set[2])) {
                cashed = true;
                this.userArmiesToPlace += this.armiesFromCards;
                this.control.setFluxBox(this.userArmiesToPlace);
                this.armiesFromCards = 0;
                for (int i = cards.size() - 1; i > -1; --i) {
                    if (cards.get(i) != set[0] && cards.get(i) != set[1] && cards.get(i) != set[2]) continue;
                    cards.removeElementAt(i);
                }
                continue;
            }
            SS.debug("cashUserCards -> inner cashCards call returned false.");
            return cashed;
        }
        return cashed;
    }

    public int getNextCardSetValue() {
        return this.control.ops.cardSequence.getNextCardSetValue();
    }

    public boolean cashCards(Card card1, Card card2, Card card3) {
        if (this.agentsCards[this.currentPlayer].size() < 5 && this.turnPhase != 0) {
            this.debug("oops. cashCards() was called outside of the cardsPhase.");
            return false;
        }
        if (!Card.isASet(card1, card2, card3)) {
            this.debug("oops. cashCards() was called with cards that aren't a set.");
            return false;
        }
        if (!(this.agentsCards[this.currentPlayer].contains(card1) && this.agentsCards[this.currentPlayer].contains(card1) && this.agentsCards[this.currentPlayer].contains(card1))) {
            this.debug("i don't think so. " + this.agents[this.currentPlayer].name() + " called cashCards() with cards that he doesn't have.");
            this.debug(" - player wants to cash the cards " + card1 + ", " + card2 + ", " + card3);
            StringBuffer hasCards = new StringBuffer(" - player has cards:");
            for (int i = 0; i < this.agentsCards[this.currentPlayer].size(); ++i) {
                hasCards.append(this.agentsCards[this.currentPlayer].get(i) + ", ");
            }
            this.debug(hasCards);
            this.debug(" - end list of cards");
            return false;
        }
        this.armiesFromCards += this.control.ops.cardSequence.getNextCardSetValue();
        this.control.ops.cardSequence.incrementCardSetValue();
        this.networkCashCardsFromPlayer(this.currentPlayer, card1, card2, card3);
        if (card1.getCode() != -1 && this.countries[card1.getCode()].getOwner() == this.currentPlayer) {
            this.countries[card1.getCode()].addArmy(this);
            this.countries[card1.getCode()].addArmy(this);
        }
        if (card2.getCode() != -1 && this.countries[card2.getCode()].getOwner() == this.currentPlayer) {
            this.countries[card2.getCode()].addArmy(this);
            this.countries[card2.getCode()].addArmy(this);
        }
        if (card3.getCode() != -1 && this.countries[card3.getCode()].getOwner() == this.currentPlayer) {
            this.countries[card3.getCode()].addArmy(this);
            this.countries[card3.getCode()].addArmy(this);
        }
        for (int i = this.agentsCards[this.currentPlayer].size() - 1; i > -1; --i) {
            if (this.agentsCards[this.currentPlayer].get(i) != card1 && this.agentsCards[this.currentPlayer].get(i) != card2 && this.agentsCards[this.currentPlayer].get(i) != card3) continue;
            Card used = (Card)this.agentsCards[this.currentPlayer].remove(i);
            this.cardBackInDeck(used);
        }
        this.control.cardsWereCashed();
        return true;
    }

    public void cardBackInDeck(Card used) {
        if (used.getCode() == -1) {
            int wildsInDeckCount = 0;
            for (int c = 0; c < this.cardDeck.size() && wildsInDeckCount < this.wildsInDeck; ++c) {
                if (((Card)this.cardDeck.get(c)).getCode() != -1) continue;
                ++wildsInDeckCount;
            }
            if (wildsInDeckCount < this.wildsInDeck) {
                this.cardDeck.add(used);
            }
        } else {
            this.cardDeck.add(used);
        }
    }

    private void networkCashCardsFromPlayer(int player, Card card1, Card card2, Card card3) {
        try {
            NetBoss boss = this.control.netBoss;
            if (boss != null) {
                boss.sendToAll("cardFromPlayerToDeck: " + player + " " + card1.getCode() + " " + card1.getSymbol());
                boss.sendToAll("cardFromPlayerToDeck: " + player + " " + card2.getCode() + " " + card2.getSymbol());
                boss.sendToAll("cardFromPlayerToDeck: " + player + " " + card3.getCode() + " " + card3.getSymbol());
                boss.sendToAll("incrementCardSetValue: ");
            }
        }
        catch (Throwable t) {
            this.debug("Lux -> in networkCashCards() " + t);
        }
    }

    public void cardFromPlayerToDeck(int player, int countryCode, int symbol) {
        Vector cards = this.agentsCards[player];
        Card usedCard = new Card(countryCode, symbol);
        if (cards.remove(usedCard)) {
            this.cardBackInDeck(usedCard);
        } else {
            this.debug("tried to remove a card from player " + player + ", but they didn't have it: " + usedCard + ". \nThey Have:");
            for (int i = 0; i < cards.size(); ++i) {
                this.debug(" -> " + cards.get(i));
            }
        }
    }

    private void givePlayerCardTellEveryone(int player, Card card) {
        try {
            this.givePlayerCardLocalWorld(player, card);
            NetBoss boss = this.control.netBoss;
            if (boss != null) {
                boss.sendToAll("givePlayerCard: " + player + " " + card.getCode() + " " + card.getSymbol());
            }
        }
        catch (Throwable t) {
            this.debug("Lux -> in givePlayerCardTellEveryone() " + t);
        }
    }

    public void givePlayerCardLocalWorld(int player, Card card) {
        this.agentsCards[player].add(card);
        if (this.control.ops.guiControl[player]) {
            this.control.updateCardButton(this.agentsCards[player].size(), false);
        }
    }

    public Card[] getCurrentPlayerCards() {
        Object[] cards = new Card[this.agentsCards[this.currentPlayer].size()];
        this.agentsCards[this.currentPlayer].copyInto(cards);
        return cards;
    }

    public Card[] getPlayerCards(int player) {
        if (player < 0) {
            return new Card[0];
        }
        Object[] cards = new Card[this.agentsCards[player].size()];
        this.agentsCards[player].copyInto(cards);
        return cards;
    }

    public void takeOverCurrentPlayer() {
        if (this.gamePhase == 3) {
            this.takingOverTurn = true;
            this.takingOverTurn = false;
            this.control.setFluxBox(0);
            this.turnPhase = 2;
            this.debug("Starting a turn with takingOverTurn=true, go directly to the attack phase");
        }
        if (this.gamePhase == 1) {
            this.canChooseCountry = true;
        }
    }

    public synchronized void takeOverPlayerWithAI(int playerID) {
        this.debug("takeOverPlayerWithAI(" + playerID + ")");
        this.control.takenOverPlayerNames[playerID] = "bot";
        if (this.currentPlayer == playerID) {
            this.debug("Taking over a player whose turn it currently is - with an AI");
            this.gotoNextPlayer();
        }
        this.control.ops.guiControl[playerID] = false;
        try {
            String className = LuxController.getInstance().getFirstAI();
            SSClassLoader agentLoader = new SSClassLoader(new String[]{"/Library/Application Support/Lux/Agents", DesktopTool.supportFolderPath() + "Agents"});
            Class agentClass = agentLoader.loadClass(className);
            this.agents[playerID] = (LuxAgent)agentClass.newInstance();
        }
        catch (Exception e) {
            this.agents[playerID] = new Pixie();
        }
        this.agents[playerID].setPrefs(playerID, this.board);
        this.control.ops.playerTypes[playerID] = this.agents[playerID].name();
        this.control.netBoss.println("\u2731 " + this.control.ops.playerNames[playerID] + " " + Translator.getString("nowComputerControl") + " " + this.agents[playerID].name() + " \u2731");
        this.control.netBoss.sendToAll("tra: 3 " + this.control.ops.playerNames[playerID] + " :nowComputerControl: " + this.agents[playerID].name());
    }

    public void restoreLostPlayer(int playerID) {
        this.agents[playerID] = new HumanAgent();
        this.agents[playerID].setPrefs(playerID, this.board);
        this.control.ops.playerTypes[playerID] = "Human";
    }

    private void stasis() {
        if (this.control.masterControl) {
            this.stasisMode = true;
            while (this.stasisMode && !this.killed && !this.gameIsOver()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void startUserTurn() {
        block13: {
            this.lastPlaceTo = -1;
            this.sameCountryPlaceCount = 1;
            this.lastAttackTo = -1;
            this.lastAttackFrom = -1;
            this.sameCountryAttackCount = 0;
            boolean allowFortify = true;
            if (this.restoringSavedGame) {
                try {
                    ((GameControllerGUI)this.control).giveStartingButtons();
                    this.debug("Starting a user's turn while restoring saved game values.");
                    this.restoringSavedGame = false;
                    int fluxArmies = XMLTool.extractInt("fluxArmies", this.control.ops.boardFile.contents);
                    this.control.setFluxBox(fluxArmies);
                    this.userArmiesToPlace = fluxArmies;
                    this.turnPhase = XMLTool.extractInt("turnPhase", this.control.ops.boardFile.contents);
                    this.userSelectedCountry = XMLTool.extractInt("userSelectedCountry", this.control.ops.boardFile.contents);
                    this.control.viewManager.selectCountry(this.userSelectedCountry);
                    this.tookOverACountry = new Boolean(XMLTool.extract("tookOverACountry", this.control.ops.boardFile.contents));
                    if (this.turnPhase == 2 && this.userSelectedCountry != -1) {
                        this.setAttackArrowsOnCountry(this.userSelectedCountry);
                    }
                    if (this.turnPhase == 22 && this.userSelectedCountry != -1) {
                        this.userAttackedFrom = this.userSelectedCountry;
                        this.userAttackedTo = XMLTool.extractInt("userAttackedTo", this.control.ops.boardFile.contents);
                        this.control.setArrowOnCountry(this.userAttackedFrom, this.userAttackedTo);
                    }
                    if (this.turnPhase != 3) break block13;
                    allowFortify = false;
                    String[] movableArray = StringTool.tokenize(XMLTool.extract("ma", this.control.ops.boardFile.contents), ",");
                    for (int i = 0; i < movableArray.length; ++i) {
                        this.countries[i].setMoveableArmies(Integer.parseInt(movableArray[i]), this);
                    }
                    if (this.userSelectedCountry != -1) {
                        this.countries[this.userSelectedCountry].setMoveableArmies(fluxArmies, this);
                        this.control.setArrowOnCountry(this.userSelectedCountry, this.countries[this.userSelectedCountry].getFriendlyAdjoiningCodeList());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.takingOverTurn) {
                this.takingOverTurn = false;
                this.control.setFluxBox(0);
                this.turnPhase = 2;
                this.debug("Starting a turn with takingOverTurn=true, go directly to the attack phase");
            } else {
                this.userArmiesToPlace = this.calculateCurrentPlayerIncome();
                if (this.userArmiesToPlace < 3) {
                    this.debug("Lux -> ERROR userArmiesToPlace should never be less then 3 at the start of a human's turn");
                    Thread.dumpStack();
                    this.userArmiesToPlace = 3;
                }
                this.control.setFluxBox(this.userArmiesToPlace);
                this.turnPhase = 0;
                this.tookOverACountry = false;
            }
        }
        this.armiesFromCards = 0;
        this.control.startUserTurn(this.getCurrentPlayerCards());
        if (this.control.masterControl) {
            this.stasis();
            if (!this.killed && this.userArmiesToPlace != 0) {
                this.debug("Lux -> checkpoint 76532234");
                this.stasis();
            }
        }
    }

    public void takeCurrentComputerPlayersTurn() {
        block8: {
            block7: {
                this.tookOverACountry = false;
                if (this.control.ops.playerTypes[this.currentPlayer].equals("Empty")) {
                    this.turnPhase = 3;
                    return;
                }
                this.currentComputerPlayersCardsPhase();
                this.armiesLeftToPlace = this.calculateCurrentPlayerIncome() + this.armiesFromCards;
                this.currentComputerPlayersPlacePhase();
                this.turnPhase = 2;
                try {
                    this.agents[this.currentPlayer].attackPhase();
                }
                catch (Throwable e) {
                    this.debug("There was an error in " + this.agents[this.currentPlayer] + "'s attackPhase():");
                    if (PrefsCache.superfast) break block7;
                    e.printStackTrace();
                }
            }
            if (this.tookOverACountry && this.control.ops.useCards) {
                this.tookOverACountry = false;
                this.givePlayerCardTellEveryone(this.currentPlayer, this.nextCardFromDeck());
            }
            if (this.gamePhase != 4) {
                this.turnPhase = 3;
                this.setUpMoveableArmies();
                try {
                    this.agents[this.currentPlayer].fortifyPhase();
                }
                catch (Throwable e) {
                    this.debug("There was an error in " + this.agents[this.currentPlayer] + "'s fortifyPhase():");
                    if (PrefsCache.superfast) break block8;
                    e.printStackTrace();
                }
            }
        }
    }

    private Card nextCardFromDeck() {
        if (this.cardDeck.size() > 0) {
            return (Card)this.cardDeck.remove(0);
        }
        this.debug("creating a new wildcard");
        return new Card(-1, 3);
    }

    private void currentComputerPlayersCardsPhase() {
        block3: {
            this.turnPhase = 0;
            this.armiesFromCards = 0;
            Object[] cards = new Card[this.agentsCards[this.currentPlayer].size()];
            this.agentsCards[this.currentPlayer].copyInto(cards);
            try {
                this.agents[this.currentPlayer].cardsPhase((Card[])cards);
            }
            catch (Throwable e) {
                this.debug("There was an error in " + this.agents[this.currentPlayer] + "'s cardsPhase():");
                if (PrefsCache.superfast) break block3;
                e.printStackTrace();
            }
        }
        while (this.agentsCards[this.currentPlayer].size() > 4) {
            Card[] randomSet = Card.getBestSet(this.getCurrentPlayerCards(), this.currentPlayer, this.countries);
            this.board.cashCards(randomSet[0], randomSet[1], randomSet[2]);
        }
    }

    private void currentComputerPlayersPlacePhase() {
        block3: {
            this.turnPhase = 1;
            try {
                this.agents[this.currentPlayer].placeArmies(this.armiesLeftToPlace);
            }
            catch (Throwable e) {
                this.debug("There was an error in " + this.agents[this.currentPlayer] + "'s placeArmies():");
                if (PrefsCache.superfast) break block3;
                e.printStackTrace();
            }
        }
        if (this.armiesLeftToPlace > 0) {
            this.debug("agent " + this.agents[this.currentPlayer].name() + " didn't place all of his armies. what a bozo.");
        }
    }

    private int calculateCurrentPlayerIncome() {
        return this.calculatePlayerIncome(this.currentPlayer);
    }

    public int calculatePlayerIncome(int player) {
        return this.control.stats.getIncome(player);
    }

    public void forcePlaceFluxArmies() {
        int forcePlaceCountry;
        if (this.userSelectedCountry != -1) {
            forcePlaceCountry = this.userSelectedCountry;
        } else {
            while (this.countries[forcePlaceCountry = this.rand.nextInt(this.countries.length)].getOwner() != this.currentPlayer) {
            }
        }
        this.debug("Lux -> " + this.userArmiesToPlace + " armies were placed automatically");
        this.countries[forcePlaceCountry].setArmies(this.userArmiesToPlace + this.countries[forcePlaceCountry].getArmies(), this);
        this.userArmiesToPlace = 0;
        this.control.setFluxBox(0);
    }

    public boolean placeArmies(int numberOfArmies, int countryCode) {
        if (this.countries[countryCode].getOwner() == this.currentPlayer) {
            int toPlace = Math.min(numberOfArmies, this.armiesLeftToPlace);
            this.armiesLeftToPlace -= toPlace;
            this.countries[countryCode].setArmies(this.countries[countryCode].getArmies() + toPlace, this);
            return true;
        }
        return false;
    }

    private void userAttack(int countryCodeAttacker, int countryCodeDefender) {
        boolean throttleNetworkTraffic;
        this.userAttackedFrom = countryCodeAttacker;
        this.userAttackedTo = countryCodeDefender;
        int defendingPlayer = this.countries[countryCodeDefender].getOwner();
        int temp = 0;
        if (this.emptyDefendersAttackMode) {
            this.usedZeroAttack = true;
            throttleNetworkTraffic = false;
            if (this.control.ops.allowNetworkPlayers && this.countries[countryCodeAttacker].getArmies() + this.countries[countryCodeDefender].getArmies() > 150) {
                throttleNetworkTraffic = true;
                this.control.viewManager.setThrottle(true);
            }
            while (temp == 0 && this.countries[countryCodeDefender].getArmies() > 2) {
                temp = this.innerAttack(countryCodeAttacker, countryCodeDefender);
            }
            if (throttleNetworkTraffic) {
                this.control.viewManager.setThrottle(false);
                this.countries[countryCodeAttacker].setArmies(this.countries[countryCodeAttacker].getArmies(), this);
                this.countries[countryCodeDefender].setArmies(this.countries[countryCodeDefender].getArmies(), this);
            }
        } else if (PrefsCache.attackTillDead && !this.userFlipTillDeath || PrefsCache.attackOnce && this.userFlipTillDeath) {
            throttleNetworkTraffic = false;
            if (this.control.ops.allowNetworkPlayers && this.countries[countryCodeAttacker].getArmies() + this.countries[countryCodeDefender].getArmies() > 150) {
                throttleNetworkTraffic = true;
                this.control.viewManager.setThrottle(true);
            }
            while (temp == 0) {
                temp = this.innerAttack(countryCodeAttacker, countryCodeDefender);
            }
            if (throttleNetworkTraffic) {
                this.control.viewManager.setThrottle(false);
                this.countries[countryCodeAttacker].setArmies(this.countries[countryCodeAttacker].getArmies(), this);
                this.countries[countryCodeDefender].setArmies(this.countries[countryCodeDefender].getArmies(), this);
            }
        } else if (!(PrefsCache.attackOnce || PrefsCache.attackTillDead || this.userFlipTillDeath)) {
            int tillDeaths = PrefsCache.attackTillDeaths;
            int firstAttackerSize = this.countries[countryCodeAttacker].getArmies();
            int firstDefenderSize = this.countries[countryCodeDefender].getArmies();
            int deaths = 0;
            while (temp == 0 && deaths < tillDeaths) {
                temp = this.innerAttack(countryCodeAttacker, countryCodeDefender);
                deaths = firstAttackerSize - this.countries[countryCodeAttacker].getArmies() + (firstDefenderSize - this.countries[countryCodeDefender].getArmies());
            }
        } else {
            if (this.lastAttackTo == countryCodeDefender && this.lastAttackFrom == countryCodeAttacker) {
                ++this.sameCountryAttackCount;
                if (this.sameCountryAttackCount == 12) {
                    ((GameControllerGUI)this.control).luxView.showNoticeOnCountry(Translator.getString("Attacktilldeadhint"), countryCodeDefender);
                }
            } else {
                this.lastAttackTo = countryCodeDefender;
                this.lastAttackFrom = countryCodeAttacker;
                this.sameCountryAttackCount = 1;
            }
            temp = this.innerAttack(countryCodeAttacker, countryCodeDefender);
        }
        if (temp == 7) {
            this.tookOverACountry = true;
            if (this.gameIsOver()) {
                this.playerWasEliminated(defendingPlayer, this.countries[countryCodeAttacker].getOwner());
                this.gameOver();
                return;
            }
            if (Prefs.getInt("armyAdvancement") == 1 && !this.userAttackWasShifted || Prefs.getInt("armyAdvancement") != 1 && this.userAttackWasShifted) {
                this.countries[countryCodeDefender].setArmies(this.countries[countryCodeAttacker].getArmies() - 1, this);
                this.countries[countryCodeAttacker].setArmies(1, this);
                if (this.countries[countryCodeDefender].getArmies() == 1) {
                    this.control.viewManager.selectCountry(-1);
                    this.userSelectedCountry = -1;
                    this.setAttackArrowsOnCountry(-1);
                } else {
                    this.control.viewManager.selectCountry(countryCodeDefender);
                    this.userSelectedCountry = countryCodeDefender;
                    this.setAttackArrowsOnCountry(this.userSelectedCountry);
                }
            }
            if (Prefs.getInt("armyAdvancement") == 1 && this.userAttackWasShifted || Prefs.getInt("armyAdvancement") != 1 && !this.userAttackWasShifted) {
                int movein = Math.min(3, this.countries[countryCodeAttacker].getArmies() - 1);
                this.userArmiesToPlace = this.countries[countryCodeAttacker].getArmies() - (movein + 1);
                this.control.setFluxBox(this.userArmiesToPlace);
                this.countries[countryCodeDefender].setArmies(movein, this);
                this.countries[countryCodeAttacker].setArmies(1, this);
                if (this.userArmiesToPlace == 0) {
                    if (this.countries[countryCodeDefender].getArmies() > 1) {
                        this.control.viewManager.selectCountry(countryCodeDefender);
                        this.userSelectedCountry = countryCodeDefender;
                        this.setAttackArrowsOnCountry(this.userSelectedCountry);
                    } else {
                        this.control.viewManager.selectCountry(-1);
                        this.userSelectedCountry = -1;
                        this.setAttackArrowsOnCountry(-1);
                    }
                    this.turnPhase = 2;
                } else {
                    this.control.userMoveInArmies(countryCodeDefender);
                    this.control.setArrowOnCountry(countryCodeAttacker, countryCodeDefender);
                    this.turnPhase = 22;
                }
            }
            if (0 == this.control.stats.getOwned(defendingPlayer)) {
                this.playerWasEliminated(defendingPlayer, this.countries[countryCodeAttacker].getOwner());
            }
            this.control.userAttackWin(countryCodeDefender);
        } else if (temp == 13) {
            this.control.viewManager.selectCountry(-1);
            this.userSelectedCountry = -1;
            this.setAttackArrowsOnCountry(-1);
            this.control.userAttackLose(countryCodeDefender);
        } else {
            this.control.userAttackDraw(countryCodeDefender);
        }
        if (!"Human".equals(this.control.ops.playerTypes[defendingPlayer])) {
            try {
                Vector<Integer> parameters = new Vector<Integer>();
                parameters.add(new Integer(countryCodeAttacker));
                parameters.add(new Integer(countryCodeDefender));
                this.agents[defendingPlayer].message("attackNotice", parameters);
            }
            catch (Throwable e) {
                this.debug("There was an error in " + this.agents[defendingPlayer] + "'s message(\"attackNotice\", x) phase:");
                e.printStackTrace();
            }
        }
    }

    public boolean tookOverACountry() {
        return this.tookOverACountry;
    }

    public int attack(int countryCodeAttacker, int countryCodeDefender, boolean attackTillDead) {
        int temp;
        if (countryCodeAttacker < 0 || countryCodeAttacker >= this.board.getNumberOfCountries()) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() with a bad attacker parameter.");
            return -6;
        }
        if (countryCodeDefender < 0 || countryCodeDefender >= this.board.getNumberOfCountries()) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() with a bad defender parameter.");
            return -7;
        }
        if (this.countries[countryCodeAttacker].getOwner() != this.currentPlayer) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() with a attacker country that they don't own.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -1;
        }
        if (this.countries[countryCodeDefender].getOwner() == this.currentPlayer) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() with a defender country that they own.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -2;
        }
        if (this.turnPhase != 2) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() outside of their attack phase.");
            return -3;
        }
        if (this.countries[countryCodeAttacker].getArmies() < 2) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() from a country with only 1 army.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -4;
        }
        if (!this.countries[countryCodeAttacker].canGoto(countryCodeDefender)) {
            this.debug("oops. " + this.agents[this.currentPlayer].name() + " called attack() with two countries that don't touch.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -5;
        }
        if (this.countries[countryCodeDefender].getArmies() < 1) {
            this.debug("Lux ERROR -> it shouldn't be possible to attack a country that has less then one army in it. 3876435231");
        }
        int defendingPlayer = this.countries[countryCodeDefender].getOwner();
        boolean throttleNetworkTraffic = false;
        if (this.control.ops.allowNetworkPlayers && attackTillDead && this.countries[countryCodeAttacker].getArmies() + this.countries[countryCodeDefender].getArmies() > 150) {
            throttleNetworkTraffic = true;
            this.control.viewManager.setThrottle(true);
        }
        do {
            temp = this.innerAttack(countryCodeAttacker, countryCodeDefender);
        } while (attackTillDead && temp == 0);
        if (throttleNetworkTraffic) {
            this.control.viewManager.setThrottle(false);
            this.countries[countryCodeAttacker].setArmies(this.countries[countryCodeAttacker].getArmies(), this);
            this.countries[countryCodeDefender].setArmies(this.countries[countryCodeDefender].getArmies(), this);
        }
        if (temp == 7) {
            this.tookOverACountry = true;
            if (0 == this.control.stats.getOwned(defendingPlayer)) {
                this.playerWasEliminated(defendingPlayer, this.countries[countryCodeAttacker].getOwner());
                if (this.gameIsOver()) {
                    this.gameOver();
                }
            }
        }
        if (!PrefsCache.superfast && this.control.getTurnSecondsLeft() > 10) {
            try {
                Thread.sleep(delay);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (!"Human".equals(this.control.ops.playerTypes[defendingPlayer])) {
            try {
                Vector<Integer> parameters = new Vector<Integer>();
                parameters.add(new Integer(countryCodeAttacker));
                parameters.add(new Integer(countryCodeDefender));
                this.agents[defendingPlayer].message("attackNotice", parameters);
            }
            catch (Throwable e) {
                this.debug("There was an error in " + this.agents[defendingPlayer] + "'s message(\"attackNotice\", x) phase:");
                e.printStackTrace();
            }
        }
        return temp;
    }

    private void playerWasEliminated(int eliminatedPlayer, int conqueringPlayer) {
        block13: {
            block15: {
                block14: {
                    block16: {
                        block12: {
                            if (PrefsCache.eliminatedPlayerSound && !this.control.ops.playerTypes[eliminatedPlayer].equals("Empty")) {
                                playerEliminatedSound.play(true);
                            }
                            if (!this.gameIsOver()) break block12;
                            if (this.control.masterControl) {
                                // empty if block
                            }
                            int winner = this.getWinningPlayer();
                            this.addNewRecordBookStats(winner, 1);
                            this.finalRounds[winner] = this.gameRound;
                            this.finalPosition[winner] = 1;
                            System.out.println("GameIsOver -> " + this.control.ops.playerNames[winner] + " (index " + winner + ") is the winner");
                            break block13;
                        }
                        if (!this.control.ops.cardTransfer) break block14;
                        while (this.agentsCards[eliminatedPlayer].size() > 0) {
                            this.agentsCards[conqueringPlayer].add(this.agentsCards[eliminatedPlayer].remove(0));
                        }
                        if (this.currentPlayer == conqueringPlayer && this.control.ops.guiControl[conqueringPlayer]) {
                            this.control.updateCardButton(this.agentsCards[this.currentPlayer].size(), this.agentsCards[this.currentPlayer].size() > 4 || Card.containsASet(this.getCurrentPlayerCards()));
                            this.control.userEliminatedPlayer();
                        }
                        if (!this.control.ops.immediateCardCash || this.agentsCards[this.currentPlayer].size() <= 4) break block15;
                        if (!this.control.ops.guiControl[this.currentPlayer]) break block16;
                        this.turnPhase = 0;
                        this.control.clickCards();
                        break block15;
                    }
                    if ("Human".equals(this.control.ops.playerTypes[this.currentPlayer]) || !this.control.masterControl) break block15;
                    int oldTurnPhase = this.turnPhase;
                    this.currentComputerPlayersCardsPhase();
                    this.armiesLeftToPlace += this.armiesFromCards;
                    this.currentComputerPlayersPlacePhase();
                    this.turnPhase = oldTurnPhase;
                    break block15;
                }
                while (this.agentsCards[eliminatedPlayer].size() > 0) {
                    this.cardDeck.add(this.agentsCards[eliminatedPlayer].remove(0));
                }
            }
            if (Prefs.getBoolean("noHumanSpeedup", true)) {
                boolean aliveHuman = false;
                for (int i = 0; i < this.control.ops.playerTypes.length; ++i) {
                    if (i == eliminatedPlayer || !"Human".equals(this.control.ops.playerTypes[i]) || 0 == this.control.stats.getOwned(i)) continue;
                    aliveHuman = true;
                }
                if (!aliveHuman) {
                    this.noHumanSpeedupActive = true;
                }
            }
        }
        this.addNewRecordBookStats(eliminatedPlayer, this.agents.length - this.playersEliminated);
        this.finalRounds[eliminatedPlayer] = this.gameRound;
        this.finalPosition[eliminatedPlayer] = this.agents.length - this.playersEliminated;
        System.out.println(this.control.ops.playerNames[eliminatedPlayer] + " was eliminated: position " + (this.agents.length - this.playersEliminated));
        if (this.control.masterControl && this.control.netBoss != null) {
            this.control.netBoss.println("\u2731 " + this.control.ops.playerNames[eliminatedPlayer] + " " + Translator.getString("waseliminatedby") + " " + this.control.ops.playerNames[conqueringPlayer] + " " + Translator.getString("inround") + " " + this.gameRound + " \u2731");
            this.control.netBoss.sendToAll("tra: 3 " + this.control.ops.playerNames[eliminatedPlayer] + " :waseliminatedby: " + this.control.ops.playerNames[conqueringPlayer] + " :inround: " + this.gameRound);
            this.control.netBoss.log(this.control.ops.playerNames[eliminatedPlayer] + " was eliminated by " + this.control.ops.playerNames[conqueringPlayer] + " in round " + this.gameRound);
            this.control.netBoss.updateTracker();
        }
        ++this.playersEliminated;
        if (this.control.masterControl && !"Human".equals(this.control.ops.playerTypes[eliminatedPlayer])) {
            try {
                this.agents[eliminatedPlayer].message("youLose", new Integer(conqueringPlayer));
            }
            catch (Throwable e) {
                this.debug("There was an error in " + this.agents[eliminatedPlayer] + "'s message(\"youLose\", x) phase:");
                e.printStackTrace();
            }
        }
        this.control.stats.dirtyArmies(eliminatedPlayer);
    }

    private void addNewRecordBookStats(int player, int position) {
        DelayedRecordBookEntry entry = new DelayedRecordBookEntry(player, position, this.control.ops.playerNames[player], this.agents[player].name(), this.gameRound);
        new Thread((Runnable)entry, "DelayRB").start();
    }

    private int innerAttack(int countryCodeAttacker, int countryCodeDefender) {
        int i;
        if (this.countries[countryCodeDefender].getArmies() < 1) {
            this.debug("Lux -> checkpoint 3876213752318");
            Thread.dumpStack();
        } else if (this.countries[countryCodeAttacker].getArmies() < 2) {
            this.debug("Tried to attack with only " + this.countries[countryCodeAttacker].getArmies() + " armies");
            Thread.dumpStack();
            return 13;
        }
        int attackDice = this.countries[countryCodeAttacker].getArmies() > 3 ? 3 : this.countries[countryCodeAttacker].getArmies() - 1;
        int defendDice = this.countries[countryCodeDefender].getArmies() == 1 ? 1 : 2;
        int[] results = new int[2];
        this.dice.roll(attackDice, defendDice, results);
        int attackerLoses = results[0];
        int defenderLoses = results[1];
        for (i = 0; i < attackerLoses; ++i) {
            this.control.viewManager.explode(countryCodeAttacker);
        }
        for (i = 0; i < defenderLoses; ++i) {
            this.control.viewManager.explode(countryCodeDefender);
        }
        this.countries[countryCodeAttacker].setArmies(this.countries[countryCodeAttacker].getArmies() - attackerLoses, this);
        this.countries[countryCodeDefender].setArmies(this.countries[countryCodeDefender].getArmies() - defenderLoses, this);
        if (this.countries[countryCodeDefender].getArmies() == 0) {
            this.countries[countryCodeDefender].setOwner(this.countries[countryCodeAttacker].getOwner(), this);
            if (PrefsCache.flashContinentTakeover && this.gamePhase > 2 && this.contBonus[this.countries[countryCodeDefender].getContinent()] != 0 && BoardHelper.playerOwnsContinent(this.countries[countryCodeDefender].getOwner(), this.countries[countryCodeDefender].getContinent(), this.countries)) {
                this.control.flashContinent(this.countries[countryCodeDefender].getContinent());
            }
            if (this.control.ops.guiControl[this.currentPlayer]) {
                return 7;
            }
            int temp = this.agents[this.countries[countryCodeAttacker].getOwner()].moveArmiesIn(countryCodeAttacker, countryCodeDefender);
            temp = Math.max(temp, attackDice);
            if ((temp = Math.min(temp, this.countries[countryCodeAttacker].getArmies() - 1)) == 0 || this.countries[countryCodeAttacker].getArmies() - temp == 0) {
                this.debug("ERROR: post-battle armies should never be 0");
                Thread.dumpStack();
            }
            this.countries[countryCodeDefender].setArmies(temp, this);
            this.countries[countryCodeAttacker].setArmies(this.countries[countryCodeAttacker].getArmies() - temp, this);
            return 7;
        }
        if (this.countries[countryCodeAttacker].getArmies() == 1) {
            return 13;
        }
        return 0;
    }

    private void setUpMoveableArmies() {
        for (int i = 0; i < this.board.getNumberOfCountries(); ++i) {
            this.countries[i].copyMoveableArmies(this);
        }
    }

    public int fortifyArmies(int numberOfArmies, int countryCodeOrigin, int countryCodeDestination) {
        if (0 > countryCodeOrigin || countryCodeOrigin >= this.board.getNumberOfCountries()) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with a bad origin country.");
            return -6;
        }
        if (0 > countryCodeDestination || countryCodeDestination >= this.board.getNumberOfCountries()) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with a bad destination country.");
            return -8;
        }
        if (numberOfArmies < 1) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with a non-positive number of armies.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -1;
        }
        if (this.countries[countryCodeOrigin].getOwner() != this.currentPlayer) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with an origin country they don't own.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -2;
        }
        if (this.countries[countryCodeDestination].getOwner() != this.currentPlayer) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with an destination country they don't own.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -3;
        }
        if (!this.countries[countryCodeOrigin].canGoto(countryCodeDestination)) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with a two countries that don't touch.");
            if (!PrefsCache.superfast) {
                Thread.dumpStack();
            }
            return -4;
        }
        if (this.countries[countryCodeOrigin].getMoveableArmies() == 0) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() with an origin country with 0 movable armies.");
            return -5;
        }
        if (this.turnPhase != 3) {
            this.debug("oops. " + this.agents[this.currentPlayer] + " called fortifyArmies() while outside of the fortifyPhase.");
            return -10;
        }
        int numberToMove = Math.min(numberOfArmies, this.countries[countryCodeOrigin].getMoveableArmies());
        if ((numberToMove = Math.min(numberToMove, this.countries[countryCodeOrigin].getArmies() - 1)) == 0) {
            return 0;
        }
        this.countries[countryCodeOrigin].setArmies(this.countries[countryCodeOrigin].getArmies() - numberToMove, this);
        this.countries[countryCodeOrigin].setMoveableArmies(this.countries[countryCodeOrigin].getMoveableArmies() - numberToMove, this);
        this.countries[countryCodeDestination].setArmies(this.countries[countryCodeDestination].getArmies() + numberToMove, this);
        return 1;
    }

    public boolean userCanStartFortifyPhase() {
        if (this.control.ops.guiControl[this.currentPlayer] && this.turnPhase == 2) {
            this.userSelectedCountry = -1;
            this.control.viewManager.selectCountry(-1);
            this.setAttackArrowsOnCountry(-1);
            this.turnPhase = 3;
            this.setUpMoveableArmies();
            return true;
        }
        return false;
    }

    private void userStartFortify(int c) {
        if (this.countries[c].getMoveableArmies() > 0) {
            this.playArmySound();
            this.userSelectedCountry = c;
            this.control.viewManager.selectCountry(c);
            this.userArmiesToPlace = Math.min(this.countries[c].getMoveableArmies(), this.countries[c].getArmies() - 1);
            this.control.setFluxBox(this.userArmiesToPlace);
            this.countries[this.userSelectedCountry].setArmies(this.countries[c].getArmies() - this.userArmiesToPlace, this);
            this.control.setArrowOnCountry(c, this.countries[c].getFriendlyAdjoiningCodeList());
        }
    }

    private int userFortifyTo(int c, int numberOfArmies) {
        if (numberOfArmies < 1) {
            return -1;
        }
        if (this.countries[c].getOwner() != this.currentPlayer) {
            this.control.showNoticeOnCountry(Translator.getString("Onlyfortifytoowned"), c);
            return -3;
        }
        if (!this.countries[this.userSelectedCountry].canGoto(c) && this.userSelectedCountry != c) {
            this.control.showNoticeOnCountry(Translator.getString("Onlyfortifytoadjoining"), c);
            return -4;
        }
        this.playArmySound();
        numberOfArmies = Math.min(numberOfArmies, this.countries[this.userSelectedCountry].getMoveableArmies());
        this.countries[c].setArmies(this.countries[c].getArmies() + numberOfArmies, this);
        this.userArmiesToPlace -= numberOfArmies;
        this.control.setFluxBox(this.userArmiesToPlace);
        if (this.userSelectedCountry != c) {
            this.countries[this.userSelectedCountry].setMoveableArmies(this.countries[this.userSelectedCountry].getMoveableArmies() - numberOfArmies, this);
        }
        if (this.userArmiesToPlace == 0) {
            this.userSelectedCountry = -1;
            this.control.viewManager.selectCountry(-1);
            this.control.setArrowOnCountry(-1, -1);
        } else if (numberOfArmies == 1) {
            this.incrementBigArmyTipCounter(c);
        }
        return 1;
    }

    public void endUserTurn() {
        if (this.control.ops.guiControl[this.currentPlayer] && this.gamePhase > 2 || this.control.masterControl && this.control.forceTurnEnd) {
            this.takingOverTurn = false;
            if (this.control.getFluxArmies() > 0) {
                this.forcePlaceFluxArmies();
            }
            this.userSelectedCountry = -1;
            this.gotoNextPlayer(0);
        } else {
            SS.beep();
        }
    }

    public void gotoNextPlayer() {
        this.gotoNextPlayer(delay);
    }

    private synchronized void gotoNextPlayer(int turnDelay) {
        this.playerActiveMemory2[this.currentPlayer] = this.playerActiveMemory1[this.currentPlayer];
        this.playerActiveMemory1[this.currentPlayer] = false;
        if (this.control.masterControl && !this.isPlayerActive(this.control.ops.playerNames[this.currentPlayer]) && "Human".equals(this.control.ops.playerTypes[this.currentPlayer]) && this.control.netBoss != null) {
            this.control.netBoss.playerIsInactive(this.currentPlayer);
        }
        if (this.gamePhase < 3) {
            this.gotoPlayer((this.currentPlayer + 1) % this.agents.length);
        } else {
            if (this.gamePhase == 3 && this.control.masterControl && this.tookOverACountry && this.control.ops.useCards) {
                this.tookOverACountry = false;
                this.givePlayerCardTellEveryone(this.currentPlayer, this.nextCardFromDeck());
            }
            int nextAlivePlayer = this.currentPlayer;
            do {
                nextAlivePlayer = (nextAlivePlayer + 1) % this.agents.length;
                if (!this.control.masterControl || nextAlivePlayer != 0 || this.gamePhase != 3) continue;
                this.incrementGameRound();
            } while (0 == this.control.stats.getOwned(nextAlivePlayer));
            if (this.noHumanSpeedupActive) {
                delay = (int)Math.ceil((double)delay * 0.6);
            }
            this.gotoPlayer(nextAlivePlayer);
        }
        if (Thread.currentThread() == this.worldThread && !PrefsCache.superfast) {
            Thread.yield();
            try {
                Thread.sleep(turnDelay);
            }
            catch (Throwable e) {
                this.debug("sleep waken");
            }
        }
    }

    public void validateRemotePlayerTurnEnd(String remotePlayerName) {
        if (this.control.ops.playerNames[this.currentPlayer].equals(remotePlayerName)) {
            this.gotoNextPlayer(0);
        } else if (this.control.takenOverPlayerNames != null && remotePlayerName.equals(this.control.takenOverPlayerNames[this.currentPlayer])) {
            this.gotoNextPlayer(0);
        } else {
            this.debug("BLOCKED validateRemotePlayerTurnEnd(" + remotePlayerName + ")");
        }
    }

    public void gotoPlayer(int player) {
        if (this.currentPlayer != -1 && this.control.ops.guiControl[this.currentPlayer] && this.control.getFluxArmies() > 0) {
            this.debug("should have error corrected the player to not have any flux armies");
            Thread.dumpStack();
        }
        this.turnPhase = 0;
        this.currentPlayer = player;
        if (!this.killed) {
            this.userSelectedCountry = -1;
            this.control.viewManager.selectCountry(-1);
            this.control.viewManager.gotoPlayer(player);
        }
        if (this.control.masterControl) {
            this.resumeWorldThread();
        } else if (this.control.ops.guiControl[player]) {
            if (this.gamePhase == 1) {
                this.debug("choosing a client country");
                this.chooseInitialCountry();
            } else if (this.gamePhase == 2) {
                this.debug("placing a client's initial armies");
                this.placeInitialArmiesPoll();
            } else if (this.gamePhase == 3) {
                this.startUserTurn();
            } else {
                this.debug("got a takeRemotePlayerAction for a client in no proper phase");
            }
        }
    }

    public void incrementGameRound() {
        ++this.gameRound;
        if (this.control.ops.continentSequence != null) {
            this.contBonus = this.control.ops.continentSequence.increment(this.contBonusOriginal);
        }
        this.control.stats.dirtyIncomes();
        if (this.control.masterControl) {
            try {
                NetBoss boss = this.control.netBoss;
                if (boss != null) {
                    boss.sendToAll("nr: ");
                }
            }
            catch (Throwable t) {
                this.debug("LuxWorld checkpoint 665342211: " + t);
            }
        }
    }

    public Board getBoard() {
        return this.board;
    }

    private boolean gameIsOver() {
        int firstCountryOwner;
        if (this.killed) {
            return false;
        }
        if (this.control.masterControl) {
            // empty if block
        }
        if ((firstCountryOwner = this.getFirstNonEmptyPlayer()) == -1) {
            return false;
        }
        for (int i = 1; i < this.board.getNumberOfCountries(); ++i) {
            if (this.countries[i].getOwner() != -1 && (this.countries[i].getOwner() == firstCountryOwner || "Empty".equals(this.agents[this.countries[i].getOwner()].name()))) continue;
            return false;
        }
        return true;
    }

    public int getFirstNonEmptyPlayer() {
        int firstCountryOwner = this.countries[0].getOwner();
        if (firstCountryOwner == -1) {
            return firstCountryOwner;
        }
        int i = 1;
        while ("Empty".equals(this.agents[firstCountryOwner].name())) {
            firstCountryOwner = this.countries[i].getOwner();
            ++i;
        }
        return firstCountryOwner;
    }

    private boolean gameIsOverTEAMS() {
        if (this.killed) {
            return false;
        }
        boolean robotsAreAlive = false;
        boolean humansAreAlive = false;
        for (int owner = 0; owner < this.control.ops.playerNames.length; ++owner) {
            if (this.control.stats.getOwned(owner) <= 0) continue;
            if ("Human".equals(this.control.ops.playerTypes[owner])) {
                humansAreAlive = true;
                continue;
            }
            robotsAreAlive = true;
        }
        if (robotsAreAlive && !humansAreAlive) {
            SS.debug("robots win the team game");
            return true;
        }
        if (robotsAreAlive && humansAreAlive) {
            return false;
        }
        try {
            int firstCountryOwner = this.getFirstNonEmptyPlayer();
            String firstCountryTeam = this.control.netBoss.connectionFromNameIgnoreCase(this.control.ops.playerNames[firstCountryOwner]).getTeam();
            if (firstCountryOwner == -1) {
                return false;
            }
            for (int i = 1; i < this.board.getNumberOfCountries(); ++i) {
                int owner;
                String team;
                if (this.countries[i].getOwner() == firstCountryOwner || (team = this.control.netBoss.connectionFromNameIgnoreCase(this.control.ops.playerNames[owner = this.countries[i].getOwner()]).getTeam()).equals(firstCountryTeam)) continue;
                return false;
            }
            SS.debug("team game has been won by " + firstCountryTeam);
            return true;
        }
        catch (Exception e) {
            SS.debug("gameIsOverTEAMS() threw: " + e);
            return false;
        }
    }

    public void countryClicked(int c, boolean shiftPressed, boolean flipTillDeath, int numberSelected) {
        if (!this.control.ops.guiControl[this.currentPlayer] || !"Human".equals(this.control.ops.playerTypes[this.currentPlayer])) {
            return;
        }
        if (this.control.masterControl && !this.stasisMode) {
            this.debug("block a non-stasis click");
            return;
        }
        numberSelected = Math.max(numberSelected, 1);
        if (this.gamePhase == 1) {
            this.chooseUserCountry(c);
        } else if (this.gamePhase == 2) {
            this.placeInitialUserArmies(c, shiftPressed, numberSelected);
        } else if (this.gamePhase == 3) {
            if (this.turnPhase == 0) {
                this.turnPhase = 1;
                this.countryClicked(c, shiftPressed, flipTillDeath, numberSelected);
            } else if (this.turnPhase == 1) {
                if (this.countries[c].getOwner() == this.currentPlayer) {
                    this.playArmySound();
                    if (shiftPressed) {
                        this.countries[c].setArmies(this.countries[c].getArmies() + this.userArmiesToPlace, this);
                        this.userArmiesToPlace = 0;
                    } else {
                        this.countries[c].setArmies(this.countries[c].getArmies() + numberSelected, this);
                        this.userArmiesToPlace -= numberSelected;
                    }
                    if (this.userArmiesToPlace < 0) {
                        this.debug("Lux -> ERROR userArmiesToPlace should never be negative. Will compensate by setting it to 0. numberSelected=" + numberSelected + ", shiftPressed=" + shiftPressed + ", flipTillDeath=" + flipTillDeath);
                        Thread.dumpStack();
                        this.userArmiesToPlace = 0;
                    }
                    this.control.setFluxBox(this.userArmiesToPlace);
                    if (this.userArmiesToPlace == 0) {
                        this.turnPhase = 2;
                        this.userSelectedCountry = c;
                        this.control.viewManager.selectCountry(c);
                        this.control.userAttackPhase(c);
                        this.setAttackArrowsOnCountry(this.userSelectedCountry);
                    } else if (numberSelected == 1) {
                        this.incrementBigArmyTipCounter(c);
                    }
                } else if (LuxController.getInstance().getSharewareCount() < 10) {
                    this.control.showNoticeOnCountry(Translator.getString("Youmustplaceoncountryyouown"), c);
                }
            } else if (this.turnPhase == 2) {
                if ((this.userSelectedCountry == -1 || this.countries[this.userSelectedCountry].getOwner() == this.currentPlayer) && this.countries[c].getOwner() == this.currentPlayer && this.countries[c].getArmies() > 1) {
                    this.userSelectedCountry = c;
                    this.control.viewManager.selectCountry(c);
                    this.setAttackArrowsOnCountry(this.userSelectedCountry);
                } else if (this.userSelectedCountry != -1) {
                    this.userAttackWasShifted = shiftPressed;
                    this.userFlipTillDeath = flipTillDeath;
                    if (this.countries[this.userSelectedCountry].canGoto(c) && this.countries[c].getOwner() != this.currentPlayer) {
                        this.userAttack(this.userSelectedCountry, c);
                    } else if (this.countries[c].getOwner() != this.currentPlayer && LuxController.getInstance().getSharewareCount() < 10) {
                        this.control.showNoticeOnCountry(Translator.getString("Onlyattackadjoining"), c);
                    }
                }
            } else if (this.turnPhase == 22) {
                if (c == this.userAttackedFrom || c == this.userAttackedTo) {
                    this.playArmySound();
                    if (shiftPressed) {
                        this.countries[c].setArmies(this.countries[c].getArmies() + this.userArmiesToPlace, this);
                        this.userArmiesToPlace = 0;
                    } else {
                        this.countries[c].setArmies(this.countries[c].getArmies() + numberSelected, this);
                        this.userArmiesToPlace -= numberSelected;
                    }
                    this.control.setFluxBox(this.userArmiesToPlace);
                    if (this.userArmiesToPlace == 0) {
                        this.turnPhase = 2;
                        this.userSelectedCountry = c;
                        this.control.viewManager.selectCountry(c);
                        this.control.doneMovingIn(c);
                        this.setAttackArrowsOnCountry(this.userSelectedCountry);
                    } else if (numberSelected == 1) {
                        this.incrementBigArmyTipCounter(c);
                    }
                } else if (LuxController.getInstance().getSharewareCount() < 10) {
                    this.control.showNoticeOnCountry(Translator.getString("Youmustplaceoncountryyouown"), c);
                }
            } else if (this.turnPhase == 3) {
                if (this.userSelectedCountry == -1 && this.countries[c].getArmies() > 1 && this.countries[c].getOwner() == this.currentPlayer) {
                    this.userStartFortify(c);
                } else if (this.userSelectedCountry != -1) {
                    if (shiftPressed) {
                        this.userFortifyTo(c, this.userArmiesToPlace);
                    } else {
                        this.userFortifyTo(c, numberSelected);
                    }
                }
            } else {
                this.debug("OOPS. recieved a country click, but the players turnPhase is out of wack (" + this.turnPhase + ")");
            }
        }
    }

    public boolean gameOver() {
        if (!this.gameIsOver()) {
            return false;
        }
        this.gamePhase = 4;
        int winner = this.getWinningPlayer();
        if (this.control.ops.guiControl[winner] || this.control.masterControl && !"Human".equals(this.control.ops.playerTypes[winner])) {
            String youWonText = null;
            try {
                youWonText = this.agents[winner].youWon();
            }
            catch (Throwable e) {
                this.debug("Wowser, " + this.agents[winner].name() + " is stooopid. He threw an exception in youWon().");
            }
            if (youWonText == null) {
                youWonText = "bee!";
            }
            StringBuffer winBuffer = new StringBuffer();
            winBuffer.append(this.control.ops.playerNames[winner]);
            if (!this.control.ops.guiControl[winner]) {
                winBuffer.append(" (");
                winBuffer.append(this.agents[winner].name());
                winBuffer.append(")");
            }
            if (Character.isLowerCase(this.control.ops.playerNames[winner].charAt(0))) {
                winBuffer.append(" wins!\n\n\"");
            } else {
                winBuffer.append(" Wins!\n\n\"");
            }
            winBuffer.append(youWonText);
            winBuffer.append("\"");
            this.control.viewManager.gameOver(winBuffer.toString());
        }
        if (this.control.masterControl) {
            NetBoss boss = this.control.netBoss;
            if (boss != null) {
                System.out.println("Sending ranking data to the server. The results:");
                for (int i = 0; i < this.agents.length; ++i) {
                    System.out.println(" -> " + this.control.ops.playerNames[i] + " lasted " + this.finalRounds[i] + " rounds. Placed " + this.finalPosition[i]);
                }
                boss.addRankings(this.finalPosition, this.finalRounds);
            }
            Thread.yield();
        }
        this.control.viewManager.selectCountry(-1);
        this.userSelectedCountry = -1;
        this.setAttackArrowsOnCountry(-1);
        this.control.gameOver();
        Thread.yield();
        DelayedRecordBookEntryEndGame entry = new DelayedRecordBookEntryEndGame(this.control.ops.playerNames, this.control.ops.playerTypes, winner);
        new Thread((Runnable)entry, "DelayRBEG").start();
        return true;
    }

    public static void setDelay(int foo) {
        delay = foo;
    }

    private boolean playerIsControlledByName(int playerID, String name) {
        return this.control.ops.playerNames[playerID].equals(name) || this.control.takenOverPlayerNames != null && name.equals(this.control.takenOverPlayerNames[playerID]);
    }

    public synchronized boolean setCountryOwnerFromNetwork(int countryCode, int ownerCode, String remotePlayerName) {
        if (this.acceptNetworkCommandFrom(remotePlayerName)) {
            int oldOwner = this.countries[countryCode].getOwner();
            this.countries[countryCode].setOwner(ownerCode, this);
            if (PrefsCache.flashContinentTakeover && this.gamePhase > 2 && this.contBonus[this.countries[countryCode].getContinent()] != 0 && BoardHelper.playerOwnsContinent(ownerCode, this.countries[countryCode].getContinent(), this.countries)) {
                this.control.flashContinent(this.countries[countryCode].getContinent());
            }
            if (oldOwner != -1 && 0 == this.control.stats.getOwned(oldOwner)) {
                this.playerWasEliminated(oldOwner, ownerCode);
            }
            if (oldOwner != -1 && this.gamePhase == 3) {
                this.tookOverACountry = true;
            }
            return true;
        }
        this.debug("blocked setCountryOwnerFromNetwork(" + countryCode + "," + ownerCode + "," + remotePlayerName + ")");
        return false;
    }

    public synchronized boolean setCountryArmiesFromNetwork(int countryCode, int armies, String remotePlayerName) {
        if (this.acceptNetworkCommandFrom(remotePlayerName)) {
            this.countries[countryCode].setArmies(armies, this);
            return true;
        }
        this.debug("blocked setCountryArmiesFromNetwork(" + countryCode + "," + armies + "," + remotePlayerName + ")");
        return false;
    }

    public boolean acceptNetworkCommandFrom(String remotePlayerName) {
        if (!this.control.masterControl || this.playerIsControlledByName(this.currentPlayer, remotePlayerName)) {
            return true;
        }
        if (!this.control.ops.useTurnTimer) {
            return false;
        }
        int currentPlayerMemory = this.currentPlayer;
        int previousHuman = -1;
        for (int i = 0; previousHuman == -1 && i < this.control.ops.playerNames.length; ++i) {
            int playerCheck = (currentPlayerMemory - (i + 1) + this.control.ops.playerNames.length) % this.control.ops.playerNames.length;
            if (!"Human".equals(this.control.ops.playerTypes[playerCheck]) || 0 == this.control.stats.getOwned(playerCheck)) continue;
            previousHuman = playerCheck;
        }
        if (previousHuman == -1) {
            System.out.println("no previous human found");
            return false;
        }
        if (this.playerIsControlledByName(previousHuman, remotePlayerName)) {
            return true;
        }
        System.out.println(this.control.ops.playerNames[previousHuman] + (this.control.takenOverPlayerNames != null ? " (taken over by " + this.control.takenOverPlayerNames[previousHuman] + ")" : "") + " not controlled by " + remotePlayerName);
        return false;
    }

    public void run() {
        block19: {
            System.out.println("LuxWorld: run()");
            this.control.viewManager.reset();
            if (!PrefsCache.superfast) {
                for (int i = 0; i < this.agents.length; ++i) {
                    StringBuffer buf = new StringBuffer(String.valueOf(i));
                    buf.append(" = ");
                    buf.append(this.control.ops.playerTypes[i]);
                    buf.append(" named ");
                    buf.append(this.control.ops.playerNames[i]);
                    if (this.control.ops.allowNetworkPlayers && this.control.masterControl) {
                        while (buf.length() < 30) {
                            buf.append(" ");
                        }
                        buf.append(" - IP: " + this.control.netBoss.IPFromName(this.control.ops.playerNames[i]));
                    }
                    System.out.println(buf.toString());
                }
            }
            if (!this.control.masterControl) {
                System.out.println("LuxWorld: Ending the client game thread");
                return;
            }
            try {
                this.worldThread = Thread.currentThread();
                if (PrefsCache.superfast) {
                    this.worldThread.setPriority(10);
                } else {
                    this.worldThread.setPriority(1);
                }
                if (this.control.netBoss != null) {
                    this.control.alertGameStarted();
                }
                if (!this.control.ops.useScenario && !this.control.ops.savedGame) {
                    this.runInitialSelectionPhases();
                }
                if (this.killed) {
                    return;
                }
                this.setGamePhase(3);
                if (this.killed) {
                    return;
                }
                if (this.control.ops.savedGame) {
                    String temp;
                    int i = 0;
                    while ((temp = XMLTool.extract("playerCards", this.control.ops.boardFile.contents, i)) != null) {
                        String cardString;
                        int c = 0;
                        while ((cardString = XMLTool.extract("cardString", temp, c)) != null) {
                            Card card = new Card(cardString);
                            this.cardDeck.remove(card);
                            this.givePlayerCardTellEveryone(i, card);
                            ++c;
                        }
                        ++i;
                    }
                    this.restoringSavedGame = true;
                    try {
                        this.gameRound = XMLTool.extractInt("gameRound", this.control.ops.boardFile.contents);
                        SS.debug("Restoring a game into round " + this.gameRound);
                        this.control.ops.cardSequence = new CardSequence(XMLTool.extract("CardsObject", this.control.ops.boardFile.contents));
                        this.control.ops.continentSequence = new ContinentSequence(XMLTool.extract("ContinentObject", this.control.ops.boardFile.contents));
                        this.contBonus = this.control.ops.continentSequence.refreshValues(this.contBonusOriginal);
                    }
                    catch (Exception e) {
                        SS.debug("There was an error while loading in some saved game data: " + e);
                    }
                    this.control.viewManager.reset();
                    this.takeTurnsLoop(XMLTool.extractInt("currentPlayer", this.control.ops.boardFile.contents));
                    break block19;
                }
                this.gameRound = 1;
                this.takeTurnsLoop(0);
            }
            catch (Throwable t) {
                if (this.killed) {
                    this.debug("Lux -> an exception was caught in a killed game thread. No need to worry about this.");
                }
                this.debug("Lux -> an exception was caught in game thread " + this + " when the world has not been killed yet.");
                t.printStackTrace();
            }
        }
        this.worldThread = null;
    }

    private void runInitialSelectionPhases() {
        this.setGamePhase(1);
        if (this.killed) {
            return;
        }
        if (this.control.ops.initialCountries) {
            this.chooseCountriesRandomly();
        } else {
            this.firstSelection = true;
            this.gotoPlayer(0);
            boolean stillPicking = true;
            int i = 0;
            while (!this.killed && stillPicking) {
                this.chooseInitialCountry();
                if (i > this.control.ops.playerNames.length) {
                    this.firstSelection = false;
                }
                if (stillPicking = BoardHelper.playerIsStillInTheGame(-1, this.countries)) {
                    this.gotoNextPlayer();
                }
                ++i;
            }
        }
        if (this.gamePhase == 1) {
            this.setGamePhase(2);
        } else {
            this.debug("gamePhase is " + this.gamePhase + " when all countries are owned");
        }
        if (this.killed) {
            return;
        }
        if (this.control.ops.initialArmies == 0) {
            this.placeInitialArmiesRandomly();
        } else if (this.control.ops.initialArmies == 1) {
            this.firstSelection = true;
            if (!this.control.ops.initialCountries) {
                this.debug("Initial countries and armies are both selected");
                this.gotoNextPlayer();
            } else {
                System.out.println("Initial countries were random, but armies are selected");
                this.gotoPlayer(0);
            }
            int i = 0;
            while (!this.killed && !this.initialArmiesGone()) {
                this.placeInitialArmiesPoll();
                if (i > this.control.ops.playerNames.length) {
                    this.firstSelection = false;
                }
                ++i;
            }
        } else if (this.control.ops.initialArmies == 2) {
            this.placeInitialArmiesEvenly();
        }
    }

    public void takeTurnsLoop(int firstPlayer) {
        if (this.control.masterControl && this.control.ops.allowNetworkPlayers) {
            boolean allBots = true;
            for (int i = 0; i < this.control.ops.playerTypes.length; ++i) {
                if (!"Human".equals(this.control.ops.playerTypes[i])) continue;
                allBots = false;
            }
            if (allBots && Prefs.getBoolean("abortbotgames", false)) {
                SS.debug("Host server is running a game with only bots. Abort the game (gamePhase=" + this.gamePhase);
                this.gamePhase = -1;
                this.control.gameLimitThread.stopLimit();
                return;
            }
        }
        this.gotoPlayer(firstPlayer);
        while (!this.killed) {
            if (this.gameIsOver()) {
                return;
            }
            if (this.control.ops.guiControl[this.currentPlayer] && "Human".equals(this.control.ops.playerTypes[this.currentPlayer])) {
                this.startUserTurn();
            } else if (!"Human".equals(this.control.ops.playerTypes[this.currentPlayer]) && this.control.masterControl) {
                this.takeCurrentComputerPlayersTurn();
                this.gotoNextPlayer();
            } else {
                int networkPlayer = this.currentPlayer;
                this.stasis();
                if (this.control.ops.guiControl[networkPlayer]) {
                    this.debug("End turn of a player that was controlled by someone else when this turn started but is now ours.");
                    this.gotoNextPlayer();
                }
            }
            this.takingOverTurn = false;
        }
        return;
    }

    public void kill() {
        this.killed = true;
        this.stasisMode = false;
        if (this.worldThread != null) {
            try {
                this.worldThread.join(3000L);
            }
            catch (Exception e) {
                this.debug("during world kill: " + e);
            }
        }
        this.control = null;
        this.board.kill(this);
        this.board = null;
    }

    private void debug(Object text) {
        if (PrefsCache.superfast) {
            return;
        }
        System.out.println(this + ": " + text);
        System.out.flush();
    }

    public String toString() {
        try {
            StringBuffer bf = new StringBuffer("<" + super.toString() + ": mc=" + this.control.masterControl + ", controls=");
            for (int i = 0; i < this.control.ops.guiControl.length; ++i) {
                if (!this.control.ops.guiControl[i]) continue;
                bf.append(this.control.ops.playerNames[i] + ",");
            }
            bf.append(" currentPlayer=" + this.currentPlayer + ", gamePhase=" + this.gamePhase + ", turnPhase=" + this.turnPhase + ">");
            return bf.toString();
        }
        catch (Exception exception) {
            return "<LuxWorld infant (" + super.toString() + ")>";
        }
    }

    public void clearForReuse() {
        int i;
        this.debug("clearForReuse");
        for (i = 0; i < this.countries.length; ++i) {
            this.countries[i].setOwner(-1, this);
            this.countries[i].setArmies(1, this);
        }
        for (i = 0; i < this.agents.length; ++i) {
            this.agentsCards[i] = new Vector();
        }
        this.userArmiesToPlace = 0;
        this.userSelectedCountry = -1;
        this.noHumanSpeedupActive = false;
        delay = (int)Prefs.getFloat("agentDelay", 400.0f);
        this.rand = new Random();
        this.currentPlayer = 0;
        this.turnPhase = -1;
        this.gamePhase = -1;
        this.control.ops.cardSequence.reset();
        this.debug(this.control.ops);
    }

    public void giveUpCurrentPlayer() {
        this.userArmiesToPlace = 0;
    }

    private void setGamePhase(int phase) {
        this.gamePhase = phase;
        if (this.gamePhase == 1 || this.gamePhase == 2) {
            this.firstSelection = true;
        }
        if (this.control.netBoss != null) {
            if (this.control.masterControl) {
                this.control.netBoss.sendToAll("setGamePhase: " + phase);
                this.control.netBoss.updateTracker();
            } else {
                this.debug("non-mc got a setGamePhase() call");
            }
        }
    }

    public void resumeWorldThread() {
        this.stasisMode = false;
        if (!this.control.masterControl) {
            this.debug("Client is going to tell master to wake up");
            this.control.netBoss.sendToAll("wakeMaster:");
        }
    }

    public boolean isKilled() {
        return this.killed;
    }

    private void playArmySound() {
        if (PrefsCache.armySound) {
            armySound.play(true);
        }
    }

    public void commandFromPlayer(String remotePlayerName) {
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!this.playerIsControlledByName(i, remotePlayerName)) continue;
            if (this.ignoreNextActiveCommandFromPlayerIndex == i) {
                --this.ignoreNextCount;
                if (this.ignoreNextCount <= 0) {
                    this.ignoreNextActiveCommandFromPlayerIndex = -1;
                }
                return;
            }
            if (this.playerActiveMemory1 != null) {
                this.playerActiveMemory1[i] = true;
            }
            return;
        }
    }

    public boolean isPlayerPlaying(String playerName) {
        if (this.gamePhase > 3) {
            return false;
        }
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!this.playerIsControlledByName(i, playerName)) continue;
            return this.control.stats.getOwned(i) > 0;
        }
        return false;
    }

    public boolean isPlayerActive(String playerName) {
        if (this.gamePhase < 3 && this.control.getTurnSecondsLeft() < 0) {
            return false;
        }
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!this.playerIsControlledByName(i, playerName)) continue;
            if (!"Human".equals(this.control.ops.playerTypes[i])) {
                return true;
            }
            if (this.control.masterControl && this.control.ops.guiControl[i]) {
                return true;
            }
            return this.control.stats.getOwned(i) > 0 && (this.playerActiveMemory1[i] || this.playerActiveMemory2[i]);
        }
        System.out.println("LuxWorld: isPlayerActive(" + playerName + ") didn't find that player.");
        return false;
    }

    public void ignoreNextActiveCommandFrom(int playerIndex) {
        if (this.ignoreNextActiveCommandFromPlayerIndex == playerIndex) {
            ++this.ignoreNextCount;
        } else {
            this.ignoreNextActiveCommandFromPlayerIndex = playerIndex;
            this.ignoreNextCount = 1;
        }
    }

    public void mouseOverCountry(int countryCode) {
        int owner = this.countries[countryCode].getOwner();
        if (owner == -1) {
            return;
        }
        if (this.control.ops.guiControl[owner]) {
            this.control.setArrowOnCountry(countryCode, this.countries[countryCode].getHostileAdjoiningCodeList());
        }
    }

    public String getToolTipForCountry(int countryCode) {
        int bonus;
        if (oftooltip == null) {
            oftooltip = Translator.getString("oftooltip");
        }
        if ((bonus = this.board.getContinentBonus(this.countries[countryCode].getContinent())) == 0) {
            return "";
        }
        if (this.getSizeOfContinent(countryCode) == 1) {
            return "\n" + LuxView.bonusString + ": " + bonus;
        }
        return "\n1/" + this.getSizeOfContinent(countryCode) + " " + oftooltip + " " + this.board.getContinentName(this.countries[countryCode].getContinent()) + " " + LuxView.bonusString + ": " + bonus;
    }

    public int getSizeOfContinent(int countryCode) {
        return BoardHelper.getContinentSize(this.countries[countryCode].getContinent(), this.countries);
    }

    private void setAttackArrowsOnCountry(int countryCode) {
        if (countryCode == -1) {
            this.control.setArrowOnCountry(-1, -1);
        } else {
            this.control.setArrowOnCountry(countryCode, this.countries[countryCode].getHostileAdjoiningCodeList(), false);
        }
    }

    public void takeOverPlayer(int playerIndex) {
        if (this.control.ops.continentSequence != null) {
            this.contBonus = this.control.ops.continentSequence.refreshValues(this.contBonusOriginal);
        }
        if (this.currentPlayer == playerIndex) {
            this.debug("Taking over a player whose turn it currently is");
            this.control.giveUserButtons();
            this.takeOverCurrentPlayer();
        }
    }

    public boolean humanPlayerExists(String userName) {
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!this.control.ops.playerNames[i].equals(userName) || !"Human".equals(this.control.ops.playerTypes[i])) continue;
            return true;
        }
        return false;
    }

    public String getPlayerName(LuxAgent sender) {
        for (int i = 0; i < this.agents.length; ++i) {
            if (this.agents[i] != sender) continue;
            return this.control.ops.playerNames[i];
        }
        return null;
    }

    public void recieveChat(String text, String from) {
        String chatText = text.substring(from.length() + 2);
        for (int i = 0; i < this.agents.length; ++i) {
            if (this.control.ops.playerTypes[i].equals("Human")) continue;
            Vector<String> parameters = new Vector<String>();
            parameters.add(from);
            parameters.add(chatText);
            try {
                this.agents[i].message("chat", parameters);
                continue;
            }
            catch (Throwable e) {
                this.debug("There was an error in " + this.agents[i] + "'s message(\"chat\", x) phase:");
                e.printStackTrace();
            }
        }
    }

    public void recieveEmote(String text, String from) {
        this.recieveChat(from + " " + text, from);
    }

    public void recieveZEmote(String text, String from) {
        this.recieveChat(from + " " + text, from);
    }

    public void recieveHEmote(String text, String from) {
        this.recieveChat(from + " " + text, from);
    }

    public void recieveSEmote(String text, String from) {
        this.recieveChat(from + " " + text, from);
    }

    private void incrementBigArmyTipCounter(int countryCode) {
        if (this.lastPlaceTo == countryCode) {
            ++this.sameCountryPlaceCount;
            if (this.sameCountryPlaceCount == 12) {
                ((GameControllerGUI)this.control).luxView.showNoticeOnCountry(Translator.getString(SS.isMacintosh ? "BigarmyplacinghintMac" : "Bigarmyplacinghint"), countryCode);
            }
        } else {
            this.lastPlaceTo = countryCode;
            this.sameCountryPlaceCount = 1;
        }
    }

    public int getNumberOfHumanPlayers() {
        int count = 0;
        try {
            for (int i = 0; i < this.agents.length; ++i) {
                if (!this.control.ops.playerTypes[i].equals("Human")) continue;
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public void setEmptyDefenders(boolean value) {
        if (this.emptyDefendersAttackMode != value) {
            SS.debug("setEmptyDefenders toogled to: " + value);
        }
        this.emptyDefendersAttackMode = value;
    }

    public boolean usedZeroAttack() {
        boolean wasValue = this.usedZeroAttack;
        this.usedZeroAttack = false;
        return wasValue;
    }

    public int getWinningPlayer() {
        return this.getFirstNonEmptyPlayer();
    }

    public int getHighestArmyPlayer() {
        int highestArmyCount = 0;
        int highestOwner = -1;
        for (int owner = 0; owner < this.control.ops.playerNames.length; ++owner) {
            if (this.control.stats.getArmies(owner) <= highestArmyCount) continue;
            highestOwner = owner;
            highestArmyCount = this.control.stats.getArmies(owner);
        }
        return highestOwner;
    }

    static {
        armySound = new SoundEffect("placeArmy.wav");
        playerEliminatedSound = new SoundEffect("playerEliminated.wav");
    }
}

