/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.BoardCache;
import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.ContinentSequence;
import com.sillysoft.lux.Lux;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import java.io.File;
import java.io.Serializable;
import java.util.Random;

public class LuxOptions
implements Serializable {
    static final long serialVersionUID = -6252907239237927233L;
    public String[] playerTypes;
    public String[] playerNames;
    public boolean[] guiControl;
    public String[] colorPassString;
    public int width;
    public int height;
    public boolean customBoard;
    public String boardSize;
    public int boardNumber;
    public BoardFile boardFile;
    private String boardName;
    public boolean useScenario;
    public boolean initialCountries;
    public int initialArmies;
    public boolean allowNetworkPlayers;
    public boolean internetPublic;
    public boolean useCards;
    public boolean cardTransfer;
    public int cardSequenceCode;
    public boolean immediateCardCash;
    public CardSequence cardSequence;
    public ContinentSequence continentSequence;
    public boolean useTurnTimer;
    public float turnTimerLength;
    public int gameLimitMinutes;
    public long gameStarted;
    public long gameEnded;
    public String boardTitle;
    public boolean isRanked;
    public int biohazardLevel;
    public boolean firstTurnContBonus;
    public boolean warFog;
    public int[] playerTeam;
    public boolean savedGame;
    private static boolean switchNextTwoPlayerOrder = false;

    public int biohazardLevel() {
        String title = this.boardNameBio();
        if (title.indexOf(" - BIO ") > 0) {
            return StringTool.captureTrailingNumbers(title);
        }
        return this.biohazardLevel;
    }

    public LuxOptions(String boardNamePass) {
        this(null, null, null, null, false, false);
        this.boardName = boardNamePass;
    }

    public LuxOptions(String[] playerTypes, String[] playerNames, String[] colorPass, boolean[] guiControl, boolean forceAllowNetworkPlayersOn, boolean forceInternetPublicOn, BoardFile boardFile) {
        this(playerTypes, playerNames, colorPass, guiControl, forceAllowNetworkPlayersOn, forceInternetPublicOn);
        if (boardFile != null) {
            this.boardFile = boardFile;
        }
    }

    public LuxOptions(String[] playerTypes, String[] playerNames, String[] colorPass, boolean[] guiControl, boolean forceAllowNetworkPlayersOn, boolean forceInternetPublicOn) {
        this.guiControl = guiControl;
        this.playerTypes = playerTypes;
        this.playerNames = playerNames;
        this.colorPassString = colorPass;
        this.loadInfo();
        if (forceAllowNetworkPlayersOn) {
            this.allowNetworkPlayers = true;
        }
        if (forceInternetPublicOn) {
            this.internetPublic = true;
        } else if (forceAllowNetworkPlayersOn) {
            this.internetPublic = false;
        }
        this.cardSequence = new CardSequence(this.cardSequenceCode);
        int contSequenceCode = Prefs.getInt("continentSequenceCode", 1);
        if (PrefsCache.headless) {
            contSequenceCode = Lux.contsParam;
        }
        this.continentSequence = new ContinentSequence(contSequenceCode);
        this.gameStarted = System.currentTimeMillis();
        this.isRanked = PrefsCache.forceUnranked ? false : Prefs.getBoolean("isRanked", true);
    }

    public void takeValues(String[] playerTypes, String[] playerNames, String[] colorPass, boolean[] guiControl, String boardNamePass) {
        System.out.println("takeValues() playerTypes size=" + playerTypes.length);
        for (int i = 0; i < playerTypes.length; ++i) {
            System.out.println(playerTypes[i]);
        }
        this.guiControl = guiControl;
        this.playerTypes = playerTypes;
        this.playerNames = playerNames;
        this.colorPassString = colorPass;
        this.boardName = boardNamePass;
    }

    private void loadInfo() {
        this.useCards = Prefs.getBoolean("useCards", true);
        this.cardTransfer = Prefs.getBoolean("cardTransfer", true);
        this.immediateCardCash = Prefs.getBoolean("immediateCardCash", true);
        this.firstTurnContBonus = Prefs.getBoolean("firstTurnContBonus", true);
        this.useTurnTimer = Prefs.getBoolean("turnTimer", false);
        this.turnTimerLength = Prefs.getInt("turnTimerSeconds", 45);
        this.cardSequenceCode = Prefs.getInt("cardSequence", 3);
        this.gameLimitMinutes = Lux.gameLimitMinutes > 0 ? Lux.gameLimitMinutes : (Prefs.getBoolean("gameLimit", false) ? Prefs.getInt("gameLimitMinutes", 45) : 0);
        LuxController lux = LuxController.getInstance();
        this.initialArmies = lux.initialArmies();
        this.initialCountries = lux.initialCountries();
        this.useScenario = lux.useScenario();
        if (this.useScenario && lux.getScenarioPlayersForSelection() == 0) {
            this.useScenario = false;
            this.initialArmies = 0;
            this.initialCountries = true;
            SS.debug("Turning off scenario, since it doesn't exist");
        }
        this.boardNumber = lux.boardNumber();
        this.customBoard = lux.isCustomBoard();
        if (this.customBoard) {
            this.boardSize = "custom";
            this.boardName = lux.customBoardName();
        } else {
            this.boardSize = lux.boardSize();
        }
        if (lux.bioLevel() > 0) {
            this.biohazardLevel = lux.bioLevel();
        }
        this.allowNetworkPlayers = lux.allowNetworkPlayers();
        boolean bl = this.internetPublic = this.allowNetworkPlayers && lux.internetPublic();
        if (PrefsCache.headless) {
            this.useTurnTimer = Lux.timeParam > 7;
            this.turnTimerLength = Lux.timeParam;
            this.cardSequenceCode = Lux.cardsParam;
            this.gameLimitMinutes = Lux.gameLimitMinutes;
            if (this.cardSequenceCode == -1) {
                this.useCards = false;
            }
            this.firstTurnContBonus = Lux.firstTurnContBonus;
            if (Lux.useScenario) {
                this.useScenario = true;
            }
        }
    }

    public String[] colorPass() {
        return this.colorPassString;
    }

    public void ensureSeed() {
        if (this.boardNumber != -1 || this.customBoard) {
            return;
        }
        this.boardNumber = BoardCache.pickCachedSeed(this.boardSize);
    }

    public LuxOptions copyWithGuiControlFor(String guiName) {
        boolean[] newGuiControl = new boolean[this.guiControl.length];
        for (int i = 0; i < this.guiControl.length; ++i) {
            newGuiControl[i] = guiName.equals(this.playerNames[i]);
        }
        return new LuxOptions(this, newGuiControl);
    }

    private LuxOptions(LuxOptions other, boolean[] guiControl) {
        this.guiControl = guiControl;
        this.playerTypes = other.playerTypes;
        this.playerNames = other.playerNames;
        this.boardSize = other.boardSize;
        this.initialCountries = other.initialCountries;
        this.useScenario = other.useScenario;
        this.initialArmies = other.initialArmies;
        this.boardNumber = other.boardNumber;
        this.colorPassString = other.colorPassString;
        this.useCards = other.useCards;
        this.cardSequenceCode = other.cardSequenceCode;
        this.cardTransfer = other.cardTransfer;
        this.immediateCardCash = other.immediateCardCash;
        this.firstTurnContBonus = other.firstTurnContBonus;
        this.allowNetworkPlayers = other.allowNetworkPlayers;
        this.internetPublic = other.internetPublic;
        this.width = other.width;
        this.height = other.height;
        this.customBoard = other.customBoard;
        this.boardName = other.boardName;
        this.boardFile = other.boardFile;
        this.useTurnTimer = other.useTurnTimer;
        this.turnTimerLength = other.turnTimerLength;
        this.gameLimitMinutes = other.gameLimitMinutes;
        this.cardSequence = other.cardSequence.copy();
        this.isRanked = other.isRanked;
        this.continentSequence = other.continentSequence.copy();
        this.warFog = other.warFog;
        this.biohazardLevel = other.biohazardLevel;
    }

    public LuxOptions ensureProperOrder() {
        if (Prefs.getBoolean("randomStartingPlayer", true) || this.internetPublic && this.isRanked) {
            this.randomizePlayers();
        }
        return this;
    }

    private void randomizePlayers() {
        if (this.playerTypes.length == 2 || this.playerTypes.length == 3 && this.boardFile != null && this.boardFile.isPlayerEmptyLocked(2)) {
            if (switchNextTwoPlayerOrder) {
                int i = 0;
                int newSpot = 1;
                String temp = this.playerTypes[newSpot];
                this.playerTypes[newSpot] = this.playerTypes[i];
                this.playerTypes[i] = temp;
                temp = this.playerNames[newSpot];
                this.playerNames[newSpot] = this.playerNames[i];
                this.playerNames[i] = temp;
                temp = this.colorPassString[newSpot];
                this.colorPassString[newSpot] = this.colorPassString[i];
                this.colorPassString[i] = temp;
                boolean tempBool = this.guiControl[newSpot];
                this.guiControl[newSpot] = this.guiControl[i];
                this.guiControl[i] = tempBool;
            }
            switchNextTwoPlayerOrder = !switchNextTwoPlayerOrder;
            return;
        }
        Random rand = new Random();
        for (int i = 0; i < this.playerTypes.length; ++i) {
            if (this.useScenario && "Empty".equals(this.playerTypes[i])) continue;
            int newSpot = rand.nextInt(this.playerTypes.length);
            while (this.useScenario && "Empty".equals(this.playerTypes[newSpot])) {
                newSpot = rand.nextInt(this.playerTypes.length);
            }
            if (newSpot == i) continue;
            String temp = this.playerTypes[newSpot];
            this.playerTypes[newSpot] = this.playerTypes[i];
            this.playerTypes[i] = temp;
            temp = this.playerNames[newSpot];
            this.playerNames[newSpot] = this.playerNames[i];
            this.playerNames[i] = temp;
            temp = this.colorPassString[newSpot];
            this.colorPassString[newSpot] = this.colorPassString[i];
            this.colorPassString[i] = temp;
            boolean tempBool = this.guiControl[newSpot];
            this.guiControl[newSpot] = this.guiControl[i];
            this.guiControl[i] = tempBool;
        }
    }

    public int getNextRemoteReplacedIndex() {
        int i;
        for (i = 0; i < this.playerNames.length; ++i) {
            if (!this.playerTypes[i].equals("networkplayeronly")) continue;
            return i;
        }
        for (i = 0; i < this.playerNames.length; ++i) {
            if (this.playerTypes[i].equals("Human") || NetBoss.robotSpot != null && NetBoss.robotSpot[i] || this.boardFile != null && this.boardFile.isPlayerEmptyLocked(i)) continue;
            return i;
        }
        return -1;
    }

    public void removeRemoteOnly() {
        if (this.useScenario) {
            for (int i = 0; i < this.playerNames.length; ++i) {
                if (!this.playerTypes[i].equals("networkplayeronly")) continue;
                try {
                    this.playerTypes[i] = LuxController.getInstance().getFirstAI();
                    continue;
                }
                catch (Exception e) {
                    this.playerTypes[i] = "Cluster";
                }
            }
            return;
        }
        for (int i = 0; i < this.playerNames.length; ++i) {
            if (!this.playerTypes[i].equals("networkplayeronly") && !this.playerTypes[i].equals("<" + Translator.getString("networkplayeronly") + ">")) continue;
            SS.debug("removing network only player from the ops");
            int j = i;
            while (j + 1 < this.playerNames.length) {
                this.playerTypes[j] = this.playerTypes[j + 1];
                this.playerNames[j] = this.playerNames[j + 1];
                this.guiControl[j] = this.guiControl[j + 1];
                this.colorPassString[j] = this.colorPassString[j + 1];
                ++j;
            }
            String[] playerTypesNew = new String[this.playerNames.length - 1];
            String[] playerNamesNew = new String[this.playerNames.length - 1];
            boolean[] guiControlNew = new boolean[this.playerNames.length - 1];
            String[] colorPassStringNew = new String[this.playerNames.length - 1];
            System.arraycopy(this.playerTypes, 0, playerTypesNew, 0, this.playerNames.length - 1);
            System.arraycopy(this.playerNames, 0, playerNamesNew, 0, this.playerNames.length - 1);
            System.arraycopy(this.guiControl, 0, guiControlNew, 0, this.playerNames.length - 1);
            System.arraycopy(this.colorPassString, 0, colorPassStringNew, 0, this.playerNames.length - 1);
            this.playerTypes = playerTypesNew;
            this.playerNames = playerNamesNew;
            this.guiControl = guiControlNew;
            this.colorPassString = colorPassStringNew;
            this.removeRemoteOnly();
            return;
        }
    }

    public int getNextAIIndex() {
        for (int i = 0; i < this.playerNames.length; ++i) {
            if (this.playerTypes[i].equals("Human")) continue;
            return i;
        }
        return -1;
    }

    public String boardName() {
        if (this.customBoard || this.savedGame) {
            return this.boardName;
        }
        this.ensureSeed();
        return this.boardSize + " ID#" + this.boardNumber;
    }

    public String boardNameBio() {
        if (this.biohazardLevel > 0) {
            return this.boardName() + " - BIO " + this.biohazardLevel;
        }
        return this.boardName();
    }

    public String generatorName() {
        if (this.customBoard) {
            return "custom";
        }
        return this.boardSize;
    }

    public String boardTitle() {
        if (this.boardTitle == null) {
            return this.boardName();
        }
        return this.boardTitle;
    }

    public void setBoardTitle(String title) {
        this.boardTitle = title;
    }

    public void ensureBoardFile() throws Exception {
        if (this.boardFile != null) {
            return;
        }
        this.ensureSeed();
        if (this.customBoard) {
            this.boardFile = new BoardFile(this.boardName, true);
            this.boardFile.biohazard(this.biohazardLevel);
        } else {
            this.boardFile = new BoardFile(this.boardSize, this.boardNumber);
            this.boardFile.biohazard(this.biohazardLevel);
        }
    }

    public void deleteRandomBoardFile() {
        if (!this.customBoard) {
            try {
                new File(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Generated" + File.separator + this.boardSize + this.boardNumber + ".luxb").delete();
            }
            catch (Throwable e) {
                System.out.println("Lux -> Error deleting the boardFile: " + e);
            }
        }
    }

    public String toString() {
        return super.toString() + ": " + "\n\t playerTypes=" + this.playerTypes + ",\n\t playerNames=" + this.playerNames + ",\n\t guiControl=" + this.guiControl + ",\n\t continentSequence=" + this.continentSequence + ",\n\t colorPassString=" + this.colorPassString + ",\n\t boardFile=" + this.boardFile + ",\n\t width=" + this.width + ",\n\t height=" + this.height + ",\n\t allowNetworkPlayers=" + this.allowNetworkPlayers + ",\n\t internetPublic=" + this.internetPublic + ",\n\t customBoard=" + this.customBoard + ",\n\t boardName=" + this.boardName + ",\n\t boardSize=" + this.boardSize + ",\n\t boardNumber=" + this.boardNumber + ",\n\t useScenario=" + this.useScenario + ",\n\t initialCountries=" + this.initialCountries + ",\n\t initialArmies=" + this.initialArmies + ",\n\t useCards=" + this.useCards + ",\n\t cardTransfer=" + this.cardTransfer + ",\n\t cardSequenceCode=" + this.cardSequenceCode + ",\n\t immediateCardCash=" + this.immediateCardCash + ",\n\t isRanked=" + this.isRanked + ",\n\t useTurnTimer=" + this.useTurnTimer + "--max minutes:" + this.gameLimitMinutes + ",\n\t turnTimerLength=" + this.turnTimerLength;
    }

    public boolean shortContinentLabels() {
        return this.boardFile.shortContinentLabels();
    }

    public void setEndTime() {
        this.gameEnded = System.currentTimeMillis();
    }

    public LuxOptions() {
        int numberOfPlayers = 4;
        this.guiControl = new boolean[]{true, false, false, false};
        this.playerTypes = new String[]{"Human", "Killbot", "Killbot", "Killbot"};
        this.playerNames = new String[]{"dustin", "bot1", "bot2", "bot3"};
        this.colorPassString = new String[]{"0/0/0", "0/1/0", "0/0/1", "1/0/0"};
        this.cardSequence = new CardSequence(1);
        this.continentSequence = new ContinentSequence(1);
        this.gameStarted = System.currentTimeMillis();
        this.isRanked = false;
        this.useCards = true;
        this.cardSequenceCode = 2;
        this.cardTransfer = true;
        this.immediateCardCash = true;
        this.firstTurnContBonus = true;
        this.useTurnTimer = false;
        this.turnTimerLength = 120.0f;
        this.gameLimitMinutes = 0;
        this.initialArmies = 0;
        this.initialCountries = true;
        this.useScenario = false;
        this.boardNumber = -1;
        this.customBoard = true;
        this.boardSize = "custom";
        this.boardName = "Classic Widescreen";
        this.allowNetworkPlayers = false;
        this.internetPublic = false;
    }

    public int numberOfHumans() {
        int result = 0;
        for (int i = 0; i < this.playerTypes.length; ++i) {
            if (!"Human".equals(this.playerTypes[i])) continue;
            ++result;
        }
        return result;
    }

    public void addPlayer(String name, String type) {
        SS.debug("addPlayer to LuxOptions");
        boolean[] newGuiControl = new boolean[this.guiControl.length + 1];
        String[] newNames = new String[this.guiControl.length + 1];
        String[] newTypes = new String[this.guiControl.length + 1];
        String[] newColors = new String[this.guiControl.length + 1];
        System.arraycopy(this.guiControl, 0, newGuiControl, 0, this.guiControl.length);
        System.arraycopy(this.playerNames, 0, newNames, 0, this.guiControl.length);
        System.arraycopy(this.playerTypes, 0, newTypes, 0, this.guiControl.length);
        System.arraycopy(this.colorPassString, 0, newColors, 0, this.guiControl.length);
        newGuiControl[this.guiControl.length] = false;
        newNames[this.guiControl.length] = name;
        newTypes[this.guiControl.length] = type;
        newColors[this.guiControl.length] = GraphicsTool.stringFromColor(GraphicsTool.getNextColor());
        this.guiControl = newGuiControl;
        this.playerTypes = newTypes;
        this.playerNames = newNames;
        this.colorPassString = newColors;
    }

    public int getGameMinutes() {
        long gameTime = (this.gameEnded == 0L ? System.currentTimeMillis() : this.gameEnded) - this.gameStarted;
        return Math.round((float)gameTime / 60000.0f);
    }
}

