/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.ContinentSequence;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.AboutWindow;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.PreferencesWindow;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSOptionPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import net.roydesign.mac.MRJAdapter;

public class Lux {
    public static String nameParam;
    public static String mapParam;
    public static String agentParam;
    public static int timeParam;
    public static int cardsParam;
    public static int contsParam;
    public static int bioParam;
    public static int shuffleMode;
    public static int gameLimitMinutes;
    public static boolean headlessGenerator;
    public static boolean autoplay;
    public static boolean useScenario;
    public static boolean firstTurnContBonus;
    public static String memoryColor;

    public static void main(String[] args) {
        if (SS.isMacintosh && !PrefsCache.headless) {
            Lux.setMacintoshProperties();
        }
        if (!PrefsCache.headless) {
            Lux.setSystemLookAndFeel();
        }
        Prefs.setPackageClassAndNode(LuxWorld.class, "Preferences");
        SSApp.setup("Lux Delux", "Lux");
        float javaVersion = 0.0f;
        try {
            javaVersion = Float.parseFloat(System.getProperty("java.class.version"));
        }
        catch (Exception e) {
            System.out.println("Error parsing the java version at startup");
        }
        if (javaVersion < 48.0f) {
            if (SS.isMacintosh) {
                SSOptionPane.showMessageDialog("Lux requires a Java version 1.4 or greater to run. Go to Software Update in your System Preferences to update your versions of Java and Mac OS X.");
            } else {
                SSOptionPane.showMessageDialog("Lux requires a Java version 1.4 or greater to run. Please visit http://www.java.com to install an updated version of Java.");
            }
            System.exit(0);
        }
        Translator.loadBundle("LuxBundle");
        for (int i = 0; i < args.length; ++i) {
            int equalPos;
            if ("-locale".equals(args[i]) && i + 1 < args.length) {
                System.out.println("Lux option to set the locale to '" + args[i + 1] + "'");
                Translator.setLocale(args[i + 1]);
                ++i;
                continue;
            }
            if ("-headless".equals(args[i])) {
                PrefsCache.headless = true;
                System.out.println(" ---- HEADLESS MODE: ");
                System.out.println(" ---- Lux is starting up in headless server mode. No GUI elements will appear.");
                continue;
            }
            if (args[i].startsWith("-shuffle")) {
                shuffleMode = StringTool.captureTrailingNumbers(args[i]);
                System.out.println("Shuffle mode has been set to " + shuffleMode);
                continue;
            }
            if ("-superfast".equals(args[i])) {
                PrefsCache.superfast = true;
                System.out.println(" ---- SUPERFAST MODE: ");
                System.out.println("Lux is starting up in superfast mode. Anything that slows down the");
                System.out.println("running of a game will be left out - including debugging information! ");
                System.out.println("You should test your agent without superfast mode to find its bugs.");
                continue;
            }
            if (args[i].startsWith("-name")) {
                String name;
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper name given. Examples: -name=dustin -name=Dustin_Headless_Host");
                    continue;
                }
                nameParam = name = StringTool.underscoreToSpace(args[i].substring(equalPos + 1));
                Prefs.put("playerNames0", name);
                continue;
            }
            if (args[i].startsWith("-agent")) {
                String name;
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper agent given. Examples: -agent=Reaper -agent=networkplayeronly");
                    continue;
                }
                agentParam = name = StringTool.underscoreToSpace(args[i].substring(equalPos + 1));
                continue;
            }
            if (args[i].startsWith("-desc")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper description given. Examples: -desc=Come_play_with_me! -name=Restart_for_humans._Bots_first.");
                    continue;
                }
                Prefs.put("lastDescription", StringTool.underscoreToSpace(args[i].substring(equalPos + 1)));
                continue;
            }
            if (args[i].startsWith("-map=")) {
                String map;
                int j;
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper map given. Examples: -map=ClassicRisk -map=ToThePowerOfHex");
                    continue;
                }
                String desiredMap = args[i].substring(equalPos + 1);
                System.out.println("Desired map = " + desiredMap);
                List mapList = PluginManager.getInstance().getMapList();
                for (j = 0; j < mapList.size() && desiredMap != null; ++j) {
                    map = (String)mapList.get(j);
                    if (!StringTool.stripSpaces(map).equals(desiredMap)) continue;
                    mapParam = map;
                    Prefs.put("mapSelector", map);
                    System.out.println("Set the map to be " + map);
                    desiredMap = null;
                }
                if (desiredMap == null) continue;
                PluginManager.getInstance().loadMapGenerators();
                mapList = PluginManager.getInstance().getAllMapGeneratorChoices();
                for (j = 0; j < mapList.size() && desiredMap != null; ++j) {
                    map = (String)mapList.get(j);
                    SS.debug(map);
                    if (!StringTool.stripSpaces(map).equals(desiredMap)) continue;
                    mapParam = map;
                    Prefs.put("mapSelector", map);
                    headlessGenerator = true;
                    System.out.println("Set the map generator to be " + map);
                    desiredMap = null;
                }
                if (desiredMap == null) continue;
                System.out.println("Map not found. You must strip all spaces from the name. Examples: -map=ClassicRisk -map=ToThePowerOfHex");
                continue;
            }
            if (args[i].equals("-maplock")) {
                Prefs.putBoolean("maplock", true);
                continue;
            }
            if (args[i].startsWith("-autoplay")) {
                if (args[i].endsWith("false")) {
                    Prefs.putBoolean("autoplay", false);
                    continue;
                }
                Prefs.putBoolean("autoplay", true);
                continue;
            }
            if (args[i].startsWith("-time")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 3) {
                    System.out.println("Improper time given. Examples: -time=30 -time=60 -time=0 (for no limit)");
                    continue;
                }
                int seconds = -1;
                try {
                    seconds = Integer.parseInt(args[i].substring(equalPos + 1));
                }
                catch (Exception e) {
                    System.out.println("Improper time given. Examples: -time=30 -time=60 -time=0 (for no limit)");
                }
                if (seconds == 0) {
                    Prefs.putBoolean("turnTimer", false);
                } else {
                    seconds = Math.max(seconds, 8);
                    Prefs.putInt("turnTimerSeconds", seconds);
                    Prefs.putBoolean("turnTimer", true);
                }
                timeParam = seconds;
                continue;
            }
            if (args[i].startsWith("-port")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 3) {
                    System.out.println("Improper time given. Examples: -port=6620");
                    continue;
                }
                int port = 6619;
                try {
                    PrefsCache.hostPort = port = Integer.parseInt(args[i].substring(equalPos + 1));
                }
                catch (Exception e) {
                    System.out.println("Improper port given. Examples: -port=6620");
                }
                continue;
            }
            if (args[i].startsWith("-unranked")) {
                PrefsCache.forceUnranked = true;
                continue;
            }
            if (args[i].startsWith("-placed")) {
                PrefsCache.forcePlaced = true;
                continue;
            }
            if (args[i].startsWith("-scenario")) {
                useScenario = true;
                continue;
            }
            if (args[i].startsWith("-transfer")) {
                if (args[i].endsWith("false")) {
                    Prefs.putBoolean("cardTransfer", false);
                    continue;
                }
                Prefs.putBoolean("cardTransfer", true);
                continue;
            }
            if (args[i].startsWith("-immediate")) {
                if (args[i].endsWith("false")) {
                    Prefs.putBoolean("immediateCardCash", false);
                    continue;
                }
                Prefs.putBoolean("immediateCardCash", true);
                continue;
            }
            if (args[i].startsWith("-cards")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 3) {
                    System.out.println("Improper card sequence given. Examples: -cards=555 -cards=468 -cards=4681015");
                    continue;
                }
                int cardSequenceID = CardSequence.getIDFromString(args[i].substring(equalPos + 1));
                if (cardSequenceID == -1) {
                    System.out.println("Improper card sequence given. Examples: -cards=555 -cards=468 -cards=4681015");
                    System.out.println("Cards will be turned off for this host");
                    cardsParam = cardSequenceID;
                    continue;
                }
                Prefs.putInt("cardSequence", cardSequenceID);
                cardsParam = cardSequenceID;
                continue;
            }
            if (args[i].startsWith("-conts")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 3) {
                    System.out.println("Improper continent increase given. Examples: -conts=0 -conts=5 -conts=20");
                    continue;
                }
                int contSequenceID = ContinentSequence.getIDFromString(args[i].substring(equalPos + 1));
                if (contSequenceID == -1) {
                    System.out.println("Improper continent increase given. Examples: -conts=0 -conts=5 -conts=20");
                    continue;
                }
                Prefs.putInt("continentSequenceCode", contSequenceID);
                contsParam = contSequenceID;
                continue;
            }
            if (args[i].startsWith("-network")) {
                if (args[i].endsWith("false")) {
                    Prefs.putBoolean("allowNetworkPlayers", false);
                    continue;
                }
                Prefs.putBoolean("allowNetworkPlayers", true);
                continue;
            }
            if (args[i].startsWith("-public")) {
                if (args[i].endsWith("false")) {
                    Prefs.putBoolean("internetPublic", false);
                    continue;
                }
                Prefs.putBoolean("internetPublic", true);
                continue;
            }
            if (args[i].startsWith("-bio")) {
                bioParam = StringTool.captureTrailingNumbers(args[i]);
                bioParam = Math.min(bioParam, 6);
                bioParam = Math.max(bioParam, 0);
                System.out.println("Biohazard param set to " + bioParam);
                continue;
            }
            if (args[i].startsWith("-gamelimit")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 3) {
                    System.out.println("Improper game limit given. Examples: -gamelimit=30 -gamelimit=0 (for no limit)");
                    continue;
                }
                int minutes = -1;
                try {
                    minutes = Integer.parseInt(args[i].substring(equalPos + 1));
                }
                catch (Exception e) {
                    System.out.println("Improper game limit given. Examples: -gamelimit=30 -gamelimit=0 (for no limit)");
                }
                if (minutes == 0) {
                    Prefs.putBoolean("gameLimit", false);
                } else {
                    minutes = Math.max(minutes, 30);
                    Prefs.putInt("gameLimitMinutes", minutes);
                    Prefs.putBoolean("gameLimit", true);
                    System.out.println("Game limit set to " + minutes + " minutes");
                }
                gameLimitMinutes = minutes;
                continue;
            }
            if (args[i].startsWith("-regcode")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("ERROR: Improper regcode given.");
                    continue;
                }
                String regcode = args[i].substring(equalPos + 1);
                System.out.println("Registration code = " + regcode);
                Prefs.put("regCode", regcode);
                Prefs.put("regName", "headless");
                continue;
            }
            if (args[i].toLowerCase().startsWith("-nofirstturncontbonus")) {
                firstTurnContBonus = false;
                System.out.println("No continent bonuses will be given in the first round");
                continue;
            }
            System.out.println("Lux unknown argument = " + args[i]);
        }
        URLTool.setUserAgent("Lux v 6.23 (" + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")");
        if (PrefsCache.affiliateURL != null) {
            Prefs.put("affiliateURL", PrefsCache.affiliateURL);
        }
        DesktopTool.initDesktopTool("Lux", "LuxDelux.icns", PrefsCache.headless);
        GraphicsTool.initGraphicsTool(DesktopTool.supportFolderPath(), DesktopTool.modernResourcesLocation());
        new LuxController();
        Lux.ensureNewPreferenceNode();
    }

    public static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean oldPrefsNodeExists() {
        Preferences oldPrefs = Preferences.userNodeForPackage(Lux.class).node("sillysoft");
        boolean oldPrefsExist = oldPrefs.get("PlayerColours1", null) != null;
        return oldPrefsExist;
    }

    private static boolean newPrefsNodeExists() {
        Preferences newPrefs = Preferences.userNodeForPackage(LuxWorld.class).node("Preferences");
        boolean newPrefsExist = newPrefs.get("PlayerColours1", null) != null;
        return newPrefsExist;
    }

    private static void ensureNewPreferenceNode() {
        if (null == Prefs.get("playerInfoSeperate", null)) {
            Prefs.putBoolean("playerInfoSeperate", !Prefs.getBoolean("playerInfoInsideMap", true));
        }
        if (Lux.oldPrefsNodeExists() && !Lux.newPrefsNodeExists()) {
            String[] keys;
            Prefs.setPackageClassAndNode(Lux.class, "sillysoft");
            SS.debug("Transfering old unamed package prefs into a proper location...");
            Preferences mainPrefs = Preferences.userNodeForPackage(LuxWorld.class).node("Preferences");
            Preferences records = Preferences.userNodeForPackage(LuxWorld.class).node("RecordBook");
            Preferences pluginPreferences = Preferences.userNodeForPackage(LuxWorld.class).node("PluginRatings");
            try {
                keys = Prefs.prefs.keys();
            }
            catch (Throwable t) {
                System.out.println("Lux -> record book error: " + t);
                return;
            }
            ProgressMonitor progressMonitor = new ProgressMonitor(null, "Lux is re-organizing how it stores your preferences. Go ahead and play while this is happening.\n\nIf you've played Lux for a long time then it might take a little while. It only has to happen once, and Lux will be a little speedier afterwards.", null, 0, keys.length - 1);
            progressMonitor.setMillisToPopup(0);
            for (int i = 0; i < keys.length; ++i) {
                progressMonitor.setProgress(i);
                String key = keys[i];
                if (key.startsWith("name")) {
                    if (key.startsWith("nameGamesPlayed_")) {
                        records.put("ngp_" + key.substring(16), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("nameGamesWon_")) {
                        records.put("ngw_" + key.substring(13), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("nameNewStatsGamesRecorded_")) {
                        records.put("nnsgr_" + key.substring(26), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("nameRoundsTotal_")) {
                        records.put("nrt_" + key.substring(16), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("namePlacementTotal_")) {
                        records.put("npt_" + key.substring(19), Prefs.get(key));
                        continue;
                    }
                    mainPrefs.put(key, Prefs.get(key));
                    continue;
                }
                if (key.startsWith("agent")) {
                    if (key.startsWith("agentGamesPlayed_")) {
                        records.put("agp_" + key.substring(17), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("agentGamesWon_")) {
                        records.put("agw_" + key.substring(14), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("agentNewStatsGamesRecorded_")) {
                        records.put("ansgr_" + key.substring(27), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("agentRoundsTotal_")) {
                        records.put("art_" + key.substring(17), Prefs.get(key));
                        continue;
                    }
                    if (key.startsWith("agentPlacementTotal_")) {
                        records.put("apt_" + key.substring(20), Prefs.get(key));
                        continue;
                    }
                    mainPrefs.put(key, Prefs.get(key));
                    continue;
                }
                if (key.startsWith("pluginRating_")) {
                    if (Prefs.getInt(key, 0) == 0) continue;
                    pluginPreferences.put(key, Prefs.get(key));
                    continue;
                }
                if (key.startsWith("savedBoardCopied4")) continue;
                mainPrefs.put(key, Prefs.get(key));
            }
            Preferences oldPrefs = Prefs.prefs;
            SS.debug("Finished transferring old preferences entries.");
            Prefs.flush(records);
            Prefs.flush(mainPrefs);
            Prefs.flush(pluginPreferences);
            Prefs.setPackageClassAndNode(LuxWorld.class, "Preferences");
            try {
                oldPrefs.removeNode();
                SS.debug("Finished removing old prefs node.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Prefs.sync();
        }
    }

    private static void setMacintoshProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "false");
        System.setProperty("apple.awt.fakefullscreen", "true");
        try {
            MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutWindow.show(6.23f, LuxController.getInstance());
                }
            });
            MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferencesWindow.show();
                }
            });
            MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LuxController.getInstance().quit();
                }
            });
        }
        catch (Throwable t) {
            System.out.println("ERROR: Lux could not find some parts of itself that it needs to integrate into the MacOS X environment. Perhaps this was caused by running the Linux installer on a Macintosh. This is not currently supported. Please go to http://sillysoft.net/download/ to get the Macintosh package if you want to run Lux on your Mac. You may be able to get around this error by putting the MRJAdapter.jar jar on the classpath when running Lux.");
            t.printStackTrace();
        }
    }

    static {
        shuffleMode = -1;
        gameLimitMinutes = 0;
        headlessGenerator = false;
        autoplay = true;
        useScenario = false;
        firstTurnContBonus = true;
    }
}

