/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.BoardCache;
import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.SS;
import com.sillysoft.widgets.SSApp;
import java.io.File;

public class LoadBoard {
    private static final String boardLocation = DesktopTool.supportFolderPath() + "Boards" + File.separator;
    private String shortname;
    private String boardSize;
    private int boardNumber;

    public LoadBoard(GameControllerAbstract control) throws Exception {
        String boardDir;
        this.boardSize = control.ops.boardSize;
        if (!control.ops.customBoard && control.ops.boardNumber == -1) {
            control.ops.boardNumber = BoardCache.pickCachedSeed(this.boardSize);
        }
        this.boardNumber = control.ops.boardNumber;
        if (control.ops.savedGame) {
            boardDir = DesktopTool.savedGameDir();
            this.shortname = control.ops.boardName();
        } else if (control.ops.customBoard) {
            boardDir = boardLocation + "Saved" + File.separator;
            this.shortname = control.ops.boardName() + ".luxb";
        } else {
            SS.debug("LoadBoard(control) hit with a generated board");
            boardDir = boardLocation + "Generated" + File.separator;
            this.shortname = this.boardSize + this.boardNumber + ".luxb";
        }
        if (control.ops.boardFile != null) {
            control.ops.boardFile.load(control);
            if (!control.ops.customBoard) {
                control.ops.deleteRandomBoardFile();
            }
            return;
        }
        File boardFile = new File(boardDir + this.shortname);
        if (boardFile.exists()) {
            control.ops.boardFile = new BoardFile(boardDir + this.shortname);
            if (!control.ops.savedGame) {
                control.ops.boardFile.biohazard(control.ops.biohazardLevel);
            }
            control.ops.boardFile.load(control);
            control.ops.deleteRandomBoardFile();
            if (!control.ops.customBoard && !control.ops.savedGame) {
                try {
                    new File(boardDir + this.shortname).delete();
                }
                catch (Throwable e) {
                    System.out.println("Error deleting the boardFile: " + e);
                }
            }
            return;
        }
        if (control.ops.customBoard) {
            SS.debug("Lux -> LoadBoard failed to find the desired custom board");
            SSApp.getInstance().fillMapSelector(null);
            throw new Exception("Could not find the specified board file.");
        }
        control.ops.boardFile = new BoardFile(this.boardSize, this.boardNumber, control);
        control.ops.boardFile.biohazard(control.ops.biohazardLevel);
        control.ops.boardFile.load(control);
    }
}

