/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.LoadBoard;
import com.sillysoft.lux.Lux;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;

public class GameControllerHeadless
extends GameControllerAbstract
implements Runnable {
    public GameControllerHeadless(LuxOptions ops, boolean masterControl, NetBoss netBoss) {
        super(ops, masterControl, netBoss);
        this.startGame();
    }

    protected void playNextMap() {
        if (this.world != null) {
            this.world.kill();
            SS.debug("killed world");
            this.world = null;
        }
        this.startGame();
    }

    public void createUserButtons() {
    }

    public void giveUserButtons() {
    }

    public void updateCardButton(int numberCards, boolean hasSet) {
    }

    public void clickCards() {
    }

    public void clickEndTurn() {
    }

    public void giveUpPlayer(int playerIndex) {
    }

    protected void forceLocalEndTurn() {
    }

    protected void ensureCashCardsAvailable() {
    }

    public void setHelperTextAfterName(String text) {
    }

    public void setArrowOnCountry(int countryFrom, int countryTo) {
    }

    public void setArrowOnCountry(int countryFrom, int[] countryToArray) {
    }

    public void setArrowOnCountry(int countryFrom, int[] countryToArray, boolean doubleArrow) {
    }

    public void setLoadText(String text) {
    }

    public int getFluxArmies() {
        return 0;
    }

    public void setFluxBox(int i) {
    }

    public void startUserTurn(Card[] cards) {
    }

    public void userMoveInArmies(int cc) {
    }

    public void doneMovingIn(int cc) {
    }

    public void cardsWereCashed() {
    }

    public void userChooseCountries() {
    }

    public void userPlaceInitialArmies() {
    }

    public void userAttackWin(int cc) {
    }

    public void userAttackLose(int cc) {
    }

    public void userAttackDraw(int cc) {
    }

    public void userAttackPhase(int cc) {
    }

    public void userEliminatedPlayer() {
    }

    public void startGame() {
        new Thread((Runnable)this, "GameControllerHeadless").start();
    }

    public void gameOver() {
        this.netBoss.promoteWinner();
        if (Lux.autoplay) {
            this.autoplayHandler();
        }
    }

    public void autoplayHandler() {
        Runnable autoplayRunnable = new Runnable(){

            public void run() {
                if (!PrefsCache.superfast) {
                    for (int i = 0; i < 30; ++i) {
                        if (i % 5 == 0) {
                            GameControllerHeadless.this.netBoss.printToAll("tra: 3 :Autoplaygamewillstart: " + (30 - i) + " :seconds: - " + (GameControllerHeadless.this.netBoss.getNumberOfHumans() - GameControllerHeadless.this.netBoss.getNumberOfGuestOnly()) + "/" + GameControllerHeadless.this.netBoss.getNumberOfHumans() + " :players:");
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception e) {
                            GameControllerHeadless.this.debug("autoplay exception 83746");
                        }
                    }
                }
                GameControllerHeadless.this.clickNextMap();
            }
        };
        new Thread(autoplayRunnable, "Headless-Autoplay-runner").start();
    }

    public void run() {
        try {
            if (PrefsCache.headless && !SS.isMacintosh && !SS.isWindows && this.ops.useScenario) {
                SS.debug("headless linux host wait for a sec");
                try {
                    Thread.yield();
                    Thread.sleep(3000L);
                    Thread.yield();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.world = new LuxWorld(this);
            try {
                new LoadBoard(this);
            }
            catch (Throwable e) {
                SS.debug("Lux -> a GameController failed to load his board. Kill him off");
                e.printStackTrace();
                this.ops.deleteRandomBoardFile();
                String boardName = null;
                if (this.ops != null) {
                    boardName = this.ops.boardName();
                }
                this.kill();
                return;
            }
            this.world.finishCreation();
            this.gameIsOver = false;
            if (PrefsCache.headless && !SS.isMacintosh && !SS.isWindows) {
                SS.debug("headless linux host wait for a sec");
                try {
                    Thread.yield();
                    Thread.sleep(1000L);
                    Thread.yield();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            new Thread((Runnable)this.world, "LuxWorld").start();
            this.doneCreation = true;
            this.doneCreationHandler();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flashContinent(int cont) {
    }

    public boolean cardsMode() {
        return false;
    }

    public void showMessage(String text) {
        System.out.println(text);
    }
}

