/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.NaughtyList;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.SS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class EsellerateWrapper {
    public static boolean validRegistration(String name, String code) {
        String result;
        Process pr;
        String[] commands;
        if (name == null || code == null) {
            return false;
        }
        if ("".equals(name.trim()) || "".equals(code.trim())) {
            return false;
        }
        if (NaughtyList.contains(name, code)) {
            return false;
        }
        if (code.toUpperCase().startsWith("DE-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "MERSCOM" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("MG-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "MANIFESTO" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("IM-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "MACGAMESTORE" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("R4-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "FUTURE4" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("R5-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "OPENSPOT" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("R6-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "FORWARD" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("R7-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "WORMHOLE" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("GG-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "SCANPORT" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (code.toUpperCase().startsWith("LD-")) {
            if (code.length() < 10) {
                return false;
            }
            String randomDigits = code.substring(3, 9);
            String codeName = "EXTRAWIN" + randomDigits.toUpperCase();
            String properCode = "luxcode-" + code.toUpperCase().substring(10);
            return EsellerateWrapper.validRegistration(codeName, properCode);
        }
        if (!SS.isMacintosh && !SS.isWindows) {
            if (EsellerateWrapper.acceptLinuxCode(code)) {
                return true;
            }
            EsellerateWrapper.printError();
            return false;
        }
        if (!code.startsWith("luxpack000") && !code.startsWith("luxcode-") || code.length() < 20) {
            if (code.startsWith("-")) {
                return EsellerateWrapper.validRegistration(name, "luxcode" + code);
            }
            return EsellerateWrapper.validRegistration(name, "luxcode-" + code);
        }
        int validateResult = 0;
        String location = SS.isMacintosh ? DesktopTool.bundleResourcesLocation() + "SSNetLib.mac" : DesktopTool.supportFolderPathExecutableSafe() + "SSNetLib.win";
        try {
            commands = new String[]{location, "SSNetLib initialize 5568", name, code};
            pr = Runtime.getRuntime().exec(commands);
            BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((result = in.readLine()) != null) {
                if (result.indexOf("Initialized: 1394") == -1) continue;
                validateResult = 1394;
            }
        }
        catch (Throwable e) {
            EsellerateWrapper.printError();
            e.printStackTrace();
            return false;
        }
        if (validateResult == 0) {
            Object[] verifyBuf;
            FileInputStream in;
            File f;
            if (SS.isMacintosh) {
                if (SS.isMacintosh104 || SS.isMacintosh105) {
                    try {
                        f = new File(DesktopTool.bundleResourcesLocation() + "eSellValidate");
                        if (f.length() != 31260L) {
                            EsellerateWrapper.printError();
                            return false;
                        }
                        in = new FileInputStream(f);
                        verifyBuf = new byte[]{-2, -19, -6, -50, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 52, 0, 0, 26, 92, 0, 0, 0, -107};
                        byte[] buf = new byte[verifyBuf.length];
                        int numRead = in.read(buf);
                        if (numRead != verifyBuf.length) {
                            EsellerateWrapper.printError();
                            return false;
                        }
                        for (int i = 0; i < verifyBuf.length; ++i) {
                            if (verifyBuf[i] == buf[i]) continue;
                            EsellerateWrapper.printError();
                            return false;
                        }
                    }
                    catch (Throwable e) {
                        EsellerateWrapper.printError();
                        return false;
                    }
                    try {
                        commands = new String[]{DesktopTool.bundleResourcesLocation() + "eSellValidate", "eSellSecretArgument", name, code};
                        pr = Runtime.getRuntime().exec(commands);
                        BufferedReader in2 = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        while ((result = in2.readLine()) != null) {
                            if (!result.startsWith("validateResult:")) continue;
                            validateResult = Integer.parseInt(result.substring(15));
                        }
                    }
                    catch (Throwable e) {
                        EsellerateWrapper.printError();
                        return false;
                    }
                }
            } else {
                try {
                    f = new File(DesktopTool.supportFolderPathExecutableSafe() + "init.exe");
                    if (f.length() != 30720L) {
                        EsellerateWrapper.printError();
                        return false;
                    }
                    in = new FileInputStream(f);
                    verifyBuf = new int[]{77, 90, -112, 0, 3, 0, 0, 0, 4, 0, 0, 0, -1, -1, 0, 0, -72, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0};
                    byte[] buf = new byte[verifyBuf.length];
                    int numRead = in.read(buf);
                    if (numRead != verifyBuf.length) {
                        System.out.println(numRead + "," + verifyBuf.length);
                        EsellerateWrapper.printError();
                        return false;
                    }
                    for (int i = 0; i < verifyBuf.length; ++i) {
                        if (verifyBuf[i] == buf[i]) continue;
                        System.out.println(i + ": " + verifyBuf[i] + "," + buf[i]);
                        EsellerateWrapper.printError();
                        return false;
                    }
                }
                catch (Throwable e) {
                    EsellerateWrapper.printError();
                    return false;
                }
                try {
                    String result2;
                    commands = new String[]{DesktopTool.supportFolderPathExecutableSafe() + "init.exe", "eSellSecretArgument", name, code};
                    pr = Runtime.getRuntime().exec(commands);
                    BufferedReader in3 = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String returnStart = "CPU:";
                    while ((result2 = in3.readLine()) != null) {
                        if (!result2.toLowerCase().startsWith(returnStart.toLowerCase())) continue;
                        validateResult = Integer.parseInt(result2.substring(returnStart.length()));
                    }
                }
                catch (Throwable e) {
                    EsellerateWrapper.printError();
                    return false;
                }
            }
        }
        if (validateResult == 0) {
            EsellerateWrapper.printError();
            return false;
        }
        return true;
    }

    private static void printError() {
    }

    private static boolean acceptLinuxCode(String code) {
        if (code.length() <= 30) {
            return false;
        }
        return code.startsWith("luxpack000-") || code.startsWith("luxcode-");
    }
}

