/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.DiceBasket;
import com.sillysoft.lux.DiceOdds;
import java.util.Hashtable;
import java.util.Random;

public class Dice {
    private static boolean verbose = false;
    private static boolean chartMode = false;
    private static int chartTries = 100;
    private static int rollerClass = 1;
    private static int diceBasketSize = 5;
    protected static Random rand = new Random();
    protected Hashtable stats = new Hashtable();

    public int getNextDiceRoll() {
        return rand.nextInt(6) + 1;
    }

    public void roll(int attackDice, int defendDice, int[] results) {
        int temp;
        int i;
        int[] attackDiceArray = new int[attackDice];
        int[] defendDiceArray = new int[defendDice];
        for (i = 0; i < attackDice; ++i) {
            attackDiceArray[i] = this.getNextDiceRoll();
        }
        for (i = 0; i < defendDice; ++i) {
            defendDiceArray[i] = this.getNextDiceRoll();
        }
        if (attackDice > 1 && attackDiceArray[0] < attackDiceArray[1]) {
            temp = attackDiceArray[0];
            attackDiceArray[0] = attackDiceArray[1];
            attackDiceArray[1] = temp;
        }
        if (attackDice == 3 && attackDiceArray[1] < attackDiceArray[2]) {
            temp = attackDiceArray[2];
            attackDiceArray[2] = attackDiceArray[1];
            if (attackDiceArray[0] < temp) {
                attackDiceArray[1] = attackDiceArray[0];
                attackDiceArray[0] = temp;
            } else {
                attackDiceArray[1] = temp;
            }
        }
        if (defendDice == 2 && defendDiceArray[0] < defendDiceArray[1]) {
            temp = defendDiceArray[0];
            defendDiceArray[0] = defendDiceArray[1];
            defendDiceArray[1] = temp;
        }
        int attackerLoses = 0;
        int defenderLoses = 0;
        if (attackDiceArray[0] > defendDiceArray[0]) {
            ++defenderLoses;
        } else {
            ++attackerLoses;
        }
        if (defendDice != 2 || attackDice <= 1 || attackDiceArray[1] <= defendDiceArray[1]) {
            // empty if block
        }
        results[0] = ++attackerLoses;
        results[1] = ++defenderLoses;
        this.recordBattle(attackDice, defendDice, attackerLoses, defenderLoses);
    }

    public void recordBattle(int attackDice, int defendDice, int attackerLosses, int defenderLosses) {
    }

    protected int getInt(String key) {
        Object o = this.stats.get(key);
        if (o == null) {
            return 0;
        }
        return (Integer)o;
    }

    public void printStats() {
        float total = this.getInt("3211") + this.getInt("3220") + this.getInt("3202");
        System.out.println("");
        System.out.println(" ------------------ START DICE RESULTS ------------------ ");
        if (total != 0.0f) {
            System.out.println("");
            System.out.println("Dice 3-2 total attacks: " + total);
            System.out.println("Dice 3-2 attacker loses twice: " + this.getInt("3220") + " times - " + this.nice((float)this.getInt("3220") / total) + "% off by " + Dice.nice2((double)this.getInt("3220") * 100.0 / (double)total - 29.26));
            System.out.println("Dice 3-2 defender loses twice: " + this.getInt("3202") + " times - " + this.nice((float)this.getInt("3202") / total) + "% off by " + Dice.nice2((double)this.getInt("3202") * 100.0 / (double)total - 37.17));
            System.out.println("Dice 3-2 one loss each: " + this.getInt("3211") + " times - " + this.nice((float)this.getInt("3211") / total) + "% off by " + Dice.nice2((double)this.getInt("3211") * 100.0 / (double)total - 33.58));
        }
        if ((total = (float)(this.getInt("2211") + this.getInt("2220") + this.getInt("2202"))) != 0.0f) {
            System.out.println("");
            System.out.println("Dice 2-2 total attacks: " + total);
            System.out.println("Dice 2-2 attacker loses twice: " + this.getInt("2220") + " times - " + this.nice((float)this.getInt("2220") / total) + "%");
            System.out.println("Dice 2-2 defender loses twice: " + this.getInt("2202") + " times - " + this.nice((float)this.getInt("2202") / total) + "%");
            System.out.println("Dice 2-2 one loss each: " + this.getInt("2211") + " times - " + this.nice((float)this.getInt("2211") / total) + "%");
        }
        if ((total = (float)(this.getInt("1210") + this.getInt("1201"))) != 0.0f) {
            System.out.println("");
            System.out.println("Dice 1-2 total attacks: " + total);
            System.out.println("Dice 1-2 attacker loses: " + this.getInt("1210") + " times - " + this.nice((float)this.getInt("1210") / total) + "%");
            System.out.println("Dice 1-2 defender loses: " + this.getInt("1201") + " times - " + this.nice((float)this.getInt("1201") / total) + "%");
        }
        if ((total = (float)(this.getInt("3110") + this.getInt("3101"))) != 0.0f) {
            System.out.println("");
            System.out.println("Dice 3-1 total attacks: " + total);
            System.out.println("Dice 3-1 attacker loses: " + this.getInt("3110") + " times - " + this.nice((float)this.getInt("3110") / total) + "%");
            System.out.println("Dice 3-1 defender loses: " + this.getInt("3101") + " times - " + this.nice((float)this.getInt("3101") / total) + "%");
        }
        if ((total = (float)(this.getInt("2110") + this.getInt("2101"))) != 0.0f) {
            System.out.println("");
            System.out.println("Dice 2-1 total attacks: " + total);
            System.out.println("Dice 2-1 attacker loses: " + this.getInt("2110") + " times - " + this.nice((float)this.getInt("2110") / total) + "%");
            System.out.println("Dice 2-1 defender loses: " + this.getInt("2101") + " times - " + this.nice((float)this.getInt("2101") / total) + "%");
        }
        if ((total = (float)(this.getInt("1110") + this.getInt("1101"))) != 0.0f) {
            System.out.println("");
            System.out.println("Dice 1-1 total attacks: " + total);
            System.out.println("Dice 1-1 attacker loses: " + this.getInt("1110") + " times - " + this.nice((float)this.getInt("1110") / total) + "%");
            System.out.println("Dice 1-1 defender loses: " + this.getInt("1101") + " times - " + this.nice((float)this.getInt("1101") / total) + "%");
        }
        System.out.println("");
        System.out.println(" ------------------ END DICE RESULTS ------------------ ");
        System.out.println("");
    }

    protected String nice(double number) {
        return String.valueOf((double)((int)(number * 10000.0)) / 100.0);
    }

    public static String nice2(double number) {
        return String.valueOf((double)((int)(number * 100.0)) / 100.0);
    }

    public float getError() {
        int total = this.getInt("3211") + this.getInt("3220") + this.getInt("3202");
        float error = 0.0f;
        error = (float)((double)error + Math.abs((double)this.getInt("3220") * 100.0 / (double)total - 29.26));
        error = (float)((double)error + Math.abs((double)this.getInt("3202") * 100.0 / (double)total - 37.17));
        error = (float)((double)error + Math.abs((double)this.getInt("3211") * 100.0 / (double)total - 33.58));
        return error;
    }

    public static Dice getNewInstance() {
        if (rollerClass == 2) {
            return new DiceBasket(diceBasketSize);
        }
        if (rollerClass == 3) {
            return new DiceOdds();
        }
        return new Dice();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("-v".equals(args[i])) {
                verbose = true;
            }
            if ("-chart".equals(args[i])) {
                chartMode = true;
                try {
                    chartTries = Integer.parseInt(args[i + 1]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("Using " + chartTries + " tries for each datapoint on the chart.");
            }
            if ("-2".equals(args[i])) {
                try {
                    diceBasketSize = Integer.parseInt(args[i + 1]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("Using DiceBasket (size " + diceBasketSize + ") class as the roller.");
                rollerClass = 2;
            }
            if (!"-3".equals(args[i])) continue;
            System.out.println("Using DiceOdds class as the roller.");
            rollerClass = 3;
        }
        if (chartMode) {
            Dice.printChart();
            return;
        }
        int[] results = new int[2];
        float error = 0.0f;
        int iterations = 1000;
        for (int i = 1; i < iterations; ++i) {
            Dice dice = Dice.getNewInstance();
            verbose = false;
            for (int r = 0; r < 20; ++r) {
                dice.roll(3, 2, results);
            }
            error += dice.getError();
        }
        System.out.println("Error metric for " + iterations + " iterations = " + Dice.nice2(error / (float)iterations));
    }

    static void printChart() {
        int d;
        Dice dice = Dice.getNewInstance();
        System.out.println("Attacker armies are displayed on the left hand side.");
        System.out.println(" ");
        System.out.println("                                    Defender Armies");
        System.out.print("      ");
        for (d = 1; d < 16; ++d) {
            System.out.print(Dice.padd(d, 3) + "   ");
        }
        System.out.println(" ");
        System.out.print("      ");
        for (d = 1; d < 16; ++d) {
            System.out.print("------");
        }
        System.out.println(" ");
        for (int a = 1; a < 26; ++a) {
            System.out.print(Dice.padd(a, 3) + " | ");
            for (int d2 = 1; d2 < 16; ++d2) {
                int aWins = 0;
                for (int t = 0; t < chartTries; ++t) {
                    aWins += dice.doesAttackerWin(a, d2) ? 1 : 0;
                }
                System.out.print(Dice.padd(Dice.percent(aWins, chartTries), 3) + "   ");
            }
            System.out.println(" ");
        }
    }

    public static int percent(int number, int outof) {
        return Math.round((float)number / (float)(outof / 100));
    }

    public static String padd(int number, int length) {
        StringBuffer sb = new StringBuffer();
        if (number < 10 && length > 1) {
            sb.append(" ");
        }
        if (number < 100 && length > 1) {
            sb.append(" ");
        }
        return sb.append(number).toString();
    }

    boolean doesAttackerWin(int attackArmies, int defendArmies) {
        int dLeft;
        int aLeft = attackArmies;
        int[] results = new int[2];
        for (dLeft = defendArmies; aLeft > 1 && dLeft > 0; aLeft -= results[0], dLeft -= results[1]) {
            this.roll(Math.min(3, aLeft - 1), Math.min(2, dLeft), results);
        }
        return dLeft == 0;
    }
}

