/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.Lux;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.SSClassLoader;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.JoinGame;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.lux.net.LuxTracker;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.DirectoryTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.LogFile;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.RegisterNag;
import com.sillysoft.widgets.SSChatArea;
import com.sillysoft.widgets.SSCheckBox;
import com.sillysoft.widgets.SSColorWell;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSFrameWatcher;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSTextField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.prefs.Preferences;

public abstract class CrossPlatformLuxController
implements SSFrameWatcher {
    public Thread mainThread;
    public boolean sharewareVersion;
    protected int sharewareCount;
    protected boolean ignoreAllComputerCheck = false;
    protected boolean killed = false;
    protected Vector windows = new Vector();
    protected static LuxController sharedController;
    protected Random rand;
    protected Vector allAgents;
    protected Vector easyAgents;
    protected Vector mediumAgents;
    protected Vector hardAgents;
    protected Vector moreAgents;
    protected SSComboBox[] playerTypes;
    protected SSTextField[] playerNames;
    public SSColorWell[] playerColors;
    protected SSComboBox mapSelector;
    protected SSComboBox bioLevel;
    protected SSComboBox mapStartingPosition;
    protected SSCheckBox allowNetworkPlayers;
    protected SSCheckBox internetPublic;
    protected SSCheckBox fullscreenCheckbox;
    protected boolean fillingMapSelector = false;

    public abstract void showSharewareOverWindow();

    public abstract void showNewGameWindow();

    public abstract void hideNewGameWindow();

    public abstract void terminate();

    public abstract void saveSelectionsToDefs();

    public static LuxController getInstance() {
        return sharedController;
    }

    public String jarLocation() {
        String fullClassName = CrossPlatformLuxController.getInstance().getClass().getName();
        String smallName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String classLocation = CrossPlatformLuxController.getInstance().getClass().getResource(smallName + ".class").toString();
        classLocation = classLocation.substring(9, classLocation.lastIndexOf(33));
        classLocation = classLocation.replaceAll("%20", " ");
        return classLocation;
    }

    public CrossPlatformLuxController() {
        sharedController = (LuxController)this;
        UpdateController.initUpdateController("http://sillysoft.net/", 6.23f, sharedController);
        File oldClassFolder = new File(DesktopTool.supportFolderPath() + "Agents");
        if (!Prefs.getBoolean("removedOldClasses", false)) {
            Prefs.putBoolean("removedOldClasses", true);
            if (oldClassFolder.exists() && oldClassFolder.lastModified() < 1132638653132L) {
                SS.debug("The Agents and MapGenerators folders were created before the switch to the 5.2 packaged versions. Delete any existing classes");
                DirectoryTool.deleteFilesWithSuffix(oldClassFolder, ".class");
                DirectoryTool.deleteFilesWithSuffix(new File(DesktopTool.supportFolderPath() + "MapGenerators"), ".class");
            }
        }
        new File(DesktopTool.supportFolderPath() + "Boards").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Generated").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Agents").mkdirs();
        new File(DesktopTool.supportFolderPath() + "MapGenerators").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Themes").mkdirs();
        LogFile.copySystemOutputToFile(DesktopTool.supportFolderPath() + "log.txt");
        System.out.println("Lux version 6.23 starting under user " + System.getProperty("user.name"));
        System.out.println("  -> OS: " + System.getProperty("os.name") + " / " + System.getProperty("os.version") + " / " + System.getProperty("os.arch"));
        System.out.println("  -> VM: " + System.getProperty("java.version") + " / " + System.getProperty("java.class.version"));
        System.out.println("  -> support: " + DesktopTool.supportFolderPath());
        System.out.println("  -> jar: " + this.jarLocation());
        this.rand = new Random();
        this.mainThread = Thread.currentThread();
        this.allAgents = new Vector();
        this.easyAgents = new Vector();
        this.mediumAgents = new Vector();
        this.hardAgents = new Vector();
        this.easyAgents.add("Angry");
        this.easyAgents.add("Communist");
        this.easyAgents.add("Stinky");
        this.mediumAgents.add("Cluster");
        this.mediumAgents.add("Pixie");
        this.mediumAgents.add("Shaft");
        this.mediumAgents.add("Yakool");
        this.hardAgents.add("Boscoe");
        this.hardAgents.add("EvilPixie");
        this.hardAgents.add("Killbot");
        this.hardAgents.add("Quo");
        if (!PrefsCache.headless) {
            SSFrame.setFrameWatcher(this);
        }
    }

    private void startMemoryReportThread() {
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("free mem = " + Runtime.getRuntime().freeMemory() / 1000000L + " / " + Runtime.getRuntime().totalMemory() / 1000000L + ", max = " + Runtime.getRuntime().maxMemory() / 1000000L);
                }
            }
        }.start();
    }

    public void setInitialSharewareCount() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(LuxController.getSharewareFilename()));
            String input = in.readLine();
            in.close();
            this.sharewareCount = Math.max(Integer.parseInt(input), this.sharewareCount);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (Float.parseFloat(System.getProperty("java.class.version")) >= 48.0f) {
                this.sharewareCount = Math.max(this.sharewareCount, Prefs.getInt("savedSelection", 0));
            }
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        if (this.sharewareCount < 0) {
            this.sharewareCount = 30;
        }
    }

    public String getRandomAI(int diffcode) {
        switch (diffcode) {
            case 0: {
                return (String)this.allAgents.get(this.rand.nextInt(this.allAgents.size()));
            }
            case 1: {
                return (String)this.easyAgents.get(this.rand.nextInt(this.easyAgents.size()));
            }
            case 3: {
                return (String)this.mediumAgents.get(this.rand.nextInt(this.mediumAgents.size()));
            }
            case 5: {
                return (String)this.hardAgents.get(this.rand.nextInt(this.hardAgents.size()));
            }
            case 2: {
                int pos = this.rand.nextInt(this.easyAgents.size() + this.mediumAgents.size());
                if (pos < this.easyAgents.size()) {
                    return (String)this.easyAgents.get(pos);
                }
                return (String)this.mediumAgents.get(pos - this.easyAgents.size());
            }
            case 4: {
                int pos2 = this.rand.nextInt(this.hardAgents.size() + this.mediumAgents.size());
                if (pos2 < this.hardAgents.size()) {
                    return (String)this.hardAgents.get(pos2);
                }
                return (String)this.mediumAgents.get(pos2 - this.hardAgents.size());
            }
        }
        System.out.println("Lux -> ERROR in getRandomAI(). bad diffcode (" + diffcode + ").");
        return null;
    }

    public void stopTutorial() {
        Prefs.putBoolean("tutorialStart", false);
        Prefs.putBoolean("tutorialStart2", false);
        Prefs.putBoolean("tutorialStart3", false);
        Prefs.putBoolean("tutorialPlaceInitialArmies", false);
        Prefs.putBoolean("tutorialAttackDraw", false);
        Prefs.putBoolean("tutorialTookCountry", false);
        Prefs.putBoolean("tutorialEliminatedPlayer", false);
        Prefs.putBoolean("tutorialAttackPhase", false);
        Prefs.putBoolean("tutorialStartTurn", false);
        Prefs.putBoolean("tutorialStartTurnWithSet", false);
        Prefs.putBoolean("tutorialFirstCard", false);
        Prefs.putBoolean("tutorialFirstFortifyPhase", false);
        Prefs.putBoolean("tutorialPlaceInitialArmiesAll", false);
        Prefs.putBoolean("tutorialMoveInArmies", false);
        Prefs.putBoolean("tutorialShowCards", false);
        Prefs.putBoolean("tutorialCashCards", false);
        Prefs.putBoolean("tutorialIncomes", false);
        Prefs.putBoolean("tutorialDoneMovingIn", false);
        GameControllerGUI.reloadTutorial();
    }

    public void restartTutorial() {
        Prefs.putBoolean("tutorialStart", true);
        Prefs.putBoolean("tutorialStart2", true);
        Prefs.putBoolean("tutorialStart3", true);
        Prefs.putBoolean("tutorialPlaceInitialArmies", true);
        Prefs.putBoolean("tutorialAttackDraw", true);
        Prefs.putBoolean("tutorialTookCountry", true);
        Prefs.putBoolean("tutorialEliminatedPlayer", true);
        Prefs.putBoolean("tutorialAttackPhase", true);
        Prefs.putBoolean("tutorialStartTurn", true);
        Prefs.putBoolean("tutorialStartTurnWithSet", true);
        Prefs.putBoolean("tutorialFirstCard", true);
        Prefs.putBoolean("tutorialFirstFortifyPhase", true);
        Prefs.putBoolean("tutorialPlaceInitialArmiesAll", true);
        Prefs.putBoolean("tutorialMoveInArmies", true);
        Prefs.putBoolean("tutorialShowCards", true);
        Prefs.putBoolean("tutorialCashCards", true);
        Prefs.putBoolean("tutorialIncomes", true);
        Prefs.putBoolean("tutorialDoneMovingIn", true);
        GameControllerGUI.reloadTutorial();
    }

    public void upSharewareCount() {
        ++this.sharewareCount;
        Prefs.putInt("savedSelection", this.sharewareCount);
        Prefs.sync();
    }

    public boolean isDemo() {
        return this.sharewareVersion;
    }

    public int getSharewareCount() {
        return this.sharewareCount;
    }

    public boolean isSharewareLocked() {
        if (this.sharewareVersion && this.sharewareCount >= 30) {
            this.showSharewareOverWindow();
            SS.beep();
            return true;
        }
        return false;
    }

    public void addMe(Object window) {
        if (!this.windows.contains(window)) {
            this.windows.add(window);
        }
        this.printActiveWindowList();
    }

    public void killMe(Object dead) {
        this.windows.remove(dead);
        if (this.killed) {
            return;
        }
        if (this.windows.size() == 0) {
            if (dead != null && dead instanceof SSChatArea) {
                JoinGame.show();
            } else {
                this.showNewGameWindow();
            }
        }
        this.printActiveWindowList();
    }

    public void printActiveWindowList() {
    }

    static void debug(Object foo) {
        if (PrefsCache.superfast) {
            return;
        }
        SS.debug(foo);
    }

    private void loadMapGeneratorsIntoSelector() {
        PluginManager pm = PluginManager.getInstance();
        List mapGenerators = pm.getMapGeneratorList();
        List mapGeneratorsChoices = pm.getMapGeneratorChoicesList();
        if (mapGenerators.size() > 0) {
            this.mapSelector.addItem(" -- " + Translator.getString("MapGenerators") + " -- ");
        }
        for (int i = 0; i < mapGenerators.size(); ++i) {
            try {
                List genChoices = (List)mapGeneratorsChoices.get(i);
                String genName = ((LuxMapGenerator)mapGenerators.get(i)).name();
                for (int c = 0; c < genChoices.size(); ++c) {
                    if (this.mapSelector.hasItem(genChoices.get(c))) {
                        CrossPlatformLuxController.debug("LuxMapGenerator '" + genName + "' cannot use the choice '" + genChoices.get(c) + "' because it is already present.");
                        continue;
                    }
                    this.mapSelector.addItem(genChoices.get(c).toString());
                }
                continue;
            }
            catch (Throwable e) {
                CrossPlatformLuxController.debug("LuxMapGenerator '" + mapGenerators.get(i).toString() + "' threw an exception in getChoices() or name(): " + e);
                mapGenerators.remove(mapGenerators.get(i));
                --i;
            }
        }
    }

    public boolean isCustomBoard() {
        int mapgenIndex;
        if (PrefsCache.headless) {
            SS.debug("returning Lux.headlessGenerator=" + Lux.headlessGenerator);
            return !Lux.headlessGenerator;
        }
        int selectionIndex = this.mapSelector.getSelectedIndex();
        return selectionIndex < (mapgenIndex = this.getMapGeneratorStartIndex());
    }

    public String customBoardName() {
        if (PrefsCache.headless) {
            return Lux.mapParam;
        }
        return this.mapSelector.getSelectedString();
    }

    public String boardSize() {
        int mapgenIndex;
        if (PrefsCache.headless) {
            return Lux.mapParam;
        }
        int selectionIndex = this.mapSelector.getSelectedIndex();
        int boardSizeCalc = selectionIndex - (mapgenIndex = this.getMapGeneratorStartIndex());
        if (boardSizeCalc == 0) {
            if (this.mapStartingPosition.getSelectedIndex() == 0) {
                int scenarioPlayers = 0;
                while (scenarioPlayers == 0) {
                    boardSizeCalc = this.rand.nextInt(this.mapSelector.getItemCount() - (mapgenIndex + 1)) + 1;
                    String choice = this.mapSelector.getTitleAt(boardSizeCalc + mapgenIndex);
                    System.out.println("Random MapGen " + boardSizeCalc + " -- " + this.mapSelector.getTitleAt(boardSizeCalc + mapgenIndex));
                    LuxMapGenerator mapgen = PluginManager.getInstance().getMapGeneratorForChoice(choice);
                    scenarioPlayers = LuxController.getScenarioPlayersForMapGenerator(mapgen, choice);
                }
            } else {
                boardSizeCalc = this.rand.nextInt(this.mapSelector.getItemCount() - (mapgenIndex + 1)) + 1;
                System.out.println("Random MapGen " + boardSizeCalc + " -- " + this.mapSelector.getTitleAt(boardSizeCalc + mapgenIndex));
            }
        }
        return this.mapSelector.getTitleAt(boardSizeCalc + mapgenIndex);
    }

    public int boardNumber() {
        return -1;
    }

    public boolean useScenario() {
        if (PrefsCache.headless) {
            return false;
        }
        return this.mapStartingPosition.getSelectedIndex() == 0;
    }

    public boolean allowNetworkPlayers() {
        if (PrefsCache.headless) {
            return Prefs.getBoolean("allowNetworkPlayers", true);
        }
        return this.allowNetworkPlayers.isSelected();
    }

    public boolean internetPublic() {
        if (this.internetPublic == null) {
            return Prefs.getBoolean("internetPublic", true);
        }
        return this.internetPublic.isSelected();
    }

    public int initialArmies() {
        if (PrefsCache.headless) {
            if (PrefsCache.forcePlaced) {
                return 1;
            }
            return 0;
        }
        int code = this.mapStartingPosition.getSelectedIndex();
        if (code == 2 || code == 5) {
            return 1;
        }
        if (code == 1 || code == 4) {
            return 2;
        }
        return 0;
    }

    public boolean initialCountries() {
        if (PrefsCache.headless) {
            return true;
        }
        int code = this.mapStartingPosition.getSelectedIndex();
        return 0 < code && code < 4;
    }

    public LuxOptions currentOptions() {
        return this.currentOptions(false, false);
    }

    public LuxOptions currentOptions(boolean forceAllowNetworkPlayersOn, boolean forceInternetPublicOn) {
        if (PrefsCache.headless) {
            String[] typePass = Lux.agentParam == null ? new String[]{"Communist", Prefs.get("playerTypes1", "Angry"), Prefs.get("playerTypes2", "EvilPixie"), Prefs.get("playerTypes3", "Quo"), Prefs.get("playerTypes4", "Killbot"), Prefs.get("playerTypes5", "Boscoe")} : ("networkplayeronly".equals(Lux.agentParam) ? new String[]{Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam, "Reaper"} : ("networkbodreaper".equals(Lux.agentParam) ? new String[]{"networkplayeronly", "networkplayeronly", "networkplayeronly", "networkplayeronly", "BotOfDoom", "Reaper"} : ("networkplayeronlyfull".equals(Lux.agentParam) ? new String[]{Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam} : new String[]{Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam, Lux.agentParam})));
            String[] namePass = new String[]{Prefs.get("playerNames0", "topknot"), Prefs.get("playerNames1", "Red"), Prefs.get("playerNames2", "Zoodiac"), Prefs.get("playerNames3", "blob"), Prefs.get("playerNames4", "k-OS"), Prefs.get("playerNames5", "Lux Luthor")};
            String[] colorPass = new String[]{Prefs.get("PlayerColours1", "0.15/0.25/0.8"), Prefs.get("PlayerColours2", "0.6/0.0/0.0"), Prefs.get("PlayerColours3", "0.0/0.6/0.4"), Prefs.get("PlayerColours4", "1.0/0.5/0.0"), Prefs.get("PlayerColours5", "0.9/0.866/0.9"), Prefs.get("PlayerColours6", "0.06/0.0/0.06")};
            if (Lux.memoryColor != null) {
                SS.debug("headless memoryColor=" + Lux.memoryColor);
                Thread.dumpStack();
                colorPass = "2v2v2".equals(Lux.memoryColor) ? new String[]{"0/0/0", "0/0/0.8", "0/0.6/0", "0.5/0.5/0.5", "0.4/0.6/1", "0.6/1/0.6"} : ("3v3".equals(Lux.memoryColor) ? new String[]{"0/0/0", "0/0/0.8", "0.5/0.5/0.5", "0.4/0.6/1", "1/1/1", "0.4/1/1"} : new String[]{Lux.memoryColor, Lux.memoryColor, Lux.memoryColor, Lux.memoryColor, Lux.memoryColor, Lux.memoryColor});
            }
            boolean[] controlPass = new boolean[]{false, false, false, false, false, false};
            if (Lux.useScenario) {
                // empty if block
            }
            if (Lux.useScenario) {
                // empty if block
            }
            if (Lux.useScenario && ("Vancouver Biathlon".equalsIgnoreCase(Lux.mapParam) || "Vancouver Competition Chase".equalsIgnoreCase(Lux.mapParam) || "Winter Games - Short Track".equalsIgnoreCase(Lux.mapParam))) {
                SS.debug("creating custom ops for Vancouver Biathlon");
                typePass = new String[]{"Communist", "Pixie", "Trotsky", "Killbot", "Reaper", "Empty"};
                namePass = new String[]{Prefs.get("playerNames0", "topknot"), Prefs.get("playerNames1", "Ruu"), Prefs.get("playerNames2", "Zoodiac"), Prefs.get("playerNames3", "blob"), "VANOC", "Empty"};
            } else if (Lux.useScenario && ("Vancouver Ski Jumping".equalsIgnoreCase(Lux.mapParam) || "Winter Games - Curling".equalsIgnoreCase(Lux.mapParam) || "Winter Games - Speed Skating".equalsIgnoreCase(Lux.mapParam))) {
                SS.debug("creating custom ops for Vancouver Biathlon");
                typePass = new String[]{"Communist", "Trotsky", "Killbot", "Reaper", "Empty"};
                namePass = new String[]{Prefs.get("playerNames0", "topknot"), Prefs.get("playerNames1", "Zoodiac"), Prefs.get("playerNames2", "blob"), Prefs.get("playerNames3", "k-OS"), "Empty"};
                colorPass = new String[]{Prefs.get("PlayerColours1", "0.2/0.6/1.0"), Prefs.get("PlayerColours2", "0.6/0.0/0.0"), Prefs.get("PlayerColours3", "0.0/0.6/0.4"), Prefs.get("PlayerColours4", "1.0/0.6/0.0"), Prefs.get("PlayerColours5", "1.0/1.0/0.8")};
                controlPass = new boolean[]{false, false, false, false, false};
            } else if (Lux.useScenario && "Shogun".equalsIgnoreCase(Lux.mapParam)) {
                SS.debug("creating custom ops for custom Shogun");
                typePass = new String[]{"Communist", "Reaper", "Empty"};
                namePass = new String[]{Prefs.get("playerNames0", "topknot"), Prefs.get("playerNames1", "Zoodiac"), "Empty"};
                colorPass = new String[]{Prefs.get("PlayerColours1", "0.2/0.6/1.0"), Prefs.get("PlayerColours2", "0.6/0.0/0.0"), Prefs.get("PlayerColours5", "1.0/1.0/0.8")};
                controlPass = new boolean[]{false, false, false};
            }
            SS.debug("Creating new headless ops");
            LuxOptions ops = new LuxOptions(typePass, namePass, colorPass, controlPass, true, forceInternetPublicOn);
            ops.ensureSeed();
            return ops;
        }
        Vector<String> agentTypes = new Vector<String>();
        Vector<String> agentColors = new Vector<String>();
        Vector<String> agentNames = new Vector<String>();
        BoardFile boardFile = null;
        if (this.useScenario() && this.mapSelector.getSelectedIndex() < this.getMapGeneratorStartIndex()) {
            try {
                SS.debug("Checkpoint BoardFile useScenario creation 872634");
                boardFile = new BoardFile(this.mapSelector.getSelectedString(), true);
                boardFile.biohazard(this.bioLevel.getSelectedIndex());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int totalPlayers = 2;
        for (int k = 0; k < 6; ++k) {
            if (!this.playerTypes[k].isEnabled()) continue;
            totalPlayers = k + 1;
        }
        if (boardFile != null && this.useScenario() && boardFile.getScenarioHasEmpty()) {
            ++totalPlayers;
        }
        boolean addedEmpty = false;
        Vector<Boolean> guiControlled = new Vector<Boolean>();
        for (int k = 0; k < totalPlayers; ++k) {
            int counter = k;
            if (addedEmpty) {
                counter = k - 1;
            }
            String selectedString = this.playerTypes[counter].getSelectedString();
            String playerName = this.playerNames[counter].getText().trim();
            if (playerName.length() > 200) {
                playerName = playerName.substring(0, 199);
                this.playerNames[k].setText(playerName);
            }
            if (this.useScenario() && boardFile != null && boardFile.isPlayerEmptyLocked(k)) {
                agentTypes.add("Empty");
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[5].getColor()));
                agentNames.add("Empty");
                guiControlled.add(new Boolean(false));
                addedEmpty = true;
                continue;
            }
            if (selectedString.equals("<" + Translator.getString("random") + ">")) {
                agentTypes.add(this.getRandomAI(0));
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
                agentNames.add(playerName);
                guiControlled.add(new Boolean(false));
                continue;
            }
            if (selectedString.equals("-- " + Translator.getString("Easy") + " --")) {
                agentTypes.add(this.getRandomAI(1));
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
                agentNames.add(playerName);
                guiControlled.add(new Boolean(false));
                continue;
            }
            if (selectedString.equals("-- " + Translator.getString("Medium") + " --")) {
                agentTypes.add(this.getRandomAI(3));
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
                agentNames.add(playerName);
                guiControlled.add(new Boolean(false));
                continue;
            }
            if (selectedString.equals("-- " + Translator.getString("Hard") + " --")) {
                agentTypes.add(this.getRandomAI(5));
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
                agentNames.add(playerName);
                guiControlled.add(new Boolean(false));
                continue;
            }
            if (selectedString.equals("-- " + Translator.getString("Other") + " --")) {
                int ai = this.rand.nextInt(this.moreAgents.size());
                agentTypes.add((String)this.moreAgents.get(ai));
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
                agentNames.add(playerName);
                guiControlled.add(new Boolean(false));
                continue;
            }
            if (selectedString.equals("<" + Translator.getString("networkplayeronly") + ">")) {
                agentTypes.add("networkplayeronly");
                agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
                agentNames.add(playerName);
                guiControlled.add(new Boolean(false));
                continue;
            }
            if (selectedString.equals("<" + Translator.getString("noplayer") + ">")) continue;
            agentColors.add(GraphicsTool.stringFromColor(this.playerColors[counter].getColor()));
            agentNames.add(playerName);
            if (this.playerTypes[counter].getSelectedIndex() == 0) {
                agentTypes.add("Human");
                guiControlled.add(new Boolean(true));
                continue;
            }
            agentTypes.add(selectedString);
            guiControlled.add(new Boolean(false));
        }
        Object[] typePass = new String[agentTypes.size()];
        agentTypes.copyInto(typePass);
        Object[] namePass = new String[agentNames.size()];
        agentNames.copyInto(namePass);
        Object[] colorPass = new String[agentColors.size()];
        agentColors.copyInto(colorPass);
        boolean[] controlPass = new boolean[guiControlled.size()];
        for (int b = 0; b < controlPass.length; ++b) {
            controlPass[b] = (Boolean)guiControlled.get(b);
        }
        for (int i = 0; i < namePass.length; ++i) {
            if (((String)namePass[i]).length() > 64) {
                namePass[i] = ((String)namePass[i]).substring(0, 64).trim();
            }
            if (((String)namePass[i]).trim().equals("")) {
                namePass[i] = "noname" + this.rand.nextInt(1000);
            }
            for (int j = i + 1; j < namePass.length; ++j) {
                if (!((String)namePass[i]).equals(namePass[j])) continue;
                namePass[j] = (String)namePass[j] + this.rand.nextInt(1000);
            }
        }
        LuxOptions ops = new LuxOptions((String[])typePass, (String[])namePass, (String[])colorPass, controlPass, forceAllowNetworkPlayersOn, forceInternetPublicOn, boardFile);
        ops.ensureSeed();
        return ops;
    }

    public String userName() {
        if (PrefsCache.headless) {
            return Lux.nameParam;
        }
        for (int i = 0; i < this.playerTypes.length; ++i) {
            if (this.playerTypes[i].getSelectedIndex() != 0) continue;
            if ("".equals(this.playerNames[i].getText().trim())) {
                String sysName = System.getProperty("user.name", "noUserNameSet");
                if (!"".equals(sysName.trim())) {
                    return sysName;
                }
                return "ServerDude" + this.rand.nextInt(100);
            }
            return this.playerNames[i].getText().trim();
        }
        return this.playerNames[0].getText().trim() + " (dedicated host)";
    }

    public void fillMapSelector(String selection) {
        if (selection == null) {
            selection = this.mapSelector.getSelectedString();
        }
        System.out.println("Fill up the list of maps and generators. -> " + selection);
        this.fillingMapSelector = true;
        this.mapSelector.removeAllItems();
        Vector mapList = PluginManager.getInstance().getMapList();
        this.mapSelector.addItemList(mapList);
        if (this.mapSelector.getItemCount() == 0) {
            this.mapSelector.addItem("<" + Translator.getString("none") + ">");
        }
        this.mapSelector.addItem(" \u221e " + Translator.getString("GotoSavedBoards"));
        this.mapSelector.addItem(" \u221e " + Translator.getString("Getmoremaps"));
        PluginManager.getInstance().loadMapGenerators();
        this.loadMapGeneratorsIntoSelector();
        this.fillingMapSelector = false;
        if (selection != null) {
            if (selection.endsWith(".luxb")) {
                selection = selection.substring(0, selection.length() - 5);
            }
            this.mapSelector.setSelectedItem(selection);
        }
        if (this.mapSelector.getSelectedString() == null) {
            this.mapSelector.setSelectedIndex(0);
        }
    }

    public boolean installBoard(String filename, boolean overwrite) {
        CrossPlatformLuxController.debug("Lux -> installBoard(" + filename + ", " + overwrite + ")");
        if (!filename.endsWith(".luxb")) {
            return false;
        }
        File newBoard = new File(filename);
        String name = newBoard.getName();
        String moveTo = DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + name;
        File oldBoard = new File(moveTo);
        if (oldBoard.exists() && overwrite) {
            oldBoard.delete();
        }
        if (!oldBoard.exists()) {
            if (!FileTool.copyFile(filename, moveTo)) {
                CrossPlatformLuxController.debug("Lux -> error copying a custom board to the proper place");
                SS.beep();
                SSOptionPane.showMessageWithTitle(Translator.getString("Therewasanerrortryingtoaddthecustomboard") + " '" + name + "'\n\nError code: 44653", Translator.getString("Error"));
                return false;
            }
            try {
                newBoard.delete();
            }
            catch (Throwable e) {
                CrossPlatformLuxController.debug("Lux -> couldn't delete a custom board file after copying it.");
            }
        }
        this.fillMapSelector(name.substring(0, name.length() - 5));
        return true;
    }

    protected int getMapGeneratorStartIndex() {
        int check = this.mapSelector.getIndexOfItem(" -- " + Translator.getString("MapGenerators") + " -- ");
        if (check == -1) {
            check = this.mapSelector.getItemCount();
        }
        return check;
    }

    public void cycleSaved() {
        SS.debug("cycleSaved");
        if (PrefsCache.headless) {
            Vector mapList = new Vector();
            PluginManager.buildMapListFromFolder(new File(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved"), "", mapList);
            for (int i = 0; i < mapList.size(); ++i) {
                if (!mapList.get(i).equals(Lux.mapParam)) continue;
                Lux.mapParam = i + 1 == mapList.size() ? mapList.get(0).toString() : mapList.get(i + 1).toString();
                Prefs.put("mapSelector", Lux.mapParam);
            }
            return;
        }
        if (this.mapSelector.getSelectedIndex() >= this.getMapGeneratorStartIndex()) {
            return;
        }
        if (!Prefs.getBoolean("cycleFolder", true)) {
            this.incrementSelectedSavedBoard();
            return;
        }
        String name = this.mapSelector.getSelectedString();
        if (name.indexOf("/") == -1) {
            do {
                this.incrementSelectedSavedBoard();
            } while (this.mapSelector.getSelectedString().indexOf("/") != -1);
            return;
        }
        name = name.substring(0, name.indexOf("/"));
        CrossPlatformLuxController.debug("Cycling inside folder: " + name);
        do {
            this.incrementSelectedSavedBoard();
        } while (this.mapSelector.getSelectedString().indexOf(name) == -1);
    }

    protected void incrementSelectedSavedBoard() {
        int index = this.mapSelector.getSelectedIndex();
        if (++index == this.getMapGeneratorStartIndex() || index == this.getMapGeneratorStartIndex() - 1 || index == this.getMapGeneratorStartIndex() - 2) {
            index = 0;
        }
        this.mapSelector.setSelectedIndex(index);
        CrossPlatformLuxController.debug("Cycling to index " + index);
    }

    public void fillPlayerTypes() {
        int k;
        int k2;
        int i;
        this.allAgents = new Vector();
        this.ignoreAllComputerCheck = true;
        for (i = 0; i < 6; ++i) {
            this.playerTypes[i].removeAllItems();
            this.playerTypes[i].addItem(this.getHumanName());
            this.playerTypes[i].addItem("-- " + Translator.getString("Easy") + " --");
        }
        for (i = 0; i < this.easyAgents.size(); ++i) {
            this.allAgents.add(this.easyAgents.get(i));
            for (k2 = 0; k2 < 6; ++k2) {
                this.playerTypes[k2].addItem((String)this.easyAgents.get(i));
            }
        }
        for (k = 0; k < 6; ++k) {
            this.playerTypes[k].addItem("-- " + Translator.getString("Medium") + " --");
        }
        for (i = 0; i < this.mediumAgents.size(); ++i) {
            this.allAgents.add(this.mediumAgents.get(i));
            for (k2 = 0; k2 < 6; ++k2) {
                this.playerTypes[k2].addItem((String)this.mediumAgents.get(i));
            }
        }
        for (k = 0; k < 6; ++k) {
            this.playerTypes[k].addItem("-- " + Translator.getString("Hard") + " --");
        }
        for (i = 0; i < this.hardAgents.size(); ++i) {
            this.allAgents.add(this.hardAgents.get(i));
            for (k2 = 0; k2 < 6; ++k2) {
                this.playerTypes[k2].addItem((String)this.hardAgents.get(i));
            }
        }
        this.moreAgents = new Vector();
        String[] agentLocations = LuxController.getAgentLocations();
        for (int l = 0; l < agentLocations.length; ++l) {
            File agentsDir = new File(agentLocations[l]);
            if (agentsDir == null || !agentsDir.isDirectory()) continue;
            String[] filenames = agentsDir.list();
            for (int i2 = 0; i2 < filenames.length; ++i2) {
                try {
                    if (!filenames[i2].endsWith(".class") || SSClassLoader.getAgentNamed(filenames[i2].substring(0, filenames[i2].length() - 6)) == null) continue;
                    this.allAgents.add(filenames[i2].substring(0, filenames[i2].length() - 6));
                    this.moreAgents.add(filenames[i2].substring(0, filenames[i2].length() - 6));
                    continue;
                }
                catch (UnsupportedClassVersionError versionx) {
                    SSOptionPane.showMessageDialog("Java Upgrade Needed", "The plugin '' requires a newer version of Java to work. Please go to www.java.com to update your Java.");
                }
            }
        }
        if (this.moreAgents.size() > 0) {
            for (k2 = 0; k2 < 6; ++k2) {
                this.playerTypes[k2].addItem("-- " + Translator.getString("Other") + " --");
            }
            for (int i3 = 0; i3 < this.moreAgents.size(); ++i3) {
                for (int k3 = 0; k3 < 6; ++k3) {
                    this.playerTypes[k3].addItem((String)this.moreAgents.get(i3));
                }
            }
        }
        for (k2 = 0; k2 < 6; ++k2) {
            this.playerTypes[k2].addItem("<" + Translator.getString("random") + ">");
        }
        for (k2 = 1; k2 < 6; ++k2) {
            if (k2 > 1) {
                this.playerTypes[k2].addItem("<" + Translator.getString("noplayer") + ">");
            }
            this.playerTypes[k2].addItem("<" + Translator.getString("networkplayeronly") + ">");
        }
        for (k2 = 0; k2 < 6; ++k2) {
            this.playerTypes[k2].addItem(" \u221e " + Translator.getString("GetmoreAIs"));
        }
        for (k2 = 0; k2 < 6; ++k2) {
            this.playerTypes[k2].setSelectedItem(Prefs.get("playerTypes" + k2));
            if (Prefs.get("playerTypes" + k2, "").equals(this.playerTypes[k2].getSelectedItem())) continue;
            CrossPlatformLuxController.debug("couldn't find player type: " + Prefs.get("playerTypes" + k2));
            if (k2 == 0) {
                this.playerTypes[k2].setSelectedIndex(0);
                continue;
            }
            this.playerTypes[k2].setSelectedIndex(1);
        }
        this.ignoreAllComputerCheck = false;
    }

    public void quit() {
        this.killed = true;
        System.out.println("Lux is now exiting. Thanks for playing.");
        LuxTracker.stop();
        this.saveSelectionsToDefs();
        if (this.sharewareVersion) {
            Prefs.putInt("savedSelection", this.sharewareCount);
            if (!SS.isMacintosh) {
                try {
                    FileTool.hideWindowsFile(LuxController.getSharewareFilename(), false);
                }
                catch (Exception e) {
                    System.out.println("Unhide n seek failed. No biggie.");
                }
            }
            try {
                PrintWriter file = new PrintWriter(new FileWriter(LuxController.getSharewareFilename()));
                file.println(this.sharewareCount);
                file.close();
            }
            catch (Throwable e) {
                System.out.println("Lux -> error 42ro0ckz0r.");
            }
            try {
                if (Float.parseFloat(System.getProperty("java.class.version")) >= 48.0f) {
                    Preferences p = Preferences.userNodeForPackage(LuxController.class);
                    p.putInt("savedSelection", this.sharewareCount);
                    p.flush();
                }
            }
            catch (Throwable e) {
                System.out.println("Lux -> error code kawasaki.");
            }
            this.hideNewGameWindow();
            if (this.sharewareCount > 2) {
                RegisterNag rn = new RegisterNag("Marketing_Closing.jpg", "closing");
                rn.terminateOnClose();
                return;
            }
        }
        Prefs.sync();
        this.terminate();
    }

    public String getHumanName() {
        return (SS.isMacintosh ? "\u265f " : "") + Translator.getString("Human");
    }

    public String getDefaultJoinName() {
        for (int k = 0; k < 6; ++k) {
            if (!this.getHumanName().equals(this.playerTypes[k].getSelectedString())) continue;
            return this.playerNames[k].getText().trim();
        }
        return this.playerNames[0].getText().trim();
    }
}

