/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.LuxObserver;
import com.sillysoft.lux.ViewManager;
import com.sillysoft.tools.SS;

public class Country {
    private int countryCode;
    private int continentCode;
    private int ownerCode;
    private int armies;
    private int moveableArmies;
    private Country[] adjoiningCountriesList;
    private String name;
    private Object owner;
    private LuxObserver viewManager;

    public Country(int newCountryCode, int newContCode, Object check) {
        this.owner = check;
        this.countryCode = newCountryCode;
        this.continentCode = newContCode;
        this.ownerCode = -1;
        this.armies = 1;
        this.moveableArmies = 0;
        this.viewManager = null;
        this.adjoiningCountriesList = null;
    }

    public void setViewManager(ViewManager man) {
        this.viewManager = man;
    }

    public int getCode() {
        return this.countryCode;
    }

    public int getOwner() {
        return this.ownerCode;
    }

    public int getContinent() {
        return this.continentCode;
    }

    public void setContinentCode(int to, Object check) {
        if (check == this.owner) {
            this.continentCode = to;
        }
    }

    public void setOwner(int newOwner, Object check) {
        if (check == this.owner) {
            this.ownerCode = newOwner;
            if (this.viewManager != null) {
                this.viewManager.setCountryOwner(this.countryCode, this.ownerCode);
            }
        }
    }

    public int getArmies() {
        return this.armies;
    }

    public void setArmies(int newArmies, Object check) {
        if (check == this.owner) {
            if (newArmies < 0) {
                Thread.dumpStack();
                System.out.println("Lux ERROR in Country -> cannot have negative amount of armies. Set the country to have 1 army. 547785");
                newArmies = 1;
            }
            this.armies = newArmies;
            if (this.viewManager != null) {
                this.viewManager.setCountryArmies(this.countryCode, this.armies);
            }
        }
    }

    public void addArmy(Object check) {
        if (check == this.owner) {
            ++this.armies;
            if (this.viewManager != null) {
                this.viewManager.setCountryArmies(this.countryCode, this.armies);
            }
        }
    }

    public int getMoveableArmies() {
        return this.moveableArmies;
    }

    public void setMoveableArmies(int newMoveable, Object check) {
        if (check == this.owner) {
            this.moveableArmies = newMoveable;
        }
    }

    public void copyMoveableArmies(Object check) {
        if (check == this.owner) {
            this.moveableArmies = this.armies;
        }
    }

    public Country[] getAdjoiningList() {
        return this.adjoiningCountriesList;
    }

    public int[] getAdjoiningCodeList() {
        int[] codeArray = new int[this.adjoiningCountriesList.length];
        boolean indexCount = false;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            codeArray[i] = this.adjoiningCountriesList[i].countryCode;
        }
        return codeArray;
    }

    public void clearAdjoiningList(Object check) {
        if (check == this.owner) {
            this.adjoiningCountriesList = null;
        }
    }

    public void addToAdjoiningList(Country newCountry, Object check) {
        if (check != this.owner) {
            return;
        }
        if (newCountry.countryCode == this.countryCode) {
            return;
        }
        if (this.adjoiningCountriesList == null) {
            this.adjoiningCountriesList = new Country[1];
            this.adjoiningCountriesList[0] = newCountry;
            return;
        }
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].countryCode != newCountry.countryCode) continue;
            return;
        }
        Country[] newList = new Country[this.adjoiningCountriesList.length + 1];
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            newList[i] = this.adjoiningCountriesList[i];
        }
        newList[this.adjoiningCountriesList.length] = newCountry;
        this.adjoiningCountriesList = newList;
    }

    public void addToAdjoiningListBoth(Country newCountry, Object check) {
        this.addToAdjoiningList(newCountry, check);
        newCountry.addToAdjoiningList(this, check);
    }

    public void ensureAdjoiningList(Object check) throws Exception {
        if (check != this.owner) {
            return;
        }
        if (this.adjoiningCountriesList == null) {
            this.adjoiningCountriesList = new Country[0];
            SS.debug("WARNING: Country named '" + this.name + "' (ID: " + this.countryCode + ") does not connect to any other countries.");
        }
    }

    public boolean canGoto(Country country) {
        return this.canGoto(country.countryCode);
    }

    public boolean canGoto(int countryCode) {
        if (this.adjoiningCountriesList == null) {
            return false;
        }
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].countryCode != countryCode) continue;
            return true;
        }
        return false;
    }

    public boolean isNextTo(Country country) {
        return this.isNextTo(country.countryCode);
    }

    public boolean isNextTo(int countryCode) {
        System.out.println("ERROR the method Country->isNextTo() is depreciated. Please use Country->canGoto() instead");
        if (this.adjoiningCountriesList == null) {
            return false;
        }
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].countryCode != countryCode) continue;
            return true;
        }
        return false;
    }

    public Country getWeakestEnemyNeighbor() {
        int weakestArmies = 1000000;
        Country weakestNeighbor = null;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode || this.adjoiningCountriesList[i].armies >= weakestArmies) continue;
            weakestNeighbor = this.adjoiningCountriesList[i];
            weakestArmies = weakestNeighbor.armies;
        }
        return weakestNeighbor;
    }

    public Country getStrongestNeighborOwnedBy(int player) {
        int strongestArmies = -1;
        Country strongestNeighbor = null;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode != player || this.adjoiningCountriesList[i].armies <= strongestArmies) continue;
            strongestNeighbor = this.adjoiningCountriesList[i];
            strongestArmies = strongestNeighbor.armies;
        }
        return strongestNeighbor;
    }

    public Country getWeakestEnemyNeighborInContinent(int cont) {
        int weakestArmies = 1000000;
        Country weakestNeighbor = null;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode || this.adjoiningCountriesList[i].armies >= weakestArmies || this.adjoiningCountriesList[i].continentCode != cont) continue;
            weakestNeighbor = this.adjoiningCountriesList[i];
            weakestArmies = weakestNeighbor.armies;
        }
        return weakestNeighbor;
    }

    public int getNumberNeighbors() {
        return this.adjoiningCountriesList.length;
    }

    public int getNumberEnemyNeighbors() {
        int enemies = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode) continue;
            ++enemies;
        }
        return enemies;
    }

    public int getNumberPlayerNeighbors(int player) {
        int number = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode != player) continue;
            ++number;
        }
        return number;
    }

    public int getNumberNotPlayerNeighbors(int player) {
        int number = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == player) continue;
            ++number;
        }
        return number;
    }

    public int getNumberPlayerNotNamedNeighbors(String agentName, Board board) {
        int number = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (board.getAgentName(this.adjoiningCountriesList[i].getOwner()).equals(agentName)) continue;
            ++number;
        }
        return number;
    }

    public String getName() {
        if (this.name == null) {
            return "no-name-" + this.countryCode;
        }
        return this.name;
    }

    public void setName(String name, Object check) {
        if (check == this.owner) {
            this.name = name;
        }
    }

    public String toString() {
        return "<Country name:" + this.getName() + " code:" + this.countryCode + " continent:" + this.continentCode + " owner:" + this.ownerCode + " armies:" + this.armies + ">";
    }

    public int[] getFriendlyAdjoiningCodeList() {
        int[] fortifyToCodeArray = new int[this.getNumberPlayerNeighbors(this.ownerCode)];
        int indexCount = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode != this.ownerCode) continue;
            fortifyToCodeArray[indexCount] = this.adjoiningCountriesList[i].getCode();
            ++indexCount;
        }
        return fortifyToCodeArray;
    }

    public int[] getHostileAdjoiningCodeList() {
        int[] fortifyToCodeArray = new int[this.getNumberNotPlayerNeighbors(this.ownerCode)];
        int indexCount = 0;
        for (int i = 0; i < this.adjoiningCountriesList.length; ++i) {
            if (this.adjoiningCountriesList[i].ownerCode == this.ownerCode) continue;
            fortifyToCodeArray[indexCount] = this.adjoiningCountriesList[i].getCode();
            ++indexCount;
        }
        return fortifyToCodeArray;
    }
}

