/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.tools.Translator;
import com.sillysoft.tools.XMLTool;
import java.io.Serializable;

public class ContinentSequence
implements Serializable {
    static final long serialVersionUID = -2076095180466024606L;
    public static String[] sequences = new String[]{Translator.getString("notatall"), Translator.getString("beforeContinentIncrease") + " 5% " + Translator.getString("afterContinentIncrease"), Translator.getString("beforeContinentIncrease") + " 10% " + Translator.getString("afterContinentIncrease"), Translator.getString("beforeContinentIncrease") + " 15% " + Translator.getString("afterContinentIncrease"), Translator.getString("beforeContinentIncrease") + " 20% " + Translator.getString("afterContinentIncrease"), Translator.getString("beforeContinentIncrease") + " 30% " + Translator.getString("afterContinentIncrease"), Translator.getString("beforeContinentIncrease") + " 40% " + Translator.getString("afterContinentIncrease"), Translator.getString("beforeContinentIncrease") + " 50% " + Translator.getString("afterContinentIncrease")};
    public static String[] shortString = new String[]{"--", "5%", "10%", "15%", "20%", "30%", "40%", "50%"};
    public static int[] intIncrease = new int[]{0, 5, 10, 15, 20, 30, 40, 50};
    private int continentSequence;
    private float currentMultiplier;

    public static int getIDFromString(String text) {
        if ("0".equals(text)) {
            return 0;
        }
        if ("5".equals(text)) {
            return 1;
        }
        if ("10".equals(text)) {
            return 2;
        }
        if ("15".equals(text)) {
            return 3;
        }
        if ("20".equals(text)) {
            return 4;
        }
        if ("30".equals(text)) {
            return 5;
        }
        if ("40".equals(text)) {
            return 6;
        }
        if ("50".equals(text)) {
            return 7;
        }
        return -1;
    }

    public ContinentSequence(int seqNumber) {
        this.continentSequence = seqNumber;
        this.currentMultiplier = 1.0f;
    }

    private float getSingleRoundIncrease() {
        switch (this.continentSequence) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 1.05f;
            }
            case 2: {
                return 1.1f;
            }
            case 3: {
                return 1.15f;
            }
            case 4: {
                return 1.2f;
            }
            case 5: {
                return 1.3f;
            }
            case 6: {
                return 1.4f;
            }
            case 7: {
                return 1.5f;
            }
        }
        System.out.println("ContinentSequence UNKNOWN SEQUENCE CODE: " + this.continentSequence);
        return 1.0f;
    }

    public int[] increment(int[] originalValues) {
        if (this.continentSequence == 0) {
            return originalValues;
        }
        this.currentMultiplier *= this.getSingleRoundIncrease();
        int[] newValues = new int[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            newValues[i] = originalValues[i] >= 0 ? (int)Math.floor((float)originalValues[i] * this.currentMultiplier) : (int)Math.ceil((float)originalValues[i] * this.currentMultiplier);
        }
        return newValues;
    }

    public int[] refreshValues(int[] originalValues) {
        if (this.continentSequence == 0) {
            return originalValues;
        }
        int[] newValues = new int[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            newValues[i] = (int)Math.floor((float)originalValues[i] * this.currentMultiplier);
        }
        return newValues;
    }

    public ContinentSequence copy() {
        ContinentSequence copy = new ContinentSequence(this.continentSequence);
        copy.currentMultiplier = this.currentMultiplier;
        return copy;
    }

    public String shortString() {
        return shortString[this.continentSequence];
    }

    public String longString() {
        return sequences[this.continentSequence];
    }

    public int intIncrease() {
        return intIncrease[this.continentSequence];
    }

    public boolean increases() {
        return this.continentSequence > 0;
    }

    public float getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public String toString() {
        return "<ContinentSequence code=\"" + this.continentSequence + "\" multiplier=\"" + this.currentMultiplier + "\" />";
    }

    public ContinentSequence(String str) {
        try {
            this.continentSequence = Integer.parseInt(XMLTool.extractAttribute("code", str));
            this.currentMultiplier = Float.parseFloat(XMLTool.extractAttribute("multiplier", str));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

