/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Country;
import com.sillysoft.tools.XMLTool;
import java.util.ArrayList;

public class Card {
    int countryCode;
    int symbol;

    public Card(int assocCode, int symbol) {
        this.symbol = symbol;
        this.countryCode = symbol == 3 ? -1 : assocCode;
    }

    public Card(String cardString) {
        try {
            this.symbol = Integer.parseInt(XMLTool.extractAttribute("symbol", cardString));
            this.countryCode = Integer.parseInt(XMLTool.extractAttribute("country", cardString));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCode() {
        return this.countryCode;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public static boolean isASet(Card card1, Card card2, Card card3) {
        if (card1 == null || card2 == null || card3 == null) {
            return false;
        }
        int[] symbolCount = new int[4];
        int n = card1.getSymbol();
        symbolCount[n] = symbolCount[n] + 1;
        int n2 = card2.getSymbol();
        symbolCount[n2] = symbolCount[n2] + 1;
        int n3 = card3.getSymbol();
        symbolCount[n3] = symbolCount[n3] + 1;
        if (symbolCount[0] + symbolCount[3] == 3 || symbolCount[1] + symbolCount[3] == 3 || symbolCount[2] + symbolCount[3] == 3) {
            return true;
        }
        return Math.min(symbolCount[0], 1) + Math.min(symbolCount[1], 1) + Math.min(symbolCount[2], 1) + symbolCount[3] > 2;
    }

    public static boolean containsASet(Card[] cards) {
        int i;
        if (cards == null || cards.length < 3) {
            return false;
        }
        int[] symbolCount = new int[4];
        for (i = 0; i < cards.length; ++i) {
            int n = cards[i].getSymbol();
            symbolCount[n] = symbolCount[n] + 1;
        }
        for (i = 0; i < 3; ++i) {
            if (symbolCount[i] + symbolCount[3] <= 2) continue;
            return true;
        }
        return Math.min(symbolCount[0], 1) + Math.min(symbolCount[1], 1) + Math.min(symbolCount[2], 1) + symbolCount[3] > 2;
    }

    public static Card[] getRandomSet(Card[] cards) {
        int i;
        Card[] toReturn = new Card[3];
        int[] symbolCount = new int[4];
        for (i = 0; i < cards.length; ++i) {
            int n = cards[i].getSymbol();
            symbolCount[n] = symbolCount[n] + 1;
        }
        for (i = 0; i < 3; ++i) {
            if (symbolCount[i] + symbolCount[3] <= 2) continue;
            int setCounter = 0;
            for (int j = 0; setCounter != 3 && j < cards.length; ++j) {
                if (cards[j].getSymbol() != i && cards[j].getSymbol() != 3) continue;
                toReturn[setCounter] = cards[j];
                ++setCounter;
            }
            return toReturn;
        }
        for (int j = 0; j < cards.length; ++j) {
            if (toReturn[0] == null && cards[j].getSymbol() == 0) {
                toReturn[0] = cards[j];
                continue;
            }
            if (toReturn[1] == null && cards[j].getSymbol() == 1) {
                toReturn[1] = cards[j];
                continue;
            }
            if (toReturn[2] == null && cards[j].getSymbol() == 2) {
                toReturn[2] = cards[j];
                continue;
            }
            if (cards[j].getSymbol() != 3) continue;
            if (symbolCount[0] == 0 && toReturn[0] == null) {
                toReturn[0] = cards[j];
                continue;
            }
            if (symbolCount[1] == 0 && toReturn[1] == null) {
                toReturn[1] = cards[j];
                continue;
            }
            if (symbolCount[2] != 0 || toReturn[2] != null) continue;
            toReturn[2] = cards[j];
        }
        return toReturn;
    }

    public static Card[] getBestSet(Card[] cards, int player, Country[] countries) {
        int c;
        int i;
        ArrayList<Card> noWildList = new ArrayList<Card>();
        ArrayList<Card> wildList = new ArrayList<Card>();
        for (int i2 = 0; i2 < cards.length; ++i2) {
            if (cards[i2].getSymbol() != 3) {
                noWildList.add(cards[i2]);
                continue;
            }
            wildList.add(cards[i2]);
        }
        if (cards.length > noWildList.size()) {
            Card[] noWildCards = new Card[noWildList.size()];
            for (int i3 = 0; i3 < noWildList.size(); ++i3) {
                noWildCards[i3] = (Card)noWildList.get(i3);
            }
            Card[] bestNoWildSet = Card.getBestSet(noWildCards, player, countries);
            if (bestNoWildSet != null) {
                return bestNoWildSet;
            }
            if (cards.length > noWildList.size() + 1) {
                Card[] oneWildCardList = new Card[noWildList.size() + 1];
                for (int i4 = 0; i4 < noWildList.size(); ++i4) {
                    oneWildCardList[i4] = (Card)noWildList.get(i4);
                }
                oneWildCardList[oneWildCardList.length - 1] = (Card)wildList.get(0);
                Card[] bestOneWildSet = Card.getBestSet(oneWildCardList, player, countries);
                if (bestOneWildSet != null) {
                    return bestOneWildSet;
                }
            }
        }
        if (cards.length > 6 && cards.length == noWildList.size()) {
            Card[] cashCards = new Card[3];
            int[] symbolCount = new int[3];
            for (int i5 = 0; i5 < cards.length; ++i5) {
                if (cards[i5].getSymbol() == -1 || cards[i5].getSymbol() == 3) continue;
                int n = cards[i5].getSymbol();
                symbolCount[n] = symbolCount[n] + 1;
            }
            int cashWithSymbol = -1;
            if (symbolCount[0] > 2 && (symbolCount[1] > 2 || symbolCount[2] > 2)) {
                cashWithSymbol = 0;
            } else if (symbolCount[1] > 2 && symbolCount[2] > 2) {
                cashWithSymbol = 1;
            }
            if (cashWithSymbol != -1) {
                int setCounter = 0;
                for (int i6 = 0; i6 < cards.length && setCounter < 3; ++i6) {
                    if (cards[i6].getSymbol() != cashWithSymbol) continue;
                    cashCards[setCounter] = cards[i6];
                    ++setCounter;
                }
                return cashCards;
            }
            if (symbolCount[0] > 1 && symbolCount[1] > 1 && symbolCount[2] > 1) {
                for (int i7 = 0; i7 < cards.length; ++i7) {
                    if (cards[i7].getSymbol() == -1 || cards[i7].getSymbol() == 3) continue;
                    cashCards[cards[i7].getSymbol()] = cards[i7];
                }
                return cashCards;
            }
        }
        int[] owners = new int[cards.length];
        int owned = 0;
        for (int i8 = 0; i8 < cards.length; ++i8) {
            if (cards[i8].getCode() == -1) {
                owners[i8] = -1;
                continue;
            }
            owners[i8] = countries[cards[i8].getCode()].getOwner();
            if (owners[i8] != player) continue;
            ++owned;
        }
        Card[] ownedCards = new Card[owned];
        int count = 0;
        for (int i9 = 0; i9 < cards.length; ++i9) {
            if (owners[i9] != player) continue;
            ownedCards[count] = cards[i9];
            ++count;
        }
        if (owned > 2 && Card.containsASet(ownedCards)) {
            return Card.getRandomSet(ownedCards);
        }
        if (owned > 1) {
            Card[] ownedPlus = new Card[owned + 1];
            for (i = 0; i < owned; ++i) {
                ownedPlus[i] = ownedCards[i];
            }
            for (c = 0; c < cards.length; ++c) {
                if (owners[c] == player) continue;
                ownedPlus[owned] = cards[c];
                if (!Card.containsASet(ownedPlus)) continue;
                return Card.getRandomSet(ownedPlus);
            }
        }
        if (owned > 0) {
            Card[] ownedPlusPlus = new Card[owned + 2];
            for (i = 0; i < owned; ++i) {
                ownedPlusPlus[i] = ownedCards[i];
            }
            for (c = 0; c < cards.length; ++c) {
                for (int d = 0; d < cards.length; ++d) {
                    if (owners[c] == player || owners[d] == player || c == d) continue;
                    ownedPlusPlus[owned] = cards[c];
                    ownedPlusPlus[owned + 1] = cards[d];
                    if (!Card.containsASet(ownedPlusPlus)) continue;
                    return Card.getRandomSet(ownedPlusPlus);
                }
            }
        }
        if (Card.containsASet(cards)) {
            return Card.getRandomSet(cards);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof Card) {
            Card card = (Card)other;
            return card.countryCode == this.countryCode && card.symbol == this.symbol;
        }
        return false;
    }

    public String toString() {
        return "<Card symbol=\"" + this.symbol + "\" country=\"" + this.countryCode + "\" />";
    }
}

