/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Biohazard;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.MapLoader;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.LuxView;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLTool;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Random;
import java.util.StringTokenizer;

public class BoardFile
implements Serializable {
    static final long serialVersionUID = 3422169136258069307L;
    public String contents;
    private String filename;
    private String description;
    private String playerInfoLocation;
    private boolean shortContinentLabels;
    private int mark = 0;
    private int armySetMemory = -1;

    public BoardFile(String boardSize, int boardNumber) throws Exception {
        this(boardSize, boardNumber, null);
    }

    public BoardFile(String boardSize, int boardNumber, GameControllerAbstract control) throws Exception {
        String path = DesktopTool.supportFolderPath() + "Boards" + File.separator + "Generated" + File.separator + boardSize + boardNumber + ".luxb";
        if (new File(path).exists()) {
            this.createFromPath(path);
        } else {
            SS.debug("we are using createFromGenerator(" + boardSize + ", " + boardNumber + ")");
            if (control instanceof GameControllerGUI) {
                this.createFromGenerator(boardSize, boardNumber, (GameControllerGUI)control);
            } else {
                this.createFromGenerator(boardSize, boardNumber, null);
            }
        }
    }

    private void createFromGenerator(String boardSize, int boardNumber, GameControllerGUI control) throws Exception {
        StringWriter resultBuffer = new StringWriter();
        PrintWriter out = new PrintWriter(resultBuffer);
        LuxMapGenerator mapgen = PluginManager.getInstance().getMapGeneratorForChoice(boardSize);
        boolean mapSuccess = mapgen.generate(out, boardSize, boardNumber, new MapLoader(control));
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.createFromReader(new BufferedReader(new StringReader(resultBuffer.toString())));
        this.filename = "Generated.luxb";
    }

    public BoardFile(String path) throws Exception {
        this.createFromPath(path);
    }

    public BoardFile(String filename, boolean custom) throws Exception {
        this.createFromPath(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + filename + ".luxb");
    }

    private void createFromPath(String path) throws Exception {
        System.out.println("BoardFile createFromPath: " + path);
        this.filename = path.substring(path.indexOf(File.separator + "Saved" + File.separator) + 7);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
        this.createFromReader(in);
    }

    private void createFromReader(BufferedReader in) throws Exception {
        StringBuffer inputBuffer = new StringBuffer();
        String temp = in.readLine();
        inputBuffer.append(temp);
        inputBuffer.append("\n");
        if ("luxboard-1.0".equals(temp)) {
            throw new Exception("The board file is malformed");
        }
        while ((temp = in.readLine()) != null) {
            inputBuffer.append(temp);
            inputBuffer.append("\n");
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.contents = inputBuffer.toString();
    }

    void load(GameControllerAbstract control) throws Exception {
        LuxWorld luxWorld = control.world;
        LuxView luxView = null;
        if (control instanceof GameControllerGUI) {
            luxView = ((GameControllerGUI)control).luxView;
        }
        this.load(control, luxWorld, luxView);
    }

    public void load(LuxView luxView) throws Exception {
        this.load(null, null, luxView);
    }

    private void load(GameControllerAbstract control, LuxWorld luxWorld, LuxView luxView) throws Exception {
        String continentXML;
        if (control != null) {
            control.setLoadText("loading file " + this.filename);
        }
        boolean fullLoad = control != null;
        System.out.println("\nLoading -> " + this.filename);
        if (!this.contents.startsWith("<?xml") && control != null && control.ops.customBoard) {
            try {
                SS.debug("BoardFile.load is adding the xml declaration to a file it reads in");
                this.saveToPath(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + this.filename);
            }
            catch (Exception e) {
                System.out.println("Tried to add the XML declaration to a board file that was missing it, but failed.");
            }
        }
        String title = XMLTool.extract("title", this.contents);
        if (control != null && control.ops.savedGame) {
            String XMLword;
            int numPlayers = XMLTool.count("player", this.contents);
            String[] namePass = new String[numPlayers];
            String[] typePass = new String[numPlayers];
            String[] colorPass = new String[numPlayers];
            boolean[] controlPass = new boolean[numPlayers];
            int p = 0;
            while ((XMLword = XMLTool.extract("player", this.contents, p)) != null) {
                namePass[p] = XMLTool.extract("name", XMLword);
                typePass[p] = XMLTool.extract("type", XMLword);
                colorPass[p] = XMLTool.extract("color", XMLword);
                controlPass[p] = "Human".equals(typePass[p]);
                ++p;
            }
            control.ops.takeValues(typePass, namePass, colorPass, controlPass, title);
        }
        if (control != null) {
            control.setLoadText("Mapping");
            control.setBoardName(title);
        }
        if (fullLoad && control instanceof GameControllerGUI) {
            try {
                GameControllerGUI guicontrol = (GameControllerGUI)control;
                control.ops.width = Integer.parseInt(XMLTool.extract("width", this.contents));
                control.ops.height = Integer.parseInt(XMLTool.extract("height", this.contents));
                if (control.ops.width == 0 || control.ops.height == 0) {
                    throw new Exception("Cannot have a width or height of 0");
                }
                guicontrol.setBoardSize();
            }
            catch (Exception e) {
                e.printStackTrace();
                SS.debug("Contents=" + this.contents);
                throw new Exception("Error in <width> or <height>: " + e.getMessage());
            }
        }
        int numCountries = XMLTool.count("country", this.contents);
        if (fullLoad) {
            String theme = XMLTool.extract("theme", this.contents);
            if (luxView != null) {
                luxView.loadTheme(theme);
            }
            luxWorld.setNumCountries(numCountries);
            if (luxView != null) {
                luxView.setNumCountries(numCountries);
            }
            control.setLoadText(numCountries + " countries");
        }
        int[] countryContinents = new int[numCountries];
        int[] countryInitialOwners = new int[numCountries];
        int[] countryInitialArmies = new int[numCountries];
        for (int i = 0; i < numCountries; ++i) {
            countryContinents[i] = -1;
            countryInitialOwners[i] = -1;
            countryInitialArmies[i] = 1;
        }
        boolean scenarioStartsAt1 = this.scenarioStartsAt1();
        int maxCont = XMLTool.count("continent", this.contents);
        if (fullLoad && luxView != null) {
            luxView.setNumContinents(maxCont);
        }
        String[] contNames = new String[maxCont];
        int[] contBonus = new int[maxCont];
        int cont = 0;
        while ((continentXML = XMLTool.extract("continent", this.contents, cont)) != null) {
            String countryXML;
            contNames[cont] = XMLTool.extract("continentname", continentXML);
            try {
                contBonus[cont] = Integer.parseInt(XMLTool.extract("bonus", continentXML));
            }
            catch (Exception e) {
                throw new Exception("Error in the <bonus> tag for continent '" + contNames[cont] + "': " + e.getMessage());
            }
            if (fullLoad && luxView != null) {
                try {
                    String colorString = XMLTool.extract("color", continentXML);
                    if (colorString != null) {
                        luxView.setContinentColor(cont, GraphicsTool.colorFromString(colorString));
                    }
                    luxView.setContinentName(cont, contNames[cont]);
                }
                catch (Exception e) {
                    throw new Exception("Error in the <color> tag for continent '" + contNames[cont] + "': " + e.getMessage());
                }
            }
            try {
                if (luxView != null) {
                    luxView.setContinentLabelLocation(cont, XMLTool.extract("labellocation", continentXML));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("Error in the <labellocation> tag in continent '" + contNames[cont] + "': " + e.getMessage());
            }
            int c = 0;
            while ((countryXML = XMLTool.extract("country", continentXML, c)) != null) {
                String countryName = XMLTool.extract("name", countryXML);
                int code = -1;
                try {
                    String poly;
                    StringTokenizer tok;
                    code = Integer.parseInt(XMLTool.extract("id", countryXML));
                    if (code >= countryContinents.length) {
                        throw new Exception("You are using an <id> that is too high (" + code + "). Note that the <id>s must start at 0, not 1.");
                    }
                    if (countryContinents[code] != -1) {
                        throw new Exception("Duplicate <id>: " + code);
                    }
                    countryContinents[code] = cont;
                    if (fullLoad) {
                        if (luxView != null) {
                            luxView.setCountryName(code, countryName);
                        }
                        luxWorld.setCountryName(code, countryName);
                        tok = new StringTokenizer(XMLTool.extract("adjoining", countryXML), ",");
                        while (tok.hasMoreTokens()) {
                            luxWorld.addCountryAdjoining(code, Integer.parseInt(tok.nextToken()));
                        }
                        try {
                            String temp = XMLTool.extract("initialOwner", countryXML);
                            if (temp != null) {
                                countryInitialOwners[code] = Integer.parseInt(temp);
                                if (scenarioStartsAt1 && !control.ops.savedGame) {
                                    int n = code;
                                    countryInitialOwners[n] = countryInitialOwners[n] - 1;
                                }
                            }
                            if ((temp = XMLTool.extract("initialArmies", countryXML)) != null) {
                                countryInitialArmies[code] = Integer.parseInt(temp);
                            }
                        }
                        catch (Exception e) {
                            throw new Exception("Error in initialOwner or initialArmies");
                        }
                    }
                    GeneralPath shape = new GeneralPath();
                    int s = 0;
                    while ((poly = XMLTool.extract("polygon", countryXML, s)) != null) {
                        tok = new StringTokenizer(poly, " ,");
                        int firstX = Integer.parseInt(tok.nextToken());
                        int firstY = Integer.parseInt(tok.nextToken());
                        shape.moveTo(firstX, firstY);
                        while (tok.hasMoreTokens()) {
                            shape.lineTo(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
                        }
                        shape.lineTo(firstX, firstY);
                        shape.closePath();
                        ++s;
                    }
                    if (luxView != null) {
                        luxView.setShape(code, shape);
                        luxView.setArmyLocation(code, XMLTool.extract("armylocation", countryXML));
                    }
                }
                catch (Exception e) {
                    SS.debug("contents = " + this.contents);
                    e.printStackTrace();
                    throw new Exception("Error in country '" + countryName + "' (could be country with id " + code + "): " + e);
                }
                ++c;
            }
            ++cont;
        }
        if (fullLoad) {
            luxWorld.setInitialValues(countryContinents, countryInitialOwners, countryInitialArmies, contBonus, contNames);
            if (luxView != null) {
                luxView.setCountryContinents(countryContinents);
            }
        }
        if (!fullLoad && luxView != null) {
            luxView.clearLines();
        }
        try {
            String lineXML;
            int h = 0;
            while ((lineXML = XMLTool.extract("line", this.contents, h)) != null) {
                String tempPosition = XMLTool.extract("position", lineXML);
                if (!tempPosition.trim().equals("")) {
                    if (luxView != null) {
                        luxView.addLine(new ExtraLine(lineXML));
                    }
                } else {
                    SS.debug("There is a <line> with an empty <position>");
                }
                ++h;
            }
        }
        catch (Exception e) {
            throw new Exception("Error in <line>: " + e.getMessage());
        }
        this.description = XMLTool.extract("description", this.contents);
        this.playerInfoLocation = XMLTool.extract("playerInfoLocation", this.contents);
        this.shortContinentLabels = "true".equals(XMLTool.extract("shortContinentLabels", this.contents));
        if (luxView != null) {
            luxView.doneLoading();
        }
        if (!fullLoad && luxView != null) {
            luxView.setLoadText(null);
        }
    }

    private String readLine() {
        int nextMark = this.contents.indexOf(10, this.mark);
        if (nextMark == -1) {
            this.mark = 0;
            return null;
        }
        String foo = this.contents.substring(this.mark, nextMark);
        this.mark = nextMark + 1;
        return foo;
    }

    private void close() {
        this.mark = 0;
    }

    public String pathCustom() {
        return DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + this.filename;
    }

    public void saveCustom(String withFilename) {
        String path;
        File file;
        if (withFilename == null) {
            withFilename = this.filename;
        }
        if ((file = new File(path = DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + withFilename)).exists()) {
            SS.debug("BOARDFILE -> decided not to overwrite existing file");
        } else {
            try {
                this.saveToPath(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveToPath(String path) throws IOException {
        SS.debug("using filename='" + this.filename + "' path='" + path);
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8")));
        String temp = this.readLine();
        if (!temp.startsWith("<?xml")) {
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        out.println(temp);
        while ((temp = this.readLine()) != null) {
            out.println(temp);
        }
        out.close();
    }

    public boolean existsCustom() {
        System.out.println("filename = " + this.filename);
        return new File(this.pathCustom()).exists();
    }

    public void saveResized(float percent, String withFilename) {
        String line;
        StringTokenizer tok;
        int y;
        int x;
        String continent;
        String temp;
        int i;
        String[] boardRequired = new String[]{"version"};
        String[] boardOptional = new String[]{"theme", "title", "author", "email", "webpage", "description", "shortContinentLabels", "armySet", "emptyPlayerID"};
        String[] continentRequired = new String[]{"bonus"};
        String[] continentOptional = new String[]{"color", "continentname"};
        String[] countryRequired = new String[]{"id", "adjoining"};
        String[] countryOptional = new String[]{"name", "initialOwner", "initialArmies"};
        String[] lineOptional = new String[]{"color", "width", "above"};
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard>\n");
        for (i = 0; i < boardRequired.length; ++i) {
            result.append("<" + boardRequired[i] + ">" + XMLTool.extract(boardRequired[i], this.contents) + "</" + boardRequired[i] + ">\n");
        }
        result.append("<height>" + (int)(percent * (float)Integer.parseInt(XMLTool.extract("height", this.contents))) + "</height>\n");
        result.append("<width>" + (int)(percent * (float)Integer.parseInt(XMLTool.extract("width", this.contents))) + "</width>\n");
        for (i = 0; i < boardOptional.length; ++i) {
            temp = XMLTool.extract(boardOptional[i], this.contents);
            if (temp == null) continue;
            result.append("<" + boardOptional[i] + ">" + temp + "</" + boardOptional[i] + ">\n");
        }
        int cont = 0;
        while ((continent = XMLTool.extract("continent", this.contents, cont)) != null) {
            String country;
            int i2;
            result.append("<continent>\n");
            for (i2 = 0; i2 < continentRequired.length; ++i2) {
                result.append("<" + continentRequired[i2] + ">" + XMLTool.extract(continentRequired[i2], continent) + "</" + continentRequired[i2] + ">\n");
            }
            for (i2 = 0; i2 < continentOptional.length; ++i2) {
                temp = XMLTool.extract(continentOptional[i2], continent);
                if (temp == null) continue;
                result.append("<" + continentOptional[i2] + ">" + temp + "</" + continentOptional[i2] + ">\n");
            }
            temp = XMLTool.extract("labellocation", continent);
            if (temp != null) {
                int divideAt = temp.indexOf(",");
                int x2 = Integer.parseInt(temp.substring(0, divideAt));
                int y2 = Integer.parseInt(temp.substring(divideAt + 1));
                result.append("<labellocation>" + (int)((float)x2 * percent) + "," + (int)((float)y2 * percent) + "</labellocation>\n");
            }
            int c = 0;
            while ((country = XMLTool.extract("country", continent, c)) != null) {
                String poly;
                int i3;
                result.append("<country>\n");
                for (i3 = 0; i3 < countryRequired.length; ++i3) {
                    result.append("<" + countryRequired[i3] + ">" + XMLTool.extract(countryRequired[i3], country) + "</" + countryRequired[i3] + ">\n");
                }
                for (i3 = 0; i3 < countryOptional.length; ++i3) {
                    temp = XMLTool.extract(countryOptional[i3], country);
                    if (temp == null) continue;
                    result.append("<" + countryOptional[i3] + ">" + temp + "</" + countryOptional[i3] + ">\n");
                }
                temp = XMLTool.extract("armylocation", country);
                if (temp != null) {
                    int divideAt = temp.indexOf(",");
                    x = Integer.parseInt(temp.substring(0, divideAt));
                    y = Integer.parseInt(temp.substring(divideAt + 1));
                    result.append("<armylocation>" + (int)((float)x * percent) + "," + (int)((float)y * percent) + "</armylocation>\n");
                }
                int s = 0;
                while ((poly = XMLTool.extract("polygon", country, s)) != null) {
                    result.append("<polygon>");
                    tok = new StringTokenizer(poly, " ,");
                    do {
                        x = Integer.parseInt(tok.nextToken());
                        y = Integer.parseInt(tok.nextToken());
                        result.append((int)((float)x * percent) + "," + (int)((float)y * percent) + " ");
                    } while (tok.hasMoreTokens());
                    result.append("</polygon>\n");
                    ++s;
                }
                result.append("</country>\n");
                ++c;
            }
            result.append("</continent>\n");
            ++cont;
        }
        int h = 0;
        while ((line = XMLTool.extract("line", this.contents, h)) != null) {
            result.append("<line>");
            for (int i4 = 0; i4 < lineOptional.length; ++i4) {
                temp = XMLTool.extract(lineOptional[i4], line);
                if (temp == null) continue;
                result.append("<" + lineOptional[i4] + ">" + temp + "</" + lineOptional[i4] + ">\n");
            }
            String pos = XMLTool.extract("position", line);
            result.append("<position>");
            tok = new StringTokenizer(pos, " ,");
            do {
                x = Integer.parseInt(tok.nextToken());
                y = Integer.parseInt(tok.nextToken());
                result.append((int)((float)x * percent) + "," + (int)((float)y * percent) + " ");
            } while (tok.hasMoreTokens());
            result.append("</position>\n");
            result.append("</line>\n");
            ++h;
        }
        result.append("</luxboard>\n");
        File file = new File(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + withFilename);
        if (file.exists()) {
            String base = DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + withFilename.substring(0, withFilename.length() - 5);
            int count = 1;
            do {
                file = new File(base + "." + count + ".luxb");
                ++count;
            } while (file.exists());
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            out.print(result);
            out.close();
        }
        catch (Throwable e) {
            System.out.println("Lux -> error in BoardFile.saveResized().");
            e.printStackTrace();
        }
    }

    public int getTotalScenarioPlayers() {
        if (this.contents.indexOf("<initialOwner>") == -1) {
            return 0;
        }
        int startAt = 0;
        if (this.scenarioStartsAt1()) {
            startAt = 1;
        }
        for (int i = startAt; i < startAt + 6; ++i) {
            if (this.contents.indexOf("<initialOwner>" + i + "</initialOwner>") != -1) continue;
            return i - startAt;
        }
        return 6;
    }

    public int getEmptyPlayerID() {
        String id = XMLTool.extract("emptyPlayerID", this.contents);
        if (id == null) {
            return -1;
        }
        try {
            int intID = Integer.parseInt(id);
            if (this.scenarioStartsAt1()) {
                --intID;
            }
            return intID;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getScenarioPlayersMinusEmpty() {
        int total = this.getTotalScenarioPlayers();
        if (this.getEmptyPlayerID() != -1) {
            return total - 1;
        }
        return total;
    }

    public boolean scenarioStartsAt1() {
        if (this.contents.indexOf("<initialOwner>") == -1) {
            return false;
        }
        return this.contents.indexOf("<initialOwner>0</initialOwner>") == -1 && this.contents.indexOf("<initialOwner>1</initialOwner>") != -1;
    }

    public boolean isPlayerEmptyLocked(int playerID) {
        return playerID == this.getEmptyPlayerID();
    }

    public boolean getScenarioHasEmpty() {
        return this.getEmptyPlayerID() > -1;
    }

    public String playerInfoLocation() {
        return this.playerInfoLocation;
    }

    public boolean shortContinentLabels() {
        return this.shortContinentLabels;
    }

    public void saveGame(GameControllerAbstract control, String filename) {
        String line;
        int i;
        String continent;
        String temp;
        int i2;
        String[] boardRequired = new String[]{"version", "width", "height"};
        String[] boardOptional = new String[]{"theme", "author", "email", "webpage", "title", "description", "shortContinentLabels", "playerInfoLocation", "armySet", "emptyPlayerID"};
        String[] continentRequired = new String[]{"bonus"};
        String[] continentOptional = new String[]{"color", "continentname", "labellocation"};
        String[] countryRequired = new String[]{"id", "adjoining"};
        String[] countryOptional = new String[]{"name", "armylocation"};
        String[] lineOptional = new String[]{"color", "width", "above"};
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard>\n");
        for (i2 = 0; i2 < boardRequired.length; ++i2) {
            result.append("<" + boardRequired[i2] + ">" + XMLTool.extract(boardRequired[i2], this.contents) + "</" + boardRequired[i2] + ">\n");
        }
        for (i2 = 0; i2 < boardOptional.length; ++i2) {
            temp = XMLTool.extract(boardOptional[i2], this.contents);
            if (temp == null) continue;
            result.append("<" + boardOptional[i2] + ">" + temp + "</" + boardOptional[i2] + ">\n");
        }
        int cont = 0;
        while ((continent = XMLTool.extract("continent", this.contents, cont)) != null) {
            String country;
            int i3;
            result.append("<continent>\n");
            for (i3 = 0; i3 < continentRequired.length; ++i3) {
                result.append("\t<" + continentRequired[i3] + ">" + XMLTool.extract(continentRequired[i3], continent) + "</" + continentRequired[i3] + ">\n");
            }
            for (i3 = 0; i3 < continentOptional.length; ++i3) {
                temp = XMLTool.extract(continentOptional[i3], continent);
                if (temp == null) continue;
                result.append("\t<" + continentOptional[i3] + ">" + temp + "</" + continentOptional[i3] + ">\n");
            }
            int c = 0;
            while ((country = XMLTool.extract("country", continent, c)) != null) {
                String poly;
                result.append("\t<country>\n");
                for (i = 0; i < countryRequired.length; ++i) {
                    result.append("\t\t<" + countryRequired[i] + ">" + XMLTool.extract(countryRequired[i], country) + "</" + countryRequired[i] + ">\n");
                }
                for (i = 0; i < countryOptional.length; ++i) {
                    temp = XMLTool.extract(countryOptional[i], country);
                    if (temp == null) continue;
                    result.append("\t\t<" + countryOptional[i] + ">" + temp + "</" + countryOptional[i] + ">\n");
                }
                int countryCode = Integer.parseInt(XMLTool.extract("id", country));
                result.append("\t\t<initialOwner>" + control.world.countries[countryCode].getOwner() + "</initialOwner>\n");
                result.append("\t\t<initialArmies>" + control.world.countries[countryCode].getArmies() + "</initialArmies>\n");
                int s = 0;
                while ((poly = XMLTool.extract("polygon", country, s)) != null) {
                    result.append("\t\t<polygon>");
                    result.append(poly);
                    result.append("</polygon>\n");
                    ++s;
                }
                result.append("\t</country>\n");
                ++c;
            }
            result.append("</continent>\n");
            ++cont;
        }
        int h = 0;
        while ((line = XMLTool.extract("line", this.contents, h)) != null) {
            result.append("<line>");
            result.append(line);
            result.append("</line>\n");
            ++h;
        }
        result.append("\n\n");
        int numPlayers = control.ops.playerNames.length;
        for (i = 0; i < numPlayers; ++i) {
            result.append("<player><name>");
            result.append(control.ops.playerNames[i]);
            result.append("</name><type>");
            result.append(control.ops.playerTypes[i]);
            result.append("</type><color>");
            result.append(control.ops.colorPassString[i]);
            result.append("</color></player>\n");
            result.append("<playerCards>");
            Card[] cards = control.world.getPlayerCards(i);
            for (int c = 0; c < cards.length; ++c) {
                result.append("<cardString>");
                result.append(cards[c].toString());
                result.append("</cardString>");
            }
            result.append("</playerCards>\n\n");
        }
        result.append("<gameRound>");
        result.append(control.world.gameRound);
        result.append("</gameRound>\n");
        result.append("<CardsObject>");
        result.append(control.ops.cardSequence.toString());
        result.append("</CardsObject>\n");
        result.append("<ContinentObject>");
        result.append(control.ops.continentSequence.toString());
        result.append("</ContinentObject>\n");
        result.append("<turnPhase>");
        result.append(control.world.turnPhase);
        result.append("</turnPhase>\n");
        result.append("<fluxArmies>");
        result.append(control.getFluxArmies());
        result.append("</fluxArmies>\n");
        result.append("<tookOverACountry>");
        result.append(control.world.tookOverACountry());
        result.append("</tookOverACountry>\n");
        result.append("<userSelectedCountry>");
        result.append(control.world.userSelectedCountry);
        result.append("</userSelectedCountry>\n");
        result.append("<currentPlayer>");
        result.append(control.world.currentPlayer);
        result.append("</currentPlayer>\n");
        if (control.world.turnPhase == 22) {
            result.append("<userAttackedTo>");
            result.append(control.world.userAttackedTo);
            result.append("</userAttackedTo>\n");
        }
        if (control.world.turnPhase == 3) {
            result.append("<ma>");
            for (i = 0; i < control.world.countries.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(control.world.countries[i].getMoveableArmies());
            }
            result.append("</ma>\n");
        }
        result.append("</luxboard>\n");
        if (!filename.endsWith(".luxsave")) {
            filename = filename + ".luxsave";
        }
        new File(DesktopTool.savedGameDir()).mkdirs();
        File file = new File(DesktopTool.savedGameDir() + filename);
        SS.debug("Saving game to " + DesktopTool.savedGameDir() + filename);
        if (file.exists()) {
            file.delete();
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            out.print(result);
            out.close();
        }
        catch (Throwable e) {
            System.out.println("Lux -> error in BoardFile.saveGame().");
            e.printStackTrace();
        }
    }

    public int armySet() {
        if (this.armySetMemory == -1) {
            String armySetString = XMLTool.extract("armySet", this.contents);
            this.armySetMemory = armySetString == null ? 0 : ("Ancient".equals(armySetString) ? 1 : ("Ancient-Oriental".equals(armySetString) ? 2 : ("None".equals(armySetString) ? 3 : ("Pre-Modern".equals(armySetString) ? 4 : ("Colonial".equals(armySetString) ? 5 : ("Medieval".equals(armySetString) ? 6 : ("Space Ships".equals(armySetString) ? 7 : ("Future Mech".equals(armySetString) ? 8 : 0))))))));
        }
        return this.armySetMemory;
    }

    public String title() {
        return XMLTool.extract("title", this.contents);
    }

    public static void sanitizeBadXMLFile(String path) throws Exception {
        SS.debug("sanitizeBadXMLFile: " + path);
        String content = FileTool.fileToString(path);
        content = BoardFile.sanitizeBadXML(content);
        FileTool.stringToFile(content, path);
    }

    public static String sanitizeBadXML(String content) throws Exception {
        return content.replaceAll("&", "&amp;");
    }

    public void biohazard(int biohazardLevel) {
        if (biohazardLevel == 0) {
            return;
        }
        SS.debug("Applying biohazard effect " + biohazardLevel + ". this=" + this);
        StringWriter resultBuffer = new StringWriter();
        PrintWriter out = new PrintWriter(resultBuffer);
        Biohazard biogen = new Biohazard();
        boolean mapSuccess = biogen.generate(out, "Biogen", new Random().nextInt(1000000), new MapLoader(null), this.contents, biohazardLevel);
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.createFromReader(new BufferedReader(new StringReader(resultBuffer.toString())));
            this.filename = "biohazardGenerated.luxb";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

