/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.MapLoader;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.DirectoryTool;
import com.sillysoft.tools.SS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Random;

public class BoardCache {
    private static final String boardLocation = DesktopTool.supportFolderPath() + "Boards" + File.separator;

    public static int pickCachedSeed(String boardSize) {
        File resourcesDir = new File(boardLocation + "Generated");
        if (resourcesDir == null || !resourcesDir.isDirectory()) {
            System.out.println("Error in CreateBoard() -> couldn't find the resources directory. 9877456");
        } else {
            int i;
            String[] filenames = resourcesDir.list();
            Random r = new Random();
            for (i = 0; i < filenames.length; ++i) {
                int pos = i + r.nextInt(filenames.length - i);
                String temp = filenames[i];
                filenames[i] = filenames[pos];
                filenames[pos] = temp;
            }
            for (i = 0; i < filenames.length; ++i) {
                if (!filenames[i].endsWith(".luxb") || !filenames[i].startsWith(boardSize)) continue;
                return Integer.parseInt(filenames[i].substring(boardSize.length(), filenames[i].length() - 5));
            }
        }
        return new Random().nextInt(1000000);
    }

    public static void clearCache() {
        File randomDir = new File(boardLocation + "Generated");
        File[] files = randomDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }

    public static void fillUpCache() {
        Thread.currentThread().setPriority(1);
        int fillLevel = 3;
        List choices = PluginManager.getInstance().getAllMapGeneratorChoices();
        for (int c = 0; c < choices.size(); ++c) {
            int count = DirectoryTool.countFilesWithPrefixAndSuffix(boardLocation + "Generated", choices.get(c).toString(), ".luxb");
            String choice = choices.get(c).toString();
            while (count < fillLevel) {
                if (PluginManager.getInstance().getMapGeneratorForChoice(choice).canCache()) {
                    System.out.println("caching for " + choice);
                    BoardCache.cacheRandomForChoice(choice);
                    ++count;
                    continue;
                }
                count = fillLevel;
            }
        }
    }

    private static void cacheRandomForChoice(String createSize) {
        boolean success = false;
        try {
            int seed = new Random().nextInt(1000000);
            success = BoardCache.saveRandomBoardAtLocation(boardLocation + "Generated" + File.separator + createSize + seed + ".luxb", createSize, seed, null);
        }
        catch (Throwable t) {
            success = false;
        }
        if (!success) {
            System.out.println("Lux -> cacheRandom failed for " + createSize);
        }
    }

    public static boolean saveRandomBoardAtLocation(String finalPath, String boardSize, int boardNumber, GameControllerGUI control) {
        PrintWriter out;
        String tempFolder = DesktopTool.supportFolderPath() + "Boards" + File.separator + "Temp";
        String tempLocation = tempFolder + File.separator + boardSize + boardNumber + ".luxb";
        new File(tempFolder).mkdirs();
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempLocation), "UTF-8"));
        }
        catch (Exception e) {
            SS.debug("Error trying to open " + tempLocation + " for writing.");
            return false;
        }
        LuxMapGenerator mapgen = PluginManager.getInstance().getMapGeneratorForChoice(boardSize);
        boolean mapSuccess = false;
        try {
            mapSuccess = mapgen.generate(out, boardSize, boardNumber, new MapLoader(control));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mapSuccess) {
            boolean moveSuccess = new File(tempLocation).renameTo(new File(finalPath));
            return moveSuccess;
        }
        new File(tempLocation).delete();
        return false;
    }
}

