/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.SSClassLoader;
import com.sillysoft.lux.agent.LuxAgent;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.widgets.SoundEffect;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.StringTokenizer;

public class Board {
    private Country[] countries;
    private LuxAgent[] agents;
    private int[] agentCards;
    private boolean pickCountriesRandomly;
    private String[] contNames;
    private LuxWorld world;
    private boolean finished = false;

    public Board(LuxWorld newWorld) {
        this.world = newWorld;
    }

    public boolean cashCards(Card card, Card card2, Card card3) {
        return this.world.cashCards(card, card2, card3);
    }

    public void placeArmies(int numberOfArmies, Country country) {
        if (country == null) {
            System.out.println("ERROR in board.placeArmies() -> country==null");
            Thread.dumpStack();
            return;
        }
        this.placeArmies(numberOfArmies, country.getCode());
    }

    public void placeArmies(int numberOfArmies, int countryCode) {
        if (!this.world.placeArmies(numberOfArmies, countryCode)) {
            System.out.println("ERROR returned from board.placeArmies(). You don't own country " + countryCode);
            Thread.dumpStack();
        }
    }

    public int attack(Country attacker, Country defender, boolean attackTillDead) {
        if (attacker == null || defender == null) {
            System.out.println("board.attack -> (attacker == null || defender == null)");
            return -1;
        }
        return this.attack(attacker.getCode(), defender.getCode(), attackTillDead);
    }

    public int attack(int countryCodeAttacker, int countryCodeDefender, boolean attackTillDead) {
        return this.world.attack(countryCodeAttacker, countryCodeDefender, attackTillDead);
    }

    public int fortifyArmies(int numberOfArmies, Country origin, Country destination) {
        if (origin == null || destination == null) {
            System.out.println("board.fortifyArmies -> (origin == null || destination == null)");
            return -1;
        }
        return this.fortifyArmies(numberOfArmies, origin.getCode(), destination.getCode());
    }

    public int fortifyArmies(int numberOfArmies, int countryCodeOrigin, int countryCodeDestination) {
        return this.world.fortifyArmies(numberOfArmies, countryCodeOrigin, countryCodeDestination);
    }

    void setCountries(Country[] newCountries) {
        if (!this.finished) {
            this.countries = newCountries;
        }
    }

    void setAgents(LuxAgent[] newAgents) {
        if (!this.finished) {
            this.agents = newAgents;
        }
    }

    public void setContinentNames(String[] contNames) {
        if (!this.finished) {
            this.contNames = contNames;
        }
    }

    public void finished() {
        this.finished = true;
    }

    public Country[] getCountries() {
        Country[] dupe = new Country[this.countries.length];
        for (int i = 0; i < this.countries.length; ++i) {
            dupe[i] = this.countries[i];
        }
        return dupe;
    }

    public int getNumberOfCountries() {
        return this.countries.length;
    }

    public int getNumberOfContinents() {
        int maxCont = 0;
        for (int i = 0; i < this.getNumberOfCountries(); ++i) {
            maxCont = Math.max(maxCont, this.countries[i].getContinent());
        }
        return ++maxCont;
    }

    public int getContinentBonus(int cont) {
        return this.world.getContinentBonus(cont);
    }

    public String getContinentName(int cont) {
        return this.contNames[cont];
    }

    public int getNumberOfPlayers() {
        return this.agents.length;
    }

    public int getNumberOfPlayersLeft() {
        int playerCount = 0;
        if (this.agents == null) {
            System.out.println("oops in Board.getNumberOfPlayersLeft -> agents is null 65422211");
        }
        for (int i = 0; i < this.agents.length; ++i) {
            if (!BoardHelper.playerIsStillInTheGame(i, this.countries)) continue;
            ++playerCount;
        }
        return playerCount;
    }

    public int getPlayerIncome(int player) {
        return this.world.calculatePlayerIncome(player);
    }

    public String getPlayerName(int player) {
        return this.world.getPlayerName(player);
    }

    public String getAgentName(int player) {
        if (player < 0 || this.agents == null || player >= this.agents.length) {
            return "no_player";
        }
        return this.agents[player].name();
    }

    public int getPlayerCards(int player) {
        return this.world.control.stats.getCards(player);
    }

    public int getNextCardSetValue() {
        return this.world.getNextCardSetValue();
    }

    public String getMapTitle() {
        return this.world.control.ops.boardTitle();
    }

    public boolean tookOverACountry() {
        return this.world.tookOverACountry();
    }

    public boolean useCards() {
        return this.world.control.ops.useCards;
    }

    public boolean transferCards() {
        return this.world.control.ops.cardTransfer;
    }

    public boolean immediateCash() {
        return this.world.control.ops.immediateCardCash;
    }

    public String toString() {
        String toReturn = "";
        toReturn = toReturn + "Country #\t\tContinent\t\tOwner\t\tArmies\n";
        for (int i = 0; i < this.getNumberOfCountries(); ++i) {
            toReturn = toReturn + "\t";
            toReturn = toReturn + i;
            toReturn = toReturn + "\t\t\t";
            toReturn = toReturn + this.countries[i].getContinent();
            toReturn = toReturn + "\t\t\t";
            toReturn = toReturn + this.countries[i].getOwner();
            toReturn = toReturn + "\t\t\t";
            toReturn = toReturn + this.countries[i].getArmies();
            toReturn = toReturn + "\n";
        }
        return toReturn;
    }

    void kill(LuxWorld owner) {
        if (this.world == owner) {
            this.world = null;
            this.agents = null;
            this.countries = null;
        } else {
            System.out.println("Someone not allowed tried to kill the board");
        }
    }

    public boolean playAudioAtURL(final String audioURL) {
        if (audioURL == null) {
            System.out.println("Board.playAudio() was called with audioURL == null");
            return false;
        }
        if (!PrefsCache.useSound || !Prefs.getBoolean("soundAgents", true)) {
            return false;
        }
        try {
            new Thread(){

                public void run() {
                    try {
                        SoundEffect.streamSampledAudio(new URL(audioURL));
                    }
                    catch (Throwable t) {
                        System.out.println(t + " caught while playing audio for an agent");
                    }
                }
            }.start();
            return true;
        }
        catch (Exception e) {
            System.out.println("Board.playAudio() caught an exception (" + e + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendChat(String message, LuxAgent sender) {
        if (message == null) {
            System.out.println("Board.sendChat() was called with message == null");
            return false;
        }
        if (message.startsWith("/") || message.startsWith("\\")) {
            System.out.println("Board.sendChat() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            NetBoss boss = this.world.control.netBoss;
            if (boss == null) {
                return false;
            }
            if (this.world.gamePhase == -1) {
                System.out.println("Board.sendChat() was called before the game has started");
                return false;
            }
            String name = this.world.getPlayerName(sender);
            if (name == null) {
                return false;
            }
            boss.dealWithAgentChat(message, name, sender.name());
            return true;
        }
        catch (Exception e) {
            System.out.println("Board.sendChat() caught an exception (" + e + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendChat(String message) {
        if (message == null) {
            System.out.println("Board.sendChat() was called with message == null");
            return false;
        }
        if (message.startsWith("/") || message.startsWith("\\")) {
            System.out.println("Board.sendChat() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            NetBoss boss = this.world.control.netBoss;
            if (boss == null) {
                return false;
            }
            if (this.world.gamePhase == -1) {
                System.out.println("Board.sendChat() was called before the game has started");
                return false;
            }
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            StringTokenizer st = new StringTokenizer(stacktrace, "\n");
            st.nextToken();
            st.nextToken();
            String classname = st.nextToken();
            classname = classname.substring(classname.indexOf("at ") + 3, classname.lastIndexOf("("));
            classname = classname.substring(0, classname.lastIndexOf("."));
            int lastPeriodPos = classname.lastIndexOf(".");
            if (lastPeriodPos != -1) {
                classname = classname.substring(lastPeriodPos + 1);
            }
            boss.dealWithAgentChat(message, classname, null);
            return true;
        }
        catch (Exception e) {
            System.out.println("Board.sendChat() caught an exception (" + e + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendEmote(String message) {
        if (message == null) {
            System.out.println("Board.sendChat() was called with message == null");
            return false;
        }
        if (message.startsWith("/") || message.startsWith("\\")) {
            System.out.println("Board.sendChat() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            NetBoss boss = this.world.control.netBoss;
            if (boss == null) {
                return false;
            }
            if (this.world.gamePhase == -1) {
                System.out.println("Board.sendChat() was called before the game has started");
                return false;
            }
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            StringTokenizer st = new StringTokenizer(stacktrace, "\n");
            st.nextToken();
            st.nextToken();
            String classname = st.nextToken();
            classname = classname.substring(classname.indexOf("at ") + 3, classname.lastIndexOf("("));
            classname = classname.substring(0, classname.lastIndexOf("."));
            int lastPeriodPos = classname.lastIndexOf(".");
            if (lastPeriodPos != -1) {
                classname = classname.substring(lastPeriodPos + 1);
            }
            boss.dealWithAgentEmote(message, classname, null);
            return true;
        }
        catch (Exception e) {
            System.out.println("Board.sendChat() caught an exception (" + e + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public boolean sendEmote(String message, LuxAgent sender) {
        if (message == null) {
            System.out.println("Board.sendEmote() was called with message == null");
            return false;
        }
        if (message.startsWith("/") || message.startsWith("\\")) {
            System.out.println("Board.sendEmote() was called with a message that starts with '/' or '', which is not allowed");
            return false;
        }
        try {
            NetBoss boss = this.world.control.netBoss;
            if (boss == null) {
                return false;
            }
            if (this.world.gamePhase == -1) {
                System.out.println("Board.sendEmote() was called before the game has started");
                return false;
            }
            String name = this.world.getPlayerName(sender);
            if (name == null) {
                return false;
            }
            boss.dealWithAgentEmote(message, name, sender.name());
            return true;
        }
        catch (Exception e) {
            System.out.println("Board.sendChat() caught an exception (" + e + "). Perhaps the game hasn't started yet.");
            return false;
        }
    }

    public static String getAgentPath() {
        return DesktopTool.supportFolderPath() + "Agents" + File.separator;
    }

    public String storageGet(String key, String defaultValue) {
        return Prefs.get("agent_" + key, defaultValue);
    }

    public boolean storageGetBoolean(String key, boolean defaultValue) {
        return Prefs.getBoolean("agent_" + key, defaultValue);
    }

    public int storageGetInt(String key, int defaultValue) {
        return Prefs.getInt("agent_" + key, defaultValue);
    }

    public float storageGetFloat(String key, float defaultValue) {
        return Prefs.getFloat("agent_" + key, defaultValue);
    }

    public void storagePut(String key, String value) {
        Prefs.put("agent_" + key, value);
    }

    public void storagePutBoolean(String key, boolean value) {
        Prefs.putBoolean("agent_" + key, value);
    }

    public void storagePutInt(String key, int value) {
        Prefs.putInt("agent_" + key, value);
    }

    public void storagePutFloat(String key, float value) {
        Prefs.putFloat("agent_" + key, value);
    }

    public void storageRemoveKey(String key) {
        Prefs.remove("agent_" + key);
    }

    public LuxAgent getAgentInstance(String agentType) {
        return SSClassLoader.getAgentNamed(agentType);
    }

    public String getCardProgression() {
        if (this.useCards()) {
            return CardSequence.sequences[this.world.control.ops.cardSequenceCode];
        }
        return "0";
    }

    public int getContinentIncrease() {
        return this.world.control.ops.continentSequence.intIncrease();
    }

    public int getTurnSecondsLeft() {
        return this.world.control.getTurnSecondsLeft();
    }

    public int getTurnCount() {
        return this.world.gameRound;
    }

    public boolean useScenario() {
        return this.world.control.ops.useScenario;
    }

    public String getMapPath() {
        return DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator;
    }
}

