/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux;

import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.MapLoader;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class Biohazard
implements LuxMapGenerator,
ImageObserver {
    String savedXML;
    Random rand;
    MapLoader m;
    private String boardSize;
    int boardSeed;
    String version;
    String width;
    String height;
    String theme;
    String author;
    String email;
    String webpage;
    String title;
    String description;
    String playerinfo;
    String shortContLabels;
    String emptyPlayer;
    String armySet;
    private int numCountries;
    private Country[] countries;
    private Vector deadCountries;
    private Vector newCountryIDs;
    private Vector origCountryIDs;
    private Vector connections;
    private Vector countryPolygons;
    private Vector countryNames;
    private Vector countryArmyLocations;
    private Vector contNames;
    private Vector contBonus;
    private Vector contColor;
    private Vector contLabelLoc;
    private Vector lines;
    private Vector players;
    private Vector initialOwners;
    private Vector initialArmies;
    boolean success = false;
    String mapFile;
    int deadCount;
    double deadPercent;
    BufferedImage background;
    BufferedImage foreground;
    BufferedImage overground;
    Graphics2D backG;
    Graphics2D foreG;
    Graphics2D overG;
    static BufferedImage TextureImage;
    int bioLevel = -1;
    boolean debugOn = false;
    static final String CHOICE_CLASSIC_L = "Biohazard - Classic - light";
    static final String CHOICE_CLASSIC_M = "Biohazard - Classic - medium";
    static final String CHOICE_CLASSIC_H = "Biohazard - Classic - heavy";
    static final String CHOICE_CLASSIC_E = "Biohazard - Classic - extreme";
    static final String CHOICE_DEUX_L = "Bio - Deux - light";
    static final String CHOICE_DEUX_M = "Bio - Deux - medium";
    static final String CHOICE_DEUX_H = "Bio - Deux - heavy";
    static final String CHOICE_DEUX_E = "Bio - Deux - extreme";
    static final String CHOICE_ARMSRACE_L = "Biohazard - Arms Race - light";

    public boolean generate(PrintWriter out, String choice, int seed, MapLoader loader, String XML, int bioLevel) {
        this.savedXML = XML;
        this.bioLevel = bioLevel;
        return this.generate(out, choice, seed, loader);
    }

    public boolean generate(PrintWriter out, String choice, int seed, MapLoader loader) {
        SS.debug("Bio.generate " + choice + ", " + seed);
        this.debug("SEED = " + seed);
        this.debug("CHOICE = " + choice);
        this.rand = new Random(seed);
        this.m = loader;
        this.boardSize = choice;
        this.boardSeed = seed;
        this.countryPolygons = new Vector();
        this.connections = new Vector();
        this.deadCountries = new Vector();
        this.newCountryIDs = new Vector();
        this.origCountryIDs = new Vector();
        this.countryNames = new Vector();
        this.countryArmyLocations = new Vector();
        this.contNames = new Vector();
        this.contBonus = new Vector();
        this.contColor = new Vector();
        this.lines = new Vector();
        this.contLabelLoc = new Vector();
        this.initialOwners = new Vector();
        this.initialArmies = new Vector();
        this.InitMapChoice(this.boardSize);
        this.debug("mapFile= " + this.mapFile);
        this.debug("deadPercent= " + this.deadPercent);
        this.numCountries = this.GetMapSize(this.mapFile);
        this.debug("numCountries= " + this.numCountries);
        this.deadCount = Math.round((float)((double)this.numCountries * this.deadPercent));
        this.debug("deadCount= " + this.deadCount);
        if (this.deadCount == 0) {
            this.deadCount = 1;
        }
        this.countries = new Country[this.numCountries];
        for (int i = 0; i < this.numCountries; ++i) {
            this.countryPolygons.add("");
            this.connections.add("");
            this.newCountryIDs.add("");
            this.countryNames.add("");
            this.countryArmyLocations.add("");
            this.initialOwners.add("");
            this.initialArmies.add("");
        }
        this.ReadXMLMap(this.mapFile);
        for (int iDeadLoop = 0; iDeadLoop < this.deadCount; ++iDeadLoop) {
            this.success = false;
            for (int iTry = 0; iTry < 5 && !this.success; ++iTry) {
                int deadTestID = this.rand.nextInt(this.numCountries);
                if (this.deadCountries.contains(new Integer(deadTestID))) {
                    this.success = false;
                    continue;
                }
                if (this.TestForValidMap(deadTestID)) {
                    this.success = true;
                    this.deadCountries.add(new Integer(deadTestID));
                    continue;
                }
                this.success = false;
            }
        }
        this.WriteMap(out);
        this.doTheme();
        return true;
    }

    private void InitMapChoice(String choice) {
        if (choice.equals(CHOICE_CLASSIC_L)) {
            this.mapFile = "Classic.luxb";
            this.deadPercent = 0.025;
        } else if (choice.equals(CHOICE_CLASSIC_M)) {
            this.mapFile = "Classic.luxb";
            this.deadPercent = 0.05;
        } else if (choice.equals(CHOICE_CLASSIC_H)) {
            this.mapFile = "Classic.luxb";
            this.deadPercent = 0.1;
        } else if (choice.equals(CHOICE_CLASSIC_E)) {
            this.mapFile = "Classic.luxb";
            this.deadPercent = 0.2;
        } else if (choice.equals(CHOICE_DEUX_L)) {
            this.mapFile = "Spicy Deux.luxb";
            this.deadPercent = 0.025;
        } else if (choice.equals(CHOICE_DEUX_M)) {
            this.mapFile = "Spicy Deux.luxb";
            this.deadPercent = 0.05;
        } else if (choice.equals(CHOICE_DEUX_H)) {
            this.mapFile = "Spicy Deux.luxb";
            this.deadPercent = 0.1;
        } else if (choice.equals(CHOICE_DEUX_E)) {
            this.mapFile = "Spicy Deux.luxb";
            this.deadPercent = 0.2;
        } else if (choice.equals(CHOICE_ARMSRACE_L)) {
            this.mapFile = "Arms Race.luxb";
            this.deadPercent = 0.05;
        } else {
            System.out.println("Biohazard general case: " + choice);
            this.mapFile = choice;
            switch (this.bioLevel) {
                case 1: {
                    this.deadPercent = 0.025;
                    break;
                }
                case 2: {
                    this.deadPercent = 0.05;
                    break;
                }
                case 3: {
                    this.deadPercent = 0.1;
                    break;
                }
                case 4: {
                    this.deadPercent = 0.2;
                    break;
                }
                case 5: {
                    this.deadPercent = 0.3;
                    break;
                }
                case 6: {
                    this.deadPercent = 0.5;
                    break;
                }
                default: {
                    this.deadPercent = 0.2;
                }
            }
        }
    }

    private int GetMapSize(String mapName) {
        int countryCount = 0;
        Biohazard biohazard = this;
        File support = new File(biohazard.m.getMapGeneratorPath()).getParentFile();
        String LuxbPath = support.getPath() + File.separator + "Boards" + File.separator + "Saved" + File.separator + mapName;
        Document doc = null;
        File mapFile = new File(LuxbPath);
        try {
            doc = this.parseLuxMap(LuxbPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NodeList nodeList = doc.getElementsByTagName("continent");
        for (int iCont = 0; iCont < nodeList.getLength(); ++iCont) {
            Element contNode = (Element)nodeList.item(iCont);
            NodeList countryList = contNode.getElementsByTagName("country");
            countryCount += countryList.getLength();
        }
        return countryCount;
    }

    private int HowManyPlayersInMap() {
        try {
            Biohazard biohazard = this;
            File support = new File(biohazard.m.getMapGeneratorPath()).getParentFile();
            String LuxbPath = support.getPath() + File.separator + "Boards" + File.separator + "Saved" + File.separator + this.mapFile;
            Document doc = this.parseLuxMap(LuxbPath);
            this.players = new Vector();
            NodeList nodeList = doc.getElementsByTagName("continent");
            for (int iCont = 0; iCont < nodeList.getLength(); ++iCont) {
                Element contNode = (Element)nodeList.item(iCont);
                NodeList countryList = contNode.getElementsByTagName("country");
                for (int iCountry = 0; iCountry < countryList.getLength(); ++iCountry) {
                    Element countryNode = (Element)countryList.item(iCountry);
                    NodeList countryChildNode = countryNode.getElementsByTagName("initialOwner");
                    Element luxbNode = (Element)countryChildNode.item(0);
                    Integer playerID = new Integer(Integer.parseInt(Biohazard.getCharacterDataFromElement(luxbNode)));
                    if (this.players.contains(playerID)) continue;
                    this.players.add(playerID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.players.size();
    }

    private void ReadXMLMap(String mapName) {
        try {
            Biohazard biohazard = this;
            File support = new File(biohazard.m.getMapGeneratorPath()).getParentFile();
            String LuxbPath = support.getPath() + File.separator + "Boards" + File.separator + "Saved" + File.separator + mapName;
            this.debug("Path= " + LuxbPath);
            Document doc = this.parseLuxMap(LuxbPath);
            NodeList nodeList = doc.getElementsByTagName("version");
            Element luxbNode = (Element)nodeList.item(0);
            this.version = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("width");
            luxbNode = (Element)nodeList.item(0);
            this.width = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("height");
            luxbNode = (Element)nodeList.item(0);
            this.height = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("theme");
            luxbNode = (Element)nodeList.item(0);
            this.theme = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("author");
            luxbNode = (Element)nodeList.item(0);
            this.author = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("email");
            luxbNode = (Element)nodeList.item(0);
            this.email = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("webpage");
            luxbNode = (Element)nodeList.item(0);
            this.webpage = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("title");
            luxbNode = (Element)nodeList.item(0);
            this.title = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("description");
            luxbNode = (Element)nodeList.item(0);
            this.description = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("playerInfoLocation");
            luxbNode = (Element)nodeList.item(0);
            this.playerinfo = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("shortContinentLabels");
            luxbNode = (Element)nodeList.item(0);
            this.shortContLabels = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("emptyPlayerID");
            luxbNode = (Element)nodeList.item(0);
            this.emptyPlayer = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("armySet");
            luxbNode = (Element)nodeList.item(0);
            this.armySet = Biohazard.getCharacterDataFromElement(luxbNode);
            nodeList = doc.getElementsByTagName("continent");
            for (int iCont = 0; iCont < nodeList.getLength(); ++iCont) {
                Element contNode = (Element)nodeList.item(iCont);
                NodeList contChildNode = contNode.getElementsByTagName("continentname");
                luxbNode = (Element)contChildNode.item(0);
                String contName = Biohazard.getCharacterDataFromElement(luxbNode);
                contChildNode = contNode.getElementsByTagName("bonus");
                luxbNode = (Element)contChildNode.item(0);
                String bonus = Biohazard.getCharacterDataFromElement(luxbNode);
                contChildNode = contNode.getElementsByTagName("color");
                luxbNode = (Element)contChildNode.item(0);
                String color = Biohazard.getCharacterDataFromElement(luxbNode);
                contChildNode = contNode.getElementsByTagName("labellocation");
                luxbNode = (Element)contChildNode.item(0);
                String contLabel = Biohazard.getCharacterDataFromElement(luxbNode);
                this.contNames.add(contName);
                this.contBonus.add(bonus);
                this.contColor.add(color);
                this.contLabelLoc.add(contLabel);
                NodeList countryNodes = contNode.getElementsByTagName("country");
                for (int iCountry = 0; iCountry < countryNodes.getLength(); ++iCountry) {
                    Element countryNode = (Element)countryNodes.item(iCountry);
                    NodeList countryChildNode = countryNode.getElementsByTagName("id");
                    luxbNode = (Element)countryChildNode.item(0);
                    Integer countryId = new Integer(Biohazard.getCharacterDataFromElement(luxbNode));
                    countryChildNode = countryNode.getElementsByTagName("name");
                    luxbNode = (Element)countryChildNode.item(0);
                    String countryName = Biohazard.getCharacterDataFromElement(luxbNode);
                    countryChildNode = countryNode.getElementsByTagName("adjoining");
                    luxbNode = (Element)countryChildNode.item(0);
                    String adjoining = Biohazard.getCharacterDataFromElement(luxbNode);
                    countryChildNode = countryNode.getElementsByTagName("armylocation");
                    luxbNode = (Element)countryChildNode.item(0);
                    String armylocation = Biohazard.getCharacterDataFromElement(luxbNode);
                    countryChildNode = countryNode.getElementsByTagName("initialOwner");
                    luxbNode = (Element)countryChildNode.item(0);
                    String initOwner = Biohazard.getCharacterDataFromElement(luxbNode);
                    countryChildNode = countryNode.getElementsByTagName("initialArmies");
                    luxbNode = (Element)countryChildNode.item(0);
                    String initArmy = Biohazard.getCharacterDataFromElement(luxbNode);
                    if (initArmy == "") {
                        initArmy = "1";
                    }
                    this.countries[countryId.intValue()] = new Country(countryId, iCont, this);
                    this.countryPolygons.set(countryId, new Vector());
                    this.countryNames.set(countryId, countryName);
                    this.countryArmyLocations.set(countryId, armylocation);
                    this.initialOwners.set(countryId, initOwner);
                    this.initialArmies.set(countryId, initArmy);
                    countryChildNode = countryNode.getElementsByTagName("polygon");
                    for (int iPolygons = 0; iPolygons < countryChildNode.getLength(); ++iPolygons) {
                        luxbNode = (Element)countryChildNode.item(iPolygons);
                        String polygon = Biohazard.getCharacterDataFromElement(luxbNode);
                        ((Vector)this.countryPolygons.get(countryId)).add(polygon);
                    }
                    Vector<String> adjList = new Vector<String>();
                    String[] adjListArray = adjoining.split(",");
                    for (int iAdj = 0; iAdj < adjListArray.length; ++iAdj) {
                        adjList.add(adjListArray[iAdj]);
                    }
                    this.connections.set(countryId, adjList);
                }
            }
            for (int iOrig = 0; iOrig < this.numCountries; ++iOrig) {
                for (int iConn = 0; iConn < ((Vector)this.connections.get(iOrig)).size(); ++iConn) {
                    Vector connect = (Vector)this.connections.get(iOrig);
                    int countryIndex = Integer.parseInt(connect.get(iConn).toString());
                    Country toJoin = this.countries[countryIndex];
                    this.countries[iOrig].addToAdjoiningList(toJoin, this);
                }
            }
            nodeList = doc.getElementsByTagName("line");
            for (int iLine = 0; iLine < nodeList.getLength(); ++iLine) {
                Element lineNode = (Element)nodeList.item(iLine);
                NodeList lineChildNode = lineNode.getElementsByTagName("position");
                luxbNode = (Element)lineChildNode.item(0);
                String position = Biohazard.getCharacterDataFromElement(luxbNode);
                lineChildNode = lineNode.getElementsByTagName("color");
                luxbNode = (Element)lineChildNode.item(0);
                String color = Biohazard.getCharacterDataFromElement(luxbNode);
                lineChildNode = lineNode.getElementsByTagName("width");
                luxbNode = (Element)lineChildNode.item(0);
                String linewidth = Biohazard.getCharacterDataFromElement(luxbNode);
                String sLine = "";
                sLine = "<position>" + position + "</position>";
                if (color != "") {
                    sLine = sLine + "<color>" + color + "</color>";
                }
                if (linewidth != "") {
                    sLine = sLine + "<width>" + linewidth + "</width>";
                }
                this.lines.add(sLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean TestForValidMap(int deadCountryID) {
        int iOrig;
        int newMapCount = this.numCountries - this.deadCountries.size() - 1;
        Country[] testMap = new Country[newMapCount];
        int iCurrent = 0;
        for (iOrig = 0; iOrig < this.numCountries; ++iOrig) {
            if (iOrig == deadCountryID || this.deadCountries.contains(new Integer(iOrig))) {
                this.newCountryIDs.set(iOrig, new Integer(-1));
                continue;
            }
            this.newCountryIDs.set(iOrig, new Integer(iCurrent));
            int contID = this.countries[iOrig].getContinent();
            testMap[iCurrent] = new Country(iCurrent, contID, this);
            ++iCurrent;
        }
        for (iOrig = 0; iOrig < this.numCountries; ++iOrig) {
            int testMapID = (Integer)this.newCountryIDs.get(iOrig);
            if (testMapID <= -1) continue;
            int[] joiningList = this.countries[iOrig].getAdjoiningCodeList();
            for (int iConn = 0; iConn < joiningList.length; ++iConn) {
                int toJoinID = (Integer)this.newCountryIDs.get(joiningList[iConn]);
                if (toJoinID <= -1) continue;
                Country toJoin = testMap[toJoinID];
                testMap[testMapID].addToAdjoiningList(toJoin, this);
            }
        }
        return this.IsValidMap(testMap);
    }

    private boolean IsValidMap(Country[] thisMap) {
        for (int i = 0; i < thisMap.length; ++i) {
            boolean cantConnect = false;
            for (int iCheck = 0; iCheck < thisMap.length && !cantConnect; ++iCheck) {
                try {
                    if (BoardHelper.friendlyPathBetweenCountries(i, iCheck, thisMap) != null || iCheck == i) continue;
                    cantConnect = true;
                    continue;
                }
                catch (Exception e) {
                    this.debug(e.toString());
                    this.debug("i: " + i);
                    this.debug("iCheck: " + iCheck);
                    cantConnect = true;
                }
            }
            if (cantConnect) continue;
            return true;
        }
        return false;
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child;
        if (e != null && (child = e.getFirstChild()) instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }

    private void WriteMap(PrintWriter out) {
        int i;
        int iOrig;
        int newMapCount = this.numCountries - this.deadCountries.size();
        Country[] testMap = new Country[newMapCount];
        int iCurrent = 0;
        for (iOrig = 0; iOrig < this.numCountries; ++iOrig) {
            if (this.deadCountries.contains(new Integer(iOrig))) {
                this.newCountryIDs.set(iOrig, new Integer(-1));
                continue;
            }
            this.newCountryIDs.set(iOrig, new Integer(iCurrent));
            this.origCountryIDs.add(iCurrent, new Integer(iOrig));
            int contID = this.countries[iOrig].getContinent();
            testMap[iCurrent] = new Country(iCurrent, contID, this);
            testMap[iCurrent].setName(this.countries[iOrig].getName(), this);
            ++iCurrent;
        }
        for (iOrig = 0; iOrig < this.numCountries; ++iOrig) {
            int testMapID = (Integer)this.newCountryIDs.get(iOrig);
            if (testMapID <= -1) continue;
            int[] joiningList = this.countries[iOrig].getAdjoiningCodeList();
            for (int iConn = 0; iConn < joiningList.length; ++iConn) {
                int toJoinID = (Integer)this.newCountryIDs.get(joiningList[iConn]);
                if (toJoinID <= -1) continue;
                Country toJoin = testMap[toJoinID];
                testMap[testMapID].addToAdjoiningList(toJoin, this);
            }
        }
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard>\n<version>1.0</version>\n<width>" + this.width + "</width>\n" + "<height>" + this.height + "</height>\n" + ("<theme>Biohazard_" + this.theme + "_" + this.boardSeed + "</theme>\n") + "<author>" + this.title + " by " + this.author + ", Biohazard by RandomGuy</author>\n" + "<email></email>\n" + "<webpage>" + this.webpage + "</webpage>\n" + "<title>" + this.title + " - BIO " + this.bioLevel + "</title>\n" + "<description>Biohazard modified map. Original map description: " + this.description + " Type: " + this.boardSize + "seed: " + this.boardSeed + "</description>\n");
        out.write("<playerInfoLocation>" + this.playerinfo + "</playerInfoLocation>");
        if (this.shortContLabels != "") {
            out.write("<shortContinentLabels>" + this.shortContLabels + "</shortContinentLabels>");
        }
        if (this.emptyPlayer != "") {
            out.write("<emptyPlayerID>" + this.emptyPlayer + "</emptyPlayerID>");
        }
        if (this.armySet != "") {
            out.write("<armySet>" + this.armySet + "</armySet>");
        }
        for (i = 0; i < this.contNames.size(); ++i) {
            if (BoardHelper.getContinentSize(i, testMap) <= 0) continue;
            out.write("<continent>\n  <continentname>" + this.contNames.get(i) + "</continentname>\n" + "  <bonus>" + this.contBonus.get(i) + "</bonus>\n");
            if (this.contColor.get(i) != "") {
                out.write("  <color>" + this.contColor.get(i) + "</color>\n");
            }
            if (this.contLabelLoc.get(i) != "") {
                out.write("  <labellocation>" + this.contLabelLoc.get(i) + "</labellocation>\n");
            }
            ContinentIterator contIt = new ContinentIterator(i, testMap);
            do {
                Country ctry = contIt.next();
                int newCode = ctry.getCode();
                int origCode = (Integer)this.origCountryIDs.get(newCode);
                this.debug("Country: " + this.countryNames.get(origCode).toString());
                this.debug("Code: " + ctry.getCode());
                this.debug("initialOwner: " + this.initialOwners.get(origCode).toString());
                this.debug("initialArmies: " + this.initialArmies.get(origCode).toString());
                this.debug("armylocation: " + this.countryArmyLocations.get(origCode));
                out.write("  <country>\n    <id>" + ctry.getCode() + "</id>\n" + "    <name>" + this.countryNames.get(origCode).toString() + "</name>\n" + (this.initialOwners.get(origCode).toString().equals("") ? "" : "   <initialOwner>" + this.initialOwners.get(origCode).toString() + "</initialOwner>\n") + (this.initialArmies.get(origCode).toString().equals("") ? "" : "   <initialArmies>" + this.initialArmies.get(origCode).toString() + "</initialArmies>\n") + "    <armylocation>" + this.countryArmyLocations.get(origCode) + "</armylocation>\n");
                this.writeConnections(out, ctry.getAdjoiningCodeList());
                int numPolygons = ((Vector)this.countryPolygons.get(origCode)).size();
                this.debug("numPolygons: " + numPolygons);
                for (int iPoly = 0; iPoly < numPolygons; ++iPoly) {
                    this.debug("polygon: " + ((Vector)this.countryPolygons.get(origCode)).get(iPoly).toString());
                    this.writePolygon(out, ((Vector)this.countryPolygons.get(origCode)).get(iPoly).toString());
                }
                out.write("  </country>\n");
            } while (contIt.hasNext());
            out.write("</continent>\n");
        }
        for (i = 0; i < this.lines.size(); ++i) {
            out.write("<line>" + this.lines.get(i) + "</line>");
        }
        out.write("</luxboard>\n");
        out.flush();
    }

    public static void createTheme(String baseTheme, int seed, int bioLevel, String mapFileName) {
        SS.debug("biohazard.createTheme: " + baseTheme + ", " + seed + ", " + bioLevel + ", " + mapFileName);
        String LuxbPath = DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved" + File.separator + mapFileName + ".luxb";
        SS.debug("biohazard.createTheme(LuxbPath=" + LuxbPath + ")");
        String XML = FileTool.fileToString(LuxbPath);
        Biohazard biogen = new Biohazard();
        PrintWriter out = new PrintWriter(new StringWriter());
        boolean mapSuccess = biogen.generate(out, "Biogen", seed, new MapLoader(null), XML, bioLevel);
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void doTheme() {
        try {
            int j;
            Biohazard biohazard = this;
            File support = new File(new File(biohazard.m.getMapGeneratorPath()).getParent());
            File themesFolder = new File(support.getPath() + File.separator + "Themes");
            File[] themesChildren = themesFolder.listFiles();
            for (int i = 0; i < themesChildren.length; ++i) {
                if (themesChildren[i].getName().indexOf("Biohazard_") == -1) continue;
                File[] oldThemeFiles = themesChildren[i].listFiles();
                for (j = 0; j < oldThemeFiles.length; ++j) {
                    oldThemeFiles[j].delete();
                }
                themesChildren[i].delete();
            }
            new File(themesFolder.getPath() + File.separator + "Biohazard_" + this.theme + "_" + this.boardSeed).mkdir();
            File origThemeFolder = new File(themesFolder.getPath() + File.separator + this.theme);
            File[] origThemeFiles = origThemeFolder.listFiles();
            for (j = 0; j < origThemeFiles.length; ++j) {
                if (origThemeFiles[j].getName().startsWith("background")) continue;
                this.copyFile(origThemeFiles[j].getAbsolutePath(), themesFolder.getPath() + File.separator + "Biohazard_" + this.theme + "_" + this.boardSeed + File.separator + origThemeFiles[j].getName());
            }
            this.loadOverground();
            this.loadBackground();
            this.overG = this.overground.createGraphics();
            this.backG = this.background.createGraphics();
            this.overG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.backG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.backG.setColor(new Color(0.286f, 0.118f, 0.286f));
            this.backG.setStroke(new BasicStroke(1.0f));
            boolean foundHazard = false;
            int hazardIconCount = 7;
            BufferedImage[] hazardIcons = new BufferedImage[hazardIconCount];
            foundHazard = true;
            for (int i = 0; i < hazardIconCount; ++i) {
                hazardIcons[i] = GraphicsTool.getBufferedImageFromJAR("biohazard_icon_" + (i + 1) + ".png");
            }
            File textureSpecific = new File(support.getPath() + File.separator + "Themes" + File.separator + this.theme + File.separator + "biohazard_background.jpg");
            if (textureSpecific.exists()) {
                TextureImage = ImageIO.read(textureSpecific);
                SS.debug("reading themed texture");
            } else {
                TextureImage = GraphicsTool.getBufferedImageFromJAR("biohazard_background.jpg");
                SS.debug("reading default texture");
            }
            int polyCenterX = -100;
            int polyCenterY = -100;
            if (Prefs.getBoolean("biotheme", true)) {
                int iPoly;
                int numPolygons;
                int deadID;
                int i;
                for (i = 0; i < this.deadCountries.size(); ++i) {
                    deadID = (Integer)this.deadCountries.get(i);
                    numPolygons = ((Vector)this.countryPolygons.get(deadID)).size();
                    for (iPoly = 0; iPoly < numPolygons; ++iPoly) {
                        String poly = ((Vector)this.countryPolygons.get(deadID)).get(iPoly).toString();
                        this.fillPolygon1(this.backG, this.getPolygon(poly));
                        Polygon p = this.getPolygon(poly);
                        polyCenterX = p.getBounds().x + p.getBounds().width / 2;
                        polyCenterY = p.getBounds().y + p.getBounds().height / 2;
                    }
                    if (!foundHazard || !Prefs.getBoolean("bioicons", true)) continue;
                    String[] xy = this.countryArmyLocations.get(deadID).toString().split(",");
                    if (xy.length < 2) {
                        xy = new String[]{"" + polyCenterX, "" + polyCenterY};
                    }
                    int x = Integer.parseInt(xy[0]);
                    int y = Integer.parseInt(xy[1]);
                    int choice = this.rand.nextInt(hazardIconCount);
                    this.overG.drawImage((Image)hazardIcons[choice], x - 14, Integer.parseInt(this.height) - y - 14, this);
                }
                for (i = 0; i < this.deadCountries.size(); ++i) {
                    deadID = (Integer)this.deadCountries.get(i);
                    numPolygons = ((Vector)this.countryPolygons.get(deadID)).size();
                    for (iPoly = 0; iPoly < numPolygons; ++iPoly) {
                        String poly = ((Vector)this.countryPolygons.get(deadID)).get(iPoly).toString();
                        this.fillPolygon2(this.backG, this.getPolygon(poly));
                    }
                }
            }
            ImageIO.write((RenderedImage)this.overground, "png", new File(support.getPath() + File.separator + "Themes" + File.separator + "Biohazard_" + this.theme + "_" + this.boardSeed + File.separator + "overground.png"));
            ImageIO.write((RenderedImage)this.background, "png", new File(support.getPath() + File.separator + "Themes" + File.separator + "Biohazard_" + this.theme + "_" + this.boardSeed + File.separator + "background.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("Exception: " + e.toString());
        }
    }

    private void loadOverground() {
        try {
            Biohazard biohazard = this;
            File support = new File(biohazard.m.getMapGeneratorPath()).getParentFile();
            String overgroundPath = support.getPath() + File.separator + "Themes" + File.separator + this.theme + File.separator + "overground.png";
            File over = new File(overgroundPath);
            this.overground = over.exists() ? ImageIO.read(over) : new BufferedImage(Integer.parseInt(this.width), Integer.parseInt(this.height), 2);
        }
        catch (Exception e) {
            this.debug(e.toString());
        }
    }

    private BufferedImage getScaledImage(Image image, double scalew, double scaleh) {
        int w = (int)(scalew * (double)image.getWidth(null));
        int h = (int)(scaleh * (double)image.getHeight(null));
        int type = 1;
        BufferedImage out = new BufferedImage(w, h, type);
        Graphics2D g2 = out.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance(scalew, scaleh);
        g2.drawImage(image, at, null);
        g2.dispose();
        return out;
    }

    private void loadBackground() {
        try {
            Biohazard biohazard = this;
            File support = new File(biohazard.m.getMapGeneratorPath()).getParentFile();
            String backgroundPathBase = support.getPath() + File.separator + "Themes" + File.separator + this.theme + File.separator + "background";
            String backgroundPath = backgroundPathBase + ".jpg";
            File back = new File(backgroundPath);
            if (!back.exists()) {
                backgroundPath = backgroundPathBase + ".png";
                back = new File(backgroundPath);
            }
            if (back.exists()) {
                BufferedImage tempBack = ImageIO.read(back);
                this.background = new BufferedImage(Integer.parseInt(this.width), Integer.parseInt(this.height), 1);
                double tempW = tempBack.getWidth();
                double tempH = tempBack.getHeight();
                double subW = 0.0;
                double subH = 0.0;
                subW = Double.parseDouble(this.width) / tempW;
                subH = Double.parseDouble(this.height) / tempH;
                BufferedImage origBG = subW == 1.0 && subH == 1.0 ? tempBack : this.getScaledImage(tempBack, subW, subH);
                Graphics2D graph = this.background.createGraphics();
                graph.drawImage((Image)origBG, 0, 0, this);
            } else {
                this.background = new BufferedImage(Integer.parseInt(this.width), Integer.parseInt(this.height), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyFile(String source, String target) {
        byte[] iobuff = new byte[1024];
        try {
            int bytes;
            FileInputStream fis = new FileInputStream(source);
            FileOutputStream fos = new FileOutputStream(target);
            while ((bytes = fis.read(iobuff)) != -1) {
                fos.write(iobuff, 0, bytes);
            }
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            this.debug(e.toString());
        }
    }

    private void writePolygon(PrintWriter out, String polygon) {
        out.write("<polygon>" + polygon + "</polygon>\n");
    }

    private Polygon getPolygon(String polygon) {
        Polygon p = new Polygon();
        StringTokenizer tok = new StringTokenizer(polygon, " ,");
        int firstX = Integer.parseInt(tok.nextToken());
        int firstY = Integer.parseInt(tok.nextToken());
        p.addPoint(firstX, firstY);
        while (tok.hasMoreTokens()) {
            int x = Integer.parseInt(tok.nextToken());
            int y = Integer.parseInt(tok.nextToken());
            p.addPoint(x, y);
        }
        return p;
    }

    private void fillPolygon1(Graphics g, Polygon p) {
        int[] ypoints = new int[p.npoints];
        for (int i = 0; i < p.npoints; ++i) {
            ypoints[i] = Integer.parseInt(this.height) - p.ypoints[i];
        }
        Polygon flippedPolyLarger = this.growPolygon(p.xpoints, ypoints, p.npoints, 4);
        g.setColor(Color.BLACK);
        ((Graphics2D)g).setStroke(new BasicStroke(6.0f, 1, 1));
        g.drawPolygon(flippedPolyLarger);
    }

    private void fillPolygon2(Graphics g, Polygon p) {
        int[] ypoints = new int[p.npoints];
        for (int i = 0; i < p.npoints; ++i) {
            ypoints[i] = Integer.parseInt(this.height) - p.ypoints[i];
        }
        Shape oldClip = g.getClip();
        Polygon flippedPoly = this.growPolygon(p.xpoints, ypoints, p.npoints, 4);
        ((Graphics2D)g).setClip(flippedPoly);
        g.drawImage(TextureImage, 0, 0, Integer.parseInt(this.width), Integer.parseInt(this.height), this);
        g.setClip(oldClip);
    }

    public Polygon growPolygon(int[] xpoints, int[] ypoints, int numberPoints, int growByPixels) {
        if (growByPixels == 0) {
            return new Polygon(xpoints, ypoints, numberPoints);
        }
        float[] c = Biohazard.centroid(xpoints, ypoints, numberPoints);
        int i = 0;
        while (i < numberPoints) {
            float vx = (float)xpoints[i] - c[0];
            float vy = (float)ypoints[i] - c[1];
            float norm = (float)Math.sqrt(vx * vx + vy * vy);
            int n = i;
            xpoints[n] = (int)((float)xpoints[n] + (float)growByPixels * vx / norm);
            int n2 = i++;
            ypoints[n2] = (int)((float)ypoints[n2] + (float)growByPixels * vy / norm);
        }
        return new Polygon(xpoints, ypoints, numberPoints);
    }

    public static float[] centroid(int[] xpoints, int[] ypoints, int numberPoints) {
        float[] c = new float[]{0.0f, 0.0f};
        for (int i = 0; i < numberPoints; ++i) {
            c[0] = c[0] + (float)xpoints[i];
            c[1] = c[1] + (float)ypoints[i];
        }
        c[0] = c[0] / (float)numberPoints;
        c[1] = c[1] / (float)numberPoints;
        return c;
    }

    private void writeConnections(PrintWriter out, int[] conns) {
        out.write("<adjoining>");
        for (int i = 0; i < conns.length - 1; ++i) {
            out.write("" + conns[i] + ",");
        }
        if (conns.length > 0) {
            out.write("" + conns[conns.length - 1]);
        }
        out.write("</adjoining>\n");
    }

    private Point polygonCenter(Polygon p) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < p.npoints; ++i) {
            x += (double)p.xpoints[i];
            y += (double)p.ypoints[i];
        }
        return new Point((int)(x /= (double)p.npoints), (int)(y /= (double)p.npoints));
    }

    public boolean canCache() {
        return false;
    }

    public String description() {
        return "Biohazard takes an existing map file and randomly selects countries that are deemed hazardous. These countries are removed from the map and marked with a biohazard icon. The map choice determines the amount of wasteland generated, but does not change the original map size in any way. Version 1.0 supports Classic and Deux. You must have the original map file to use the Biohazard version.";
    }

    public List getChoices() {
        Vector<String> v = new Vector<String>();
        v.add(CHOICE_CLASSIC_L);
        v.add(CHOICE_CLASSIC_M);
        v.add(CHOICE_CLASSIC_H);
        v.add(CHOICE_CLASSIC_E);
        v.add(CHOICE_DEUX_L);
        v.add(CHOICE_DEUX_M);
        v.add(CHOICE_DEUX_H);
        v.add(CHOICE_DEUX_E);
        return v;
    }

    public String message(String message, Object data) {
        if ("scenarioPlayerCount".equals(message)) {
            this.debug("get scenario number");
            this.InitMapChoice((String)data);
            int numPlayers = this.HowManyPlayersInMap();
            String choice = (String)data;
            return String.valueOf(numPlayers);
        }
        return null;
    }

    public String name() {
        return "Biohazard";
    }

    public float version() {
        return 1.3f;
    }

    private void debug(String s) {
        if (this.debugOn) {
            System.out.println(":" + s);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    private Document parseLuxMap(String LuxbPath) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        try {
            if (this.savedXML == null) {
                if (!new File(LuxbPath).exists() && LuxbPath.endsWith("Spicy Deux.luxb")) {
                    return docBuilder.parse(new StringBufferInputStream(this.SpicyDeuxXML()));
                }
                return docBuilder.parse(new File(LuxbPath));
            }
            System.out.println("Biogen parsing from saved XML");
            ByteArrayInputStream s = new ByteArrayInputStream(this.savedXML.getBytes("UTF-8"));
            return docBuilder.parse(s);
        }
        catch (SAXParseException sax) {
            if (this.savedXML == null) {
                BoardFile.sanitizeBadXMLFile(LuxbPath);
                return docBuilder.parse(new File(LuxbPath));
            }
            this.savedXML = BoardFile.sanitizeBadXML(this.savedXML);
            System.out.println("Biogen parsing from saved XML 2");
            ByteArrayInputStream s = new ByteArrayInputStream(this.savedXML.getBytes("UTF-8"));
            return docBuilder.parse(s);
        }
    }

    private String SpicyDeuxXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<luxboard><version>2.0</version><width>958</width><height>613</height><theme>Biohazard Deux</theme><author>Sillysoft Games</author><email>lux@sillysoft.net</email><webpage>http://sillysoft.net</webpage><title>Bio Deux</title><description>After the nukes.</description><continent><continentname>Australia</continentname><bonus>3</bonus><labellocation>791,172</labellocation><color>0.5843137254901961/0.3568627450980392/0.06274509803921569</color><country><id>0</id><name>Eastern Australia</name><initialOwner>0</initialOwner><adjoining>1,2</adjoining><armylocation>829,137</armylocation><polygon>838,100 824,101 818,111 811,113 806,121 799,141 807,147 811,172 823,166 827,189 833,176 837,161 854,143 855,128 845,106</polygon></country><country><id>1</id><name>New Guinea</name><initialOwner>0</initialOwner><initialArmies>6</initialArmies><adjoining>0,2,3</adjoining><armylocation>826,203</armylocation><polygon>833,196 841,189 850,189 836,207 815,214 808,208 819,199 813,195 826,190</polygon></country><country><id>2</id><name>Western Australia</name><initialOwner>0</initialOwner><adjoining>0,1,3</adjoining><armylocation>781,146</armylocation><polygon>757,115 766,113 771,117 779,117 785,122 794,124 800,123 806,121 799,141 807,147 811,172 813,185 796,185 791,176 785,179 776,169 772,161 754,153 753,142 758,127</polygon></country><country><id>3</id><name>Indonesia</name><initialOwner>0</initialOwner><initialArmies>11</initialArmies><adjoining>1,2,32</adjoining><armylocation>752,221</armylocation><polygon>763,239 766,232 761,217 771,221 785,224 778,214 770,212 779,201 763,201 761,217 757,208 746,209 741,200 763,194 785,193 781,185 758,188 733,195 736,203 723,208 709,235 718,233 723,225 742,206 742,224</polygon></country><country><id>32</id><name>Siam</name><initialOwner>0</initialOwner><initialArmies>2</initialArmies><adjoining>3,31,34</adjoining><armylocation>718,284</armylocation><polygon>705,274 705,263 713,267 715,243 723,227 733,223 729,236 719,249 721,259 733,245 742,251 741,265 733,273 735,283 724,303 701,302 697,286</polygon></country></continent><continent><continentname>South America</continentname><bonus>4</bonus><labellocation>316,148</labellocation><color>0.5019607843137255/0.0/0.0</color><country><id>4</id><name>Argentina</name><initialOwner>1</initialOwner><adjoining>5,6</adjoining><armylocation>296,109</armylocation><polygon>291,41 297,45 289,56 296,73 291,76 301,87 320,109 310,116 321,124 329,135 321,141 313,136 304,143 296,141 284,147 281,119 277,91 272,61 279,46</polygon></country><country><id>5</id><name>Brazil</name><initialOwner>1</initialOwner><initialArmies>2</initialArmies><adjoining>4,6,7,12</adjoining><armylocation>333,187</armylocation><polygon>321,141 329,135 321,124 310,116 320,109 339,130 345,148 362,157 364,178 375,200 362,209 341,217 329,233 313,221 304,233 283,226 279,206 285,199 278,189 284,177 293,181 310,170</polygon></country><country><id>6</id><name>Peru</name><initialOwner>1</initialOwner><initialArmies>6</initialArmies><adjoining>4,5,7</adjoining><armylocation>298,163</armylocation><polygon>260,212 279,206 285,199 278,189 284,177 293,181 310,170 321,141 313,136 304,143 296,141 284,147 286,165 271,176 257,200</polygon></country><country><id>7</id><name>Venezuela</name><initialOwner>1</initialOwner><initialArmies>11</initialArmies><adjoining>5,6,14</adjoining><armylocation>285,238</armylocation><polygon>329,233 313,221 304,233 283,226 279,206 260,212 268,230 268,243 283,255 296,248 310,250 316,238</polygon></country></continent><continent><continentname>Africa</continentname><bonus>6</bonus><labellocation>499,236</labellocation><color>0.0/0.0/0.0</color><country><id>8</id><name>South Africa</name><initialOwner>0</initialOwner><initialArmies>3</initialArmies><adjoining>9,10,11</adjoining><armylocation>526,152</armylocation><polygon>497,190 512,190 515,181 525,179 529,190 538,191 536,173 545,171 550,181 565,172 554,159 555,147 545,137 539,122 525,115 512,115 508,129 502,147 497,158 494,170</polygon></country><country><id>9</id><name>Congo</name><initialOwner>1</initialOwner><adjoining>8,10,12</adjoining><armylocation>515,209</armylocation><polygon>497,190 512,190 515,181 525,179 529,190 536,226 525,231 507,232 501,215 487,215 495,202</polygon></country><country><id>10</id><name>East Africa</name><initialOwner>2</initialOwner><adjoining>8,9,11,12,13,30</adjoining><armylocation>557,238</armylocation><polygon>525,231 536,226 529,190 538,191 536,173 545,171 550,181 565,172 567,188 565,203 574,221 589,233 596,255 575,250 573,257 560,271 555,287 537,281 521,261</polygon></country><country><id>11</id><name>Madagascar</name><initialOwner>3</initialOwner><initialArmies>3</initialArmies><adjoining>8,10</adjoining><armylocation>586,169</armylocation><polygon>579,171 590,184 597,169 594,149 585,140 574,152 579,161</polygon></country><country><id>12</id><name>North Africa</name><initialOwner>4</initialOwner><adjoining>5,9,10,13,26,28</adjoining><armylocation>460,281</armylocation><polygon>487,215 501,215 507,232 525,231 521,261 493,281 497,296 513,310 491,320 490,331 471,331 449,326 440,314 430,302 421,281 421,259 429,243 445,232 472,237 488,230</polygon></country><country><id>13</id><name>Egypt</name><initialOwner>0</initialOwner><adjoining>10,12,28,30</adjoining><armylocation>524,293</armylocation><polygon>555,287 549,303 544,311 520,319 513,310 497,296 493,281 521,261 537,281</polygon></country></continent><continent><continentname>Mexico</continentname><bonus>1</bonus><labellocation>208,268</labellocation><color>1.0/0.5019607843137255/0.0</color><country><id>14</id><name>Central America</name><initialOwner>4</initialOwner><adjoining>7,15,16</adjoining><armylocation>200,301</armylocation><polygon>157,325 181,327 201,321 218,304 215,296 217,280 224,274 231,275 243,283 241,267 253,262 254,250 268,243 247,245 232,262 217,265 195,277 188,296 172,314 177,301 185,284 172,297</polygon></country></continent><continent><continentname>USA</continentname><bonus>4</bonus><labellocation>140,370</labellocation><color>0.17647058823529413/0.21176470588235294/0.5843137254901961</color><country><id>15</id><name>Western United States</name><initialOwner>2</initialOwner><initialArmies>11</initialArmies><adjoining>14,16,17,18</adjoining><armylocation>181,349</armylocation><polygon>201,321 201,339 213,338 215,368 205,368 147,367 147,347 157,325 181,327</polygon></country><country><id>16</id><name>Eastern United States</name><initialOwner>2</initialOwner><initialArmies>2</initialArmies><adjoining>14,15,18,19</adjoining><armylocation>243,337</armylocation><polygon>218,304 201,321 201,339 213,338 215,368 244,357 267,353 301,373 305,362 296,355 284,351 285,344 274,341 271,328 257,313 259,293 249,308 237,311 232,305 224,309</polygon></country><country><id>20</id><name>Alaska</name><initialOwner>2</initialOwner><initialArmies>6</initialArmies><adjoining>17,21,40</adjoining><armylocation>71,440</armylocation><polygon>91,418 67,406 38,415 39,440 50,460 65,470 112,459 128,423 116,406</polygon></country></continent><continent><continentname>Canada</continentname><bonus>5</bonus><labellocation>231,434</labellocation><color>0.0/0.7490196078431373/1.0</color><country><id>17</id><name>Western Canada</name><initialOwner>2</initialOwner><adjoining>15,18,20,21</adjoining><armylocation>166,394</armylocation><polygon>131,386 116,406 128,423 203,417 205,368 147,367</polygon></country><country><id>18</id><name>Ontario</name><initialOwner>1</initialOwner><adjoining>15,16,17,19,21</adjoining><armylocation>232,382</armylocation><polygon>223,413 230,404 255,393 262,382 267,353 244,357 215,368 205,368 203,417 212,415</polygon></country><country><id>19</id><name>Quebec</name><initialOwner>3</initialOwner><adjoining>16,18,22</adjoining><armylocation>286,389</armylocation><polygon>263,394 269,399 266,424 286,417 292,407 301,417 308,401 322,389 321,382 301,373 267,353 262,382</polygon></country><country><id>21</id><name>Northwest Territories</name><initialOwner>4</initialOwner><initialArmies>3</initialArmies><adjoining>17,18,20,42</adjoining><armylocation>186,439</armylocation><polygon>112,459 136,464 171,455 163,473 146,473 149,488 177,479 195,482 209,459 184,460 175,454 194,453 208,452 224,470 248,457 255,425 230,430 223,413 212,415 203,417 128,423</polygon></country><country><id>42</id><name>Nunavut</name><initialOwner>0</initialOwner><adjoining>21,22</adjoining><armylocation>264,470</armylocation><polygon>230,489 250,494 276,474 296,452 288,436 261,446 244,465</polygon></country></continent><continent><continentname>Scandinavia</continentname><bonus>3</bonus><labellocation>441,476</labellocation><color>0.6078431372549019/0.7529411764705882/0.8941176470588236</color><country><id>22</id><name>Greenland</name><initialOwner>3</initialOwner><initialArmies>6</initialArmies><adjoining>19,23,42</adjoining><armylocation>363,513</armylocation><polygon>280,514 295,533 320,553 359,568 388,572 406,551 430,543 415,506 404,464 379,452 358,435 352,413 335,427 332,459 319,488 307,499 286,499</polygon></country><country><id>23</id><name>Iceland</name><initialOwner>3</initialOwner><initialArmies>11</initialArmies><adjoining>22,24,25</adjoining><armylocation>421,435</armylocation><polygon>404,440 423,447 435,435 422,423 409,429</polygon></country><country><id>24</id><name>Scandinavia</name><initialOwner>3</initialOwner><initialArmies>2</initialArmies><adjoining>23,25,27,29</adjoining><armylocation>499,422</armylocation><polygon>537,415 536,467 502,453 494,435 477,423 481,406 493,411 497,397 512,411 507,421 521,440 529,439 519,427 521,416</polygon></country></continent><continent><continentname>Europe</continentname><bonus>6</bonus><labellocation>479,374</labellocation><color>0.0/0.5019607843137255/0.0</color><country><id>25</id><name>Great Britain</name><initialOwner>3</initialOwner><adjoining>23,24,26,27</adjoining><armylocation>461,387</armylocation><polygon>457,410 464,406 458,399 469,386 466,380 451,377 455,388 449,395 448,386 445,385 437,382 437,394 449,397 449,406</polygon></country><country><id>26</id><name>Western Europe</name><initialOwner>1</initialOwner><adjoining>12,25,27,28</adjoining><armylocation>453,344</armylocation><polygon>469,377 479,368 478,353 470,353 469,346 461,341 460,331 449,329 440,335 440,353 459,352 464,358 453,369</polygon></country><country><id>27</id><name>Northern Europe</name><initialOwner>4</initialOwner><adjoining>24,25,26,28,29</adjoining><armylocation>514,383</armylocation><polygon>469,377 488,397 497,391 517,395 521,406 529,411 526,377 511,368 506,375 479,368</polygon></country><country><id>28</id><name>Southern Europe</name><initialOwner>2</initialOwner><initialArmies>3</initialArmies><adjoining>12,13,26,27,29,30</adjoining><armylocation>523,359</armylocation><polygon>479,368 506,375 511,368 526,377 544,364 531,345 521,343 514,347 502,361 496,358 509,340 502,329 494,335 503,339 487,355 478,353</polygon></country><country><id>29</id><name>Ukraine</name><initialOwner>3</initialOwner><adjoining>24,27,28,30,33,35</adjoining><armylocation>566,403</armylocation><polygon>536,467 568,449 562,442 549,445 551,435 560,430 585,449 604,455 607,430 596,411 597,387 596,364 584,359 590,334 569,347 560,362 544,364 526,377 529,411 537,415</polygon></country></continent><continent><continentname>Middle East</continentname><bonus>3</bonus><labellocation>608,330</labellocation><color>1.0/1.0/0.0</color><country><id>30</id><name>Middle East</name><initialOwner>4</initialOwner><initialArmies>7</initialArmies><adjoining>10,13,28,29,31,33</adjoining><armylocation>573,315</armylocation><polygon>544,311 549,303 555,301 563,289 573,271 573,257 597,267 616,285 607,296 595,291 586,305 591,309 601,301 616,296 625,296 622,308 635,319 627,332 601,333 590,334 569,347 550,349 533,344 531,333 544,328 556,329 553,315</polygon></country><country><id>33</id><name>Afghanistan</name><initialOwner>4</initialOwner><initialArmies>7</initialArmies><adjoining>29,30,31,34,35</adjoining><armylocation>635,352</armylocation><polygon>601,333 595,364 597,387 651,373 682,355 663,340 669,325 635,319 627,332</polygon></country></continent><continent><continentname>India</continentname><bonus>1</bonus><labellocation>661,267</labellocation><color>0.8/0.8/0.8</color><country><id>31</id><name>India</name><initialOwner>4</initialOwner><initialArmies>5</initialArmies><adjoining>30,32,33,34</adjoining><armylocation>664,296</armylocation><polygon>633,295 641,281 649,278 661,243 669,248 669,263 686,281 697,286 701,302 697,317 680,325 669,325 635,319 622,308 625,296</polygon></country></continent><continent><continentname>Far East</continentname><bonus>5</bonus><labellocation>750,337</labellocation><color>0.10196078431372549/0.10196078431372549/0.30196078431372547</color><country><id>34</id><name>China</name><initialOwner>1</initialOwner><adjoining>31,32,33,35,36,37</adjoining><armylocation>721,329</armylocation><polygon>669,323 663,340 682,355 693,363 709,365 739,353 770,341 773,331 769,323 777,309 770,295 752,283 735,283 724,303 701,302 697,317 680,325</polygon></country><country><id>37</id><name>Mongolia</name><initialOwner>2</initialOwner><adjoining>34,36,38,39,40</adjoining><armylocation>751,369</armylocation><polygon>778,382 800,351 789,339 795,328 785,320 781,339 770,341 739,353 709,365 713,391</polygon></country><country><id>38</id><name>Japan</name><initialOwner>4</initialOwner><adjoining>37,40</adjoining><armylocation>811,325</armylocation><polygon>825,359 838,351 826,347 823,316 795,299 796,320 813,332 823,344</polygon></country></continent><continent><continentname>Russia</continentname><bonus>7</bonus><labellocation>722,441</labellocation><color>0.4/0.0/0.2</color><country><id>35</id><name>Ural</name><initialOwner>4</initialOwner><adjoining>29,33,34,36</adjoining><armylocation>632,406</armylocation><polygon>615,461 628,459 641,453 656,416 679,382 693,363 682,355 651,373 597,387 596,411 607,430 604,455 595,469 598,477 607,491 633,503 640,502 639,496 629,493 617,489 605,473 610,464</polygon></country><country><id>36</id><name>Siberia</name><initialOwner>0</initialOwner><adjoining>34,35,37,39,41</adjoining><armylocation>685,430</armylocation><polygon>644,482 652,473 670,478 694,494 718,500 718,454 713,391 709,365 693,363 679,382 656,416 641,453</polygon></country><country><id>39</id><name>Irkutsk</name><initialOwner>1</initialOwner><initialArmies>3</initialArmies><adjoining>36,37,40,41</adjoining><armylocation>752,418</armylocation><polygon>805,437 778,382 713,391 718,454</polygon></country><country><id>40</id><name>Kamchatka</name><initialOwner>2</initialOwner><adjoining>20,37,38,39,41</adjoining><armylocation>853,439</armylocation><polygon>853,465 873,465 893,458 921,458 922,439 916,425 898,417 881,415 878,399 862,380 861,400 883,425 866,422 855,411 829,412 809,397 829,387 818,367 800,351 778,382 805,437</polygon></country><country><id>41</id><name>Yakutsk</name><initialOwner>3</initialOwner><adjoining>36,39,40</adjoining><armylocation>765,464</armylocation><polygon>730,511 755,499 753,483 777,477 781,484 796,478 799,466 820,476 848,473 853,465 805,437 718,454 718,500</polygon></country></continent></luxboard>";
    }
}

