/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.UnitStackGroupIterator;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util2 {
    Polymath bot;
    Country[][] incomingConnections;
    boolean inited = false;

    public Util2(Polymath bot) {
        this.bot = bot;
    }

    public void initMap() {
        if (this.inited) {
            return;
        }
        this.incomingConnections = new Country[this.bot.countryArray.length][];
        for (Country dest : this.bot.countryArray) {
            ArrayList<Country> connections = new ArrayList<Country>();
            for (Country source : this.bot.countryArray) {
                if (!this.realOutgoingList(source).contains(dest)) continue;
                connections.add(source);
            }
            this.incomingConnections[dest.getID()] = connections.toArray(new Country[connections.size()]);
        }
        this.inited = true;
    }

    public static UnitStack stackFromGroup(UnitStackGroup g, Unit u) {
        UnitStackGroupIterator stacks = new UnitStackGroupIterator(g);
        while (stacks.hasNext()) {
            UnitStack stack = stacks.next();
            if (!stack.getOwner().equals(u.getOwner()) || !(u instanceof UnitPawn && stack.getUnit() instanceof UnitPawn || u instanceof UnitKnight && stack.getUnit() instanceof UnitKnight) && (!(u instanceof UnitCastle) || !(stack.getUnit() instanceof UnitCastle))) continue;
            return stack;
        }
        return new UnitStack(u, 0);
    }

    public static int numInfantry(UnitStackGroup g) {
        return Util2.groupInfantry(g).getTotalUnitCount();
    }

    public static int numKnights(UnitStackGroup g) {
        return Util2.groupKnights(g).getTotalUnitCount();
    }

    public static int numCastles(UnitStackGroup g) {
        return Util2.groupCastles(g).getTotalUnitCount();
    }

    public static UnitStackGroup playerSubgroup(UnitStackGroup g, Player p) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator stacks = new UnitStackGroupIterator(g);
        while (stacks.hasNext()) {
            UnitStack stack = stacks.next();
            if (!stack.getOwner().equals(p)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup teamSubgroup(UnitStackGroup g, Team t) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator stacks = new UnitStackGroupIterator(g);
        while (stacks.hasNext()) {
            UnitStack stack = stacks.next();
            if (!stack.getTeam().equals(t)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup excludeTeam(UnitStackGroup g, Team t) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator stacks = new UnitStackGroupIterator(g);
        while (stacks.hasNext()) {
            UnitStack stack = stacks.next();
            if (stack.getTeam().equals(t)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup groupFromStack(UnitStack stack) {
        UnitStackGroup ret = new UnitStackGroup();
        ret.add(stack);
        return ret;
    }

    public static UnitStackGroup groupInfantry(UnitStackGroup g) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator units = new UnitStackGroupIterator(g);
        while (units.hasNext()) {
            UnitStack stack = units.next();
            if (!(stack.getUnit() instanceof UnitPawn)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup groupKnights(UnitStackGroup g) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator units = new UnitStackGroupIterator(g);
        while (units.hasNext()) {
            UnitStack stack = units.next();
            if (!(stack.getUnit() instanceof UnitKnight)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup groupCastles(UnitStackGroup g) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator units = new UnitStackGroupIterator(g);
        while (units.hasNext()) {
            UnitStack stack = units.next();
            if (!(stack.getUnit() instanceof UnitCastle)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static ArrayList<UnitStackGroup> splitByTeam(UnitStackGroup g, List<Team> teams) {
        ArrayList<UnitStackGroup> ret = new ArrayList<UnitStackGroup>(teams.size());
        for (int i = 0; i < teams.size(); ++i) {
            ret.add(Util2.teamSubgroup(g, teams.get(i)));
        }
        return ret;
    }

    public static UnitStackGroup combine(UnitStackGroup a, UnitStackGroup b) {
        UnitStackGroup ret = new UnitStackGroup();
        ret.add(a);
        ret.add(b);
        return ret;
    }

    public static ArrayList<Country> teamCountries(Team t, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (!c.getTeam().equals(t)) continue;
            ret.add(c);
        }
        return ret;
    }

    public static ArrayList<Country> hostileCountries(Team t, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (c.getTeam().equals(t)) continue;
            ret.add(c);
        }
        return ret;
    }

    public List<Country> realOutgoingList(Country c) {
        List fakeOutgoingList = c.getAdjoiningList();
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country f : fakeOutgoingList) {
            ret.add(this.bot.countryArray[f.getID()]);
        }
        return ret;
    }

    public List<Country> realIncomingList(Country c) {
        Country[] fakeIncomingList = this.incomingConnections[c.getID()];
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country f : fakeIncomingList) {
            ret.add(this.bot.countryArray[f.getID()]);
        }
        return ret;
    }

    public ArrayList<Country> countriesInIncomingRange(Country c, int range, boolean safe) {
        ArrayList<Country> ret = new ArrayList<Country>();
        ret.add(c);
        ret.addAll(this.realIncomingList(c));
        if (safe) {
            ret = Util2.teamCountries(c.getTeam(), ret);
        }
        for (int i = 2; i <= range; ++i) {
            ArrayList<Country> newRet = new ArrayList<Country>();
            for (Country r : ret) {
                for (Country n : this.realIncomingList(r)) {
                    if (newRet.contains(n) || ret.contains(n) || n.equals(c) || safe && !n.getTeam().equals(c.getTeam())) continue;
                    newRet.add(n);
                }
            }
            ret.addAll(newRet);
        }
        return ret;
    }

    public ArrayList<Country> countriesInOutgoingRange(Country c, int range, boolean safe) {
        ArrayList<Country> ret = new ArrayList<Country>();
        ret.add(c);
        ret.addAll(this.realOutgoingList(c));
        if (safe) {
            ret = Util2.teamCountries(c.getTeam(), ret);
        }
        for (int i = 2; i <= range; ++i) {
            ArrayList<Country> newRet = new ArrayList<Country>();
            for (Country r : ret) {
                for (Country n : this.realOutgoingList(r)) {
                    if (newRet.contains(n) || ret.contains(n) || n.equals(c) || safe && !n.getTeam().equals(c.getTeam())) continue;
                    newRet.add(n);
                }
            }
            ret.addAll(newRet);
        }
        return ret;
    }

    public UnitStackGroup potentialArrivers(Country c) {
        UnitStackGroup ret = this.bot.troops.incomingGroup(c);
        ArrayList<Country> nearby = this.countriesInIncomingRange(c, 2, false);
        for (Country n : nearby) {
            UnitStackGroupIterator units = new UnitStackGroupIterator(this.bot.troops.remainingGroup(n));
            while (units.hasNext()) {
                UnitStack unit = units.next();
                if (!c.equals(n) && !this.bot.world.unitCanReach(unit, n, c)) continue;
                ret.add(unit);
            }
        }
        return ret;
    }

    public UnitStackGroup potentialArriversFromContinent(Country c, int contID) {
        UnitStackGroup ret = new UnitStackGroup();
        ArrayList<Country> nearby = this.countriesInIncomingRange(c, 2, false);
        for (Country n : nearby) {
            if (n.getContinentID() != contID) continue;
            UnitStackGroupIterator units = new UnitStackGroupIterator(this.bot.troops.remainingGroup(n));
            while (units.hasNext()) {
                UnitStack unit = units.next();
                if (!c.equals(n) && !this.bot.world.unitCanReach(unit, n, c)) continue;
                ret.add(unit);
            }
        }
        return ret;
    }

    public UnitStackGroup potentialAttackers(Country c) {
        return Util2.excludeTeam(this.potentialArrivers(c), c.getTeam());
    }

    public UnitStackGroup potentialAttackersFromContinent(Country c, int contID) {
        return Util2.excludeTeam(this.potentialArriversFromContinent(c, contID), c.getTeam());
    }

    public UnitStackGroup potentialDefenders(Country c) {
        return Util2.teamSubgroup(this.potentialArrivers(c), c.getTeam());
    }

    public ArrayList<Country> hostileIncomingNeighbors(Country c) {
        return Util2.hostileCountries(c.getTeam(), this.realIncomingList(c));
    }

    public ArrayList<Country> hostileOutgoingNeighbors(Country c) {
        return Util2.hostileCountries(c.getTeam(), this.realOutgoingList(c));
    }

    public ArrayList<Country> friendlyIncomingNeighbors(Country c) {
        return Util2.teamCountries(c.getTeam(), this.realIncomingList(c));
    }

    public boolean isBorder(Country c) {
        return this.hostileIncomingNeighbors(c).size() > 0;
    }

    public boolean isEdge(Country c) {
        return this.hostileOutgoingNeighbors(c).size() > 0;
    }

    public ArrayList<Country> friendlyIncomingNeighborBorders(Country c) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country n : Util2.teamCountries(c.getTeam(), this.realIncomingList(c))) {
            if (!this.isBorder(n)) continue;
            ret.add(n);
        }
        return ret;
    }

    public ArrayList<Country> knightDestinations(Country origin) {
        List<Country> neighbors = this.realOutgoingList(origin);
        ArrayList<Country> ret = new ArrayList<Country>(neighbors);
        for (Country n : neighbors) {
            if (!n.getTeam().equals(origin.getTeam()) && this.bot.troops.originalGroup(n).getTotalUnitCount() != 0) continue;
            for (Country n2 : this.realOutgoingList(n)) {
                if (ret.contains(n2)) continue;
                ret.add(n2);
            }
        }
        return ret;
    }

    public ArrayList<Country> knightSources(Country target) {
        List<Country> neighbors = this.realIncomingList(target);
        ArrayList<Country> ret = new ArrayList<Country>(neighbors);
        for (Country n : neighbors) {
            for (Country n2 : this.realIncomingList(n)) {
                if (!n.getTeam().equals(n2.getTeam()) && this.bot.troops.originalGroup(n).getTotalUnitCount() != 0 || ret.contains(n2)) continue;
                ret.add(n2);
            }
        }
        return ret;
    }

    public Team continentOwner(int contID) {
        Team owner = null;
        for (Country c : this.bot.countryList) {
            if (c.getContinentID() != contID) continue;
            if (owner == null) {
                owner = c.getTeam();
                continue;
            }
            if (owner.equals(c.getTeam())) continue;
            return null;
        }
        return owner;
    }

    public boolean isContinentBorder(Country c) {
        for (Country n : this.realIncomingList(c)) {
            if (n.getContinentID() == c.getContinentID()) continue;
            return true;
        }
        return false;
    }

    public boolean isContinentEdge(Country c) {
        for (Country n : this.realOutgoingList(c)) {
            if (n.getContinentID() == c.getContinentID()) continue;
            return true;
        }
        return false;
    }

    public boolean weOwnIncomingNeighborContinents(Country c) {
        for (Country n : this.realIncomingList(c)) {
            if (c.getContinentID() == n.getContinentID() || this.bot.us.equals(this.continentOwner(n.getContinentID()))) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<Country> continentCountries(int contID, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (c.getContinentID() != contID) continue;
            ret.add(c);
        }
        return ret;
    }

    public static ArrayList<Country> teamCastles(Team t, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (!c.hasCastle() || !c.getTeam().equals(t)) continue;
            ret.add(c);
        }
        return ret;
    }

    public static <T> List<T> setSubtract(List<T> a, List<T> b) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T t : a) {
            if (b.contains(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public static <T> List<T> setIntersect(List<T> a, List<T> b) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T t : a) {
            if (!b.contains(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public static boolean isBoring(Player p) {
        return !p.isHuman() && p.getBrain().equals("Boring");
    }

    public static boolean isBoring(Country c) {
        return Util2.isBoring(c.getOwner());
    }

    public static String listToString(List list) {
        String ret = "{";
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                ret = ret + ", ";
            }
            ret = ret + list.get(i).toString();
        }
        ret = ret + "}";
        return ret;
    }
}

