/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.UnitStackGroupIterator;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    Hawk bot;
    UnitStackGroup[] original;
    UnitStackGroup[] remaining;
    UnitStackGroup[] incoming;

    public Util(Hawk bot) {
        this.bot = bot;
    }

    public void initTurn() {
        this.original = new UnitStackGroup[this.bot.countryArray.length];
        this.remaining = new UnitStackGroup[this.bot.countryArray.length];
        this.incoming = new UnitStackGroup[this.bot.countryArray.length];
        for (int i = 0; i < this.bot.countryArray.length; ++i) {
            if (this.bot.countryArray[i].getTeam().equals(this.bot.us)) {
                this.original[i] = Simulation.clone(this.bot.countryArray[i].getUnitStackGroup());
                this.remaining[i] = Simulation.clone(this.bot.countryArray[i].getUnitStackGroup());
            } else {
                this.original[i] = new UnitStackGroup();
                this.remaining[i] = new UnitStackGroup();
            }
            this.incoming[i] = new UnitStackGroup();
        }
    }

    public void placeInfantry(Country c, int number) {
        this.bot.world.placeUnits(new UnitStack(new UnitPawn(this.bot.me), number), c);
    }

    public void placeKnights(Country c, int number) {
        this.bot.world.placeUnits(new UnitStack(new UnitKnight(this.bot.me), number), c);
    }

    private void moveUnit(Country from, Country to, int count, boolean infantry) {
        int numToMove;
        int numAvailable;
        if (count == 0) {
            return;
        }
        int n = numAvailable = infantry ? this.remainingInfantry(from).getTotalUnitCount() : this.remainingKnights(from).getTotalUnitCount();
        if (count < 0 || count > numAvailable) {
            throw new RuntimeException("Bad count in moveInfantry(" + from.getName() + ", " + to.getName() + ", " + count + ")");
        }
        for (int moved = 0; moved < count; moved += numToMove) {
            UnitStack toBeMoved = null;
            UnitStackGroupIterator stacks = new UnitStackGroupIterator(this.remaining[from.getID()]);
            while (stacks.hasNext()) {
                UnitStack stack = stacks.next();
                if (stack.getCount() <= 0 || (!infantry || !(stack.getUnit() instanceof UnitPawn)) && (infantry || !(stack.getUnit() instanceof UnitKnight)) || toBeMoved != null && stack.getOwner().getID() >= toBeMoved.getOwner().getID()) continue;
                toBeMoved = stack;
            }
            numToMove = Math.min(count - moved, toBeMoved.getCount());
            if (toBeMoved.getOwner().equals(this.bot.me) && !from.equals(to)) {
                this.bot.world.moveUnit(toBeMoved, from, to, numToMove);
            }
            this.incoming[to.getID()].add(new UnitStack(toBeMoved.getUnit(), numToMove));
            this.incoming[to.getID()].consolidateUnits();
            toBeMoved.setCount(toBeMoved.getCount() - numToMove);
        }
    }

    public void moveInfantry(Country from, Country to, int count) {
        this.moveUnit(from, to, count, true);
    }

    public void moveKnights(Country from, Country to, int count) {
        this.moveUnit(from, to, count, false);
    }

    public void moveRemainingInfantry(Country from, Country to) {
        this.moveInfantry(from, to, this.remainingInfantry(from).getTotalUnitCount());
    }

    public void moveRemainingKnights(Country from, Country to) {
        this.moveKnights(from, to, this.remainingKnights(from).getTotalUnitCount());
    }

    public void reserveInfantry(Country c, int count) {
        this.moveInfantry(c, c, count);
    }

    public void reserveKnights(Country c, int count) {
        this.moveKnights(c, c, count);
    }

    public UnitStackGroup originalGroup(Country c) {
        return this.original[c.getID()];
    }

    public UnitStackGroup remainingGroup(Country c) {
        return this.remaining[c.getID()];
    }

    public UnitStackGroup incomingGroup(Country c) {
        return this.incoming[c.getID()];
    }

    public UnitStackGroup originalInfantry(Country c) {
        return Util.groupInfantry(this.original[c.getID()]);
    }

    public UnitStackGroup originalKnights(Country c) {
        return Util.groupKnights(this.original[c.getID()]);
    }

    public UnitStackGroup remainingInfantry(Country c) {
        return Util.groupInfantry(this.remaining[c.getID()]);
    }

    public UnitStackGroup remainingKnights(Country c) {
        return Util.groupKnights(this.remaining[c.getID()]);
    }

    public UnitStackGroup incomingInfantry(Country c) {
        return Util.groupInfantry(this.incoming[c.getID()]);
    }

    public UnitStackGroup incomingKnights(Country c) {
        return Util.groupKnights(this.incoming[c.getID()]);
    }

    public static UnitStack stackFromGroup(UnitStackGroup g, Unit u) {
        UnitStackGroupIterator stacks = new UnitStackGroupIterator(g);
        while (stacks.hasNext()) {
            UnitStack stack = stacks.next();
            if (!stack.getOwner().equals(u.getOwner()) || !(u instanceof UnitPawn && stack.getUnit() instanceof UnitPawn || u instanceof UnitKnight && stack.getUnit() instanceof UnitKnight) && (!(u instanceof UnitCastle) || !(stack.getUnit() instanceof UnitCastle))) continue;
            return stack;
        }
        return new UnitStack(u, 0);
    }

    public static int numInfantry(UnitStackGroup g) {
        return Util.groupInfantry(g).getTotalUnitCount();
    }

    public static int numKnights(UnitStackGroup g) {
        return Util.groupKnights(g).getTotalUnitCount();
    }

    public static int numCastles(UnitStackGroup g) {
        return Util.groupCastles(g).getTotalUnitCount();
    }

    public static UnitStackGroup playerSubgroup(UnitStackGroup g, Player p) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator stacks = new UnitStackGroupIterator(g);
        while (stacks.hasNext()) {
            UnitStack stack = stacks.next();
            if (!stack.getOwner().equals(p)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup groupFromStack(UnitStack stack) {
        UnitStackGroup ret = new UnitStackGroup();
        ret.add(stack);
        return ret;
    }

    public static UnitStackGroup groupInfantry(UnitStackGroup g) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator units = new UnitStackGroupIterator(g);
        while (units.hasNext()) {
            UnitStack stack = units.next();
            if (!(stack.getUnit() instanceof UnitPawn)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup groupKnights(UnitStackGroup g) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator units = new UnitStackGroupIterator(g);
        while (units.hasNext()) {
            UnitStack stack = units.next();
            if (!(stack.getUnit() instanceof UnitKnight)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static UnitStackGroup groupCastles(UnitStackGroup g) {
        UnitStackGroup ret = new UnitStackGroup();
        UnitStackGroupIterator units = new UnitStackGroupIterator(g);
        while (units.hasNext()) {
            UnitStack stack = units.next();
            if (!(stack.getUnit() instanceof UnitCastle)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public List<Country> realAdjoiningList(Country c) {
        List fakeAdjoiningList = c.getAdjoiningList();
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country f : fakeAdjoiningList) {
            ret.add(this.bot.countryArray[f.getID()]);
        }
        return ret;
    }

    public UnitStackGroup potentialAttackers(Country c) {
        if (!c.getTeam().equals(this.bot.us)) {
            throw new RuntimeException("potentialAttackers should only be called on team countries!");
        }
        UnitStackGroup ret = new UnitStackGroup();
        List<Country> nearby = this.countriesInRange(c, 2);
        for (Country n : nearby) {
            if (n.getTeam().equals(c.getTeam())) continue;
            UnitStackGroupIterator units = new UnitStackGroupIterator(n.getUnitStackGroup());
            while (units.hasNext()) {
                UnitStack unit = units.next();
                if (!this.bot.world.unitCanReach(unit, n, c)) continue;
                ret.add(unit);
            }
        }
        return ret;
    }

    public ArrayList<Country> hostileNeighbors(Country c) {
        ArrayList<Country> ret = new ArrayList<Country>();
        Team countryTeam = c.getTeam();
        for (Country n : this.realAdjoiningList(c)) {
            if (n.getTeam().equals(countryTeam)) continue;
            ret.add(n);
        }
        return ret;
    }

    public boolean isPlayerEdge(Country c) {
        Player countryOwner = c.getOwner();
        for (Country n : this.realAdjoiningList(c)) {
            if (n.getOwner().equals(countryOwner)) continue;
            return true;
        }
        return false;
    }

    public boolean isBorder(Country c) {
        Team countryTeam = c.getTeam();
        for (Country n : this.realAdjoiningList(c)) {
            if (n.getTeam().equals(countryTeam)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Country> neighboringBorders(Country c) {
        ArrayList<Country> ret = new ArrayList<Country>();
        Player countryOwner = c.getOwner();
        for (Country n : this.realAdjoiningList(c)) {
            if (!n.getOwner().equals(countryOwner) || !this.isBorder(n)) continue;
            ret.add(n);
        }
        return ret;
    }

    public List<Country> countriesInRange(Country c, int range) {
        ArrayList<Country> ret = new ArrayList<Country>();
        ret.addAll(this.realAdjoiningList(c));
        for (int i = 2; i <= range; ++i) {
            ArrayList<Country> newRet = new ArrayList<Country>();
            for (Country r : ret) {
                for (Country n : this.realAdjoiningList(r)) {
                    if (newRet.contains(n) || ret.contains(n) || n.equals(c)) continue;
                    newRet.add(n);
                }
            }
            ret.addAll(newRet);
        }
        return ret;
    }

    public ArrayList<Country> reachableByKnight(Country origin) {
        List<Country> neighbors = this.realAdjoiningList(origin);
        ArrayList<Country> ret = new ArrayList<Country>(neighbors);
        for (Country n : neighbors) {
            if (!n.getTeam().equals(origin.getTeam()) && n.getUnitStackGroup().getTotalUnitCount() != 0) continue;
            for (Country n2 : this.realAdjoiningList(n)) {
                if (ret.contains(n2)) continue;
                ret.add(n2);
            }
        }
        return ret;
    }

    public static ArrayList<Country> playerCountries(Player p, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (!c.getOwner().equals(p)) continue;
            ret.add(c);
        }
        return ret;
    }

    public static ArrayList<Country> teamCountries(Team t, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (!c.getTeam().equals(t)) continue;
            ret.add(c);
        }
        return ret;
    }

    public static ArrayList<Country> hostileCountries(Team t, List<Country> countries) {
        ArrayList<Country> ret = new ArrayList<Country>();
        for (Country c : countries) {
            if (c.getTeam().equals(t)) continue;
            ret.add(c);
        }
        return ret;
    }

    public Team continentOwner(int contID) {
        Team owner = null;
        for (Country c : this.bot.countryList) {
            if (c.getContinentID() != contID) continue;
            if (owner == null) {
                owner = c.getTeam();
                continue;
            }
            if (owner.equals(c.getTeam())) continue;
            return null;
        }
        return owner;
    }

    public boolean isContinentBorder(Country c) {
        for (Country n : this.realAdjoiningList(c)) {
            if (n.getContinentID() == c.getContinentID()) continue;
            return true;
        }
        return false;
    }

    public boolean weOwnNeighboringContinents(Country c) {
        for (Country n : this.realAdjoiningList(c)) {
            if (this.bot.us.equals(this.continentOwner(n.getContinentID()))) continue;
            return false;
        }
        return true;
    }

    public static String listToString(List list) {
        String ret = "{";
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                ret = ret + ", ";
            }
            ret = ret + list.get(i).toString();
        }
        ret = ret + "}";
        return ret;
    }
}

