/*
 * Decompiled with CFR 0.152.
 */
import com.sillysoft.vox.Country;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.UnitStackGroupIterator;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Troops {
    Polymath bot;
    UnitStackGroup[] original;
    UnitStackGroup[] remaining;
    UnitStackGroup[] incoming;

    public Troops(Polymath bot) {
        this.bot = bot;
    }

    public void initTurn() {
        this.original = new UnitStackGroup[this.bot.countryArray.length];
        this.remaining = new UnitStackGroup[this.bot.countryArray.length];
        this.incoming = new UnitStackGroup[this.bot.countryArray.length];
        for (int i = 0; i < this.bot.countryArray.length; ++i) {
            UnitStackGroupIterator stacks = new UnitStackGroupIterator(this.bot.countryArray[i].getUnitStackGroup());
            this.original[i] = new UnitStackGroup();
            this.remaining[i] = new UnitStackGroup();
            this.incoming[i] = new UnitStackGroup();
            while (stacks.hasNext()) {
                UnitStack stack = stacks.next();
                this.original[i].add(stack);
                if (stack.getUnit() instanceof UnitCastle || Util2.isBoring(this.bot.countryArray[i])) {
                    this.incoming[i].add(stack);
                    continue;
                }
                this.remaining[i].add(stack);
            }
        }
    }

    public void placeInfantry(Country c, int number) {
        if (number > 0) {
            this.bot.world.placeUnits(new UnitStack(new UnitPawn(this.bot.me), number), c);
        }
    }

    public void placeKnights(Country c, int number) {
        if (number > 0) {
            this.bot.world.placeUnits(new UnitStack(new UnitKnight(this.bot.me), number), c);
        }
    }

    private void moveUnit(Country from, Country to, int count, boolean infantry) {
        int numToMove;
        int numAvailable;
        if (count == 0) {
            return;
        }
        int n = numAvailable = infantry ? this.remainingInfantry(from).getTotalUnitCount() : this.remainingKnights(from).getTotalUnitCount();
        if (count < 0 || count > numAvailable) {
            throw new RuntimeException("Bad count in moveInfantry(" + from.getName() + ", " + to.getName() + ", " + count + ")");
        }
        for (int moved = 0; moved < count; moved += numToMove) {
            UnitStack toBeMoved = null;
            UnitStackGroupIterator stacks = new UnitStackGroupIterator(this.remaining[from.getID()]);
            while (stacks.hasNext()) {
                UnitStack stack = stacks.next();
                if (stack.getCount() <= 0 || (!infantry || !(stack.getUnit() instanceof UnitPawn)) && (infantry || !(stack.getUnit() instanceof UnitKnight)) || toBeMoved != null && stack.getOwner().getID() >= toBeMoved.getOwner().getID()) continue;
                toBeMoved = stack;
            }
            numToMove = Math.min(count - moved, toBeMoved.getCount());
            if (toBeMoved.getOwner().equals(this.bot.me) && !from.equals(to)) {
                if (!this.bot.world.unitCanReach(toBeMoved, from, to)) {
                    throw new RuntimeException("BAD MOVE COMMAND IN moveUnit(" + from + ", " + to + ", " + count + ", " + infantry + ")  (chose stack " + toBeMoved + ")");
                }
                this.bot.world.moveUnit(toBeMoved, from, to, numToMove);
            }
            this.incoming[to.getID()].add(new UnitStack(toBeMoved.getUnit(), numToMove));
            this.incoming[to.getID()].consolidateUnits();
            toBeMoved.setCount(toBeMoved.getCount() - numToMove);
        }
    }

    public void moveInfantry(Country from, Country to, int count) {
        this.moveUnit(from, to, count, true);
    }

    public void moveKnights(Country from, Country to, int count) {
        this.moveUnit(from, to, count, false);
    }

    public void moveRemainingInfantry(Country from, Country to) {
        this.moveInfantry(from, to, this.remainingInfantry(from).getTotalUnitCount());
    }

    public void moveRemainingKnights(Country from, Country to) {
        this.moveKnights(from, to, this.remainingKnights(from).getTotalUnitCount());
    }

    public void reserveInfantry(Country c, int count) {
        this.moveInfantry(c, c, count);
    }

    public void reserveKnights(Country c, int count) {
        this.moveKnights(c, c, count);
    }

    public UnitStackGroup originalGroup(Country c) {
        return Simulation2.clone(this.original[c.getID()]);
    }

    public UnitStackGroup remainingGroup(Country c) {
        return Simulation2.clone(this.remaining[c.getID()]);
    }

    public UnitStackGroup incomingGroup(Country c) {
        return Simulation2.clone(this.incoming[c.getID()]);
    }

    public UnitStackGroup originalInfantry(Country c) {
        return Util2.groupInfantry(this.original[c.getID()]);
    }

    public UnitStackGroup originalKnights(Country c) {
        return Util2.groupKnights(this.original[c.getID()]);
    }

    public UnitStackGroup originalCastles(Country c) {
        return Util2.groupCastles(this.original[c.getID()]);
    }

    public UnitStackGroup remainingInfantry(Country c) {
        return Util2.groupInfantry(this.remaining[c.getID()]);
    }

    public UnitStackGroup remainingKnights(Country c) {
        return Util2.groupKnights(this.remaining[c.getID()]);
    }

    public UnitStackGroup incomingInfantry(Country c) {
        return Util2.groupInfantry(this.incoming[c.getID()]);
    }

    public UnitStackGroup incomingKnights(Country c) {
        return Util2.groupKnights(this.incoming[c.getID()]);
    }

    public UnitStackGroup combinedOriginalGroup(List<Country> countries) {
        UnitStackGroup ret = new UnitStackGroup();
        for (Country c : countries) {
            ret.add(this.original[c.getID()]);
        }
        return ret;
    }

    public UnitStackGroup combinedRemainingGroup(List<Country> countries) {
        UnitStackGroup ret = new UnitStackGroup();
        for (Country c : countries) {
            ret.add(this.remaining[c.getID()]);
        }
        return ret;
    }

    public UnitStackGroup combinedIncomingGroup(List<Country> countries) {
        UnitStackGroup ret = new UnitStackGroup();
        for (Country c : countries) {
            ret.add(this.incoming[c.getID()]);
        }
        return ret;
    }
}

