/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RankerPriorityQueue<T> {
    ArrayList<T> elements = new ArrayList();
    ArrayList<Double> ranks = new ArrayList();
    Ranker<T> ranker;

    public RankerPriorityQueue(Ranker<T> ranker) {
        this.ranker = ranker;
    }

    public void push(T t) {
        double rank = this.ranker.rank(t);
        if (rank > Double.NEGATIVE_INFINITY) {
            this.elements.add(t);
            this.ranks.add(this.ranker.rank(t));
        }
    }

    public T pop() {
        if (this.size() == 0) {
            return null;
        }
        double bestRank = this.ranks.get(0);
        int bestIndex = 0;
        for (int i = 1; i < this.ranks.size(); ++i) {
            if (!(this.ranks.get(i) > bestRank)) continue;
            bestRank = this.ranks.get(i);
            bestIndex = i;
        }
        T bestT = this.elements.get(bestIndex);
        this.elements.remove(bestIndex);
        this.ranks.remove(bestIndex);
        return bestT;
    }

    public int size() {
        return this.elements.size();
    }
}

